// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file constants.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__CONSTANTS_HPP
#define FAST_DDS_GENERATED__CONSTANTS_HPP

#include <array>
#include <cstdint>
#include <utility>
#include "helpers/basic_inner_types.hpp"

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(CONSTANTS_SOURCE)
#define CONSTANTS_DllAPI __declspec( dllexport )
#else
#define CONSTANTS_DllAPI __declspec( dllimport )
#endif // CONSTANTS_SOURCE
#else
#define CONSTANTS_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define CONSTANTS_DllAPI
#endif // _WIN32

const int16_t const_short = 87;
const uint16_t const_ushort = 43;
const int32_t const_long = 23;
const uint32_t const_ulong = 6;
const int64_t const_longlong = 8;
const uint64_t const_ulonglong = 67;
const float const_float = 13.1f;
const double const_double = 84.1;
const long double const_longdouble = 46.1;
const bool const_boolean = true;
const uint8_t const_octet = 7;
const char const_char8 = 'A';
const wchar_t const_char16 = L'B';
const int8_t const_int8 = 53;
const uint8_t const_uint8 = 11;
const int16_t const_int16 = 27;
const uint16_t const_uint16 = 31;
const int32_t const_int32 = 74;
const uint32_t const_uint32 = 64;
const int64_t const_int64 = 17;
const uint64_t const_uint64 = 19;
typedef int16_t alias_short;

const alias_short alias_const = 55;
const InnerEnumHelper const_enum = InnerEnumHelper::ENUM_VALUE_1;
namespace const_module1 {

const int16_t const_moduled = 11;
typedef int16_t alias_short_moduled;

const alias_short_moduled alias_const_moduled = 10;
/*!
 * @brief This class represents the structure ModuleConstsLiteralsStruct defined by the user in the IDL file.
 * @ingroup constants
 */
class ModuleConstsLiteralsStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ModuleConstsLiteralsStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ModuleConstsLiteralsStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ModuleConstsLiteralsStruct that will be copied.
     */
    eProsima_user_DllExport ModuleConstsLiteralsStruct(
            const ModuleConstsLiteralsStruct& x)
    {
                    m_module1_array_literal_const_moduled = x.m_module1_array_literal_const_moduled;

                    m_module1_array_literal_const_alias_const_moduled = x.m_module1_array_literal_const_alias_const_moduled;

                    m_var1 = x.m_var1;

                    m_var2 = x.m_var2;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ModuleConstsLiteralsStruct that will be copied.
     */
    eProsima_user_DllExport ModuleConstsLiteralsStruct(
            ModuleConstsLiteralsStruct&& x) noexcept
    {
        m_module1_array_literal_const_moduled = std::move(x.m_module1_array_literal_const_moduled);
        m_module1_array_literal_const_alias_const_moduled = std::move(x.m_module1_array_literal_const_alias_const_moduled);
        m_var1 = x.m_var1;
        m_var2 = x.m_var2;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ModuleConstsLiteralsStruct that will be copied.
     */
    eProsima_user_DllExport ModuleConstsLiteralsStruct& operator =(
            const ModuleConstsLiteralsStruct& x)
    {

                    m_module1_array_literal_const_moduled = x.m_module1_array_literal_const_moduled;

                    m_module1_array_literal_const_alias_const_moduled = x.m_module1_array_literal_const_alias_const_moduled;

                    m_var1 = x.m_var1;

                    m_var2 = x.m_var2;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ModuleConstsLiteralsStruct that will be copied.
     */
    eProsima_user_DllExport ModuleConstsLiteralsStruct& operator =(
            ModuleConstsLiteralsStruct&& x) noexcept
    {

        m_module1_array_literal_const_moduled = std::move(x.m_module1_array_literal_const_moduled);
        m_module1_array_literal_const_alias_const_moduled = std::move(x.m_module1_array_literal_const_alias_const_moduled);
        m_var1 = x.m_var1;
        m_var2 = x.m_var2;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ModuleConstsLiteralsStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ModuleConstsLiteralsStruct& x) const
    {
        return (m_module1_array_literal_const_moduled == x.m_module1_array_literal_const_moduled &&
           m_module1_array_literal_const_alias_const_moduled == x.m_module1_array_literal_const_alias_const_moduled &&
           m_var1 == x.m_var1 &&
           m_var2 == x.m_var2);
    }

    /*!
     * @brief Comparison operator.
     * @param x ModuleConstsLiteralsStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ModuleConstsLiteralsStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member module1_array_literal_const_moduled
     * @param _module1_array_literal_const_moduled New value to be copied in member module1_array_literal_const_moduled
     */
    eProsima_user_DllExport void module1_array_literal_const_moduled(
            const std::array<int16_t, const_moduled>& _module1_array_literal_const_moduled)
    {
        m_module1_array_literal_const_moduled = _module1_array_literal_const_moduled;
    }

    /*!
     * @brief This function moves the value in member module1_array_literal_const_moduled
     * @param _module1_array_literal_const_moduled New value to be moved in member module1_array_literal_const_moduled
     */
    eProsima_user_DllExport void module1_array_literal_const_moduled(
            std::array<int16_t, const_moduled>&& _module1_array_literal_const_moduled)
    {
        m_module1_array_literal_const_moduled = std::move(_module1_array_literal_const_moduled);
    }

    /*!
     * @brief This function returns a constant reference to member module1_array_literal_const_moduled
     * @return Constant reference to member module1_array_literal_const_moduled
     */
    eProsima_user_DllExport const std::array<int16_t, const_moduled>& module1_array_literal_const_moduled() const
    {
        return m_module1_array_literal_const_moduled;
    }

    /*!
     * @brief This function returns a reference to member module1_array_literal_const_moduled
     * @return Reference to member module1_array_literal_const_moduled
     */
    eProsima_user_DllExport std::array<int16_t, const_moduled>& module1_array_literal_const_moduled()
    {
        return m_module1_array_literal_const_moduled;
    }


    /*!
     * @brief This function copies the value in member module1_array_literal_const_alias_const_moduled
     * @param _module1_array_literal_const_alias_const_moduled New value to be copied in member module1_array_literal_const_alias_const_moduled
     */
    eProsima_user_DllExport void module1_array_literal_const_alias_const_moduled(
            const std::array<int16_t, alias_const_moduled>& _module1_array_literal_const_alias_const_moduled)
    {
        m_module1_array_literal_const_alias_const_moduled = _module1_array_literal_const_alias_const_moduled;
    }

    /*!
     * @brief This function moves the value in member module1_array_literal_const_alias_const_moduled
     * @param _module1_array_literal_const_alias_const_moduled New value to be moved in member module1_array_literal_const_alias_const_moduled
     */
    eProsima_user_DllExport void module1_array_literal_const_alias_const_moduled(
            std::array<int16_t, alias_const_moduled>&& _module1_array_literal_const_alias_const_moduled)
    {
        m_module1_array_literal_const_alias_const_moduled = std::move(_module1_array_literal_const_alias_const_moduled);
    }

    /*!
     * @brief This function returns a constant reference to member module1_array_literal_const_alias_const_moduled
     * @return Constant reference to member module1_array_literal_const_alias_const_moduled
     */
    eProsima_user_DllExport const std::array<int16_t, alias_const_moduled>& module1_array_literal_const_alias_const_moduled() const
    {
        return m_module1_array_literal_const_alias_const_moduled;
    }

    /*!
     * @brief This function returns a reference to member module1_array_literal_const_alias_const_moduled
     * @return Reference to member module1_array_literal_const_alias_const_moduled
     */
    eProsima_user_DllExport std::array<int16_t, alias_const_moduled>& module1_array_literal_const_alias_const_moduled()
    {
        return m_module1_array_literal_const_alias_const_moduled;
    }


    /*!
     * @brief This function sets a value in member var1
     * @param _var1 New value for member var1
     */
    eProsima_user_DllExport void var1(
            alias_short _var1)
    {
        m_var1 = _var1;
    }

    /*!
     * @brief This function returns the value of member var1
     * @return Value of member var1
     */
    eProsima_user_DllExport alias_short var1() const
    {
        return m_var1;
    }

    /*!
     * @brief This function returns a reference to member var1
     * @return Reference to member var1
     */
    eProsima_user_DllExport alias_short& var1()
    {
        return m_var1;
    }


    /*!
     * @brief This function sets a value in member var2
     * @param _var2 New value for member var2
     */
    eProsima_user_DllExport void var2(
            alias_short_moduled _var2)
    {
        m_var2 = _var2;
    }

    /*!
     * @brief This function returns the value of member var2
     * @return Value of member var2
     */
    eProsima_user_DllExport alias_short_moduled var2() const
    {
        return m_var2;
    }

    /*!
     * @brief This function returns a reference to member var2
     * @return Reference to member var2
     */
    eProsima_user_DllExport alias_short_moduled& var2()
    {
        return m_var2;
    }



private:

    std::array<int16_t, const_moduled> m_module1_array_literal_const_moduled{0};
    std::array<int16_t, alias_const_moduled> m_module1_array_literal_const_alias_const_moduled{0};
    alias_short m_var1{0};
    alias_short_moduled m_var2{0};

};

} // namespace const_module1
namespace const_module2 {

const int16_t const_moduled = 22;
const const_module1::alias_short_moduled alias_const_moduled = 2;
const int16_t const_moduled_module1 = const_module1::const_moduled;
/*!
 * @brief This class represents the structure Module2ConstsLiteralsStruct defined by the user in the IDL file.
 * @ingroup constants
 */
class Module2ConstsLiteralsStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Module2ConstsLiteralsStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Module2ConstsLiteralsStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Module2ConstsLiteralsStruct that will be copied.
     */
    eProsima_user_DllExport Module2ConstsLiteralsStruct(
            const Module2ConstsLiteralsStruct& x)
    {
                    m_module2_array_literal_const_moduled = x.m_module2_array_literal_const_moduled;

                    m_module2_array_literal_const_alias_const_moduled = x.m_module2_array_literal_const_alias_const_moduled;

                    m_module2_array_literal_const_scoped_moduled = x.m_module2_array_literal_const_scoped_moduled;

                    m_module2_array_literal_module1_const_moduled = x.m_module2_array_literal_module1_const_moduled;

                    m_module2_array_literal_const_moduled_module1 = x.m_module2_array_literal_const_moduled_module1;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Module2ConstsLiteralsStruct that will be copied.
     */
    eProsima_user_DllExport Module2ConstsLiteralsStruct(
            Module2ConstsLiteralsStruct&& x) noexcept
    {
        m_module2_array_literal_const_moduled = std::move(x.m_module2_array_literal_const_moduled);
        m_module2_array_literal_const_alias_const_moduled = std::move(x.m_module2_array_literal_const_alias_const_moduled);
        m_module2_array_literal_const_scoped_moduled = std::move(x.m_module2_array_literal_const_scoped_moduled);
        m_module2_array_literal_module1_const_moduled = std::move(x.m_module2_array_literal_module1_const_moduled);
        m_module2_array_literal_const_moduled_module1 = std::move(x.m_module2_array_literal_const_moduled_module1);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Module2ConstsLiteralsStruct that will be copied.
     */
    eProsima_user_DllExport Module2ConstsLiteralsStruct& operator =(
            const Module2ConstsLiteralsStruct& x)
    {

                    m_module2_array_literal_const_moduled = x.m_module2_array_literal_const_moduled;

                    m_module2_array_literal_const_alias_const_moduled = x.m_module2_array_literal_const_alias_const_moduled;

                    m_module2_array_literal_const_scoped_moduled = x.m_module2_array_literal_const_scoped_moduled;

                    m_module2_array_literal_module1_const_moduled = x.m_module2_array_literal_module1_const_moduled;

                    m_module2_array_literal_const_moduled_module1 = x.m_module2_array_literal_const_moduled_module1;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Module2ConstsLiteralsStruct that will be copied.
     */
    eProsima_user_DllExport Module2ConstsLiteralsStruct& operator =(
            Module2ConstsLiteralsStruct&& x) noexcept
    {

        m_module2_array_literal_const_moduled = std::move(x.m_module2_array_literal_const_moduled);
        m_module2_array_literal_const_alias_const_moduled = std::move(x.m_module2_array_literal_const_alias_const_moduled);
        m_module2_array_literal_const_scoped_moduled = std::move(x.m_module2_array_literal_const_scoped_moduled);
        m_module2_array_literal_module1_const_moduled = std::move(x.m_module2_array_literal_module1_const_moduled);
        m_module2_array_literal_const_moduled_module1 = std::move(x.m_module2_array_literal_const_moduled_module1);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Module2ConstsLiteralsStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Module2ConstsLiteralsStruct& x) const
    {
        return (m_module2_array_literal_const_moduled == x.m_module2_array_literal_const_moduled &&
           m_module2_array_literal_const_alias_const_moduled == x.m_module2_array_literal_const_alias_const_moduled &&
           m_module2_array_literal_const_scoped_moduled == x.m_module2_array_literal_const_scoped_moduled &&
           m_module2_array_literal_module1_const_moduled == x.m_module2_array_literal_module1_const_moduled &&
           m_module2_array_literal_const_moduled_module1 == x.m_module2_array_literal_const_moduled_module1);
    }

    /*!
     * @brief Comparison operator.
     * @param x Module2ConstsLiteralsStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Module2ConstsLiteralsStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member module2_array_literal_const_moduled
     * @param _module2_array_literal_const_moduled New value to be copied in member module2_array_literal_const_moduled
     */
    eProsima_user_DllExport void module2_array_literal_const_moduled(
            const std::array<int16_t, const_moduled>& _module2_array_literal_const_moduled)
    {
        m_module2_array_literal_const_moduled = _module2_array_literal_const_moduled;
    }

    /*!
     * @brief This function moves the value in member module2_array_literal_const_moduled
     * @param _module2_array_literal_const_moduled New value to be moved in member module2_array_literal_const_moduled
     */
    eProsima_user_DllExport void module2_array_literal_const_moduled(
            std::array<int16_t, const_moduled>&& _module2_array_literal_const_moduled)
    {
        m_module2_array_literal_const_moduled = std::move(_module2_array_literal_const_moduled);
    }

    /*!
     * @brief This function returns a constant reference to member module2_array_literal_const_moduled
     * @return Constant reference to member module2_array_literal_const_moduled
     */
    eProsima_user_DllExport const std::array<int16_t, const_moduled>& module2_array_literal_const_moduled() const
    {
        return m_module2_array_literal_const_moduled;
    }

    /*!
     * @brief This function returns a reference to member module2_array_literal_const_moduled
     * @return Reference to member module2_array_literal_const_moduled
     */
    eProsima_user_DllExport std::array<int16_t, const_moduled>& module2_array_literal_const_moduled()
    {
        return m_module2_array_literal_const_moduled;
    }


    /*!
     * @brief This function copies the value in member module2_array_literal_const_alias_const_moduled
     * @param _module2_array_literal_const_alias_const_moduled New value to be copied in member module2_array_literal_const_alias_const_moduled
     */
    eProsima_user_DllExport void module2_array_literal_const_alias_const_moduled(
            const std::array<int16_t, alias_const_moduled>& _module2_array_literal_const_alias_const_moduled)
    {
        m_module2_array_literal_const_alias_const_moduled = _module2_array_literal_const_alias_const_moduled;
    }

    /*!
     * @brief This function moves the value in member module2_array_literal_const_alias_const_moduled
     * @param _module2_array_literal_const_alias_const_moduled New value to be moved in member module2_array_literal_const_alias_const_moduled
     */
    eProsima_user_DllExport void module2_array_literal_const_alias_const_moduled(
            std::array<int16_t, alias_const_moduled>&& _module2_array_literal_const_alias_const_moduled)
    {
        m_module2_array_literal_const_alias_const_moduled = std::move(_module2_array_literal_const_alias_const_moduled);
    }

    /*!
     * @brief This function returns a constant reference to member module2_array_literal_const_alias_const_moduled
     * @return Constant reference to member module2_array_literal_const_alias_const_moduled
     */
    eProsima_user_DllExport const std::array<int16_t, alias_const_moduled>& module2_array_literal_const_alias_const_moduled() const
    {
        return m_module2_array_literal_const_alias_const_moduled;
    }

    /*!
     * @brief This function returns a reference to member module2_array_literal_const_alias_const_moduled
     * @return Reference to member module2_array_literal_const_alias_const_moduled
     */
    eProsima_user_DllExport std::array<int16_t, alias_const_moduled>& module2_array_literal_const_alias_const_moduled()
    {
        return m_module2_array_literal_const_alias_const_moduled;
    }


    /*!
     * @brief This function copies the value in member module2_array_literal_const_scoped_moduled
     * @param _module2_array_literal_const_scoped_moduled New value to be copied in member module2_array_literal_const_scoped_moduled
     */
    eProsima_user_DllExport void module2_array_literal_const_scoped_moduled(
            const std::array<int16_t, const_module2::const_moduled>& _module2_array_literal_const_scoped_moduled)
    {
        m_module2_array_literal_const_scoped_moduled = _module2_array_literal_const_scoped_moduled;
    }

    /*!
     * @brief This function moves the value in member module2_array_literal_const_scoped_moduled
     * @param _module2_array_literal_const_scoped_moduled New value to be moved in member module2_array_literal_const_scoped_moduled
     */
    eProsima_user_DllExport void module2_array_literal_const_scoped_moduled(
            std::array<int16_t, const_module2::const_moduled>&& _module2_array_literal_const_scoped_moduled)
    {
        m_module2_array_literal_const_scoped_moduled = std::move(_module2_array_literal_const_scoped_moduled);
    }

    /*!
     * @brief This function returns a constant reference to member module2_array_literal_const_scoped_moduled
     * @return Constant reference to member module2_array_literal_const_scoped_moduled
     */
    eProsima_user_DllExport const std::array<int16_t, const_module2::const_moduled>& module2_array_literal_const_scoped_moduled() const
    {
        return m_module2_array_literal_const_scoped_moduled;
    }

    /*!
     * @brief This function returns a reference to member module2_array_literal_const_scoped_moduled
     * @return Reference to member module2_array_literal_const_scoped_moduled
     */
    eProsima_user_DllExport std::array<int16_t, const_module2::const_moduled>& module2_array_literal_const_scoped_moduled()
    {
        return m_module2_array_literal_const_scoped_moduled;
    }


    /*!
     * @brief This function copies the value in member module2_array_literal_module1_const_moduled
     * @param _module2_array_literal_module1_const_moduled New value to be copied in member module2_array_literal_module1_const_moduled
     */
    eProsima_user_DllExport void module2_array_literal_module1_const_moduled(
            const std::array<int16_t, const_module1::const_moduled>& _module2_array_literal_module1_const_moduled)
    {
        m_module2_array_literal_module1_const_moduled = _module2_array_literal_module1_const_moduled;
    }

    /*!
     * @brief This function moves the value in member module2_array_literal_module1_const_moduled
     * @param _module2_array_literal_module1_const_moduled New value to be moved in member module2_array_literal_module1_const_moduled
     */
    eProsima_user_DllExport void module2_array_literal_module1_const_moduled(
            std::array<int16_t, const_module1::const_moduled>&& _module2_array_literal_module1_const_moduled)
    {
        m_module2_array_literal_module1_const_moduled = std::move(_module2_array_literal_module1_const_moduled);
    }

    /*!
     * @brief This function returns a constant reference to member module2_array_literal_module1_const_moduled
     * @return Constant reference to member module2_array_literal_module1_const_moduled
     */
    eProsima_user_DllExport const std::array<int16_t, const_module1::const_moduled>& module2_array_literal_module1_const_moduled() const
    {
        return m_module2_array_literal_module1_const_moduled;
    }

    /*!
     * @brief This function returns a reference to member module2_array_literal_module1_const_moduled
     * @return Reference to member module2_array_literal_module1_const_moduled
     */
    eProsima_user_DllExport std::array<int16_t, const_module1::const_moduled>& module2_array_literal_module1_const_moduled()
    {
        return m_module2_array_literal_module1_const_moduled;
    }


    /*!
     * @brief This function copies the value in member module2_array_literal_const_moduled_module1
     * @param _module2_array_literal_const_moduled_module1 New value to be copied in member module2_array_literal_const_moduled_module1
     */
    eProsima_user_DllExport void module2_array_literal_const_moduled_module1(
            const std::array<int16_t, const_moduled_module1>& _module2_array_literal_const_moduled_module1)
    {
        m_module2_array_literal_const_moduled_module1 = _module2_array_literal_const_moduled_module1;
    }

    /*!
     * @brief This function moves the value in member module2_array_literal_const_moduled_module1
     * @param _module2_array_literal_const_moduled_module1 New value to be moved in member module2_array_literal_const_moduled_module1
     */
    eProsima_user_DllExport void module2_array_literal_const_moduled_module1(
            std::array<int16_t, const_moduled_module1>&& _module2_array_literal_const_moduled_module1)
    {
        m_module2_array_literal_const_moduled_module1 = std::move(_module2_array_literal_const_moduled_module1);
    }

    /*!
     * @brief This function returns a constant reference to member module2_array_literal_const_moduled_module1
     * @return Constant reference to member module2_array_literal_const_moduled_module1
     */
    eProsima_user_DllExport const std::array<int16_t, const_moduled_module1>& module2_array_literal_const_moduled_module1() const
    {
        return m_module2_array_literal_const_moduled_module1;
    }

    /*!
     * @brief This function returns a reference to member module2_array_literal_const_moduled_module1
     * @return Reference to member module2_array_literal_const_moduled_module1
     */
    eProsima_user_DllExport std::array<int16_t, const_moduled_module1>& module2_array_literal_const_moduled_module1()
    {
        return m_module2_array_literal_const_moduled_module1;
    }



private:

    std::array<int16_t, const_moduled> m_module2_array_literal_const_moduled{0};
    std::array<int16_t, alias_const_moduled> m_module2_array_literal_const_alias_const_moduled{0};
    std::array<int16_t, const_module2::const_moduled> m_module2_array_literal_const_scoped_moduled{0};
    std::array<int16_t, const_module1::const_moduled> m_module2_array_literal_module1_const_moduled{0};
    std::array<int16_t, const_moduled_module1> m_module2_array_literal_const_moduled_module1{0};

};

} // namespace const_module2
/*!
 * @brief This class represents the structure ConstsLiteralsStruct defined by the user in the IDL file.
 * @ingroup constants
 */
class ConstsLiteralsStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ConstsLiteralsStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ConstsLiteralsStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ConstsLiteralsStruct that will be copied.
     */
    eProsima_user_DllExport ConstsLiteralsStruct(
            const ConstsLiteralsStruct& x)
    {
                    m_array_literal_const_short = x.m_array_literal_const_short;

                    m_array_literal_const_ushort = x.m_array_literal_const_ushort;

                    m_array_literal_const_long = x.m_array_literal_const_long;

                    m_array_literal_const_ulong = x.m_array_literal_const_ulong;

                    m_array_literal_const_longlong = x.m_array_literal_const_longlong;

                    m_array_literal_const_ulonglong = x.m_array_literal_const_ulonglong;

                    m_array_literal_const_int8 = x.m_array_literal_const_int8;

                    m_array_literal_const_uint8 = x.m_array_literal_const_uint8;

                    m_array_literal_const_int16 = x.m_array_literal_const_int16;

                    m_array_literal_const_uint16 = x.m_array_literal_const_uint16;

                    m_array_literal_const_int32 = x.m_array_literal_const_int32;

                    m_array_literal_const_uint32 = x.m_array_literal_const_uint32;

                    m_array_literal_const_int64 = x.m_array_literal_const_int64;

                    m_array_literal_const_uint64 = x.m_array_literal_const_uint64;

                    m_array_literals_operations1_const = x.m_array_literals_operations1_const;

                    m_array_literals_operations2_const = x.m_array_literals_operations2_const;

                    m_array_literals_operations3_const = x.m_array_literals_operations3_const;

                    m_array_literals_operations4_const = x.m_array_literals_operations4_const;

                    m_array_literals_operations5_const = x.m_array_literals_operations5_const;

                    m_array_literals_operations6_const = x.m_array_literals_operations6_const;

                    m_array_literals_operations7_const = x.m_array_literals_operations7_const;

                    m_array_literals_operations8_const = x.m_array_literals_operations8_const;

                    m_array_literal_const_inner_const_helper = x.m_array_literal_const_inner_const_helper;

                    m_array_moduled1_literal_const = x.m_array_moduled1_literal_const;

                    m_array_moduled2_literal_const = x.m_array_moduled2_literal_const;

                    m_array_literal_const_alias_const = x.m_array_literal_const_alias_const;

                    m_array_moduled1_literal_alias_const_moduled = x.m_array_moduled1_literal_alias_const_moduled;

                    m_array_moduled2_literal_alias_const_moduled = x.m_array_moduled2_literal_alias_const_moduled;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ConstsLiteralsStruct that will be copied.
     */
    eProsima_user_DllExport ConstsLiteralsStruct(
            ConstsLiteralsStruct&& x) noexcept
    {
        m_array_literal_const_short = std::move(x.m_array_literal_const_short);
        m_array_literal_const_ushort = std::move(x.m_array_literal_const_ushort);
        m_array_literal_const_long = std::move(x.m_array_literal_const_long);
        m_array_literal_const_ulong = std::move(x.m_array_literal_const_ulong);
        m_array_literal_const_longlong = std::move(x.m_array_literal_const_longlong);
        m_array_literal_const_ulonglong = std::move(x.m_array_literal_const_ulonglong);
        m_array_literal_const_int8 = std::move(x.m_array_literal_const_int8);
        m_array_literal_const_uint8 = std::move(x.m_array_literal_const_uint8);
        m_array_literal_const_int16 = std::move(x.m_array_literal_const_int16);
        m_array_literal_const_uint16 = std::move(x.m_array_literal_const_uint16);
        m_array_literal_const_int32 = std::move(x.m_array_literal_const_int32);
        m_array_literal_const_uint32 = std::move(x.m_array_literal_const_uint32);
        m_array_literal_const_int64 = std::move(x.m_array_literal_const_int64);
        m_array_literal_const_uint64 = std::move(x.m_array_literal_const_uint64);
        m_array_literals_operations1_const = std::move(x.m_array_literals_operations1_const);
        m_array_literals_operations2_const = std::move(x.m_array_literals_operations2_const);
        m_array_literals_operations3_const = std::move(x.m_array_literals_operations3_const);
        m_array_literals_operations4_const = std::move(x.m_array_literals_operations4_const);
        m_array_literals_operations5_const = std::move(x.m_array_literals_operations5_const);
        m_array_literals_operations6_const = std::move(x.m_array_literals_operations6_const);
        m_array_literals_operations7_const = std::move(x.m_array_literals_operations7_const);
        m_array_literals_operations8_const = std::move(x.m_array_literals_operations8_const);
        m_array_literal_const_inner_const_helper = std::move(x.m_array_literal_const_inner_const_helper);
        m_array_moduled1_literal_const = std::move(x.m_array_moduled1_literal_const);
        m_array_moduled2_literal_const = std::move(x.m_array_moduled2_literal_const);
        m_array_literal_const_alias_const = std::move(x.m_array_literal_const_alias_const);
        m_array_moduled1_literal_alias_const_moduled = std::move(x.m_array_moduled1_literal_alias_const_moduled);
        m_array_moduled2_literal_alias_const_moduled = std::move(x.m_array_moduled2_literal_alias_const_moduled);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ConstsLiteralsStruct that will be copied.
     */
    eProsima_user_DllExport ConstsLiteralsStruct& operator =(
            const ConstsLiteralsStruct& x)
    {

                    m_array_literal_const_short = x.m_array_literal_const_short;

                    m_array_literal_const_ushort = x.m_array_literal_const_ushort;

                    m_array_literal_const_long = x.m_array_literal_const_long;

                    m_array_literal_const_ulong = x.m_array_literal_const_ulong;

                    m_array_literal_const_longlong = x.m_array_literal_const_longlong;

                    m_array_literal_const_ulonglong = x.m_array_literal_const_ulonglong;

                    m_array_literal_const_int8 = x.m_array_literal_const_int8;

                    m_array_literal_const_uint8 = x.m_array_literal_const_uint8;

                    m_array_literal_const_int16 = x.m_array_literal_const_int16;

                    m_array_literal_const_uint16 = x.m_array_literal_const_uint16;

                    m_array_literal_const_int32 = x.m_array_literal_const_int32;

                    m_array_literal_const_uint32 = x.m_array_literal_const_uint32;

                    m_array_literal_const_int64 = x.m_array_literal_const_int64;

                    m_array_literal_const_uint64 = x.m_array_literal_const_uint64;

                    m_array_literals_operations1_const = x.m_array_literals_operations1_const;

                    m_array_literals_operations2_const = x.m_array_literals_operations2_const;

                    m_array_literals_operations3_const = x.m_array_literals_operations3_const;

                    m_array_literals_operations4_const = x.m_array_literals_operations4_const;

                    m_array_literals_operations5_const = x.m_array_literals_operations5_const;

                    m_array_literals_operations6_const = x.m_array_literals_operations6_const;

                    m_array_literals_operations7_const = x.m_array_literals_operations7_const;

                    m_array_literals_operations8_const = x.m_array_literals_operations8_const;

                    m_array_literal_const_inner_const_helper = x.m_array_literal_const_inner_const_helper;

                    m_array_moduled1_literal_const = x.m_array_moduled1_literal_const;

                    m_array_moduled2_literal_const = x.m_array_moduled2_literal_const;

                    m_array_literal_const_alias_const = x.m_array_literal_const_alias_const;

                    m_array_moduled1_literal_alias_const_moduled = x.m_array_moduled1_literal_alias_const_moduled;

                    m_array_moduled2_literal_alias_const_moduled = x.m_array_moduled2_literal_alias_const_moduled;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ConstsLiteralsStruct that will be copied.
     */
    eProsima_user_DllExport ConstsLiteralsStruct& operator =(
            ConstsLiteralsStruct&& x) noexcept
    {

        m_array_literal_const_short = std::move(x.m_array_literal_const_short);
        m_array_literal_const_ushort = std::move(x.m_array_literal_const_ushort);
        m_array_literal_const_long = std::move(x.m_array_literal_const_long);
        m_array_literal_const_ulong = std::move(x.m_array_literal_const_ulong);
        m_array_literal_const_longlong = std::move(x.m_array_literal_const_longlong);
        m_array_literal_const_ulonglong = std::move(x.m_array_literal_const_ulonglong);
        m_array_literal_const_int8 = std::move(x.m_array_literal_const_int8);
        m_array_literal_const_uint8 = std::move(x.m_array_literal_const_uint8);
        m_array_literal_const_int16 = std::move(x.m_array_literal_const_int16);
        m_array_literal_const_uint16 = std::move(x.m_array_literal_const_uint16);
        m_array_literal_const_int32 = std::move(x.m_array_literal_const_int32);
        m_array_literal_const_uint32 = std::move(x.m_array_literal_const_uint32);
        m_array_literal_const_int64 = std::move(x.m_array_literal_const_int64);
        m_array_literal_const_uint64 = std::move(x.m_array_literal_const_uint64);
        m_array_literals_operations1_const = std::move(x.m_array_literals_operations1_const);
        m_array_literals_operations2_const = std::move(x.m_array_literals_operations2_const);
        m_array_literals_operations3_const = std::move(x.m_array_literals_operations3_const);
        m_array_literals_operations4_const = std::move(x.m_array_literals_operations4_const);
        m_array_literals_operations5_const = std::move(x.m_array_literals_operations5_const);
        m_array_literals_operations6_const = std::move(x.m_array_literals_operations6_const);
        m_array_literals_operations7_const = std::move(x.m_array_literals_operations7_const);
        m_array_literals_operations8_const = std::move(x.m_array_literals_operations8_const);
        m_array_literal_const_inner_const_helper = std::move(x.m_array_literal_const_inner_const_helper);
        m_array_moduled1_literal_const = std::move(x.m_array_moduled1_literal_const);
        m_array_moduled2_literal_const = std::move(x.m_array_moduled2_literal_const);
        m_array_literal_const_alias_const = std::move(x.m_array_literal_const_alias_const);
        m_array_moduled1_literal_alias_const_moduled = std::move(x.m_array_moduled1_literal_alias_const_moduled);
        m_array_moduled2_literal_alias_const_moduled = std::move(x.m_array_moduled2_literal_alias_const_moduled);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ConstsLiteralsStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ConstsLiteralsStruct& x) const
    {
        return (m_array_literal_const_short == x.m_array_literal_const_short &&
           m_array_literal_const_ushort == x.m_array_literal_const_ushort &&
           m_array_literal_const_long == x.m_array_literal_const_long &&
           m_array_literal_const_ulong == x.m_array_literal_const_ulong &&
           m_array_literal_const_longlong == x.m_array_literal_const_longlong &&
           m_array_literal_const_ulonglong == x.m_array_literal_const_ulonglong &&
           m_array_literal_const_int8 == x.m_array_literal_const_int8 &&
           m_array_literal_const_uint8 == x.m_array_literal_const_uint8 &&
           m_array_literal_const_int16 == x.m_array_literal_const_int16 &&
           m_array_literal_const_uint16 == x.m_array_literal_const_uint16 &&
           m_array_literal_const_int32 == x.m_array_literal_const_int32 &&
           m_array_literal_const_uint32 == x.m_array_literal_const_uint32 &&
           m_array_literal_const_int64 == x.m_array_literal_const_int64 &&
           m_array_literal_const_uint64 == x.m_array_literal_const_uint64 &&
           m_array_literals_operations1_const == x.m_array_literals_operations1_const &&
           m_array_literals_operations2_const == x.m_array_literals_operations2_const &&
           m_array_literals_operations3_const == x.m_array_literals_operations3_const &&
           m_array_literals_operations4_const == x.m_array_literals_operations4_const &&
           m_array_literals_operations5_const == x.m_array_literals_operations5_const &&
           m_array_literals_operations6_const == x.m_array_literals_operations6_const &&
           m_array_literals_operations7_const == x.m_array_literals_operations7_const &&
           m_array_literals_operations8_const == x.m_array_literals_operations8_const &&
           m_array_literal_const_inner_const_helper == x.m_array_literal_const_inner_const_helper &&
           m_array_moduled1_literal_const == x.m_array_moduled1_literal_const &&
           m_array_moduled2_literal_const == x.m_array_moduled2_literal_const &&
           m_array_literal_const_alias_const == x.m_array_literal_const_alias_const &&
           m_array_moduled1_literal_alias_const_moduled == x.m_array_moduled1_literal_alias_const_moduled &&
           m_array_moduled2_literal_alias_const_moduled == x.m_array_moduled2_literal_alias_const_moduled);
    }

    /*!
     * @brief Comparison operator.
     * @param x ConstsLiteralsStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ConstsLiteralsStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member array_literal_const_short
     * @param _array_literal_const_short New value to be copied in member array_literal_const_short
     */
    eProsima_user_DllExport void array_literal_const_short(
            const std::array<int16_t, const_short>& _array_literal_const_short)
    {
        m_array_literal_const_short = _array_literal_const_short;
    }

    /*!
     * @brief This function moves the value in member array_literal_const_short
     * @param _array_literal_const_short New value to be moved in member array_literal_const_short
     */
    eProsima_user_DllExport void array_literal_const_short(
            std::array<int16_t, const_short>&& _array_literal_const_short)
    {
        m_array_literal_const_short = std::move(_array_literal_const_short);
    }

    /*!
     * @brief This function returns a constant reference to member array_literal_const_short
     * @return Constant reference to member array_literal_const_short
     */
    eProsima_user_DllExport const std::array<int16_t, const_short>& array_literal_const_short() const
    {
        return m_array_literal_const_short;
    }

    /*!
     * @brief This function returns a reference to member array_literal_const_short
     * @return Reference to member array_literal_const_short
     */
    eProsima_user_DllExport std::array<int16_t, const_short>& array_literal_const_short()
    {
        return m_array_literal_const_short;
    }


    /*!
     * @brief This function copies the value in member array_literal_const_ushort
     * @param _array_literal_const_ushort New value to be copied in member array_literal_const_ushort
     */
    eProsima_user_DllExport void array_literal_const_ushort(
            const std::array<uint16_t, const_ushort>& _array_literal_const_ushort)
    {
        m_array_literal_const_ushort = _array_literal_const_ushort;
    }

    /*!
     * @brief This function moves the value in member array_literal_const_ushort
     * @param _array_literal_const_ushort New value to be moved in member array_literal_const_ushort
     */
    eProsima_user_DllExport void array_literal_const_ushort(
            std::array<uint16_t, const_ushort>&& _array_literal_const_ushort)
    {
        m_array_literal_const_ushort = std::move(_array_literal_const_ushort);
    }

    /*!
     * @brief This function returns a constant reference to member array_literal_const_ushort
     * @return Constant reference to member array_literal_const_ushort
     */
    eProsima_user_DllExport const std::array<uint16_t, const_ushort>& array_literal_const_ushort() const
    {
        return m_array_literal_const_ushort;
    }

    /*!
     * @brief This function returns a reference to member array_literal_const_ushort
     * @return Reference to member array_literal_const_ushort
     */
    eProsima_user_DllExport std::array<uint16_t, const_ushort>& array_literal_const_ushort()
    {
        return m_array_literal_const_ushort;
    }


    /*!
     * @brief This function copies the value in member array_literal_const_long
     * @param _array_literal_const_long New value to be copied in member array_literal_const_long
     */
    eProsima_user_DllExport void array_literal_const_long(
            const std::array<int32_t, const_long>& _array_literal_const_long)
    {
        m_array_literal_const_long = _array_literal_const_long;
    }

    /*!
     * @brief This function moves the value in member array_literal_const_long
     * @param _array_literal_const_long New value to be moved in member array_literal_const_long
     */
    eProsima_user_DllExport void array_literal_const_long(
            std::array<int32_t, const_long>&& _array_literal_const_long)
    {
        m_array_literal_const_long = std::move(_array_literal_const_long);
    }

    /*!
     * @brief This function returns a constant reference to member array_literal_const_long
     * @return Constant reference to member array_literal_const_long
     */
    eProsima_user_DllExport const std::array<int32_t, const_long>& array_literal_const_long() const
    {
        return m_array_literal_const_long;
    }

    /*!
     * @brief This function returns a reference to member array_literal_const_long
     * @return Reference to member array_literal_const_long
     */
    eProsima_user_DllExport std::array<int32_t, const_long>& array_literal_const_long()
    {
        return m_array_literal_const_long;
    }


    /*!
     * @brief This function copies the value in member array_literal_const_ulong
     * @param _array_literal_const_ulong New value to be copied in member array_literal_const_ulong
     */
    eProsima_user_DllExport void array_literal_const_ulong(
            const std::array<uint32_t, const_ulong>& _array_literal_const_ulong)
    {
        m_array_literal_const_ulong = _array_literal_const_ulong;
    }

    /*!
     * @brief This function moves the value in member array_literal_const_ulong
     * @param _array_literal_const_ulong New value to be moved in member array_literal_const_ulong
     */
    eProsima_user_DllExport void array_literal_const_ulong(
            std::array<uint32_t, const_ulong>&& _array_literal_const_ulong)
    {
        m_array_literal_const_ulong = std::move(_array_literal_const_ulong);
    }

    /*!
     * @brief This function returns a constant reference to member array_literal_const_ulong
     * @return Constant reference to member array_literal_const_ulong
     */
    eProsima_user_DllExport const std::array<uint32_t, const_ulong>& array_literal_const_ulong() const
    {
        return m_array_literal_const_ulong;
    }

    /*!
     * @brief This function returns a reference to member array_literal_const_ulong
     * @return Reference to member array_literal_const_ulong
     */
    eProsima_user_DllExport std::array<uint32_t, const_ulong>& array_literal_const_ulong()
    {
        return m_array_literal_const_ulong;
    }


    /*!
     * @brief This function copies the value in member array_literal_const_longlong
     * @param _array_literal_const_longlong New value to be copied in member array_literal_const_longlong
     */
    eProsima_user_DllExport void array_literal_const_longlong(
            const std::array<int64_t, const_longlong>& _array_literal_const_longlong)
    {
        m_array_literal_const_longlong = _array_literal_const_longlong;
    }

    /*!
     * @brief This function moves the value in member array_literal_const_longlong
     * @param _array_literal_const_longlong New value to be moved in member array_literal_const_longlong
     */
    eProsima_user_DllExport void array_literal_const_longlong(
            std::array<int64_t, const_longlong>&& _array_literal_const_longlong)
    {
        m_array_literal_const_longlong = std::move(_array_literal_const_longlong);
    }

    /*!
     * @brief This function returns a constant reference to member array_literal_const_longlong
     * @return Constant reference to member array_literal_const_longlong
     */
    eProsima_user_DllExport const std::array<int64_t, const_longlong>& array_literal_const_longlong() const
    {
        return m_array_literal_const_longlong;
    }

    /*!
     * @brief This function returns a reference to member array_literal_const_longlong
     * @return Reference to member array_literal_const_longlong
     */
    eProsima_user_DllExport std::array<int64_t, const_longlong>& array_literal_const_longlong()
    {
        return m_array_literal_const_longlong;
    }


    /*!
     * @brief This function copies the value in member array_literal_const_ulonglong
     * @param _array_literal_const_ulonglong New value to be copied in member array_literal_const_ulonglong
     */
    eProsima_user_DllExport void array_literal_const_ulonglong(
            const std::array<uint64_t, const_ulonglong>& _array_literal_const_ulonglong)
    {
        m_array_literal_const_ulonglong = _array_literal_const_ulonglong;
    }

    /*!
     * @brief This function moves the value in member array_literal_const_ulonglong
     * @param _array_literal_const_ulonglong New value to be moved in member array_literal_const_ulonglong
     */
    eProsima_user_DllExport void array_literal_const_ulonglong(
            std::array<uint64_t, const_ulonglong>&& _array_literal_const_ulonglong)
    {
        m_array_literal_const_ulonglong = std::move(_array_literal_const_ulonglong);
    }

    /*!
     * @brief This function returns a constant reference to member array_literal_const_ulonglong
     * @return Constant reference to member array_literal_const_ulonglong
     */
    eProsima_user_DllExport const std::array<uint64_t, const_ulonglong>& array_literal_const_ulonglong() const
    {
        return m_array_literal_const_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member array_literal_const_ulonglong
     * @return Reference to member array_literal_const_ulonglong
     */
    eProsima_user_DllExport std::array<uint64_t, const_ulonglong>& array_literal_const_ulonglong()
    {
        return m_array_literal_const_ulonglong;
    }


    /*!
     * @brief This function copies the value in member array_literal_const_int8
     * @param _array_literal_const_int8 New value to be copied in member array_literal_const_int8
     */
    eProsima_user_DllExport void array_literal_const_int8(
            const std::array<int8_t, const_int8>& _array_literal_const_int8)
    {
        m_array_literal_const_int8 = _array_literal_const_int8;
    }

    /*!
     * @brief This function moves the value in member array_literal_const_int8
     * @param _array_literal_const_int8 New value to be moved in member array_literal_const_int8
     */
    eProsima_user_DllExport void array_literal_const_int8(
            std::array<int8_t, const_int8>&& _array_literal_const_int8)
    {
        m_array_literal_const_int8 = std::move(_array_literal_const_int8);
    }

    /*!
     * @brief This function returns a constant reference to member array_literal_const_int8
     * @return Constant reference to member array_literal_const_int8
     */
    eProsima_user_DllExport const std::array<int8_t, const_int8>& array_literal_const_int8() const
    {
        return m_array_literal_const_int8;
    }

    /*!
     * @brief This function returns a reference to member array_literal_const_int8
     * @return Reference to member array_literal_const_int8
     */
    eProsima_user_DllExport std::array<int8_t, const_int8>& array_literal_const_int8()
    {
        return m_array_literal_const_int8;
    }


    /*!
     * @brief This function copies the value in member array_literal_const_uint8
     * @param _array_literal_const_uint8 New value to be copied in member array_literal_const_uint8
     */
    eProsima_user_DllExport void array_literal_const_uint8(
            const std::array<uint8_t, const_uint8>& _array_literal_const_uint8)
    {
        m_array_literal_const_uint8 = _array_literal_const_uint8;
    }

    /*!
     * @brief This function moves the value in member array_literal_const_uint8
     * @param _array_literal_const_uint8 New value to be moved in member array_literal_const_uint8
     */
    eProsima_user_DllExport void array_literal_const_uint8(
            std::array<uint8_t, const_uint8>&& _array_literal_const_uint8)
    {
        m_array_literal_const_uint8 = std::move(_array_literal_const_uint8);
    }

    /*!
     * @brief This function returns a constant reference to member array_literal_const_uint8
     * @return Constant reference to member array_literal_const_uint8
     */
    eProsima_user_DllExport const std::array<uint8_t, const_uint8>& array_literal_const_uint8() const
    {
        return m_array_literal_const_uint8;
    }

    /*!
     * @brief This function returns a reference to member array_literal_const_uint8
     * @return Reference to member array_literal_const_uint8
     */
    eProsima_user_DllExport std::array<uint8_t, const_uint8>& array_literal_const_uint8()
    {
        return m_array_literal_const_uint8;
    }


    /*!
     * @brief This function copies the value in member array_literal_const_int16
     * @param _array_literal_const_int16 New value to be copied in member array_literal_const_int16
     */
    eProsima_user_DllExport void array_literal_const_int16(
            const std::array<int16_t, const_int16>& _array_literal_const_int16)
    {
        m_array_literal_const_int16 = _array_literal_const_int16;
    }

    /*!
     * @brief This function moves the value in member array_literal_const_int16
     * @param _array_literal_const_int16 New value to be moved in member array_literal_const_int16
     */
    eProsima_user_DllExport void array_literal_const_int16(
            std::array<int16_t, const_int16>&& _array_literal_const_int16)
    {
        m_array_literal_const_int16 = std::move(_array_literal_const_int16);
    }

    /*!
     * @brief This function returns a constant reference to member array_literal_const_int16
     * @return Constant reference to member array_literal_const_int16
     */
    eProsima_user_DllExport const std::array<int16_t, const_int16>& array_literal_const_int16() const
    {
        return m_array_literal_const_int16;
    }

    /*!
     * @brief This function returns a reference to member array_literal_const_int16
     * @return Reference to member array_literal_const_int16
     */
    eProsima_user_DllExport std::array<int16_t, const_int16>& array_literal_const_int16()
    {
        return m_array_literal_const_int16;
    }


    /*!
     * @brief This function copies the value in member array_literal_const_uint16
     * @param _array_literal_const_uint16 New value to be copied in member array_literal_const_uint16
     */
    eProsima_user_DllExport void array_literal_const_uint16(
            const std::array<uint16_t, const_uint16>& _array_literal_const_uint16)
    {
        m_array_literal_const_uint16 = _array_literal_const_uint16;
    }

    /*!
     * @brief This function moves the value in member array_literal_const_uint16
     * @param _array_literal_const_uint16 New value to be moved in member array_literal_const_uint16
     */
    eProsima_user_DllExport void array_literal_const_uint16(
            std::array<uint16_t, const_uint16>&& _array_literal_const_uint16)
    {
        m_array_literal_const_uint16 = std::move(_array_literal_const_uint16);
    }

    /*!
     * @brief This function returns a constant reference to member array_literal_const_uint16
     * @return Constant reference to member array_literal_const_uint16
     */
    eProsima_user_DllExport const std::array<uint16_t, const_uint16>& array_literal_const_uint16() const
    {
        return m_array_literal_const_uint16;
    }

    /*!
     * @brief This function returns a reference to member array_literal_const_uint16
     * @return Reference to member array_literal_const_uint16
     */
    eProsima_user_DllExport std::array<uint16_t, const_uint16>& array_literal_const_uint16()
    {
        return m_array_literal_const_uint16;
    }


    /*!
     * @brief This function copies the value in member array_literal_const_int32
     * @param _array_literal_const_int32 New value to be copied in member array_literal_const_int32
     */
    eProsima_user_DllExport void array_literal_const_int32(
            const std::array<int32_t, const_int32>& _array_literal_const_int32)
    {
        m_array_literal_const_int32 = _array_literal_const_int32;
    }

    /*!
     * @brief This function moves the value in member array_literal_const_int32
     * @param _array_literal_const_int32 New value to be moved in member array_literal_const_int32
     */
    eProsima_user_DllExport void array_literal_const_int32(
            std::array<int32_t, const_int32>&& _array_literal_const_int32)
    {
        m_array_literal_const_int32 = std::move(_array_literal_const_int32);
    }

    /*!
     * @brief This function returns a constant reference to member array_literal_const_int32
     * @return Constant reference to member array_literal_const_int32
     */
    eProsima_user_DllExport const std::array<int32_t, const_int32>& array_literal_const_int32() const
    {
        return m_array_literal_const_int32;
    }

    /*!
     * @brief This function returns a reference to member array_literal_const_int32
     * @return Reference to member array_literal_const_int32
     */
    eProsima_user_DllExport std::array<int32_t, const_int32>& array_literal_const_int32()
    {
        return m_array_literal_const_int32;
    }


    /*!
     * @brief This function copies the value in member array_literal_const_uint32
     * @param _array_literal_const_uint32 New value to be copied in member array_literal_const_uint32
     */
    eProsima_user_DllExport void array_literal_const_uint32(
            const std::array<uint32_t, const_uint32>& _array_literal_const_uint32)
    {
        m_array_literal_const_uint32 = _array_literal_const_uint32;
    }

    /*!
     * @brief This function moves the value in member array_literal_const_uint32
     * @param _array_literal_const_uint32 New value to be moved in member array_literal_const_uint32
     */
    eProsima_user_DllExport void array_literal_const_uint32(
            std::array<uint32_t, const_uint32>&& _array_literal_const_uint32)
    {
        m_array_literal_const_uint32 = std::move(_array_literal_const_uint32);
    }

    /*!
     * @brief This function returns a constant reference to member array_literal_const_uint32
     * @return Constant reference to member array_literal_const_uint32
     */
    eProsima_user_DllExport const std::array<uint32_t, const_uint32>& array_literal_const_uint32() const
    {
        return m_array_literal_const_uint32;
    }

    /*!
     * @brief This function returns a reference to member array_literal_const_uint32
     * @return Reference to member array_literal_const_uint32
     */
    eProsima_user_DllExport std::array<uint32_t, const_uint32>& array_literal_const_uint32()
    {
        return m_array_literal_const_uint32;
    }


    /*!
     * @brief This function copies the value in member array_literal_const_int64
     * @param _array_literal_const_int64 New value to be copied in member array_literal_const_int64
     */
    eProsima_user_DllExport void array_literal_const_int64(
            const std::array<int64_t, const_int64>& _array_literal_const_int64)
    {
        m_array_literal_const_int64 = _array_literal_const_int64;
    }

    /*!
     * @brief This function moves the value in member array_literal_const_int64
     * @param _array_literal_const_int64 New value to be moved in member array_literal_const_int64
     */
    eProsima_user_DllExport void array_literal_const_int64(
            std::array<int64_t, const_int64>&& _array_literal_const_int64)
    {
        m_array_literal_const_int64 = std::move(_array_literal_const_int64);
    }

    /*!
     * @brief This function returns a constant reference to member array_literal_const_int64
     * @return Constant reference to member array_literal_const_int64
     */
    eProsima_user_DllExport const std::array<int64_t, const_int64>& array_literal_const_int64() const
    {
        return m_array_literal_const_int64;
    }

    /*!
     * @brief This function returns a reference to member array_literal_const_int64
     * @return Reference to member array_literal_const_int64
     */
    eProsima_user_DllExport std::array<int64_t, const_int64>& array_literal_const_int64()
    {
        return m_array_literal_const_int64;
    }


    /*!
     * @brief This function copies the value in member array_literal_const_uint64
     * @param _array_literal_const_uint64 New value to be copied in member array_literal_const_uint64
     */
    eProsima_user_DllExport void array_literal_const_uint64(
            const std::array<uint64_t, const_uint64>& _array_literal_const_uint64)
    {
        m_array_literal_const_uint64 = _array_literal_const_uint64;
    }

    /*!
     * @brief This function moves the value in member array_literal_const_uint64
     * @param _array_literal_const_uint64 New value to be moved in member array_literal_const_uint64
     */
    eProsima_user_DllExport void array_literal_const_uint64(
            std::array<uint64_t, const_uint64>&& _array_literal_const_uint64)
    {
        m_array_literal_const_uint64 = std::move(_array_literal_const_uint64);
    }

    /*!
     * @brief This function returns a constant reference to member array_literal_const_uint64
     * @return Constant reference to member array_literal_const_uint64
     */
    eProsima_user_DllExport const std::array<uint64_t, const_uint64>& array_literal_const_uint64() const
    {
        return m_array_literal_const_uint64;
    }

    /*!
     * @brief This function returns a reference to member array_literal_const_uint64
     * @return Reference to member array_literal_const_uint64
     */
    eProsima_user_DllExport std::array<uint64_t, const_uint64>& array_literal_const_uint64()
    {
        return m_array_literal_const_uint64;
    }


    /*!
     * @brief This function copies the value in member array_literals_operations1_const
     * @param _array_literals_operations1_const New value to be copied in member array_literals_operations1_const
     */
    eProsima_user_DllExport void array_literals_operations1_const(
            const std::array<int16_t, const_short+const_long>& _array_literals_operations1_const)
    {
        m_array_literals_operations1_const = _array_literals_operations1_const;
    }

    /*!
     * @brief This function moves the value in member array_literals_operations1_const
     * @param _array_literals_operations1_const New value to be moved in member array_literals_operations1_const
     */
    eProsima_user_DllExport void array_literals_operations1_const(
            std::array<int16_t, const_short+const_long>&& _array_literals_operations1_const)
    {
        m_array_literals_operations1_const = std::move(_array_literals_operations1_const);
    }

    /*!
     * @brief This function returns a constant reference to member array_literals_operations1_const
     * @return Constant reference to member array_literals_operations1_const
     */
    eProsima_user_DllExport const std::array<int16_t, const_short+const_long>& array_literals_operations1_const() const
    {
        return m_array_literals_operations1_const;
    }

    /*!
     * @brief This function returns a reference to member array_literals_operations1_const
     * @return Reference to member array_literals_operations1_const
     */
    eProsima_user_DllExport std::array<int16_t, const_short+const_long>& array_literals_operations1_const()
    {
        return m_array_literals_operations1_const;
    }


    /*!
     * @brief This function copies the value in member array_literals_operations2_const
     * @param _array_literals_operations2_const New value to be copied in member array_literals_operations2_const
     */
    eProsima_user_DllExport void array_literals_operations2_const(
            const std::array<int16_t, const_short-const_long>& _array_literals_operations2_const)
    {
        m_array_literals_operations2_const = _array_literals_operations2_const;
    }

    /*!
     * @brief This function moves the value in member array_literals_operations2_const
     * @param _array_literals_operations2_const New value to be moved in member array_literals_operations2_const
     */
    eProsima_user_DllExport void array_literals_operations2_const(
            std::array<int16_t, const_short-const_long>&& _array_literals_operations2_const)
    {
        m_array_literals_operations2_const = std::move(_array_literals_operations2_const);
    }

    /*!
     * @brief This function returns a constant reference to member array_literals_operations2_const
     * @return Constant reference to member array_literals_operations2_const
     */
    eProsima_user_DllExport const std::array<int16_t, const_short-const_long>& array_literals_operations2_const() const
    {
        return m_array_literals_operations2_const;
    }

    /*!
     * @brief This function returns a reference to member array_literals_operations2_const
     * @return Reference to member array_literals_operations2_const
     */
    eProsima_user_DllExport std::array<int16_t, const_short-const_long>& array_literals_operations2_const()
    {
        return m_array_literals_operations2_const;
    }


    /*!
     * @brief This function copies the value in member array_literals_operations3_const
     * @param _array_literals_operations3_const New value to be copied in member array_literals_operations3_const
     */
    eProsima_user_DllExport void array_literals_operations3_const(
            const std::array<int16_t, const_short+const_module2::const_moduled>& _array_literals_operations3_const)
    {
        m_array_literals_operations3_const = _array_literals_operations3_const;
    }

    /*!
     * @brief This function moves the value in member array_literals_operations3_const
     * @param _array_literals_operations3_const New value to be moved in member array_literals_operations3_const
     */
    eProsima_user_DllExport void array_literals_operations3_const(
            std::array<int16_t, const_short+const_module2::const_moduled>&& _array_literals_operations3_const)
    {
        m_array_literals_operations3_const = std::move(_array_literals_operations3_const);
    }

    /*!
     * @brief This function returns a constant reference to member array_literals_operations3_const
     * @return Constant reference to member array_literals_operations3_const
     */
    eProsima_user_DllExport const std::array<int16_t, const_short+const_module2::const_moduled>& array_literals_operations3_const() const
    {
        return m_array_literals_operations3_const;
    }

    /*!
     * @brief This function returns a reference to member array_literals_operations3_const
     * @return Reference to member array_literals_operations3_const
     */
    eProsima_user_DllExport std::array<int16_t, const_short+const_module2::const_moduled>& array_literals_operations3_const()
    {
        return m_array_literals_operations3_const;
    }


    /*!
     * @brief This function copies the value in member array_literals_operations4_const
     * @param _array_literals_operations4_const New value to be copied in member array_literals_operations4_const
     */
    eProsima_user_DllExport void array_literals_operations4_const(
            const std::array<int16_t, const_module2::const_moduled-const_module1::const_moduled>& _array_literals_operations4_const)
    {
        m_array_literals_operations4_const = _array_literals_operations4_const;
    }

    /*!
     * @brief This function moves the value in member array_literals_operations4_const
     * @param _array_literals_operations4_const New value to be moved in member array_literals_operations4_const
     */
    eProsima_user_DllExport void array_literals_operations4_const(
            std::array<int16_t, const_module2::const_moduled-const_module1::const_moduled>&& _array_literals_operations4_const)
    {
        m_array_literals_operations4_const = std::move(_array_literals_operations4_const);
    }

    /*!
     * @brief This function returns a constant reference to member array_literals_operations4_const
     * @return Constant reference to member array_literals_operations4_const
     */
    eProsima_user_DllExport const std::array<int16_t, const_module2::const_moduled-const_module1::const_moduled>& array_literals_operations4_const() const
    {
        return m_array_literals_operations4_const;
    }

    /*!
     * @brief This function returns a reference to member array_literals_operations4_const
     * @return Reference to member array_literals_operations4_const
     */
    eProsima_user_DllExport std::array<int16_t, const_module2::const_moduled-const_module1::const_moduled>& array_literals_operations4_const()
    {
        return m_array_literals_operations4_const;
    }


    /*!
     * @brief This function copies the value in member array_literals_operations5_const
     * @param _array_literals_operations5_const New value to be copied in member array_literals_operations5_const
     */
    eProsima_user_DllExport void array_literals_operations5_const(
            const std::array<int16_t, const_short*const_long>& _array_literals_operations5_const)
    {
        m_array_literals_operations5_const = _array_literals_operations5_const;
    }

    /*!
     * @brief This function moves the value in member array_literals_operations5_const
     * @param _array_literals_operations5_const New value to be moved in member array_literals_operations5_const
     */
    eProsima_user_DllExport void array_literals_operations5_const(
            std::array<int16_t, const_short*const_long>&& _array_literals_operations5_const)
    {
        m_array_literals_operations5_const = std::move(_array_literals_operations5_const);
    }

    /*!
     * @brief This function returns a constant reference to member array_literals_operations5_const
     * @return Constant reference to member array_literals_operations5_const
     */
    eProsima_user_DllExport const std::array<int16_t, const_short*const_long>& array_literals_operations5_const() const
    {
        return m_array_literals_operations5_const;
    }

    /*!
     * @brief This function returns a reference to member array_literals_operations5_const
     * @return Reference to member array_literals_operations5_const
     */
    eProsima_user_DllExport std::array<int16_t, const_short*const_long>& array_literals_operations5_const()
    {
        return m_array_literals_operations5_const;
    }


    /*!
     * @brief This function copies the value in member array_literals_operations6_const
     * @param _array_literals_operations6_const New value to be copied in member array_literals_operations6_const
     */
    eProsima_user_DllExport void array_literals_operations6_const(
            const std::array<int16_t, const_short/const_long>& _array_literals_operations6_const)
    {
        m_array_literals_operations6_const = _array_literals_operations6_const;
    }

    /*!
     * @brief This function moves the value in member array_literals_operations6_const
     * @param _array_literals_operations6_const New value to be moved in member array_literals_operations6_const
     */
    eProsima_user_DllExport void array_literals_operations6_const(
            std::array<int16_t, const_short/const_long>&& _array_literals_operations6_const)
    {
        m_array_literals_operations6_const = std::move(_array_literals_operations6_const);
    }

    /*!
     * @brief This function returns a constant reference to member array_literals_operations6_const
     * @return Constant reference to member array_literals_operations6_const
     */
    eProsima_user_DllExport const std::array<int16_t, const_short/const_long>& array_literals_operations6_const() const
    {
        return m_array_literals_operations6_const;
    }

    /*!
     * @brief This function returns a reference to member array_literals_operations6_const
     * @return Reference to member array_literals_operations6_const
     */
    eProsima_user_DllExport std::array<int16_t, const_short/const_long>& array_literals_operations6_const()
    {
        return m_array_literals_operations6_const;
    }


    /*!
     * @brief This function copies the value in member array_literals_operations7_const
     * @param _array_literals_operations7_const New value to be copied in member array_literals_operations7_const
     */
    eProsima_user_DllExport void array_literals_operations7_const(
            const std::array<int16_t, const_short*const_module2::const_moduled>& _array_literals_operations7_const)
    {
        m_array_literals_operations7_const = _array_literals_operations7_const;
    }

    /*!
     * @brief This function moves the value in member array_literals_operations7_const
     * @param _array_literals_operations7_const New value to be moved in member array_literals_operations7_const
     */
    eProsima_user_DllExport void array_literals_operations7_const(
            std::array<int16_t, const_short*const_module2::const_moduled>&& _array_literals_operations7_const)
    {
        m_array_literals_operations7_const = std::move(_array_literals_operations7_const);
    }

    /*!
     * @brief This function returns a constant reference to member array_literals_operations7_const
     * @return Constant reference to member array_literals_operations7_const
     */
    eProsima_user_DllExport const std::array<int16_t, const_short*const_module2::const_moduled>& array_literals_operations7_const() const
    {
        return m_array_literals_operations7_const;
    }

    /*!
     * @brief This function returns a reference to member array_literals_operations7_const
     * @return Reference to member array_literals_operations7_const
     */
    eProsima_user_DllExport std::array<int16_t, const_short*const_module2::const_moduled>& array_literals_operations7_const()
    {
        return m_array_literals_operations7_const;
    }


    /*!
     * @brief This function copies the value in member array_literals_operations8_const
     * @param _array_literals_operations8_const New value to be copied in member array_literals_operations8_const
     */
    eProsima_user_DllExport void array_literals_operations8_const(
            const std::array<int16_t, const_module1::const_moduled%const_module2::const_moduled>& _array_literals_operations8_const)
    {
        m_array_literals_operations8_const = _array_literals_operations8_const;
    }

    /*!
     * @brief This function moves the value in member array_literals_operations8_const
     * @param _array_literals_operations8_const New value to be moved in member array_literals_operations8_const
     */
    eProsima_user_DllExport void array_literals_operations8_const(
            std::array<int16_t, const_module1::const_moduled%const_module2::const_moduled>&& _array_literals_operations8_const)
    {
        m_array_literals_operations8_const = std::move(_array_literals_operations8_const);
    }

    /*!
     * @brief This function returns a constant reference to member array_literals_operations8_const
     * @return Constant reference to member array_literals_operations8_const
     */
    eProsima_user_DllExport const std::array<int16_t, const_module1::const_moduled%const_module2::const_moduled>& array_literals_operations8_const() const
    {
        return m_array_literals_operations8_const;
    }

    /*!
     * @brief This function returns a reference to member array_literals_operations8_const
     * @return Reference to member array_literals_operations8_const
     */
    eProsima_user_DllExport std::array<int16_t, const_module1::const_moduled%const_module2::const_moduled>& array_literals_operations8_const()
    {
        return m_array_literals_operations8_const;
    }


    /*!
     * @brief This function copies the value in member array_literal_const_inner_const_helper
     * @param _array_literal_const_inner_const_helper New value to be copied in member array_literal_const_inner_const_helper
     */
    eProsima_user_DllExport void array_literal_const_inner_const_helper(
            const std::array<int16_t, inner_const_helper>& _array_literal_const_inner_const_helper)
    {
        m_array_literal_const_inner_const_helper = _array_literal_const_inner_const_helper;
    }

    /*!
     * @brief This function moves the value in member array_literal_const_inner_const_helper
     * @param _array_literal_const_inner_const_helper New value to be moved in member array_literal_const_inner_const_helper
     */
    eProsima_user_DllExport void array_literal_const_inner_const_helper(
            std::array<int16_t, inner_const_helper>&& _array_literal_const_inner_const_helper)
    {
        m_array_literal_const_inner_const_helper = std::move(_array_literal_const_inner_const_helper);
    }

    /*!
     * @brief This function returns a constant reference to member array_literal_const_inner_const_helper
     * @return Constant reference to member array_literal_const_inner_const_helper
     */
    eProsima_user_DllExport const std::array<int16_t, inner_const_helper>& array_literal_const_inner_const_helper() const
    {
        return m_array_literal_const_inner_const_helper;
    }

    /*!
     * @brief This function returns a reference to member array_literal_const_inner_const_helper
     * @return Reference to member array_literal_const_inner_const_helper
     */
    eProsima_user_DllExport std::array<int16_t, inner_const_helper>& array_literal_const_inner_const_helper()
    {
        return m_array_literal_const_inner_const_helper;
    }


    /*!
     * @brief This function copies the value in member array_moduled1_literal_const
     * @param _array_moduled1_literal_const New value to be copied in member array_moduled1_literal_const
     */
    eProsima_user_DllExport void array_moduled1_literal_const(
            const std::array<int16_t, const_module1::const_moduled>& _array_moduled1_literal_const)
    {
        m_array_moduled1_literal_const = _array_moduled1_literal_const;
    }

    /*!
     * @brief This function moves the value in member array_moduled1_literal_const
     * @param _array_moduled1_literal_const New value to be moved in member array_moduled1_literal_const
     */
    eProsima_user_DllExport void array_moduled1_literal_const(
            std::array<int16_t, const_module1::const_moduled>&& _array_moduled1_literal_const)
    {
        m_array_moduled1_literal_const = std::move(_array_moduled1_literal_const);
    }

    /*!
     * @brief This function returns a constant reference to member array_moduled1_literal_const
     * @return Constant reference to member array_moduled1_literal_const
     */
    eProsima_user_DllExport const std::array<int16_t, const_module1::const_moduled>& array_moduled1_literal_const() const
    {
        return m_array_moduled1_literal_const;
    }

    /*!
     * @brief This function returns a reference to member array_moduled1_literal_const
     * @return Reference to member array_moduled1_literal_const
     */
    eProsima_user_DllExport std::array<int16_t, const_module1::const_moduled>& array_moduled1_literal_const()
    {
        return m_array_moduled1_literal_const;
    }


    /*!
     * @brief This function copies the value in member array_moduled2_literal_const
     * @param _array_moduled2_literal_const New value to be copied in member array_moduled2_literal_const
     */
    eProsima_user_DllExport void array_moduled2_literal_const(
            const std::array<int16_t, const_module2::const_moduled>& _array_moduled2_literal_const)
    {
        m_array_moduled2_literal_const = _array_moduled2_literal_const;
    }

    /*!
     * @brief This function moves the value in member array_moduled2_literal_const
     * @param _array_moduled2_literal_const New value to be moved in member array_moduled2_literal_const
     */
    eProsima_user_DllExport void array_moduled2_literal_const(
            std::array<int16_t, const_module2::const_moduled>&& _array_moduled2_literal_const)
    {
        m_array_moduled2_literal_const = std::move(_array_moduled2_literal_const);
    }

    /*!
     * @brief This function returns a constant reference to member array_moduled2_literal_const
     * @return Constant reference to member array_moduled2_literal_const
     */
    eProsima_user_DllExport const std::array<int16_t, const_module2::const_moduled>& array_moduled2_literal_const() const
    {
        return m_array_moduled2_literal_const;
    }

    /*!
     * @brief This function returns a reference to member array_moduled2_literal_const
     * @return Reference to member array_moduled2_literal_const
     */
    eProsima_user_DllExport std::array<int16_t, const_module2::const_moduled>& array_moduled2_literal_const()
    {
        return m_array_moduled2_literal_const;
    }


    /*!
     * @brief This function copies the value in member array_literal_const_alias_const
     * @param _array_literal_const_alias_const New value to be copied in member array_literal_const_alias_const
     */
    eProsima_user_DllExport void array_literal_const_alias_const(
            const std::array<int16_t, alias_const>& _array_literal_const_alias_const)
    {
        m_array_literal_const_alias_const = _array_literal_const_alias_const;
    }

    /*!
     * @brief This function moves the value in member array_literal_const_alias_const
     * @param _array_literal_const_alias_const New value to be moved in member array_literal_const_alias_const
     */
    eProsima_user_DllExport void array_literal_const_alias_const(
            std::array<int16_t, alias_const>&& _array_literal_const_alias_const)
    {
        m_array_literal_const_alias_const = std::move(_array_literal_const_alias_const);
    }

    /*!
     * @brief This function returns a constant reference to member array_literal_const_alias_const
     * @return Constant reference to member array_literal_const_alias_const
     */
    eProsima_user_DllExport const std::array<int16_t, alias_const>& array_literal_const_alias_const() const
    {
        return m_array_literal_const_alias_const;
    }

    /*!
     * @brief This function returns a reference to member array_literal_const_alias_const
     * @return Reference to member array_literal_const_alias_const
     */
    eProsima_user_DllExport std::array<int16_t, alias_const>& array_literal_const_alias_const()
    {
        return m_array_literal_const_alias_const;
    }


    /*!
     * @brief This function copies the value in member array_moduled1_literal_alias_const_moduled
     * @param _array_moduled1_literal_alias_const_moduled New value to be copied in member array_moduled1_literal_alias_const_moduled
     */
    eProsima_user_DllExport void array_moduled1_literal_alias_const_moduled(
            const std::array<int16_t, const_module1::alias_const_moduled>& _array_moduled1_literal_alias_const_moduled)
    {
        m_array_moduled1_literal_alias_const_moduled = _array_moduled1_literal_alias_const_moduled;
    }

    /*!
     * @brief This function moves the value in member array_moduled1_literal_alias_const_moduled
     * @param _array_moduled1_literal_alias_const_moduled New value to be moved in member array_moduled1_literal_alias_const_moduled
     */
    eProsima_user_DllExport void array_moduled1_literal_alias_const_moduled(
            std::array<int16_t, const_module1::alias_const_moduled>&& _array_moduled1_literal_alias_const_moduled)
    {
        m_array_moduled1_literal_alias_const_moduled = std::move(_array_moduled1_literal_alias_const_moduled);
    }

    /*!
     * @brief This function returns a constant reference to member array_moduled1_literal_alias_const_moduled
     * @return Constant reference to member array_moduled1_literal_alias_const_moduled
     */
    eProsima_user_DllExport const std::array<int16_t, const_module1::alias_const_moduled>& array_moduled1_literal_alias_const_moduled() const
    {
        return m_array_moduled1_literal_alias_const_moduled;
    }

    /*!
     * @brief This function returns a reference to member array_moduled1_literal_alias_const_moduled
     * @return Reference to member array_moduled1_literal_alias_const_moduled
     */
    eProsima_user_DllExport std::array<int16_t, const_module1::alias_const_moduled>& array_moduled1_literal_alias_const_moduled()
    {
        return m_array_moduled1_literal_alias_const_moduled;
    }


    /*!
     * @brief This function copies the value in member array_moduled2_literal_alias_const_moduled
     * @param _array_moduled2_literal_alias_const_moduled New value to be copied in member array_moduled2_literal_alias_const_moduled
     */
    eProsima_user_DllExport void array_moduled2_literal_alias_const_moduled(
            const std::array<int16_t, const_module2::alias_const_moduled>& _array_moduled2_literal_alias_const_moduled)
    {
        m_array_moduled2_literal_alias_const_moduled = _array_moduled2_literal_alias_const_moduled;
    }

    /*!
     * @brief This function moves the value in member array_moduled2_literal_alias_const_moduled
     * @param _array_moduled2_literal_alias_const_moduled New value to be moved in member array_moduled2_literal_alias_const_moduled
     */
    eProsima_user_DllExport void array_moduled2_literal_alias_const_moduled(
            std::array<int16_t, const_module2::alias_const_moduled>&& _array_moduled2_literal_alias_const_moduled)
    {
        m_array_moduled2_literal_alias_const_moduled = std::move(_array_moduled2_literal_alias_const_moduled);
    }

    /*!
     * @brief This function returns a constant reference to member array_moduled2_literal_alias_const_moduled
     * @return Constant reference to member array_moduled2_literal_alias_const_moduled
     */
    eProsima_user_DllExport const std::array<int16_t, const_module2::alias_const_moduled>& array_moduled2_literal_alias_const_moduled() const
    {
        return m_array_moduled2_literal_alias_const_moduled;
    }

    /*!
     * @brief This function returns a reference to member array_moduled2_literal_alias_const_moduled
     * @return Reference to member array_moduled2_literal_alias_const_moduled
     */
    eProsima_user_DllExport std::array<int16_t, const_module2::alias_const_moduled>& array_moduled2_literal_alias_const_moduled()
    {
        return m_array_moduled2_literal_alias_const_moduled;
    }



private:

    std::array<int16_t, const_short> m_array_literal_const_short{0};
    std::array<uint16_t, const_ushort> m_array_literal_const_ushort{0};
    std::array<int32_t, const_long> m_array_literal_const_long{0};
    std::array<uint32_t, const_ulong> m_array_literal_const_ulong{0};
    std::array<int64_t, const_longlong> m_array_literal_const_longlong{0};
    std::array<uint64_t, const_ulonglong> m_array_literal_const_ulonglong{0};
    std::array<int8_t, const_int8> m_array_literal_const_int8{0};
    std::array<uint8_t, const_uint8> m_array_literal_const_uint8{0};
    std::array<int16_t, const_int16> m_array_literal_const_int16{0};
    std::array<uint16_t, const_uint16> m_array_literal_const_uint16{0};
    std::array<int32_t, const_int32> m_array_literal_const_int32{0};
    std::array<uint32_t, const_uint32> m_array_literal_const_uint32{0};
    std::array<int64_t, const_int64> m_array_literal_const_int64{0};
    std::array<uint64_t, const_uint64> m_array_literal_const_uint64{0};
    std::array<int16_t, const_short+const_long> m_array_literals_operations1_const{0};
    std::array<int16_t, const_short-const_long> m_array_literals_operations2_const{0};
    std::array<int16_t, const_short+const_module2::const_moduled> m_array_literals_operations3_const{0};
    std::array<int16_t, const_module2::const_moduled-const_module1::const_moduled> m_array_literals_operations4_const{0};
    std::array<int16_t, const_short*const_long> m_array_literals_operations5_const{0};
    std::array<int16_t, const_short/const_long> m_array_literals_operations6_const{0};
    std::array<int16_t, const_short*const_module2::const_moduled> m_array_literals_operations7_const{0};
    std::array<int16_t, const_module1::const_moduled%const_module2::const_moduled> m_array_literals_operations8_const{0};
    std::array<int16_t, inner_const_helper> m_array_literal_const_inner_const_helper{0};
    std::array<int16_t, const_module1::const_moduled> m_array_moduled1_literal_const{0};
    std::array<int16_t, const_module2::const_moduled> m_array_moduled2_literal_const{0};
    std::array<int16_t, alias_const> m_array_literal_const_alias_const{0};
    std::array<int16_t, const_module1::alias_const_moduled> m_array_moduled1_literal_alias_const_moduled{0};
    std::array<int16_t, const_module2::alias_const_moduled> m_array_moduled2_literal_alias_const_moduled{0};

};

#endif // _FAST_DDS_GENERATED_CONSTANTS_HPP_


