/* $Id: LoopStat.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __LOOP_STAT_HPP_INCLUDED
#define __LOOP_STAT_HPP_INCLUDED

#include <list>
#include "frontend/ast/SeqStat.hpp"

namespace ast {

/** generic class for loop statements */
class LoopStat : public SeqStat {
public:
	//! c'tor
	/** @param lbl label of the loop
         *  @param stats sequential statements enclosed by the loop
	 *  @param loc Location of the Loop statement.
         */
	LoopStat(
		std::string *lbl, 
		std::list<SeqStat*> *stats,
		Location loc
		) : 	SeqStat(lbl, loc),
			loopStats(stats) {}

	/** sequential statements of the loop */
	std::list<SeqStat*> *loopStats;

protected:
	/** Destructor */
	virtual ~LoopStat() {
		util::MiscUtil::lterminate(loopStats);
	}
};
	
}; /* namespace ast */

#endif /* __LOOP_STAT_HPP_INCLUDED */
