/* $Id$ 
 *
 * GetSig: determine the value of a signal.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */
#ifndef __GETSIG_HPP_INCLUDED
#define __GETSIG_HPP_INCLUDED

#include "intermediate/opcodes/OpCode.hpp"
#include "intermediate/operands/Operand.hpp"

namespace intermediate {

//! determine the value of a signal.
/** This class can determine the value of a Signal.
 *
 * Read Operands: src
 * Write Operands: dst
 * Reserved Operands: att
 *
 * src: contains the pointer to a signal instance.
 * dst: destination of the value of the signal.
 * att: reserved (might be used for attributes later on).
 *
 * Operation: dst = value_of_the_signal(src)
 */
class GetSig : public OpCode {
public:
	//! c'tor
	/** @param source source containing the pointer to the signal.
	 *  @param dest destination operand for the value of the signal.
	 *  @param attr reserved.
	 */
	GetSig(
		Operand *source, 
		Operand *dest, 
		Operand *attr
		) : 	src(source),
			dst(dest),
			att(attr) {
		assert(source->type == OP_TYPE_POINTER);
		assert(dest->type != OP_TYPE_POINTER);
	}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	//! source operand
	Operand *src;
	//! destination operand
	Operand *dst;
	//! reserved
	Operand *att;

protected:
	virtual ~GetSig() {
		util::MiscUtil::terminate(this->src);
		util::MiscUtil::terminate(this->dst);
		util::MiscUtil::terminate(this->att);
	}
};

}; /* namespace intermediate */

#endif /* __GETSIG_HPP_INCLUDED */
