/*
 * $Id: sig_parallel.h,v 1.9 2012-03-06 14:46:50 siflkres Exp $
 *
 * Copyright (C) 2006-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_PARALLEL_H_INCLUDED
#define __SIG_PARALLEL_H_INCLUDED

#include "sig_gen.h"

struct sig_parallel_msg {
	unsigned char status;
	unsigned char control;
	unsigned char data;
};

struct sig_parallel_funcs {
	void (*recv)(void *s, struct sig_parallel_msg *msg);
};

struct sig_parallel {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_parallel_funcs *f;
	} member[2];
	unsigned int nmembers;
};

extern void
sig_parallel_send(struct sig_parallel *b, void *s,
		struct sig_parallel_msg *msg);

extern void
sig_parallel_connect(struct sig_parallel *b, void *s,
		const struct sig_parallel_funcs *f);

extern struct sig_parallel *
sig_parallel_create(const char *name);
extern void
sig_parallel_destroy(struct sig_parallel *sig);

extern void
sig_parallel_suspend(struct sig_parallel *b, FILE *fSig);
extern void
sig_parallel_resume(struct sig_parallel *b, FILE *fSig);

#endif /* __SIG_PARALLEL_H_INCLUDED */
