/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.util.Random;
import loci.formats.LogTools;
import loci.formats.codec.BitWriter;

public class BitBuffer {
    private static final int[] BACK_MASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127};
    private static final int[] FRONT_MASK = new int[]{0, 128, 192, 224, 240, 248, 252, 254};
    private int currentByte;
    private int currentBit;
    private byte[] byteBuffer;
    private int eofByte;
    private boolean eofFlag;

    public BitBuffer(byte[] byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.currentByte = 0;
        this.currentBit = 0;
        this.eofByte = byteBuffer.length;
    }

    public void skipBits(long bits) {
        if (bits < 0L) {
            throw new IllegalArgumentException("Bits to skip may not be negative");
        }
        if ((long)this.eofByte * 8L < (long)this.currentByte * 8L + (long)this.currentBit + bits) {
            this.eofFlag = true;
            this.currentByte = this.eofByte;
            this.currentBit = 0;
            return;
        }
        int skipBytes = (int)(bits / 8L);
        int skipBits = (int)(bits % 8L);
        this.currentByte += skipBytes;
        this.currentBit += skipBits;
        if (this.currentBit >= 8) {
            ++this.currentByte;
            this.currentBit -= 8;
        }
    }

    public int getBits(int bitsToRead) {
        if (bitsToRead == 0) {
            return 0;
        }
        if (this.eofFlag) {
            return -1;
        }
        int toStore = 0;
        while (bitsToRead != 0 && !this.eofFlag) {
            int cb;
            if (bitsToRead >= 8 - this.currentBit) {
                if (this.currentBit == 0) {
                    toStore <<= 8;
                    cb = this.byteBuffer[this.currentByte];
                    toStore += cb < 0 ? 256 + cb : cb;
                    bitsToRead -= 8;
                    ++this.currentByte;
                } else {
                    toStore <<= 8 - this.currentBit;
                    toStore += this.byteBuffer[this.currentByte] & BACK_MASK[8 - this.currentBit];
                    bitsToRead -= 8 - this.currentBit;
                    this.currentBit = 0;
                    ++this.currentByte;
                }
            } else {
                toStore <<= bitsToRead;
                cb = this.byteBuffer[this.currentByte];
                cb = cb < 0 ? 256 + cb : cb;
                toStore += (cb & 255 - FRONT_MASK[this.currentBit]) >> 8 - (this.currentBit + bitsToRead);
                this.currentBit += bitsToRead;
                bitsToRead = 0;
            }
            if (this.currentByte != this.eofByte) continue;
            this.eofFlag = true;
            return toStore;
        }
        return toStore;
    }

    public static void main(String[] args) {
        int trials = 50000;
        int[] nums = new int[trials];
        int[] len = new int[trials];
        BitWriter bw = new BitWriter();
        int totallen = 0;
        Random r = new Random();
        LogTools.println("Generating " + trials + " trials.");
        LogTools.println("Writing to byte array");
        for (int i = 0; i < trials; ++i) {
            nums[i] = 31 == i % 32 ? r.nextInt() : r.nextInt(1 << i % 32);
            len[i] = Integer.toBinaryString(nums[i]).length();
            totallen += len[i];
            bw.write(nums[i], len[i]);
        }
        BitBuffer bb = new BitBuffer(bw.toByteArray());
        LogTools.println("Reading from BitBuffer");
        for (int i = 0; i < trials; ++i) {
            int c = r.nextInt(100);
            if (c > 50) {
                int readint = bb.getBits(len[i]);
                if (readint == nums[i]) continue;
                LogTools.println("Error at #" + i + ": " + readint + " received, " + nums[i] + " expected.");
                continue;
            }
            bb.skipBits(len[i]);
        }
        LogTools.println("Testing end of buffer");
        bb = new BitBuffer(bw.toByteArray());
        bb.skipBits(totallen + 8);
        int read = bb.getBits(1);
        if (-1 != read) {
            LogTools.println("-1 expected at end of buffer, " + read + " received.");
        }
    }
}

