/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded3DSet;
import visad.GriddedDoubleSet;
import visad.MathType;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADException;

public class Gridded3DDoubleSet
extends Gridded3DSet
implements GriddedDoubleSet {
    double[] Low = new double[3];
    double[] Hi = new double[3];
    double LowX;
    double HiX;
    double LowY;
    double HiY;
    double LowZ;
    double HiZ;
    double[][] Samples;

    public Gridded3DDoubleSet(MathType type, float[][] samples, int lengthX, int lengthY, int lengthZ) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, lengthY, lengthZ, null, null, null, true);
    }

    public Gridded3DDoubleSet(MathType type, float[][] samples, int lengthX, int lengthY, int lengthZ, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, lengthY, lengthZ, coord_sys, units, errors, true);
    }

    public Gridded3DDoubleSet(MathType type, float[][] samples, int lengthX, int lengthY, int lengthZ, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, lengthY, lengthZ, coord_sys, units, errors, copy);
    }

    public Gridded3DDoubleSet(MathType type, float[][] samples, int lengthX, int lengthY) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, lengthY, null, null, null, true);
    }

    public Gridded3DDoubleSet(MathType type, float[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, lengthY, coord_sys, units, errors, true);
    }

    public Gridded3DDoubleSet(MathType type, float[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, lengthY, coord_sys, units, errors, copy);
    }

    public Gridded3DDoubleSet(MathType type, float[][] samples, int lengthX) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, null, null, null, true);
    }

    public Gridded3DDoubleSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, coord_sys, units, errors, true);
    }

    public Gridded3DDoubleSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, coord_sys, units, errors, copy);
    }

    public Gridded3DDoubleSet(MathType type, double[][] samples, int lengthX, int lengthY, int lengthZ) throws VisADException {
        this(type, samples, lengthX, lengthY, lengthZ, null, null, null, true);
    }

    public Gridded3DDoubleSet(MathType type, double[][] samples, int lengthX, int lengthY, int lengthZ, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, lengthX, lengthY, lengthZ, coord_sys, units, errors, true);
    }

    public Gridded3DDoubleSet(MathType type, double[][] samples, int lengthX, int lengthY, int lengthZ, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        this(type, samples, lengthX, lengthY, lengthZ, coord_sys, units, errors, copy, true);
    }

    public Gridded3DDoubleSet(MathType type, double[][] samples, int lengthX, int lengthY, int lengthZ, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy, boolean test) throws VisADException {
        super(type, null, lengthX, lengthY, lengthZ, coord_sys, units, errors, copy);
        if (samples == null) {
            throw new SetException("Gridded3DDoubleSet: samples are null");
        }
        this.init_doubles(samples, copy);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LengthX = this.Lengths[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.LengthY = this.Lengths[1];
        this.LowZ = this.Low[2];
        this.HiZ = this.Hi[2];
        this.LengthZ = this.Lengths[2];
        if (this.Samples != null && this.Lengths[0] > 1 && this.Lengths[1] > 1 && this.Lengths[2] > 1) {
            for (int i = 0; i < this.Length; ++i) {
                if (this.Samples[0][i] == this.Samples[0][i]) continue;
                throw new SetException("Gridded3DDoubleSet: samples values may not be missing");
            }
            double[] t000 = new double[3];
            double[] t100 = new double[3];
            double[] t010 = new double[3];
            double[] t001 = new double[3];
            double[] t110 = new double[3];
            double[] t101 = new double[3];
            double[] t011 = new double[3];
            double[] t111 = new double[3];
            for (int v = 0; v < 3; ++v) {
                t000[v] = this.Samples[v][0];
                t100[v] = this.Samples[v][1];
                t010[v] = this.Samples[v][this.LengthX];
                t001[v] = this.Samples[v][this.LengthY * this.LengthX];
                t110[v] = this.Samples[v][this.LengthX + 1];
                t101[v] = this.Samples[v][this.LengthY * this.LengthX + 1];
                t011[v] = this.Samples[v][(this.LengthY + 1) * this.LengthX];
                t111[v] = this.Samples[v][(this.LengthY + 1) * this.LengthX + 1];
            }
            double xpos = ((t100[1] - t000[1]) * (t101[2] - t100[2]) - (t100[2] - t000[2]) * (t101[1] - t100[1])) * (t110[0] - t100[0]) + ((t100[2] - t000[2]) * (t101[0] - t100[0]) - (t100[0] - t000[0]) * (t101[2] - t100[2])) * (t110[1] - t100[1]) + ((t100[0] - t000[0]) * (t101[1] - t100[1]) - (t100[1] - t000[1]) * (t101[0] - t100[0])) * (t110[2] - t100[2]);
            boolean bl = this.Pos = xpos > 0.0;
            if (test) {
                double[] v000 = new double[3];
                double[] v100 = new double[3];
                double[] v010 = new double[3];
                double[] v001 = new double[3];
                double[] v110 = new double[3];
                double[] v101 = new double[3];
                double[] v011 = new double[3];
                double[] v111 = new double[3];
                for (int k = 0; k < this.LengthZ - 1; ++k) {
                    for (int j = 0; j < this.LengthY - 1; ++j) {
                        for (int i = 0; i < this.LengthX - 1; ++i) {
                            for (int v = 0; v < 3; ++v) {
                                int zadd = this.LengthY * this.LengthX;
                                int base = k * zadd + j * this.LengthX + i;
                                v000[v] = this.Samples[v][base];
                                v100[v] = this.Samples[v][base + 1];
                                v010[v] = this.Samples[v][base + this.LengthX];
                                v001[v] = this.Samples[v][base + zadd];
                                v110[v] = this.Samples[v][base + this.LengthX + 1];
                                v101[v] = this.Samples[v][base + zadd + 1];
                                v011[v] = this.Samples[v][base + zadd + this.LengthX];
                                v111[v] = this.Samples[v][base + zadd + this.LengthX + 1];
                            }
                            double w1 = ((v100[1] - v000[1]) * (v101[2] - v100[2]) - (v100[2] - v000[2]) * (v101[1] - v100[1])) * (v110[0] - v100[0]) + ((v100[2] - v000[2]) * (v101[0] - v100[0]) - (v100[0] - v000[0]) * (v101[2] - v100[2])) * (v110[1] - v100[1]) + ((v100[0] - v000[0]) * (v101[1] - v100[1]) - (v100[1] - v000[1]) * (v101[0] - v100[0])) * (v110[2] - v100[2]);
                            double w2 = ((v101[1] - v100[1]) * (v001[2] - v101[2]) - (v101[2] - v100[2]) * (v001[1] - v101[1])) * (v111[0] - v101[0]) + ((v101[2] - v100[2]) * (v001[0] - v101[0]) - (v101[0] - v100[0]) * (v001[2] - v101[2])) * (v111[1] - v101[1]) + ((v101[0] - v100[0]) * (v001[1] - v101[1]) - (v101[1] - v100[1]) * (v001[0] - v101[0])) * (v111[2] - v101[2]);
                            double w3 = ((v001[1] - v101[1]) * (v000[2] - v001[2]) - (v001[2] - v101[2]) * (v000[1] - v001[1])) * (v011[0] - v001[0]) + ((v001[2] - v101[2]) * (v000[0] - v001[0]) - (v001[0] - v101[0]) * (v000[2] - v001[2])) * (v011[1] - v001[1]) + ((v001[0] - v101[0]) * (v000[1] - v001[1]) - (v001[1] - v101[1]) * (v000[0] - v001[0])) * (v011[2] - v001[2]);
                            double w4 = ((v000[1] - v001[1]) * (v100[2] - v000[2]) - (v000[2] - v001[2]) * (v100[1] - v000[1])) * (v010[0] - v000[0]) + ((v000[2] - v001[2]) * (v100[0] - v000[0]) - (v000[0] - v001[0]) * (v100[2] - v000[2])) * (v010[1] - v000[1]) + ((v000[0] - v001[0]) * (v100[1] - v000[1]) - (v000[1] - v001[1]) * (v100[0] - v000[0])) * (v010[2] - v000[2]);
                            double w5 = ((v110[1] - v111[1]) * (v010[2] - v110[2]) - (v110[2] - v111[2]) * (v010[1] - v110[1])) * (v100[0] - v110[0]) + ((v110[2] - v111[2]) * (v010[0] - v110[0]) - (v110[0] - v111[0]) * (v010[2] - v110[2])) * (v100[1] - v110[1]) + ((v110[0] - v111[0]) * (v010[1] - v110[1]) - (v110[1] - v111[1]) * (v010[0] - v110[0])) * (v100[2] - v110[2]);
                            double w6 = ((v111[1] - v011[1]) * (v110[2] - v111[2]) - (v111[2] - v011[2]) * (v110[1] - v111[1])) * (v101[0] - v111[0]) + ((v111[2] - v011[2]) * (v110[0] - v111[0]) - (v111[0] - v011[0]) * (v110[2] - v111[2])) * (v101[1] - v111[1]) + ((v111[0] - v011[0]) * (v110[1] - v111[1]) - (v111[1] - v011[1]) * (v110[0] - v111[0])) * (v101[2] - v111[2]);
                            double w7 = ((v011[1] - v010[1]) * (v111[2] - v011[2]) - (v011[2] - v010[2]) * (v111[1] - v011[1])) * (v001[0] - v011[0]) + ((v011[2] - v010[2]) * (v111[0] - v011[0]) - (v011[0] - v010[0]) * (v111[2] - v011[2])) * (v001[1] - v011[1]) + ((v011[0] - v010[0]) * (v111[1] - v011[1]) - (v011[1] - v010[1]) * (v111[0] - v011[0])) * (v001[2] - v011[2]);
                            double w8 = ((v010[1] - v110[1]) * (v011[2] - v010[2]) - (v010[2] - v110[2]) * (v011[1] - v010[1])) * (v000[0] - v010[0]) + ((v010[2] - v110[2]) * (v011[0] - v010[0]) - (v010[0] - v110[0]) * (v011[2] - v010[2])) * (v000[1] - v010[1]) + ((v010[0] - v110[0]) * (v011[1] - v010[1]) - (v010[1] - v110[1]) * (v011[0] - v010[0])) * (v000[2] - v010[2]);
                            if (w1 > 0.0 == this.Pos && w1 != 0.0 && w2 > 0.0 == this.Pos && w2 != 0.0 && w3 > 0.0 == this.Pos && w3 != 0.0 && w4 > 0.0 == this.Pos && w4 != 0.0 && w5 > 0.0 == this.Pos && w5 != 0.0 && w6 > 0.0 == this.Pos && w6 != 0.0 && w7 > 0.0 == this.Pos && w7 != 0.0 && w8 > 0.0 == this.Pos && w8 != 0.0) continue;
                            throw new SetException("Gridded3DDoubleSet: samples do not form a valid grid (" + i + "," + j + "," + k + ")");
                        }
                    }
                }
            }
        }
    }

    public Gridded3DDoubleSet(MathType type, double[][] samples, int lengthX, int lengthY) throws VisADException {
        this(type, samples, lengthX, lengthY, null, null, null, true);
    }

    public Gridded3DDoubleSet(MathType type, double[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, lengthX, lengthY, coord_sys, units, errors, true);
    }

    public Gridded3DDoubleSet(MathType type, double[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        super(type, (float[][])null, lengthX, lengthY, coord_sys, units, errors, copy);
        if (samples == null) {
            throw new SetException("Gridded3DDoubleSet: samples are null");
        }
        this.init_doubles(samples, copy);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LengthX = this.Lengths[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.LengthY = this.Lengths[1];
        this.LowZ = this.Low[2];
        this.HiZ = this.Hi[2];
    }

    public Gridded3DDoubleSet(MathType type, double[][] samples, int lengthX) throws VisADException {
        this(type, samples, lengthX, null, null, null, true);
    }

    public Gridded3DDoubleSet(MathType type, double[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, lengthX, coord_sys, units, errors, true);
    }

    public Gridded3DDoubleSet(MathType type, double[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        super(type, (float[][])null, lengthX, coord_sys, units, errors, copy);
        if (samples == null) {
            throw new SetException("Gridded3DDoubleSet: samples are null");
        }
        this.init_doubles(samples, copy);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LengthX = this.Lengths[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.LowZ = this.Low[2];
        this.HiZ = this.Hi[2];
    }

    public float[][] getSamples() throws VisADException {
        return this.getSamples(true);
    }

    public float[][] getSamples(boolean copy) throws VisADException {
        return Set.doubleToFloat(this.Samples);
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        return Set.doubleToFloat(this.indexToDouble(index));
    }

    public int[] valueToIndex(float[][] value) throws VisADException {
        return this.doubleToIndex(Set.floatToDouble(value));
    }

    public float[][] gridToValue(float[][] grid) throws VisADException {
        return Set.doubleToFloat(this.gridToDouble(Set.floatToDouble(grid)));
    }

    public float[][] valueToGrid(float[][] value) throws VisADException {
        return Set.doubleToFloat(this.doubleToGrid(Set.floatToDouble(value)));
    }

    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        int len = weights.length;
        double[][] w = new double[len][];
        this.doubleToInterp(Set.floatToDouble(value), indices, w);
        for (int i = 0; i < len; ++i) {
            if (w[i] == null) continue;
            weights[i] = new float[w[i].length];
            for (int j = 0; j < w[i].length; ++j) {
                weights[i][j] = (float)w[i][j];
            }
        }
    }

    public double[][] getDoubles() throws VisADException {
        return this.getDoubles(true);
    }

    public double[][] getDoubles(boolean copy) throws VisADException {
        return copy ? Set.copyDoubles(this.Samples) : this.Samples;
    }

    public double[][] indexToDouble(int[] index) throws VisADException {
        int length = index.length;
        if (this.Samples == null) {
            double[][] grid = new double[this.ManifoldDimension][length];
            for (int i = 0; i < length; ++i) {
                int indexZ;
                int indexY;
                int indexX;
                if (0 <= index[i] && index[i] < this.Length) {
                    indexX = index[i] % this.LengthX;
                    int k = index[i] / this.LengthX;
                    indexY = k % this.LengthY;
                    indexZ = k / this.LengthY;
                } else {
                    indexX = -1;
                    indexY = -1;
                    indexZ = -1;
                }
                grid[0][i] = indexX;
                grid[1][i] = indexY;
                grid[2][i] = indexZ;
            }
            return this.gridToDouble(grid);
        }
        double[][] values = new double[3][length];
        for (int i = 0; i < length; ++i) {
            if (0 <= index[i] && index[i] < this.Length) {
                values[0][i] = this.Samples[0][index[i]];
                values[1][i] = this.Samples[1][index[i]];
                values[2][i] = this.Samples[2][index[i]];
                continue;
            }
            values[0][i] = Double.NaN;
            values[1][i] = Double.NaN;
            values[2][i] = Double.NaN;
        }
        return values;
    }

    public int[] doubleToIndex(double[][] value) throws VisADException {
        if (value.length != this.DomainDimension) {
            throw new SetException("Gridded3DDoubleSet.doubleToIndex: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        int[] index = new int[length];
        double[][] grid = this.doubleToGrid(value);
        double[] grid0 = grid[0];
        double[] grid1 = grid[1];
        double[] grid2 = grid[2];
        for (int i = 0; i < length; ++i) {
            double g0 = grid0[i];
            double g1 = grid1[i];
            double g2 = grid2[i];
            index[i] = g0 != g0 || g1 != g1 || g2 != g2 ? -1 : (int)(g0 + 0.5) + this.LengthX * ((int)(g1 + 0.5) + this.LengthY * (int)(g2 + 0.5));
        }
        return index;
    }

    public double[][] gridToDouble(double[][] grid) throws VisADException {
        if (grid.length != this.ManifoldDimension) {
            throw new SetException("Gridded3DDoubleSet.gridToDouble: grid dimension " + grid.length + " not equal to Manifold dimension " + this.ManifoldDimension);
        }
        if (this.ManifoldDimension == 3) {
            return this.gridToDouble3D(grid);
        }
        if (this.ManifoldDimension == 2) {
            return this.gridToDouble2D(grid);
        }
        throw new SetException("Gridded3DDoubleSet.gridToDouble: ManifoldDimension must be 2 or 3");
    }

    private double[][] gridToDouble2D(double[][] grid) throws VisADException {
        if (this.Length > 1 && (this.Lengths[0] < 2 || this.Lengths[1] < 2)) {
            throw new SetException("Gridded3DDoubleSet.gridToDouble: requires all grid dimensions to be > 1");
        }
        int length = Math.min(grid[0].length, grid[1].length);
        double[][] value = new double[3][length];
        for (int i = 0; i < length; ++i) {
            int j;
            double gx = grid[0][i];
            double gy = grid[1][i];
            if (gx < -0.5 || gy < -0.5 || gx > (double)this.LengthX - 0.5 || gy > (double)this.LengthY - 0.5) {
                value[2][i] = Double.NaN;
                value[1][i] = Double.NaN;
                value[0][i] = Double.NaN;
                continue;
            }
            if (this.Length == 1) {
                value[0][i] = this.Samples[0][0];
                value[1][i] = this.Samples[1][0];
                value[2][i] = this.Samples[2][0];
                continue;
            }
            int igx = (int)gx;
            int igy = (int)gy;
            if (igx < 0) {
                igx = 0;
            }
            if (igx > this.LengthX - 2) {
                igx = this.LengthX - 2;
            }
            if (igy < 0) {
                igy = 0;
            }
            if (igy > this.LengthY - 2) {
                igy = this.LengthY - 2;
            }
            int[][] s = new int[][]{{this.LengthX * igy + igx, this.LengthX * (igy + 1) + igx}, {this.LengthX * igy + igx + 1, this.LengthX * (igy + 1) + igx + 1}};
            if (gx + gy - (double)igx - (double)igy - 1.0 <= 0.0) {
                for (j = 0; j < 3; ++j) {
                    value[j][i] = this.Samples[j][s[0][0]] + (gx - (double)igx) * (this.Samples[j][s[1][0]] - this.Samples[j][s[0][0]]) + (gy - (double)igy) * (this.Samples[j][s[0][1]] - this.Samples[j][s[0][0]]);
                }
                continue;
            }
            for (j = 0; j < 3; ++j) {
                value[j][i] = this.Samples[j][s[1][1]] + ((double)(1 + igx) - gx) * (this.Samples[j][s[0][1]] - this.Samples[j][s[1][1]]) + ((double)(1 + igy) - gy) * (this.Samples[j][s[1][0]] - this.Samples[j][s[1][1]]);
            }
        }
        return value;
    }

    private double[][] gridToDouble3D(double[][] grid) throws VisADException {
        if (this.Length > 1 && (this.Lengths[0] < 2 || this.Lengths[1] < 2 || this.Lengths[2] < 2)) {
            throw new SetException("Gridded3DDoubleSet.gridToDouble: requires all grid dimensions to be > 1");
        }
        int length = Math.min(grid[0].length, grid[1].length);
        length = Math.min(length, grid[2].length);
        double[][] value = new double[3][length];
        double[] A = new double[3];
        double[] B = new double[3];
        double[] C = new double[3];
        double[] D = new double[3];
        double[] E = new double[3];
        double[] F = new double[3];
        double[] G = new double[3];
        double[] H = new double[3];
        for (int i = 0; i < length; ++i) {
            int j;
            boolean test4;
            double u;
            double t;
            double s;
            boolean evencube;
            double gx = grid[0][i];
            double gy = grid[1][i];
            double gz = grid[2][i];
            if (gx < -0.5 || gy < -0.5 || gz < -0.5 || gx > (double)this.LengthX - 0.5 || gy > (double)this.LengthY - 0.5 || gz > (double)this.LengthZ - 0.5) {
                value[2][i] = Double.NaN;
                value[1][i] = Double.NaN;
                value[0][i] = Double.NaN;
                continue;
            }
            if (this.Length == 1) {
                value[0][i] = this.Samples[0][0];
                value[1][i] = this.Samples[1][0];
                value[2][i] = this.Samples[2][0];
                continue;
            }
            int igx = gx < 0.0 ? 0 : (gx > (double)(this.LengthX - 2) ? this.LengthX - 2 : (int)gx);
            int igy = gy < 0.0 ? 0 : (gy > (double)(this.LengthY - 2) ? this.LengthY - 2 : (int)gy);
            int igz = gz < 0.0 ? 0 : (gz > (double)(this.LengthZ - 2) ? this.LengthZ - 2 : (int)gz);
            boolean bl = evencube = (igx + igy + igz) % 2 == 0;
            if (evencube) {
                s = gx - (double)igx;
                t = gy - (double)igy;
                u = gz - (double)igz;
            } else {
                s = (double)(1 + igx) - gx;
                t = (double)(1 + igy) - gy;
                u = (double)(1 + igz) - gz;
            }
            int zadd = this.LengthY * this.LengthX;
            int base = igz * zadd + igy * this.LengthX + igx;
            int ai = base + zadd;
            int bi = base + zadd + 1;
            int ci = base + zadd + this.LengthX + 1;
            int di = base + zadd + this.LengthX;
            int ei = base;
            int fi = base + 1;
            int gi = base + this.LengthX + 1;
            int hi = base + this.LengthX;
            if (evencube) {
                A[0] = this.Samples[0][ai];
                A[1] = this.Samples[1][ai];
                A[2] = this.Samples[2][ai];
                B[0] = this.Samples[0][bi];
                B[1] = this.Samples[1][bi];
                B[2] = this.Samples[2][bi];
                C[0] = this.Samples[0][ci];
                C[1] = this.Samples[1][ci];
                C[2] = this.Samples[2][ci];
                D[0] = this.Samples[0][di];
                D[1] = this.Samples[1][di];
                D[2] = this.Samples[2][di];
                E[0] = this.Samples[0][ei];
                E[1] = this.Samples[1][ei];
                E[2] = this.Samples[2][ei];
                F[0] = this.Samples[0][fi];
                F[1] = this.Samples[1][fi];
                F[2] = this.Samples[2][fi];
                G[0] = this.Samples[0][gi];
                G[1] = this.Samples[1][gi];
                G[2] = this.Samples[2][gi];
                H[0] = this.Samples[0][hi];
                H[1] = this.Samples[1][hi];
                H[2] = this.Samples[2][hi];
            } else {
                G[0] = this.Samples[0][ai];
                G[1] = this.Samples[1][ai];
                G[2] = this.Samples[2][ai];
                H[0] = this.Samples[0][bi];
                H[1] = this.Samples[1][bi];
                H[2] = this.Samples[2][bi];
                E[0] = this.Samples[0][ci];
                E[1] = this.Samples[1][ci];
                E[2] = this.Samples[2][ci];
                F[0] = this.Samples[0][di];
                F[1] = this.Samples[1][di];
                F[2] = this.Samples[2][di];
                C[0] = this.Samples[0][ei];
                C[1] = this.Samples[1][ei];
                C[2] = this.Samples[2][ei];
                D[0] = this.Samples[0][fi];
                D[1] = this.Samples[1][fi];
                D[2] = this.Samples[2][fi];
                A[0] = this.Samples[0][gi];
                A[1] = this.Samples[1][gi];
                A[2] = this.Samples[2][gi];
                B[0] = this.Samples[0][hi];
                B[1] = this.Samples[1][hi];
                B[2] = this.Samples[2][hi];
            }
            boolean test1 = 1.0 - s - t - u >= 0.0;
            boolean test2 = s - t + u - 1.0 >= 0.0;
            boolean test3 = t - s + u - 1.0 >= 0.0;
            boolean bl2 = test4 = s + t - u - 1.0 >= 0.0;
            if (gx < 0.0 || gx > (double)(this.LengthX - 1) || gy < 0.0 || gy > (double)(this.LengthY - 1) || gz < 0.0 || gz > (double)(this.LengthZ - 1)) {
                boolean LZ = false;
                boolean LY = false;
                boolean LX = false;
                boolean MZ = false;
                boolean MY = false;
                boolean MX = false;
                boolean OZ = false;
                boolean OY = false;
                boolean OX = false;
                if (igx == 0) {
                    OX = true;
                }
                if (igy == 0) {
                    OY = true;
                }
                if (igz == 0) {
                    OZ = true;
                }
                if (igx == this.LengthX - 2) {
                    LX = true;
                }
                if (igy == this.LengthY - 2) {
                    LY = true;
                }
                if (igz == this.LengthZ - 2) {
                    LZ = true;
                }
                if (!OX && !LX) {
                    MX = true;
                }
                if (!OY && !LY) {
                    MY = true;
                }
                if (!OZ && !LZ) {
                    MZ = true;
                }
                test4 = false;
                test3 = false;
                test2 = false;
                test1 = false;
                if (evencube) {
                    if (!(LX || LY || LZ)) {
                        test1 = true;
                    } else if (LX && OY && MZ || MX && OY && LZ || LX && MY && LZ || LX && OY && LZ || MX && MY && LZ || LX && MY && MZ) {
                        test2 = true;
                    } else if (OX && LY && MZ || OX && MY && LZ || MX && LY && LZ || OX && LY && LZ || MX && LY && MZ) {
                        test3 = true;
                    } else if (MX && LY && OZ || LX && MY && OZ || LX && LY && MZ || LX && LY && OZ) {
                        test4 = true;
                    }
                } else if (!(OX || OY || OZ)) {
                    test1 = true;
                } else if (OX && MY && OZ || MX && LY && OZ || OX && LY && MZ || OX && LY && OZ || MX && MY && OZ || OX && MY && MZ) {
                    test2 = true;
                } else if (LX && MY && OZ || MX && OY && OZ || LX && OY && MZ || LX && OY && OZ || MX && OY && MZ) {
                    test3 = true;
                } else if (OX && OY && MZ || OX && MY && OZ || MX && OY && LZ || OX && OY && LZ) {
                    test4 = true;
                }
            }
            if (test1) {
                for (j = 0; j < 3; ++j) {
                    value[j][i] = E[j] + s * (F[j] - E[j]) + t * (H[j] - E[j]) + u * (A[j] - E[j]);
                }
                continue;
            }
            if (test2) {
                for (j = 0; j < 3; ++j) {
                    value[j][i] = B[j] + (1.0 - s) * (A[j] - B[j]) + t * (C[j] - B[j]) + (1.0 - u) * (F[j] - B[j]);
                }
                continue;
            }
            if (test3) {
                for (j = 0; j < 3; ++j) {
                    value[j][i] = D[j] + s * (C[j] - D[j]) + (1.0 - t) * (A[j] - D[j]) + (1.0 - u) * (H[j] - D[j]);
                }
                continue;
            }
            if (test4) {
                for (j = 0; j < 3; ++j) {
                    value[j][i] = G[j] + (1.0 - s) * (H[j] - G[j]) + (1.0 - t) * (F[j] - G[j]) + u * (C[j] - G[j]);
                }
                continue;
            }
            for (j = 0; j < 3; ++j) {
                value[j][i] = (H[j] + F[j] + A[j] - C[j]) / 2.0 + s * (C[j] + F[j] - H[j] - A[j]) / 2.0 + t * (C[j] - F[j] + H[j] - A[j]) / 2.0 + u * (C[j] - F[j] - H[j] + A[j]) / 2.0;
            }
        }
        return value;
    }

    public double[][] doubleToGrid(double[][] value) throws VisADException {
        if (value.length < this.DomainDimension) {
            throw new SetException("Gridded3DDoubleSet.doubleToGrid: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.ManifoldDimension < 3) {
            throw new SetException("Gridded3DDoubleSet.doubleToGrid: ManifoldDimension must be 3");
        }
        if (this.Length > 1 && (this.Lengths[0] < 2 || this.Lengths[1] < 2 || this.Lengths[2] < 2)) {
            throw new SetException("Gridded3DDoubleSet.doubleToGrid: requires all grid dimensions to be > 1");
        }
        int length = Math.min(value[0].length, value[1].length);
        length = Math.min(length, value[2].length);
        double[][] grid = new double[this.ManifoldDimension][length];
        int gx = (this.LengthX - 1) / 2;
        int gy = (this.LengthY - 1) / 2;
        int gz = (this.LengthZ - 1) / 2;
        double[] A = new double[3];
        double[] B = new double[3];
        double[] C = new double[3];
        double[] D = new double[3];
        double[] E = new double[3];
        double[] F = new double[3];
        double[] G = new double[3];
        double[] H = new double[3];
        double[] M = new double[3];
        double[] N = new double[3];
        double[] O = new double[3];
        double[] P = new double[3];
        double[] X = new double[3];
        double[] Y = new double[3];
        double[] Q = new double[3];
        for (int i = 0; i < length; ++i) {
            if (this.Length == 1) {
                if (Double.isNaN(value[0][i]) || Double.isNaN(value[1][i]) || Double.isNaN(value[2][i])) {
                    grid[2][i] = Double.NaN;
                    grid[1][i] = Double.NaN;
                    grid[0][i] = Double.NaN;
                    continue;
                }
                grid[0][i] = 0.0;
                grid[1][i] = 0.0;
                grid[2][i] = 0.0;
                continue;
            }
            boolean offgrid = false;
            if (i != 0 && grid[0][i - 1] != grid[0][i - 1]) {
                gx = (this.LengthX - 1) / 2;
                gy = (this.LengthY - 1) / 2;
                gz = (this.LengthZ - 1) / 2;
            }
            int tetnum = 5;
            grid[2][i] = Double.NaN;
            grid[1][i] = Double.NaN;
            grid[0][i] = Double.NaN;
            for (int itnum = 0; itnum < 2 * (this.LengthX + this.LengthY + this.LengthZ); ++itnum) {
                double t;
                double s;
                boolean test4;
                double ad2;
                double ad1;
                double ad0;
                double d2;
                int j;
                boolean test3;
                boolean test2;
                boolean test1;
                double tval3;
                double tval2;
                double tval1;
                boolean evencube = (gx + gy + gz) % 2 == 0;
                int zadd = this.LengthY * this.LengthX;
                int base = gz * zadd + gy * this.LengthX + gx;
                int ai = base + zadd;
                int bi = base + zadd + 1;
                int ci = base + zadd + this.LengthX + 1;
                int di = base + zadd + this.LengthX;
                int ei = base;
                int fi = base + 1;
                int gi = base + this.LengthX + 1;
                int hi = base + this.LengthX;
                if (evencube) {
                    A[0] = this.Samples[0][ai];
                    A[1] = this.Samples[1][ai];
                    A[2] = this.Samples[2][ai];
                    B[0] = this.Samples[0][bi];
                    B[1] = this.Samples[1][bi];
                    B[2] = this.Samples[2][bi];
                    C[0] = this.Samples[0][ci];
                    C[1] = this.Samples[1][ci];
                    C[2] = this.Samples[2][ci];
                    D[0] = this.Samples[0][di];
                    D[1] = this.Samples[1][di];
                    D[2] = this.Samples[2][di];
                    E[0] = this.Samples[0][ei];
                    E[1] = this.Samples[1][ei];
                    E[2] = this.Samples[2][ei];
                    F[0] = this.Samples[0][fi];
                    F[1] = this.Samples[1][fi];
                    F[2] = this.Samples[2][fi];
                    G[0] = this.Samples[0][gi];
                    G[1] = this.Samples[1][gi];
                    G[2] = this.Samples[2][gi];
                    H[0] = this.Samples[0][hi];
                    H[1] = this.Samples[1][hi];
                    H[2] = this.Samples[2][hi];
                } else {
                    G[0] = this.Samples[0][ai];
                    G[1] = this.Samples[1][ai];
                    G[2] = this.Samples[2][ai];
                    H[0] = this.Samples[0][bi];
                    H[1] = this.Samples[1][bi];
                    H[2] = this.Samples[2][bi];
                    E[0] = this.Samples[0][ci];
                    E[1] = this.Samples[1][ci];
                    E[2] = this.Samples[2][ci];
                    F[0] = this.Samples[0][di];
                    F[1] = this.Samples[1][di];
                    F[2] = this.Samples[2][di];
                    C[0] = this.Samples[0][ei];
                    C[1] = this.Samples[1][ei];
                    C[2] = this.Samples[2][ei];
                    D[0] = this.Samples[0][fi];
                    D[1] = this.Samples[1][fi];
                    D[2] = this.Samples[2][fi];
                    A[0] = this.Samples[0][gi];
                    A[1] = this.Samples[1][gi];
                    A[2] = this.Samples[2][gi];
                    B[0] = this.Samples[0][hi];
                    B[1] = this.Samples[1][hi];
                    B[2] = this.Samples[2][hi];
                }
                int ogx = gx;
                int ogy = gy;
                int ogz = gz;
                if (tetnum == 1) {
                    double t2;
                    double s2;
                    int updown;
                    tval1 = ((E[1] - A[1]) * (F[2] - E[2]) - (E[2] - A[2]) * (F[1] - E[1])) * (value[0][i] - E[0]) + ((E[2] - A[2]) * (F[0] - E[0]) - (E[0] - A[0]) * (F[2] - E[2])) * (value[1][i] - E[1]) + ((E[0] - A[0]) * (F[1] - E[1]) - (E[1] - A[1]) * (F[0] - E[0])) * (value[2][i] - E[2]);
                    tval2 = ((E[1] - H[1]) * (A[2] - E[2]) - (E[2] - H[2]) * (A[1] - E[1])) * (value[0][i] - E[0]) + ((E[2] - H[2]) * (A[0] - E[0]) - (E[0] - H[0]) * (A[2] - E[2])) * (value[1][i] - E[1]) + ((E[0] - H[0]) * (A[1] - E[1]) - (E[1] - H[1]) * (A[0] - E[0])) * (value[2][i] - E[2]);
                    tval3 = ((E[1] - F[1]) * (H[2] - E[2]) - (E[2] - F[2]) * (H[1] - E[1])) * (value[0][i] - E[0]) + ((E[2] - F[2]) * (H[0] - E[0]) - (E[0] - F[0]) * (H[2] - E[2])) * (value[1][i] - E[1]) + ((E[0] - F[0]) * (H[1] - E[1]) - (E[1] - F[1]) * (H[0] - E[0])) * (value[2][i] - E[2]);
                    boolean bl = tval1 == 0.0 || tval1 > 0.0 == !evencube ^ this.Pos ? true : (test1 = false);
                    boolean bl2 = tval2 == 0.0 || tval2 > 0.0 == !evencube ^ this.Pos ? true : (test2 = false);
                    test3 = tval3 == 0.0 || tval3 > 0.0 == !evencube ^ this.Pos;
                    int n = updown = evencube ? -1 : 1;
                    if (!test1) {
                        gy += updown;
                    }
                    if (!test2) {
                        gx += updown;
                    }
                    if (!test3) {
                        gz += updown;
                    }
                    tetnum = 5;
                    if (gx < 0) {
                        gx = 0;
                    }
                    if (gy < 0) {
                        gy = 0;
                    }
                    if (gz < 0) {
                        gz = 0;
                    }
                    if (gx > this.LengthX - 2) {
                        gx = this.LengthX - 2;
                    }
                    if (gy > this.LengthY - 2) {
                        gy = this.LengthY - 2;
                    }
                    if (gz > this.LengthZ - 2) {
                        gz = this.LengthZ - 2;
                    }
                    if (!(gx != ogx || gy != ogy || gz != ogz || test1 && test2 && test3 || offgrid)) {
                        offgrid = true;
                        continue;
                    }
                    if ((gx != ogx || gy != ogy || gz != ogz) && !offgrid) continue;
                    for (int j2 = 0; j2 < 3; ++j2) {
                        M[j2] = (F[j2] - E[j2]) * (A[(j2 + 1) % 3] - E[(j2 + 1) % 3]) - (F[(j2 + 1) % 3] - E[(j2 + 1) % 3]) * (A[j2] - E[j2]);
                        N[j2] = (H[j2] - E[j2]) * (A[(j2 + 1) % 3] - E[(j2 + 1) % 3]) - (H[(j2 + 1) % 3] - E[(j2 + 1) % 3]) * (A[j2] - E[j2]);
                        O[j2] = (F[(j2 + 1) % 3] - E[(j2 + 1) % 3]) * (A[(j2 + 2) % 3] - E[(j2 + 2) % 3]) - (F[(j2 + 2) % 3] - E[(j2 + 2) % 3]) * (A[(j2 + 1) % 3] - E[(j2 + 1) % 3]);
                        P[j2] = (H[(j2 + 1) % 3] - E[(j2 + 1) % 3]) * (A[(j2 + 2) % 3] - E[(j2 + 2) % 3]) - (H[(j2 + 2) % 3] - E[(j2 + 2) % 3]) * (A[(j2 + 1) % 3] - E[(j2 + 1) % 3]);
                        X[j2] = value[(j2 + 2) % 3][i] * (A[(j2 + 1) % 3] - E[(j2 + 1) % 3]) - value[(j2 + 1) % 3][i] * (A[(j2 + 2) % 3] - E[(j2 + 2) % 3]) + E[(j2 + 1) % 3] * A[(j2 + 2) % 3] - E[(j2 + 2) % 3] * A[(j2 + 1) % 3];
                        Y[j2] = value[j2][i] * (A[(j2 + 1) % 3] - E[(j2 + 1) % 3]) - value[(j2 + 1) % 3][i] * (A[j2] - E[j2]) + E[(j2 + 1) % 3] * A[j2] - E[j2] * A[(j2 + 1) % 3];
                    }
                    double d0 = M[0] * P[0] - N[0] * O[0];
                    double d1 = M[1] * P[1] - N[1] * O[1];
                    double d22 = M[2] * P[2] - N[2] * O[2];
                    double ad02 = Math.abs(d0);
                    double ad12 = Math.abs(d1);
                    double ad22 = Math.abs(d22);
                    if (ad02 > ad12 && ad02 > ad22) {
                        s2 = (N[0] * X[0] + P[0] * Y[0]) / d0;
                        t2 = -(M[0] * X[0] + O[0] * Y[0]) / d0;
                    } else if (ad12 > ad22) {
                        s2 = (N[1] * X[1] + P[1] * Y[1]) / d1;
                        t2 = -(M[1] * X[1] + O[1] * Y[1]) / d1;
                    } else {
                        s2 = (N[2] * X[2] + P[2] * Y[2]) / d22;
                        t2 = -(M[2] * X[2] + O[2] * Y[2]) / d22;
                    }
                    d0 = A[0] - E[0];
                    d1 = A[1] - E[1];
                    d22 = A[2] - E[2];
                    ad02 = Math.abs(d0);
                    ad12 = Math.abs(d1);
                    ad22 = Math.abs(d22);
                    double u = ad02 > ad12 && ad02 > ad22 ? (value[0][i] - E[0] - s2 * (F[0] - E[0]) - t2 * (H[0] - E[0])) / d0 : (ad12 > ad22 ? (value[1][i] - E[1] - s2 * (F[1] - E[1]) - t2 * (H[1] - E[1])) / d1 : (value[2][i] - E[2] - s2 * (F[2] - E[2]) - t2 * (H[2] - E[2])) / d22);
                    if (evencube) {
                        grid[0][i] = (double)gx + s2;
                        grid[1][i] = (double)gy + t2;
                        grid[2][i] = (double)gz + u;
                        break;
                    }
                    grid[0][i] = (double)(gx + 1) - s2;
                    grid[1][i] = (double)(gy + 1) - t2;
                    grid[2][i] = (double)(gz + 1) - u;
                    break;
                }
                if (tetnum == 2) {
                    double t3;
                    double s3;
                    tval1 = ((B[1] - C[1]) * (F[2] - B[2]) - (B[2] - C[2]) * (F[1] - B[1])) * (value[0][i] - B[0]) + ((B[2] - C[2]) * (F[0] - B[0]) - (B[0] - C[0]) * (F[2] - B[2])) * (value[1][i] - B[1]) + ((B[0] - C[0]) * (F[1] - B[1]) - (B[1] - C[1]) * (F[0] - B[0])) * (value[2][i] - B[2]);
                    tval2 = ((B[1] - A[1]) * (C[2] - B[2]) - (B[2] - A[2]) * (C[1] - B[1])) * (value[0][i] - B[0]) + ((B[2] - A[2]) * (C[0] - B[0]) - (B[0] - A[0]) * (C[2] - B[2])) * (value[1][i] - B[1]) + ((B[0] - A[0]) * (C[1] - B[1]) - (B[1] - A[1]) * (C[0] - B[0])) * (value[2][i] - B[2]);
                    tval3 = ((B[1] - F[1]) * (A[2] - B[2]) - (B[2] - F[2]) * (A[1] - B[1])) * (value[0][i] - B[0]) + ((B[2] - F[2]) * (A[0] - B[0]) - (B[0] - F[0]) * (A[2] - B[2])) * (value[1][i] - B[1]) + ((B[0] - F[0]) * (A[1] - B[1]) - (B[1] - F[1]) * (A[0] - B[0])) * (value[2][i] - B[2]);
                    boolean bl = tval1 == 0.0 || tval1 > 0.0 == !evencube ^ this.Pos ? true : (test1 = false);
                    boolean bl3 = tval2 == 0.0 || tval2 > 0.0 == !evencube ^ this.Pos ? true : (test2 = false);
                    boolean bl4 = tval3 == 0.0 || tval3 > 0.0 == !evencube ^ this.Pos ? true : (test3 = false);
                    if (!test1 && evencube) {
                        ++gx;
                    }
                    if (!test1 && !evencube) {
                        --gx;
                    }
                    if (!test2 && evencube) {
                        ++gz;
                    }
                    if (!test2 && !evencube) {
                        --gz;
                    }
                    if (!test3 && evencube) {
                        --gy;
                    }
                    if (!test3 && !evencube) {
                        ++gy;
                    }
                    tetnum = 5;
                    if (gx < 0) {
                        gx = 0;
                    }
                    if (gy < 0) {
                        gy = 0;
                    }
                    if (gz < 0) {
                        gz = 0;
                    }
                    if (gx > this.LengthX - 2) {
                        gx = this.LengthX - 2;
                    }
                    if (gy > this.LengthY - 2) {
                        gy = this.LengthY - 2;
                    }
                    if (gz > this.LengthZ - 2) {
                        gz = this.LengthZ - 2;
                    }
                    if (!(gx != ogx || gy != ogy || gz != ogz || test1 && test2 && test3 || offgrid)) {
                        offgrid = true;
                        continue;
                    }
                    if ((gx != ogx || gy != ogy || gz != ogz) && !offgrid) continue;
                    for (j = 0; j < 3; ++j) {
                        M[j] = (A[j] - B[j]) * (F[(j + 1) % 3] - B[(j + 1) % 3]) - (A[(j + 1) % 3] - B[(j + 1) % 3]) * (F[j] - B[j]);
                        N[j] = (C[j] - B[j]) * (F[(j + 1) % 3] - B[(j + 1) % 3]) - (C[(j + 1) % 3] - B[(j + 1) % 3]) * (F[j] - B[j]);
                        O[j] = (A[(j + 1) % 3] - B[(j + 1) % 3]) * (F[(j + 2) % 3] - B[(j + 2) % 3]) - (A[(j + 2) % 3] - B[(j + 2) % 3]) * (F[(j + 1) % 3] - B[(j + 1) % 3]);
                        P[j] = (C[(j + 1) % 3] - B[(j + 1) % 3]) * (F[(j + 2) % 3] - B[(j + 2) % 3]) - (C[(j + 2) % 3] - B[(j + 2) % 3]) * (F[(j + 1) % 3] - B[(j + 1) % 3]);
                        X[j] = value[(j + 2) % 3][i] * (F[(j + 1) % 3] - B[(j + 1) % 3]) - value[(j + 1) % 3][i] * (F[(j + 2) % 3] - B[(j + 2) % 3]) + B[(j + 1) % 3] * F[(j + 2) % 3] - B[(j + 2) % 3] * F[(j + 1) % 3];
                        Y[j] = value[j][i] * (F[(j + 1) % 3] - B[(j + 1) % 3]) - value[1][i] * (F[j] - B[j]) + B[(j + 1) % 3] * F[j] - B[j] * F[(j + 1) % 3];
                    }
                    double d0 = M[0] * P[0] - N[0] * O[0];
                    double d1 = M[1] * P[1] - N[1] * O[1];
                    d2 = M[2] * P[2] - N[2] * O[2];
                    ad0 = Math.abs(d0);
                    ad1 = Math.abs(d1);
                    ad2 = Math.abs(d2);
                    if (ad0 > ad1 && ad0 > ad2) {
                        s3 = 1.0 - (N[0] * X[0] + P[0] * Y[0]) / d0;
                        t3 = -(M[0] * X[0] + O[0] * Y[0]) / d0;
                    } else if (ad1 > ad2) {
                        s3 = 1.0 - (N[1] * X[1] + P[1] * Y[1]) / d1;
                        t3 = -(M[1] * X[1] + O[1] * Y[1]) / d1;
                    } else {
                        s3 = 1.0 - (N[2] * X[2] + P[2] * Y[2]) / d2;
                        t3 = -(M[2] * X[2] + O[2] * Y[2]) / d2;
                    }
                    d0 = F[0] - B[0];
                    d1 = F[1] - B[1];
                    d2 = F[2] - B[2];
                    ad0 = Math.abs(d0);
                    ad1 = Math.abs(d1);
                    ad2 = Math.abs(d2);
                    double u = ad0 > ad1 && ad0 > ad2 ? 1.0 - (value[0][i] - B[0] - (1.0 - s3) * (A[0] - B[0]) - t3 * (C[0] - B[0])) / d0 : (ad1 > ad2 ? 1.0 - (value[1][i] - B[1] - (1.0 - s3) * (A[1] - B[1]) - t3 * (C[1] - B[1])) / d1 : 1.0 - (value[2][i] - B[2] - (1.0 - s3) * (A[2] - B[2]) - t3 * (C[2] - B[2])) / d2);
                    if (evencube) {
                        grid[0][i] = (double)gx + s3;
                        grid[1][i] = (double)gy + t3;
                        grid[2][i] = (double)gz + u;
                        break;
                    }
                    grid[0][i] = (double)(gx + 1) - s3;
                    grid[1][i] = (double)(gy + 1) - t3;
                    grid[2][i] = (double)(gz + 1) - u;
                    break;
                }
                if (tetnum == 3) {
                    double t4;
                    double s4;
                    tval1 = ((D[1] - A[1]) * (H[2] - D[2]) - (D[2] - A[2]) * (H[1] - D[1])) * (value[0][i] - D[0]) + ((D[2] - A[2]) * (H[0] - D[0]) - (D[0] - A[0]) * (H[2] - D[2])) * (value[1][i] - D[1]) + ((D[0] - A[0]) * (H[1] - D[1]) - (D[1] - A[1]) * (H[0] - D[0])) * (value[2][i] - D[2]);
                    tval2 = ((D[1] - C[1]) * (A[2] - D[2]) - (D[2] - C[2]) * (A[1] - D[1])) * (value[0][i] - D[0]) + ((D[2] - C[2]) * (A[0] - D[0]) - (D[0] - C[0]) * (A[2] - D[2])) * (value[1][i] - D[1]) + ((D[0] - C[0]) * (A[1] - D[1]) - (D[1] - C[1]) * (A[0] - D[0])) * (value[2][i] - D[2]);
                    tval3 = ((D[1] - H[1]) * (C[2] - D[2]) - (D[2] - H[2]) * (C[1] - D[1])) * (value[0][i] - D[0]) + ((D[2] - H[2]) * (C[0] - D[0]) - (D[0] - H[0]) * (C[2] - D[2])) * (value[1][i] - D[1]) + ((D[0] - H[0]) * (C[1] - D[1]) - (D[1] - H[1]) * (C[0] - D[0])) * (value[2][i] - D[2]);
                    boolean bl = tval1 == 0.0 || tval1 > 0.0 == !evencube ^ this.Pos ? true : (test1 = false);
                    boolean bl5 = tval2 == 0.0 || tval2 > 0.0 == !evencube ^ this.Pos ? true : (test2 = false);
                    boolean bl6 = tval3 == 0.0 || tval3 > 0.0 == !evencube ^ this.Pos ? true : (test3 = false);
                    if (!test1 && evencube) {
                        --gx;
                    }
                    if (!test1 && !evencube) {
                        ++gx;
                    }
                    if (!test2 && evencube) {
                        ++gz;
                    }
                    if (!test2 && !evencube) {
                        --gz;
                    }
                    if (!test3 && evencube) {
                        ++gy;
                    }
                    if (!test3 && !evencube) {
                        --gy;
                    }
                    tetnum = 5;
                    if (gx < 0) {
                        gx = 0;
                    }
                    if (gy < 0) {
                        gy = 0;
                    }
                    if (gz < 0) {
                        gz = 0;
                    }
                    if (gx > this.LengthX - 2) {
                        gx = this.LengthX - 2;
                    }
                    if (gy > this.LengthY - 2) {
                        gy = this.LengthY - 2;
                    }
                    if (gz > this.LengthZ - 2) {
                        gz = this.LengthZ - 2;
                    }
                    if (!(gx != ogx || gy != ogy || gz != ogz || test1 && test2 && test3 || offgrid)) {
                        offgrid = true;
                        continue;
                    }
                    if ((gx != ogx || gy != ogy || gz != ogz) && !offgrid) continue;
                    for (j = 0; j < 3; ++j) {
                        M[j] = (C[j] - D[j]) * (H[(j + 1) % 3] - D[(j + 1) % 3]) - (C[(j + 1) % 3] - D[(j + 1) % 3]) * (H[j] - D[j]);
                        N[j] = (A[j] - D[j]) * (H[(j + 1) % 3] - D[(j + 1) % 3]) - (A[(j + 1) % 3] - D[(j + 1) % 3]) * (H[j] - D[j]);
                        O[j] = (C[(j + 1) % 3] - D[(j + 1) % 3]) * (H[(j + 2) % 3] - D[(j + 2) % 3]) - (C[(j + 2) % 3] - D[(j + 2) % 3]) * (H[(j + 1) % 3] - D[(j + 1) % 3]);
                        P[j] = (A[(j + 1) % 3] - D[(j + 1) % 3]) * (H[(j + 2) % 3] - D[(j + 2) % 3]) - (A[(j + 2) % 3] - D[(j + 2) % 3]) * (H[(j + 1) % 3] - D[(j + 1) % 3]);
                        X[j] = value[(j + 2) % 3][i] * (H[(j + 1) % 3] - D[(j + 1) % 3]) - value[(j + 1) % 3][i] * (H[(j + 2) % 3] - D[(j + 2) % 3]) + D[(j + 1) % 3] * H[(j + 2) % 3] - D[(j + 2) % 3] * H[(j + 1) % 3];
                        Y[j] = value[j][i] * (H[(j + 1) % 3] - D[(j + 1) % 3]) - value[(j + 1) % 3][i] * (H[j] - D[j]) + D[(j + 1) % 3] * H[j] - D[j] * H[(j + 1) % 3];
                    }
                    double d0 = M[0] * P[0] - N[0] * O[0];
                    double d1 = M[1] * P[1] - N[1] * O[1];
                    d2 = M[2] * P[2] - N[2] * O[2];
                    ad0 = Math.abs(d0);
                    ad1 = Math.abs(d1);
                    ad2 = Math.abs(d2);
                    if (ad0 > ad1 && ad0 > ad2) {
                        s4 = (N[0] * X[0] + P[0] * Y[0]) / d0;
                        t4 = 1.0 + (M[0] * X[0] + O[0] * Y[0]) / d0;
                    } else if (ad1 > ad2) {
                        s4 = (N[1] * X[1] + P[1] * Y[1]) / d1;
                        t4 = 1.0 + (M[1] * X[1] + O[1] * Y[1]) / d1;
                    } else {
                        s4 = (N[2] * X[2] + P[2] * Y[2]) / d2;
                        t4 = 1.0 + (M[2] * X[2] + O[2] * Y[2]) / d2;
                    }
                    d0 = H[0] - D[0];
                    d1 = H[1] - D[1];
                    d2 = H[2] - D[2];
                    ad0 = Math.abs(d0);
                    ad1 = Math.abs(d1);
                    ad2 = Math.abs(d2);
                    double u = ad0 > ad1 && ad0 > ad2 ? 1.0 - (value[0][i] - D[0] - s4 * (C[0] - D[0]) - (1.0 - t4) * (A[0] - D[0])) / d0 : (ad1 > ad2 ? 1.0 - (value[1][i] - D[1] - s4 * (C[1] - D[1]) - (1.0 - t4) * (A[1] - D[1])) / d1 : 1.0 - (value[2][i] - D[2] - s4 * (C[2] - D[2]) - (1.0 - t4) * (A[2] - D[2])) / d2);
                    if (evencube) {
                        grid[0][i] = (double)gx + s4;
                        grid[1][i] = (double)gy + t4;
                        grid[2][i] = (double)gz + u;
                        break;
                    }
                    grid[0][i] = (double)(gx + 1) - s4;
                    grid[1][i] = (double)(gy + 1) - t4;
                    grid[2][i] = (double)(gz + 1) - u;
                    break;
                }
                if (tetnum == 4) {
                    double t5;
                    double s5;
                    tval1 = ((G[1] - C[1]) * (H[2] - G[2]) - (G[2] - C[2]) * (H[1] - G[1])) * (value[0][i] - G[0]) + ((G[2] - C[2]) * (H[0] - G[0]) - (G[0] - C[0]) * (H[2] - G[2])) * (value[1][i] - G[1]) + ((G[0] - C[0]) * (H[1] - G[1]) - (G[1] - C[1]) * (H[0] - G[0])) * (value[2][i] - G[2]);
                    tval2 = ((G[1] - F[1]) * (C[2] - G[2]) - (G[2] - F[2]) * (C[1] - G[1])) * (value[0][i] - G[0]) + ((G[2] - F[2]) * (C[0] - G[0]) - (G[0] - F[0]) * (C[2] - G[2])) * (value[1][i] - G[1]) + ((G[0] - F[0]) * (C[1] - G[1]) - (G[1] - F[1]) * (C[0] - G[0])) * (value[2][i] - G[2]);
                    tval3 = ((G[1] - H[1]) * (F[2] - G[2]) - (G[2] - H[2]) * (F[1] - G[1])) * (value[0][i] - G[0]) + ((G[2] - H[2]) * (F[0] - G[0]) - (G[0] - H[0]) * (F[2] - G[2])) * (value[1][i] - G[1]) + ((G[0] - H[0]) * (F[1] - G[1]) - (G[1] - H[1]) * (F[0] - G[0])) * (value[2][i] - G[2]);
                    boolean bl = tval1 == 0.0 || tval1 > 0.0 == !evencube ^ this.Pos ? true : (test1 = false);
                    boolean bl7 = tval2 == 0.0 || tval2 > 0.0 == !evencube ^ this.Pos ? true : (test2 = false);
                    boolean bl8 = tval3 == 0.0 || tval3 > 0.0 == !evencube ^ this.Pos ? true : (test3 = false);
                    if (!test1 && evencube) {
                        ++gy;
                    }
                    if (!test1 && !evencube) {
                        --gy;
                    }
                    if (!test2 && evencube) {
                        ++gx;
                    }
                    if (!test2 && !evencube) {
                        --gx;
                    }
                    if (!test3 && evencube) {
                        --gz;
                    }
                    if (!test3 && !evencube) {
                        ++gz;
                    }
                    tetnum = 5;
                    if (gx < 0) {
                        gx = 0;
                    }
                    if (gy < 0) {
                        gy = 0;
                    }
                    if (gz < 0) {
                        gz = 0;
                    }
                    if (gx > this.LengthX - 2) {
                        gx = this.LengthX - 2;
                    }
                    if (gy > this.LengthY - 2) {
                        gy = this.LengthY - 2;
                    }
                    if (gz > this.LengthZ - 2) {
                        gz = this.LengthZ - 2;
                    }
                    if (!(gx != ogx || gy != ogy || gz != ogz || test1 && test2 && test3 || offgrid)) {
                        offgrid = true;
                        continue;
                    }
                    if ((gx != ogx || gy != ogy || gz != ogz) && !offgrid) continue;
                    for (j = 0; j < 3; ++j) {
                        M[j] = (H[j] - G[j]) * (C[(j + 1) % 3] - G[(j + 1) % 3]) - (H[(j + 1) % 3] - G[(j + 1) % 3]) * (C[j] - G[j]);
                        N[j] = (F[j] - G[j]) * (C[(j + 1) % 3] - G[(j + 1) % 3]) - (F[(j + 1) % 3] - G[(j + 1) % 3]) * (C[j] - G[j]);
                        O[j] = (H[(j + 1) % 3] - G[(j + 1) % 3]) * (C[(j + 2) % 3] - G[(j + 2) % 3]) - (H[(j + 2) % 3] - G[(j + 2) % 3]) * (C[(j + 1) % 3] - G[(j + 1) % 3]);
                        P[j] = (F[(j + 1) % 3] - G[(j + 1) % 3]) * (C[(j + 2) % 3] - G[(j + 2) % 3]) - (F[(j + 2) % 3] - G[(j + 2) % 3]) * (C[(j + 1) % 3] - G[(j + 1) % 3]);
                        X[j] = value[(j + 2) % 3][i] * (C[(j + 1) % 3] - G[(j + 1) % 3]) - value[(j + 1) % 3][i] * (C[(j + 2) % 3] - G[(j + 2) % 3]) + G[(j + 1) % 3] * C[(j + 2) % 3] - G[(j + 2) % 3] * C[(j + 1) % 3];
                        Y[j] = value[j][i] * (C[(j + 1) % 3] - G[(j + 1) % 3]) - value[(j + 1) % 3][i] * (C[j] - G[j]) + G[(j + 1) % 3] * C[j] - G[j] * C[(j + 1) % 3];
                    }
                    double d0 = M[0] * P[0] - N[0] * O[0];
                    double d1 = M[1] * P[1] - N[1] * O[1];
                    d2 = M[2] * P[2] - N[2] * O[2];
                    ad0 = Math.abs(d0);
                    ad1 = Math.abs(d1);
                    ad2 = Math.abs(d2);
                    if (ad0 > ad1 && ad0 > ad2) {
                        s5 = 1.0 - (N[0] * X[0] + P[0] * Y[0]) / d0;
                        t5 = 1.0 + (M[0] * X[0] + O[0] * Y[0]) / d0;
                    } else if (ad1 > ad2) {
                        s5 = 1.0 - (N[1] * X[1] + P[1] * Y[1]) / d1;
                        t5 = 1.0 + (M[1] * X[1] + O[1] * Y[1]) / d1;
                    } else {
                        s5 = 1.0 - (N[2] * X[2] + P[2] * Y[2]) / d2;
                        t5 = 1.0 + (M[2] * X[2] + O[2] * Y[2]) / d2;
                    }
                    d0 = C[0] - G[0];
                    d1 = C[1] - G[1];
                    d2 = C[2] - G[2];
                    ad0 = Math.abs(d0);
                    ad1 = Math.abs(d1);
                    ad2 = Math.abs(d2);
                    double u = ad0 > ad1 && ad0 > ad2 ? (value[0][i] - G[0] - (1.0 - s5) * (H[0] - G[0]) - (1.0 - t5) * (F[0] - G[0])) / d0 : (ad1 > ad2 ? (value[1][i] - G[1] - (1.0 - s5) * (H[1] - G[1]) - (1.0 - t5) * (F[1] - G[1])) / d1 : (value[2][i] - G[2] - (1.0 - s5) * (H[2] - G[2]) - (1.0 - t5) * (F[2] - G[2])) / d2);
                    if (evencube) {
                        grid[0][i] = (double)gx + s5;
                        grid[1][i] = (double)gy + t5;
                        grid[2][i] = (double)gz + u;
                        break;
                    }
                    grid[0][i] = (double)(gx + 1) - s5;
                    grid[1][i] = (double)(gy + 1) - t5;
                    grid[2][i] = (double)(gz + 1) - u;
                    break;
                }
                tval1 = ((F[1] - H[1]) * (A[2] - F[2]) - (F[2] - H[2]) * (A[1] - F[1])) * (value[0][i] - F[0]) + ((F[2] - H[2]) * (A[0] - F[0]) - (F[0] - H[0]) * (A[2] - F[2])) * (value[1][i] - F[1]) + ((F[0] - H[0]) * (A[1] - F[1]) - (F[1] - H[1]) * (A[0] - F[0])) * (value[2][i] - F[2]);
                tval2 = ((C[1] - F[1]) * (A[2] - C[2]) - (C[2] - F[2]) * (A[1] - C[1])) * (value[0][i] - C[0]) + ((C[2] - F[2]) * (A[0] - C[0]) - (C[0] - F[0]) * (A[2] - C[2])) * (value[1][i] - C[1]) + ((C[0] - F[0]) * (A[1] - C[1]) - (C[1] - F[1]) * (A[0] - C[0])) * (value[2][i] - C[2]);
                tval3 = ((C[1] - A[1]) * (H[2] - C[2]) - (C[2] - A[2]) * (H[1] - C[1])) * (value[0][i] - C[0]) + ((C[2] - A[2]) * (H[0] - C[0]) - (C[0] - A[0]) * (H[2] - C[2])) * (value[1][i] - C[1]) + ((C[0] - A[0]) * (H[1] - C[1]) - (C[1] - A[1]) * (H[0] - C[0])) * (value[2][i] - C[2]);
                double tval4 = ((F[1] - C[1]) * (H[2] - F[2]) - (F[2] - C[2]) * (H[1] - F[1])) * (value[0][i] - F[0]) + ((F[2] - C[2]) * (H[0] - F[0]) - (F[0] - C[0]) * (H[2] - F[2])) * (value[1][i] - F[1]) + ((F[0] - C[0]) * (H[1] - F[1]) - (F[1] - C[1]) * (H[0] - F[0])) * (value[2][i] - F[2]);
                boolean bl = tval1 == 0.0 || tval1 > 0.0 == !evencube ^ this.Pos ? true : (test1 = false);
                boolean bl9 = tval2 == 0.0 || tval2 > 0.0 == !evencube ^ this.Pos ? true : (test2 = false);
                boolean bl10 = tval3 == 0.0 || tval3 > 0.0 == !evencube ^ this.Pos ? true : (test3 = false);
                boolean bl11 = tval4 == 0.0 || tval4 > 0.0 == !evencube ^ this.Pos ? true : (test4 = false);
                if (!test1 && test2 && test3 && test4) {
                    tetnum = 1;
                }
                if (test1 && !test2 && test3 && test4) {
                    tetnum = 2;
                }
                if (test1 && test2 && !test3 && test4) {
                    tetnum = 3;
                }
                if (test1 && test2 && test3 && !test4) {
                    tetnum = 4;
                }
                if (!test1 && !test2 && evencube || !test3 && !test4 && !evencube) {
                    --gy;
                }
                if (!test1 && !test3 && evencube || !test2 && !test4 && !evencube) {
                    --gx;
                }
                if (!test1 && !test4 && evencube || !test2 && !test3 && !evencube) {
                    --gz;
                }
                if (!test2 && !test3 && evencube || !test1 && !test4 && !evencube) {
                    ++gz;
                }
                if (!test2 && !test4 && evencube || !test1 && !test3 && !evencube) {
                    ++gx;
                }
                if (!test3 && !test4 && evencube || !test1 && !test2 && !evencube) {
                    ++gy;
                }
                if (gx < 0) {
                    gx = 0;
                }
                if (gy < 0) {
                    gy = 0;
                }
                if (gz < 0) {
                    gz = 0;
                }
                if (gx > this.LengthX - 2) {
                    gx = this.LengthX - 2;
                }
                if (gy > this.LengthY - 2) {
                    gy = this.LengthY - 2;
                }
                if (gz > this.LengthZ - 2) {
                    gz = this.LengthZ - 2;
                }
                if (!((gx != ogx || gy != ogy || gz != ogz || test1 && test2 && test3 && test4 || tetnum != 5) && !offgrid)) {
                    offgrid = true;
                    boolean LZ = false;
                    boolean LY = false;
                    boolean LX = false;
                    boolean MZ = false;
                    boolean MY = false;
                    boolean MX = false;
                    boolean OZ = false;
                    boolean OY = false;
                    boolean OX = false;
                    if (gx == 0) {
                        OX = true;
                    }
                    if (gy == 0) {
                        OY = true;
                    }
                    if (gz == 0) {
                        OZ = true;
                    }
                    if (gx == this.LengthX - 2) {
                        LX = true;
                    }
                    if (gy == this.LengthY - 2) {
                        LY = true;
                    }
                    if (gz == this.LengthZ - 2) {
                        LZ = true;
                    }
                    if (!OX && !LX) {
                        MX = true;
                    }
                    if (!OY && !LY) {
                        MY = true;
                    }
                    if (!OZ && !LZ) {
                        MZ = true;
                    }
                    test4 = false;
                    test3 = false;
                    test2 = false;
                    test1 = false;
                    if (evencube) {
                        if (!(LX || LY || LZ)) {
                            tetnum = 1;
                        } else if (LX && OY && MZ || MX && OY && LZ || LX && MY && LZ || LX && OY && LZ || MX && MY && LZ || LX && MY && MZ) {
                            tetnum = 2;
                        } else if (OX && LY && MZ || OX && MY && LZ || MX && LY && LZ || OX && LY && LZ || MX && LY && MZ) {
                            tetnum = 3;
                        } else if (MX && LY && OZ || LX && MY && OZ || LX && LY && MZ || LX && LY && OZ) {
                            tetnum = 4;
                        }
                    } else if (!(OX || OY || OZ)) {
                        tetnum = 1;
                    } else if (OX && MY && OZ || MX && LY && OZ || OX && LY && MZ || OX && LY && OZ || MX && MY && OZ || OX && MY && MZ) {
                        tetnum = 2;
                    } else if (LX && MY && OZ || MX && OY && OZ || LX && OY && MZ || LX && OY && OZ || MX && OY && MZ) {
                        tetnum = 3;
                    } else if (OX && OY && MZ || OX && MY && OZ || MX && OY && LZ || OX && OY && LZ) {
                        tetnum = 4;
                    }
                }
                if (gx != ogx || gy != ogy || gz != ogz || tetnum != 5) continue;
                for (j = 0; j < 3; ++j) {
                    Q[j] = (H[j] + F[j] + A[j] - C[j]) / 2.0;
                }
                for (j = 0; j < 3; ++j) {
                    M[j] = (F[j] - Q[j]) * (A[(j + 1) % 3] - Q[(j + 1) % 3]) - (F[(j + 1) % 3] - Q[(j + 1) % 3]) * (A[j] - Q[j]);
                    N[j] = (H[j] - Q[j]) * (A[(j + 1) % 3] - Q[(j + 1) % 3]) - (H[(j + 1) % 3] - Q[(j + 1) % 3]) * (A[j] - Q[j]);
                    O[j] = (F[(j + 1) % 3] - Q[(j + 1) % 3]) * (A[(j + 2) % 3] - Q[(j + 2) % 3]) - (F[(j + 2) % 3] - Q[(j + 2) % 3]) * (A[(j + 1) % 3] - Q[(j + 1) % 3]);
                    P[j] = (H[(j + 1) % 3] - Q[(j + 1) % 3]) * (A[(j + 2) % 3] - Q[(j + 2) % 3]) - (H[(j + 2) % 3] - Q[(j + 2) % 3]) * (A[(j + 1) % 3] - Q[(j + 1) % 3]);
                    X[j] = value[(j + 2) % 3][i] * (A[(j + 1) % 3] - Q[(j + 1) % 3]) - value[(j + 1) % 3][i] * (A[(j + 2) % 3] - Q[(j + 2) % 3]) + Q[(j + 1) % 3] * A[(j + 2) % 3] - Q[(j + 2) % 3] * A[(j + 1) % 3];
                    Y[j] = value[j][i] * (A[(j + 1) % 3] - Q[(j + 1) % 3]) - value[(j + 1) % 3][i] * (A[j] - Q[j]) + Q[(j + 1) % 3] * A[j] - Q[j] * A[(j + 1) % 3];
                }
                double d0 = M[0] * P[0] - N[0] * O[0];
                double d1 = M[1] * P[1] - N[1] * O[1];
                d2 = M[2] * P[2] - N[2] * O[2];
                ad0 = Math.abs(d0);
                ad1 = Math.abs(d1);
                ad2 = Math.abs(d2);
                if (ad0 > ad1 && ad0 > ad2) {
                    s = (N[0] * X[0] + P[0] * Y[0]) / d0;
                    t = -(M[0] * X[0] + O[0] * Y[0]) / d0;
                } else if (ad1 > ad2) {
                    s = (N[1] * X[1] + P[1] * Y[1]) / d1;
                    t = -(M[1] * X[1] + O[1] * Y[1]) / d1;
                } else {
                    s = (N[2] * X[2] + P[2] * Y[2]) / d2;
                    t = -(M[2] * X[2] + O[2] * Y[2]) / d2;
                }
                d0 = A[0] - Q[0];
                d1 = A[1] - Q[1];
                d2 = A[2] - Q[2];
                ad0 = Math.abs(d0);
                ad1 = Math.abs(d1);
                ad2 = Math.abs(d2);
                double u = ad0 > ad1 && ad0 > ad2 ? (value[0][i] - Q[0] - s * (F[0] - Q[0]) - t * (H[0] - Q[0])) / d0 : (ad1 > ad2 ? (value[1][i] - Q[1] - s * (F[1] - Q[1]) - t * (H[1] - Q[1])) / d1 : (value[2][i] - Q[2] - s * (F[2] - Q[2]) - t * (H[2] - Q[2])) / d2);
                if (evencube) {
                    grid[0][i] = (double)gx + s;
                    grid[1][i] = (double)gy + t;
                    grid[2][i] = (double)gz + u;
                    break;
                }
                grid[0][i] = (double)(gx + 1) - s;
                grid[1][i] = (double)(gy + 1) - t;
                grid[2][i] = (double)(gz + 1) - u;
                break;
            }
            if (!(grid[0][i] <= -0.5 || grid[0][i] >= (double)this.LengthX - 0.5 || grid[1][i] <= -0.5 || grid[1][i] >= (double)this.LengthY - 0.5 || grid[2][i] <= -0.5) && !(grid[2][i] >= (double)this.LengthZ - 0.5)) continue;
            grid[2][i] = Double.NaN;
            grid[1][i] = Double.NaN;
            grid[0][i] = Double.NaN;
        }
        return grid;
    }

    public void doubleToInterp(double[][] value, int[][] indices, double[][] weights) throws VisADException {
        int j;
        if (value.length != this.DomainDimension) {
            throw new SetException("Gridded3DDoubleSet.doubleToInterp: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        if (indices.length != length) {
            throw new SetException("Gridded3DDoubleSet.doubleToInterp: indices length " + indices.length + " doesn't match value[0] length " + value[0].length);
        }
        if (weights.length != length) {
            throw new SetException("Gridded3DDoubleSet.doubleToInterp: weights length " + weights.length + " doesn't match value[0] length " + value[0].length);
        }
        double[][] grid = this.doubleToGrid(value);
        int[] l = new int[this.ManifoldDimension];
        double[] c = new double[this.ManifoldDimension];
        int[] off = new int[this.ManifoldDimension];
        off[0] = 1;
        for (j = 1; j < this.ManifoldDimension; ++j) {
            off[j] = off[j - 1] * this.Lengths[j - 1];
        }
        for (int i = 0; i < length; ++i) {
            double[] cs;
            int[] is;
            int base;
            int length_is = 1;
            if (Double.isNaN(grid[this.ManifoldDimension - 1][i])) {
                base = -1;
            } else {
                l[this.ManifoldDimension - 1] = (int)(grid[this.ManifoldDimension - 1][i] + 0.5);
                if (l[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1]) {
                    int n = this.ManifoldDimension - 1;
                    l[n] = l[n] - 1;
                }
                c[this.ManifoldDimension - 1] = grid[this.ManifoldDimension - 1][i] - (double)l[this.ManifoldDimension - 1];
                if (!(l[this.ManifoldDimension - 1] == 0 && c[this.ManifoldDimension - 1] <= 0.0 || l[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1] - 1 && c[this.ManifoldDimension - 1] >= 0.0)) {
                    length_is *= 2;
                }
                base = l[this.ManifoldDimension - 1];
            }
            for (j = this.ManifoldDimension - 2; j >= 0 && base >= 0; --j) {
                if (Double.isNaN(grid[j][i])) {
                    base = -1;
                    continue;
                }
                l[j] = (int)(grid[j][i] + 0.5);
                if (l[j] == this.Lengths[j]) {
                    int n = j;
                    l[n] = l[n] - 1;
                }
                c[j] = grid[j][i] - (double)l[j];
                if (!(l[j] == 0 && c[j] <= 0.0 || l[j] == this.Lengths[j] - 1 && c[j] >= 0.0)) {
                    length_is *= 2;
                }
                base = l[j] + this.Lengths[j] * base;
            }
            if (base < 0) {
                is = null;
                cs = null;
            } else {
                is = new int[length_is];
                cs = new double[length_is];
                is[0] = base;
                cs[0] = 1.0;
                int lis = 1;
                for (j = 0; j < this.ManifoldDimension; ++j) {
                    double b;
                    double a;
                    int isoff;
                    if (l[j] == 0 && c[j] <= 0.0 || l[j] == this.Lengths[j] - 1 && c[j] >= 0.0) continue;
                    if (c[j] >= 0.0) {
                        isoff = off[j];
                        a = 1.0 - c[j];
                        b = c[j];
                    } else {
                        isoff = -off[j];
                        a = 1.0 + c[j];
                        b = -c[j];
                    }
                    int k = 0;
                    while (k < lis) {
                        is[k + lis] = is[k] + isoff;
                        cs[k + lis] = cs[k] * b;
                        int n = k++;
                        cs[n] = cs[n] * a;
                    }
                    lis *= 2;
                }
            }
            indices[i] = is;
            weights[i] = cs;
        }
    }

    void init_doubles(double[][] samples, boolean copy) throws VisADException {
        if (samples.length != this.DomainDimension) {
            throw new SetException("Gridded3DDoubleSet.init_doubles: samples dimension " + samples.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.Length == 0) {
            this.Length = samples[0].length;
        } else if (this.Length != samples[0].length) {
            throw new SetException("Gridded3DDoubleSet.init_doubles: samples[0] length " + samples[0].length + " doesn't match expected length " + this.Length);
        }
        this.Samples = copy ? new double[this.DomainDimension][this.Length] : samples;
        for (int j = 0; j < this.DomainDimension; ++j) {
            if (samples[j].length != this.Length) {
                throw new SetException("Gridded3DDoubleSet.init_doubles: samples[" + j + "] length " + samples[0].length + " doesn't match expected length " + this.Length);
            }
            double[] samplesJ = samples[j];
            double[] SamplesJ = this.Samples[j];
            if (copy) {
                System.arraycopy(samplesJ, 0, SamplesJ, 0, this.Length);
            }
            this.Low[j] = Double.POSITIVE_INFINITY;
            this.Hi[j] = Double.NEGATIVE_INFINITY;
            double sum = 0.0;
            for (int i = 0; i < this.Length; ++i) {
                if (SamplesJ[i] == SamplesJ[i] && !Double.isInfinite(SamplesJ[i])) {
                    if (SamplesJ[i] < this.Low[j]) {
                        this.Low[j] = SamplesJ[i];
                    }
                    if (SamplesJ[i] > this.Hi[j]) {
                        this.Hi[j] = SamplesJ[i];
                    }
                } else {
                    SamplesJ[i] = Double.NaN;
                }
                sum += SamplesJ[i];
            }
            if (this.SetErrors[j] != null) {
                this.SetErrors[j] = new ErrorEstimate(this.SetErrors[j].getErrorValue(), sum / (double)this.Length, this.Length, this.SetErrors[j].getUnit());
            }
            ((Gridded3DSet)this).Low[j] = (float)this.Low[j];
            ((Gridded3DSet)this).Hi[j] = (float)this.Hi[j];
        }
    }

    public void cram_missing(boolean[] range_select) {
        int n = Math.min(range_select.length, this.Samples[0].length);
        for (int i = 0; i < n; ++i) {
            if (range_select[i]) continue;
            this.Samples[0][i] = Double.NaN;
        }
    }

    public boolean isMissing() {
        return this.Samples == null;
    }

    public boolean equals(Object set) {
        if (!(set instanceof Gridded3DDoubleSet) || set == null) {
            return false;
        }
        if (this == set) {
            return true;
        }
        if (this.testNotEqualsCache((Set)set)) {
            return false;
        }
        if (this.testEqualsCache((Set)set)) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)set)) {
            return false;
        }
        try {
            int j;
            if (this.DomainDimension != ((Gridded3DDoubleSet)set).getDimension() || this.ManifoldDimension != ((Gridded3DDoubleSet)set).getManifoldDimension() || this.Length != ((Gridded3DDoubleSet)set).getLength()) {
                return false;
            }
            for (j = 0; j < this.ManifoldDimension; ++j) {
                if (this.Lengths[j] == ((Gridded3DDoubleSet)set).getLength(j)) continue;
                return false;
            }
            double[][] samples = ((Gridded3DDoubleSet)set).getDoubles(false);
            if (this.Samples != null && samples != null) {
                for (j = 0; j < this.DomainDimension; ++j) {
                    for (int i = 0; i < this.Length; ++i) {
                        if (this.Samples[j][i] == samples[j][i]) continue;
                        this.addNotEqualsCache((Set)set);
                        return false;
                    }
                }
            } else {
                double[][] this_samples = this.getDoubles(false);
                if (this_samples == null) {
                    if (samples != null) {
                        return false;
                    }
                } else {
                    if (samples == null) {
                        return false;
                    }
                    for (j = 0; j < this.DomainDimension; ++j) {
                        for (int i = 0; i < this.Length; ++i) {
                            if (this_samples[j][i] == samples[j][i]) continue;
                            this.addNotEqualsCache((Set)set);
                            return false;
                        }
                    }
                }
            }
            this.addEqualsCache((Set)set);
            return true;
        }
        catch (VisADException e) {
            return false;
        }
    }

    public Object clone() {
        Gridded3DDoubleSet clone = (Gridded3DDoubleSet)super.clone();
        if (this.Samples != null) {
            clone.Samples = (double[][])this.Samples.clone();
            for (int i = 0; i < this.Samples.length; ++i) {
                clone.Samples[i] = (double[])this.Samples[i].clone();
            }
        }
        return clone;
    }

    public Object cloneButType(MathType type) throws VisADException {
        if (this.ManifoldDimension == 3) {
            return new Gridded3DDoubleSet(type, this.Samples, this.LengthX, this.LengthY, this.LengthZ, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        if (this.ManifoldDimension == 2) {
            return new Gridded3DDoubleSet(type, this.Samples, this.LengthX, this.LengthY, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        return new Gridded3DDoubleSet(type, this.Samples, this.LengthX, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }
}

