	SUBROUTINE DO_AUX_VAR_REGRID( memory, axis_list, naxis, aux_has_cell_pts,
     .				      src,  msrc,  src_cx,
     .				      dst,  mdst,  dst_cx,
     .				      aux1, maux1, aux1_cx,
     .				      aux2, maux2, aux2_cx,
     .				      aux3, maux3, aux3_cx,
     .				      status )

*
*
*  This software was developed by the Thermal Modeling and Analysis
*  Project(TMAP) of the National Oceanographic and Atmospheric
*  Administration''s (NOAA) Pacific Marine Environmental Lab(PMEL),
*  hereafter referred to as NOAA/PMEL/TMAP.
*
*  Access and use of this software shall impose the following
*  obligations and understandings on the user. The user is granted the
*  right, without any fee or cost, to use, copy, modify, alter, enhance
*  and distribute this software, and any derivative works thereof, and
*  its supporting documentation for any purpose whatsoever, provided
*  that this entire notice appears in all copies of the software,
*  derivative works and supporting documentation.  Further, the user
*  agrees to credit NOAA/PMEL/TMAP in any publications that result from
*  the use of this software or in any product that includes this
*  software. The names TMAP, NOAA and/or PMEL, however, may not be used
*  in any advertising or publicity to endorse or promote any products
*  or commercial entity unless specific written permission is obtained
*  from NOAA/PMEL/TMAP. The user also understands that NOAA/PMEL/TMAP
*  is not obligated to provide the user with any support, consulting,
*  training or assistance of any kind with regard to the use, operation
*  and performance of this software nor to provide the user with any
*  updates, revisions, new versions or "bug fixes".
*
*  THIS SOFTWARE IS PROVIDED BY NOAA/PMEL/TMAP "AS IS" AND ANY EXPRESS
*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
*  ARE DISCLAIMED. IN NO EVENT SHALL NOAA/PMEL/TMAP BE LIABLE FOR ANY SPECIAL,
*  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
*  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
*  CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
*  CONNECTION WITH THE ACCESS, USE OR PERFORMANCE OF THIS SOFTWARE. 
*
*
* perform a dispatch of regridding to the rountine appropriate
! for the dimensionailty

* v685 4/13 *sh*

        IMPLICIT NONE
        include 'tmap_dims.parm'
        include 'errmsg.parm'
	include	'ferret.parm'
	include	'xcontext.cmn'
	include	'xvariables.cmn'
	include	'xmem_subsc.cmn'

* calling argument declarations:
	LOGICAL	aux_has_cell_pts
	INTEGER	naxis, axis_list(naxis), status,
     .		msrc, mdst, maux1, maux2, maux3,
     .		src_cx, dst_cx, aux1_cx, aux2_cx, aux3_cx
	REAL	memory( mem_blk_size, max_mem_blks )
        REAL    src(*), dst(*), aux1(*), aux2(*), aux3(*)


	IF ( naxis .EQ. 1) THEN
* Ansley:  note that this needs to be generalized for other axes than Z
* allocate a work arrays for a single profile of Z depths
* nwk_dst enuf to hold a line of the destination grid
	   IF (axis_list(1) .NE. z_dim)
     .			CALL ERRMSG( ferr_internal, status, 'non-z aux', *5000)

* do the 1D regridding using linear interpolation
	   CALL DO_AUX_VAR_REGRID_1D(
     .			axis_list(1), aux_has_cell_pts,
     .			src,  msrc,  src_cx,
     .			dst,  mdst,  dst_cx,
     .			aux1, maux1, aux1_cx,
     .			cx_lo_ss(src_cx,z_dim),cx_hi_ss(src_cx,z_dim),
     .			cx_lo_ss(dst_cx,z_dim),cx_hi_ss(dst_cx,z_dim) )
	ELSE
*  ==> insert horizontal curvilinear regridding (naxis.EQ.2) here
	   STOP 'do_aux_var_regrid >1d'
	ENDIF

* success
	RETURN

* error
 5000	RETURN

	END
