/*******************************************************************
 * Fritz Fun                                                       *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file voicebox.c
 * \brief Contains all function needed for voice box support
 */

#include <ffgtk.h>

/**
 * \brief Voice box play callback
 * \param psModel tree model
 * \param psPath tree path
 */
void voiceBoxPlay( GtkTreeModel *psModel, GtkTreePath *psPath ) {
	GtkTreeIter sSelectedIter;
	GValue sFile = { 0 };

	if ( gtk_tree_model_get_iter( psModel, &sSelectedIter, psPath ) ) {
		gtk_tree_model_get_value( psModel, &sSelectedIter, 6, &sFile );

		Debug( KERN_DEBUG, "sFile: [%s]\n", g_value_get_string( &sFile ) );
		if ( routerLoadVoiceFile( getActiveProfile(), g_value_get_string( &sFile ) ) == 0 ) {
			gchar *pnStorePath = g_strdup_printf( "%s/ffgtk-%s/voice", g_get_tmp_dir(), g_get_user_name() );
			if ( pnStorePath != NULL ) {
				PlayVoxFile( pnStorePath );
				g_free( pnStorePath );
			}
		}

		g_value_unset( &sFile );
	}
}

/**
 * \brief Voice box delete callback
 * \param psModel tree model
 * \param psPath tree path
 */
void voiceBoxDelete( GtkTreeModel *psModel, GtkTreePath *psPath ) {
	GtkTreeIter sSelectedIter;
	GValue sFile = { 0 };

	if ( gtk_tree_model_get_iter( psModel, &sSelectedIter, psPath ) ) {
		gtk_tree_model_get_value( psModel, &sSelectedIter, 6, &sFile );

		Debug( KERN_DEBUG, "sFile: [%s]\n", g_value_get_string( &sFile ) );
		routerDeleteVoiceFile( getActiveProfile(), g_value_get_string( &sFile ) );

		g_value_unset( &sFile );
	}
}
