/*
 * Decompiled with CFR 0.152.
 */
package friendless.games.filler;

import friendless.games.filler.FillerModel;
import friendless.games.filler.FillerSettings;
import friendless.games.filler.FillerSpace;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class FillerBoard
extends JComponent {
    static Point[] topLefts;
    static Point[] botRights;
    protected Image off;
    protected FillerModel model;

    static final Point topLeft(int n) {
        return topLefts[n];
    }

    static final Point bottomRight(int n) {
        return botRights[n];
    }

    public FillerBoard() {
        this(new FillerModel());
    }

    public FillerBoard(FillerModel fillerModel) {
        this.model = fillerModel;
    }

    public void restart(boolean bl) {
        this.model.randomFill(bl);
        this.off = null;
        this.repaint();
    }

    public Image resetOffscreenImage() {
        Rectangle rectangle = this.getBounds();
        Image image = this.createImage(rectangle.width, rectangle.height);
        Graphics graphics = image.getGraphics();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        int[] nArray = this.model.pieces;
        int n = FillerSettings.colours.length;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (FillerModel.valid(n2)) {
                Color color;
                int n3 = nArray[n2];
                if (n3 >= n) {
                    int n4 = n3 - n;
                    int n5 = n4 * 16 % 192 + 32;
                    color = new Color(n5, n5, n5);
                } else {
                    color = FillerSettings.colours[n3];
                }
                this.drawHex(graphics, color, n2);
            }
            ++n2;
        }
        graphics.dispose();
        this.off = image;
        return image;
    }

    public void addNotify() {
        super.addNotify();
        this.off = null;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.off = null;
    }

    public int changeColourCountScore(FillerSpace fillerSpace, int n, int n2, boolean bl) {
        Image image = this.off;
        if (image == null) {
            image = this.resetOffscreenImage();
        }
        boolean[] blArray = fillerSpace.captured;
        Graphics graphics = image.getGraphics();
        int[] nArray = this.model.pieces;
        int n3 = 0;
        while (n3 < blArray.length) {
            if (blArray[n3]) {
                nArray[n3] = n;
                this.drawHexCentre(graphics, FillerSettings.colours[n], n3);
            }
            ++n3;
        }
        graphics.dispose();
        if (bl) {
            this.repaint(1000L);
        } else {
            this.repaint();
        }
        return this.countScore(n2, fillerSpace);
    }

    public int countScore(int n, FillerSpace fillerSpace) {
        int n2 = 1;
        int n3 = this.model.pieces[n];
        int n4 = 0;
        fillerSpace.reset();
        boolean[] blArray = fillerSpace.captured;
        int[] nArray = fillerSpace.counted;
        boolean[] blArray2 = fillerSpace.listed;
        int[] nArray2 = fillerSpace.border;
        blArray2[0] = true;
        int[] nArray3 = FillerModel.neighbours(n);
        int n5 = 0;
        while (n5 < nArray3.length) {
            int n6 = nArray3[n5];
            if (n6 == -1) break;
            nArray2[n4++] = n6;
            ++n5;
        }
        nArray[n] = 7;
        blArray[n] = true;
        int[] nArray4 = this.model.pieces;
        block1: while (n4 > 0) {
            int n7;
            if (nArray[n7 = nArray2[--n4]] != 0) continue;
            if (nArray4[n7] == n3) {
                nArray[n7] = 7;
                ++n2;
                blArray[n7] = true;
                nArray3 = FillerModel.neighbours(n7);
                n5 = 0;
                while (n5 < nArray3.length) {
                    int n8 = nArray3[n5];
                    if (n8 == -1) continue block1;
                    if (!blArray2[n8]) {
                        blArray2[n8] = true;
                        nArray2[n4++] = n8;
                    }
                    ++n5;
                }
                continue;
            }
            nArray[n7] = 6;
        }
        return n2;
    }

    void drawHexCentre(Graphics graphics, Color color, int n) {
        Point point = FillerBoard.topLeft(n);
        int n2 = point.x;
        int n3 = point.y;
        graphics.setColor(color);
        int n4 = 0;
        while (n4 < 4) {
            int n5 = n2 - n4;
            int n6 = n3 + n4 + 1;
            int n7 = n2 + 1 + n4;
            int n8 = n3 + 12 - n4;
            graphics.drawLine(n5, n6, n5, n8);
            graphics.drawLine(n7, n6, n7, n8);
            ++n4;
        }
        if (n == FillerSettings.ORIGINS[0]) {
            this.drawLeft(graphics, FillerBoard.contrastingColour(color), FillerBoard.topLeft(FillerSettings.ORIGINS[0]));
        } else if (n == FillerSettings.ORIGINS[1]) {
            this.drawRight(graphics, FillerBoard.contrastingColour(color), FillerBoard.topLeft(FillerSettings.ORIGINS[1]));
        }
    }

    static Color contrastingColour(Color color) {
        if (color.equals(Color.black) || color.equals(Color.blue) || color.equals(Color.darkGray)) {
            return Color.white;
        }
        return Color.black;
    }

    void drawRight(Graphics graphics, Color color, Point point) {
        int n = point.x;
        int n2 = point.y;
        graphics.setColor(color);
        graphics.drawLine(n - 1, n2 + 4, n - 1, n2 + 9);
        graphics.drawLine(n - 1, n2 + 4, n + 1, n2 + 4);
        graphics.drawLine(n + 2, n2 + 5, n + 2, n2 + 6);
        graphics.drawLine(n - 1, n2 + 7, n + 1, n2 + 7);
        graphics.drawLine(n + 1, n2 + 8, n + 2, n2 + 9);
    }

    void drawLeft(Graphics graphics, Color color, Point point) {
        int n = point.x;
        int n2 = point.y;
        graphics.setColor(color);
        graphics.drawLine(n - 1, n2 + 4, n - 1, n2 + 9);
        graphics.drawLine(n - 1, n2 + 9, n + 2, n2 + 9);
    }

    void drawHex(Graphics graphics, Color color, int n) {
        Point point = FillerBoard.topLeft(n);
        int n2 = point.x;
        int n3 = point.y;
        graphics.setColor(Color.white);
        graphics.drawLine(n2, n3, n2 - 4, n3 + 4);
        graphics.drawLine(n2 - 4, n3 + 4, n2 - 4, n3 + 9);
        graphics.drawLine(n2 - 4, n3 + 9, n2, n3 + 13);
        graphics.setColor(Color.darkGray);
        graphics.drawLine(n2 + 1, n3, n2 + 5, n3 + 4);
        graphics.drawLine(n2 + 5, n3 + 4, n2 + 5, n3 + 9);
        graphics.drawLine(n2 + 5, n3 + 9, n2 + 1, n3 + 13);
        this.drawHexCentre(graphics, color, n);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Point point = FillerBoard.bottomRight(FillerModel.makeIndex(94, 14));
        Point point2 = FillerBoard.bottomRight(FillerModel.makeIndex(93, 14));
        Dimension dimension = new Dimension(point.x < point2.x ? point2.x : point.x, point.y < point2.y ? point2.y : point.y);
        dimension.width += 5;
        dimension.height += 5;
        return dimension;
    }

    public void paintComponent(Graphics graphics) {
        if (this.off == null) {
            this.resetOffscreenImage();
        }
        graphics.drawImage(this.off, 0, 0, this);
    }

    static {
        int n = 1425;
        topLefts = new Point[n];
        botRights = new Point[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = FillerModel.getX(n2);
            int n4 = FillerModel.getY(n2);
            FillerBoard.topLefts[n2] = new Point(n3 * 5 + 5, n4 * 20 + n3 % 2 * 10 - 5);
            FillerBoard.botRights[n2] = new Point(FillerBoard.topLefts[n2].x + 5, FillerBoard.topLefts[n2].y + 13);
            ++n2;
        }
    }
}

