static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"   /* no properties */                                                        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_C_SOURCE invert-gamma.c                                       \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"R'G'B'A float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"R'G'B'A float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *op,                                             \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                samples,                                        \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  gfloat *in  = in_buf;                                                       \n"
"  gfloat *out = out_buf;                                                      \n"
"                                                                              \n"
"  while (samples--)                                                           \n"
"    {                                                                         \n"
"      out[0] = 1.0 - in[0];                                                   \n"
"      out[1] = 1.0 - in[1];                                                   \n"
"      out[2] = 1.0 - in[2];                                                   \n"
"      out[3] = in[3];                                                         \n"
"                                                                              \n"
"      in += 4;                                                                \n"
"      out+= 4;                                                                \n"
"    }                                                                         \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  operation_class->prepare     = prepare;                                     \n"
"  point_filter_class->process  = process;                                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"       , \"gegl:invert-gamma\",                                   \n"
"    \"title\",      _(\"Invert in Perceptual space\"),                        \n"
"    \"categories\" , \"color\",                                               \n"
"    \"description\",                                                          \n"
"       _(\"Inverts the components (except alpha), the result is the \"        \n"
"         \"corresponding \\\"negative\\\" image.\"),                          \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
