/*
** 1999-05-10 -	A module to deal with the command group DpFocus, the purpose of which is
**		to (finally!) make keyboard navigation possible in gentoo. Should at least
**		give people something else to mail me about. :^)
*/

#include "gentoo.h"

#include "dirpane.h"
#include "cmdarg.h"
#include "cmdseq_config.h"
#include "nag_dialog.h"
#include "cmd_dpfocus.h"

/* ----------------------------------------------------------------------------------------- */

typedef struct {
	gboolean	modified;
	gboolean	fake_select;		/* Treat focus as selection if no "real" selection exists? */
	gboolean	focus_select;		/* Move focus to last selected/deselected row? */
} OptDpFocus;

static OptDpFocus	dpfocus_options;
static CmdCfg		*dpfocus_cmc = NULL;

/* ----------------------------------------------------------------------------------------- */

/* 1999-05-10 -	Do some focusing. */
gint cmd_dpfocus(MainInfo *min, DirPane *src, DirPane *dst, const CmdArg *ca)
{
	/* We no longer support this command, so nag to the user about its demise. */
	ndl_dialog_sync_new_wait(min, "dpfocus-deprecated", _("DpFocus Command is Deprecated"),
			_("The <tt>DpFocus</tt> command has been deprecated and is no longer "
			  "supported. Please remove any keyboard or mouse bindings that use it "
			  "and look into using the default GTK+ list view's cursor controls."));

	return 1;
}

/* ----------------------------------------------------------------------------------------- */

/* Just return the "fake select" option. */
gboolean dpf_get_fake_select(void)
{
	return dpfocus_options.fake_select;
}

/* Return the "focus selected" option. */
gboolean dpf_get_focus_select(void)
{
	return dpfocus_options.focus_select;
}

void cfg_dpfocus(MainInfo *min)
{
	if(dpfocus_cmc == NULL)
	{
		dpfocus_options.modified  = FALSE;
		dpfocus_options.fake_select = FALSE;

		dpfocus_cmc = cmc_config_new("DpFocus", &dpfocus_options);
		cmc_field_add_boolean(dpfocus_cmc, "modified", NULL, offsetof(OptDpFocus, modified));
		cmc_field_add_boolean(dpfocus_cmc, "fake_select", _("Treat Focused Row As Selection "
						"If No \"Real\" Selection Exists?"), offsetof(OptDpFocus, fake_select));
		cmc_field_add_boolean(dpfocus_cmc, "focus_select", _("Move Focus to Last Selected/Deselected "
						"Row?"), offsetof(OptDpFocus, focus_select));
		cmc_config_register(dpfocus_cmc);
	}
}
