
import glitch, glitch.glut
from glitch.limbo.lights import LightSwitch, AmbientLight, DiffuseLight
from glitch.limbo.objects import make_test_scene

def make_scene(children):
    return LightSwitch(children=[
        AmbientLight(intensity=0.4, children=[
            DiffuseLight(intensity=0.4, children=children)])])

if __name__ == '__main__':
    texture1 = glitch.CameraTexture(800, 600, eye=[0, 0.5, 3],
        children=[make_scene([make_test_scene()])])
    texture2 = glitch.CameraTexture(800, 600, eye=[0, 0.5, 3], children=[
        make_scene([
            make_test_scene(),
            glitch.Translate(-1.5, -1.5, z=-1.4, children=[
                glitch.Scale(3, 3, children=[
                    glitch.ApplyTexture(texture1,
                        children=[glitch.TexturedRectangle()])])])])])
    camera = glitch.glut.GLUTCamera(eye=[0, 0.5, 3], children=[
        make_scene([make_test_scene(),
            glitch.Translate(-1.5, -1.5, z=-1.4, children=[
                glitch.Scale(3, 3, children=[
                    glitch.ApplyTexture(texture2,
                        children=[glitch.TexturedRectangle()])])])])])
    camera.run()

