
import OpenGL.GL as gl

import glitch
import glitch.gtk

class UnitView(glitch.Node):
    """Unit view.

    Sets the model view and projection matrices so that (0, 0, z) is the bottom
    left corner of the screen and (1, 1, z) is the top right.
    """

    def render(self, ctx):
        gl.glMatrixMode(gl.GL_MODELVIEW)
        gl.glPushMatrix()
        gl.glLoadIdentity()

        gl.glMatrixMode(gl.GL_PROJECTION)
        gl.glPushMatrix()
        gl.glLoadIdentity()

        tmp = glitch.Translate(x=-1, y=-1, z=0, children=[
            glitch.Scale(x=2, y=2, children=self.children)])
        tmp.render(ctx)

        gl.glMatrixMode(gl.GL_PROJECTION)
        gl.glPopMatrix()

        gl.glMatrixMode(gl.GL_MODELVIEW)
        gl.glPopMatrix()

