// -*-C++-*-
// This file is part of the gmod package
// Copyright (C) 1997 by Andrew J. Robinson

#ifndef USE_X

#include <sys/ioctl.h>
#include <signal.h>
#include <stdio.h>
#include <sys/time.h>

#ifdef USE_LOCAL
#include "soundcard.h"
#else
#include <sys/soundcard.h>
#endif

#include <sys/types.h>
#include <unistd.h>


#include "CursesScr.h"
#include "SampleShell.h"

#include "defines.h"
#include "structs.h"
#include "globals.h"
#include "protos.h"

#include "Sequencer.h"

void
timerHandler (int sig)
{
  extern CursesScr *cursScreen;
#ifdef USE_NCURSES
  extern SampleShell *sampleShell;
#endif

  int keypress = EOF;
  unsigned int volume;
  int tmpVolume;
  static int resetArg = MY_FALSE;
  /*
     char message[80];
     */
  static unsigned int keyedArg = 0;

  extern Sequencer *seq;

  if (sig != -1)
    signal (sig, timerHandler);

  switch (sig)
    {
    case -1:
      keypress = cursScreen->getChar();
      break;
    case SIGTERM:
      keypress = 'q';
      break;
    case SIGUSR1:
      keypress = 'p';
      break;
    case SIGUSR2:
      keypress = 'n';
      break;
    }

  while (keypress != EOF)
    {
      switch (keypress)
	{
#ifdef USE_NCURSES
	case KEY_LEFT:
#endif
	case 'b':
	  if (keyedArg == 0)
	    positionChange--;
	  else
	    positionChange -= keyedArg;
	  resetArg = MY_TRUE;
	  stopFlag = STOP_FORWBACK;
	  seq->stopPlayback ();
	  break;
#ifdef USE_NCURSES
	case KEY_RIGHT:
#endif
	case 'f':
	  if (keyedArg == 0)
	    positionChange++;
	  else
	    positionChange += keyedArg;
	  resetArg = MY_TRUE;
	  stopFlag = STOP_FORWBACK;
	  seq->stopPlayback ();
	  break;
#ifdef USE_NCURSES
	case KEY_NPAGE:
#endif
	case 'n':
	  stopFlag = STOP_NEXT;
	  seq->stopPlayback ();
	  break;
#ifdef USE_NCURSES
	case KEY_PPAGE:
#endif
	case 'p':
	  stopFlag = STOP_PREV;
	  seq->stopPlayback ();
	  break;
	case 'q':
	  stopFlag = STOP_EXIT;
	  seq->stopPlayback ();
	  break;
	  //#ifdef USE_NCURSES
	  //	case KEY_UP:
	  //#endif
	case '+':
	  if (mixerfd != -1)
	    {
	      ioctl (mixerfd, MIXER_READ (SOUND_MIXER_SYNTH), &volume);
	      volume &= 0xff;
	      if (keyedArg == 0)
		tmpVolume = (int) volume + 1;
	      else
		tmpVolume = (int) volume + keyedArg;
	      if (tmpVolume > MIXER_MAX_VOL)
		tmpVolume = MIXER_MAX_VOL;
	      volume = tmpVolume * 256 + tmpVolume;
	      ioctl (mixerfd, MIXER_WRITE (SOUND_MIXER_SYNTH), &volume);
	    }
	  resetArg = MY_TRUE;
	  break;
	  //#ifdef USE_NCURSES
	  //	case KEY_DOWN:
	  //#endif
	case '-':
	  if (mixerfd != -1)
	    {
	      ioctl (mixerfd, MIXER_READ (SOUND_MIXER_SYNTH), &volume);
	      volume &= 0xff;
	      if (keyedArg == 0)
		tmpVolume = (int) volume - 1;
	      else
		tmpVolume = (int) volume - keyedArg;
	      if (tmpVolume < MIXER_MIN_VOL)
		tmpVolume = MIXER_MIN_VOL;
	      volume = tmpVolume * 256 + tmpVolume;
	      ioctl (mixerfd, MIXER_WRITE (SOUND_MIXER_SYNTH), &volume);
	    }
	  resetArg = MY_TRUE;
	  break;
#ifdef USE_NCURSES
	case KEY_UP:
	  sampleShell->scrollSamples(-1);
	  break;
	case KEY_DOWN:
	  sampleShell->scrollSamples(1);
	  break;
#endif
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	  if (resetArg == MY_TRUE)
	    {
	      resetArg = MY_FALSE;
	      keyedArg = 0;
	    }
	  keyedArg = (keyedArg * 10) + (keypress - '0');
	  break;
	}

      keypress = cursScreen->getChar();
    }
}

void
setSignals (void)
{
  signal (SIGTERM, timerHandler);
  signal (SIGUSR1, timerHandler);
  signal (SIGUSR2, timerHandler);
}

#endif /* USE_X */
