#
# $Id$
#
# Default GMTSAR settings. DO NOT EDIT THIS FILE!
#
# There are two configuration files:
#   1) "ConfigDefault.cmake" - is version controlled and used to add new default
#      variables and set defaults for everyone.
#   2) "ConfigUser.cmake" - is not version controlled (currently listed in
#      svn:ignore property) and used to override defaults on a per-user basis.
#
# NOTE: If you want to change CMake behaviour just for yourself then copy
#      "ConfigUserTemplate.cmake" to "ConfigUser.cmake" and then edit
#      "ConfigUser.cmake" (not "ConfigDefault.cmake" or "ConfigUserTemplate.cmake").
#

# The GMTSAR package name.
set (GMTSAR_PACKAGE_NAME "GMTSAR")

# a short description of the gmt project (only a few words).
set (GMTSAR_PACKAGE_DESCRIPTION_SUMMARY "Includes preprocessors for ERS1/2,
Envisat, ALOS-1, ALOS-2, TerraSAR-X, COSMOS-SkyMed, and RADARSAT-2 (beta),
Sentinel-1A TOPS")

# GMTSAR_VERSION_YEAR is set to current date in
# cmake/modules/ConfigCMake.cmake if not specified here:
#set (GMTSAR_VERSION_YEAR "2015")

# The GMTSAR package version.
set (GMTSAR_PACKAGE_VERSION_MAJOR 5)
set (GMTSAR_PACKAGE_VERSION_MINOR 3)
set (GMTSAR_PACKAGE_VERSION_PATCH 0)

# The subversion revision of the GMTSAR source code.
# This is manually set when making GMTSAR *public* releases.
# However, when making internal releases or just an ordinary developer build, leave it
# empty; if it is empty, the revision number is automatically populated for you on build.
#set (GMTSAR_SOURCE_CODE_CONTROL_VERSION_STRING "15220")

# The GMTSAR package version.
set (GMTSAR_PACKAGE_VERSION "${GMTSAR_PACKAGE_VERSION_MAJOR}.${GMTSAR_PACKAGE_VERSION_MINOR}.${GMTSAR_PACKAGE_VERSION_PATCH}")

# The API version (SOVERSION) of the GMTSAR libraries.
# Increment this when more or fewer functions are included in the
# library, the function prototype changes, or data type changes.
set (GMTSAR_LIB_SOVERSION 5)

# The build version (VERSION) of the GMTSAR libraries.
set (GMTSAR_LIB_VERSION "${GMTSAR_LIB_SOVERSION}.${GMTSAR_PACKAGE_VERSION_MINOR}.${GMTSAR_PACKAGE_VERSION_PATCH}")

# The GMTSAR wiki location
set (GMTSAR_TRAC_WIKI "http://gmt.soest.hawaii.edu/projects/gmt5sar/wiki")

# Directory in which to install the release sources per default
if (NOT DEFINED GMTSAR_RELEASE_PREFIX)
	set (GMTSAR_RELEASE_PREFIX ${GMTSAR_BINARY_DIR}/gmtsar-${GMTSAR_PACKAGE_VERSION})
endif (NOT DEFINED GMTSAR_RELEASE_PREFIX)

# You can set the build configuration type as a command-line argument to 'cmake' using -DCMAKE_BUILD_TYPE:STRING=Debug for example.
# If no build configuration type was given as a command-line option to 'cmake' then a default cache entry is set here.
# A cache entry is what appears in the 'CMakeCache.txt' file that CMake generates - you can edit that file directly or use the CMake GUI to edit it.
# The user can then set this parameter via the CMake GUI before generating the native build system.
# NOTE: this is not needed for visual studio because it has multiple configurations in the ide (and CMake includes them all).
# however makefile generators can only have one build type (to have multiple build types you'll need multiple out-of-place builds - one for each build type).
#
# The following are some valid build configuration types:
# 1) Debug - no optimisation with debug info.
# 2) Release - release build optimised for speed.
# 3) RelWithDebInfo - release build optimised for speed with debug info.
# 4) MinSizeRel - release build optimised for size.

# The following is from http://mail.kde.org/pipermail/kde-buildsystem/2008-November/005112.html...
#
# "The way to identify whether a generator is multi-configuration is to
# check whether CMAKE_CONFIGURATION_TYPES is set.  The VS/XCode generators
# set it (and ignore CMAKE_BUILD_TYPE).  The Makefile generators do not
# set it (and use CMAKE_BUILD_TYPE).  If CMAKE_CONFIGURATION_TYPES is not
# already set, don't set it."
#
if (NOT DEFINED CMAKE_CONFIGURATION_TYPES)
	if (NOT DEFINED CMAKE_BUILD_TYPE)
		# Should we set build type to RelWithDebInfo for developers and
		# to release for general public (ie when GPLATES_SOURCE_RELEASE is true) ?
		# Currently it's Release for both.
		set (CMAKE_BUILD_TYPE Release CACHE STRING
		"Choose the type of build, options are: None Debug Release RelWithDebInfo MinSizeRel ${extra_build_configurations}."
		FORCE)
	endif (NOT DEFINED CMAKE_BUILD_TYPE)
endif (NOT DEFINED CMAKE_CONFIGURATION_TYPES)


# Turn this on if you want to...
#  Unix: see compiler commands echoed to console and messages about make
#  entering and leaving directories.
#  VisualStudio: see compiler commands.
# Setting CMAKE_VERBOSE_MAKEFILE to 'true'...
#  Unix: puts 'VERBOSE=1' in the top Makefile.
#  VisualStudio: sets SuppressStartupBanner to FALSE.
# If CMAKE_VERBOSE_MAKEFILE is set to 'false' and you want to turn on
# verbosity temporarily you can...
#  Unix: type 'make VERBOSE=1'  on the command-line when building.
#  VisualStudio: change SuppressStartupBanner to 'no' in "project
#  settings->configuration properties->*->general".
if (NOT DEFINED CMAKE_VERBOSE_MAKEFILE)
	set (CMAKE_VERBOSE_MAKEFILE false)
endif (NOT DEFINED CMAKE_VERBOSE_MAKEFILE)

# prefer shared libs over static
set (BUILD_SHARED_LIBS true)
set (CMAKE_FIND_STATIC LAST)

# look also for lib64 when building 64-bit binaries
if (NOT DEFINED FIND_LIBRARY_USE_LIB64_PATHS)
	set (FIND_LIBRARY_USE_LIB64_PATHS true)
endif (NOT DEFINED FIND_LIBRARY_USE_LIB64_PATHS)

# search order for find_*
set (CMAKE_FIND_FRAMEWORK LAST)

# vim: textwidth=78 noexpandtab tabstop=2 softtabstop=2 shiftwidth=2
