// Code generated by smithy-go-codegen DO NOT EDIT.

package ssoadmin

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/ssoadmin/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves details about a trusted token issuer configuration stored in an
// instance of IAM Identity Center. Details include the name of the trusted token
// issuer, the issuer URL, and the path of the source attribute and the destination
// attribute for a trusted token issuer configuration.
func (c *Client) DescribeTrustedTokenIssuer(ctx context.Context, params *DescribeTrustedTokenIssuerInput, optFns ...func(*Options)) (*DescribeTrustedTokenIssuerOutput, error) {
	if params == nil {
		params = &DescribeTrustedTokenIssuerInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeTrustedTokenIssuer", params, optFns, c.addOperationDescribeTrustedTokenIssuerMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeTrustedTokenIssuerOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeTrustedTokenIssuerInput struct {

	// Specifies the ARN of the trusted token issuer configuration that you want
	// details about.
	//
	// This member is required.
	TrustedTokenIssuerArn *string

	noSmithyDocumentSerde
}

type DescribeTrustedTokenIssuerOutput struct {

	// The name of the trusted token issuer configuration.
	Name *string

	// The ARN of the trusted token issuer configuration.
	TrustedTokenIssuerArn *string

	// A structure the describes the settings that apply of this trusted token issuer.
	TrustedTokenIssuerConfiguration types.TrustedTokenIssuerConfiguration

	// The type of the trusted token issuer.
	TrustedTokenIssuerType types.TrustedTokenIssuerType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeTrustedTokenIssuerMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeTrustedTokenIssuer{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeTrustedTokenIssuer{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeTrustedTokenIssuer"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeTrustedTokenIssuerValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeTrustedTokenIssuer(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeTrustedTokenIssuer(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeTrustedTokenIssuer",
	}
}
