package storage

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessTier enumerates the values for access tier.
type AccessTier string

const (
	// AccessTierCool ...
	AccessTierCool AccessTier = "Cool"
	// AccessTierHot ...
	AccessTierHot AccessTier = "Hot"
	// AccessTierPremium ...
	AccessTierPremium AccessTier = "Premium"
)

// PossibleAccessTierValues returns an array of possible values for the AccessTier const type.
func PossibleAccessTierValues() []AccessTier {
	return []AccessTier{AccessTierCool, AccessTierHot, AccessTierPremium}
}

// AccountExpand enumerates the values for account expand.
type AccountExpand string

const (
	// AccountExpandBlobRestoreStatus ...
	AccountExpandBlobRestoreStatus AccountExpand = "blobRestoreStatus"
	// AccountExpandGeoReplicationStats ...
	AccountExpandGeoReplicationStats AccountExpand = "geoReplicationStats"
)

// PossibleAccountExpandValues returns an array of possible values for the AccountExpand const type.
func PossibleAccountExpandValues() []AccountExpand {
	return []AccountExpand{AccountExpandBlobRestoreStatus, AccountExpandGeoReplicationStats}
}

// AccountImmutabilityPolicyState enumerates the values for account immutability policy state.
type AccountImmutabilityPolicyState string

const (
	// AccountImmutabilityPolicyStateDisabled ...
	AccountImmutabilityPolicyStateDisabled AccountImmutabilityPolicyState = "Disabled"
	// AccountImmutabilityPolicyStateLocked ...
	AccountImmutabilityPolicyStateLocked AccountImmutabilityPolicyState = "Locked"
	// AccountImmutabilityPolicyStateUnlocked ...
	AccountImmutabilityPolicyStateUnlocked AccountImmutabilityPolicyState = "Unlocked"
)

// PossibleAccountImmutabilityPolicyStateValues returns an array of possible values for the AccountImmutabilityPolicyState const type.
func PossibleAccountImmutabilityPolicyStateValues() []AccountImmutabilityPolicyState {
	return []AccountImmutabilityPolicyState{AccountImmutabilityPolicyStateDisabled, AccountImmutabilityPolicyStateLocked, AccountImmutabilityPolicyStateUnlocked}
}

// AccountStatus enumerates the values for account status.
type AccountStatus string

const (
	// AccountStatusAvailable ...
	AccountStatusAvailable AccountStatus = "available"
	// AccountStatusUnavailable ...
	AccountStatusUnavailable AccountStatus = "unavailable"
)

// PossibleAccountStatusValues returns an array of possible values for the AccountStatus const type.
func PossibleAccountStatusValues() []AccountStatus {
	return []AccountStatus{AccountStatusAvailable, AccountStatusUnavailable}
}

// AccountType enumerates the values for account type.
type AccountType string

const (
	// AccountTypeComputer ...
	AccountTypeComputer AccountType = "Computer"
	// AccountTypeUser ...
	AccountTypeUser AccountType = "User"
)

// PossibleAccountTypeValues returns an array of possible values for the AccountType const type.
func PossibleAccountTypeValues() []AccountType {
	return []AccountType{AccountTypeComputer, AccountTypeUser}
}

// Action enumerates the values for action.
type Action string

const (
	// ActionAllow ...
	ActionAllow Action = "Allow"
)

// PossibleActionValues returns an array of possible values for the Action const type.
func PossibleActionValues() []Action {
	return []Action{ActionAllow}
}

// Action1 enumerates the values for action 1.
type Action1 string

const (
	// Action1Acquire ...
	Action1Acquire Action1 = "Acquire"
	// Action1Break ...
	Action1Break Action1 = "Break"
	// Action1Change ...
	Action1Change Action1 = "Change"
	// Action1Release ...
	Action1Release Action1 = "Release"
	// Action1Renew ...
	Action1Renew Action1 = "Renew"
)

// PossibleAction1Values returns an array of possible values for the Action1 const type.
func PossibleAction1Values() []Action1 {
	return []Action1{Action1Acquire, Action1Break, Action1Change, Action1Release, Action1Renew}
}

// AllowedCopyScope enumerates the values for allowed copy scope.
type AllowedCopyScope string

const (
	// AllowedCopyScopeAAD ...
	AllowedCopyScopeAAD AllowedCopyScope = "AAD"
	// AllowedCopyScopePrivateLink ...
	AllowedCopyScopePrivateLink AllowedCopyScope = "PrivateLink"
)

// PossibleAllowedCopyScopeValues returns an array of possible values for the AllowedCopyScope const type.
func PossibleAllowedCopyScopeValues() []AllowedCopyScope {
	return []AllowedCopyScope{AllowedCopyScopeAAD, AllowedCopyScopePrivateLink}
}

// BlobRestoreProgressStatus enumerates the values for blob restore progress status.
type BlobRestoreProgressStatus string

const (
	// BlobRestoreProgressStatusComplete ...
	BlobRestoreProgressStatusComplete BlobRestoreProgressStatus = "Complete"
	// BlobRestoreProgressStatusFailed ...
	BlobRestoreProgressStatusFailed BlobRestoreProgressStatus = "Failed"
	// BlobRestoreProgressStatusInProgress ...
	BlobRestoreProgressStatusInProgress BlobRestoreProgressStatus = "InProgress"
)

// PossibleBlobRestoreProgressStatusValues returns an array of possible values for the BlobRestoreProgressStatus const type.
func PossibleBlobRestoreProgressStatusValues() []BlobRestoreProgressStatus {
	return []BlobRestoreProgressStatus{BlobRestoreProgressStatusComplete, BlobRestoreProgressStatusFailed, BlobRestoreProgressStatusInProgress}
}

// Bypass enumerates the values for bypass.
type Bypass string

const (
	// BypassAzureServices ...
	BypassAzureServices Bypass = "AzureServices"
	// BypassLogging ...
	BypassLogging Bypass = "Logging"
	// BypassMetrics ...
	BypassMetrics Bypass = "Metrics"
	// BypassNone ...
	BypassNone Bypass = "None"
)

// PossibleBypassValues returns an array of possible values for the Bypass const type.
func PossibleBypassValues() []Bypass {
	return []Bypass{BypassAzureServices, BypassLogging, BypassMetrics, BypassNone}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// DefaultAction enumerates the values for default action.
type DefaultAction string

const (
	// DefaultActionAllow ...
	DefaultActionAllow DefaultAction = "Allow"
	// DefaultActionDeny ...
	DefaultActionDeny DefaultAction = "Deny"
)

// PossibleDefaultActionValues returns an array of possible values for the DefaultAction const type.
func PossibleDefaultActionValues() []DefaultAction {
	return []DefaultAction{DefaultActionAllow, DefaultActionDeny}
}

// DefaultSharePermission enumerates the values for default share permission.
type DefaultSharePermission string

const (
	// DefaultSharePermissionNone ...
	DefaultSharePermissionNone DefaultSharePermission = "None"
	// DefaultSharePermissionStorageFileDataSmbShareContributor ...
	DefaultSharePermissionStorageFileDataSmbShareContributor DefaultSharePermission = "StorageFileDataSmbShareContributor"
	// DefaultSharePermissionStorageFileDataSmbShareElevatedContributor ...
	DefaultSharePermissionStorageFileDataSmbShareElevatedContributor DefaultSharePermission = "StorageFileDataSmbShareElevatedContributor"
	// DefaultSharePermissionStorageFileDataSmbShareReader ...
	DefaultSharePermissionStorageFileDataSmbShareReader DefaultSharePermission = "StorageFileDataSmbShareReader"
)

// PossibleDefaultSharePermissionValues returns an array of possible values for the DefaultSharePermission const type.
func PossibleDefaultSharePermissionValues() []DefaultSharePermission {
	return []DefaultSharePermission{DefaultSharePermissionNone, DefaultSharePermissionStorageFileDataSmbShareContributor, DefaultSharePermissionStorageFileDataSmbShareElevatedContributor, DefaultSharePermissionStorageFileDataSmbShareReader}
}

// DirectoryServiceOptions enumerates the values for directory service options.
type DirectoryServiceOptions string

const (
	// DirectoryServiceOptionsAADDS ...
	DirectoryServiceOptionsAADDS DirectoryServiceOptions = "AADDS"
	// DirectoryServiceOptionsAD ...
	DirectoryServiceOptionsAD DirectoryServiceOptions = "AD"
	// DirectoryServiceOptionsNone ...
	DirectoryServiceOptionsNone DirectoryServiceOptions = "None"
)

// PossibleDirectoryServiceOptionsValues returns an array of possible values for the DirectoryServiceOptions const type.
func PossibleDirectoryServiceOptionsValues() []DirectoryServiceOptions {
	return []DirectoryServiceOptions{DirectoryServiceOptionsAADDS, DirectoryServiceOptionsAD, DirectoryServiceOptionsNone}
}

// DNSEndpointType enumerates the values for dns endpoint type.
type DNSEndpointType string

const (
	// DNSEndpointTypeAzureDNSZone ...
	DNSEndpointTypeAzureDNSZone DNSEndpointType = "AzureDnsZone"
	// DNSEndpointTypeStandard ...
	DNSEndpointTypeStandard DNSEndpointType = "Standard"
)

// PossibleDNSEndpointTypeValues returns an array of possible values for the DNSEndpointType const type.
func PossibleDNSEndpointTypeValues() []DNSEndpointType {
	return []DNSEndpointType{DNSEndpointTypeAzureDNSZone, DNSEndpointTypeStandard}
}

// EnabledProtocols enumerates the values for enabled protocols.
type EnabledProtocols string

const (
	// EnabledProtocolsNFS ...
	EnabledProtocolsNFS EnabledProtocols = "NFS"
	// EnabledProtocolsSMB ...
	EnabledProtocolsSMB EnabledProtocols = "SMB"
)

// PossibleEnabledProtocolsValues returns an array of possible values for the EnabledProtocols const type.
func PossibleEnabledProtocolsValues() []EnabledProtocols {
	return []EnabledProtocols{EnabledProtocolsNFS, EnabledProtocolsSMB}
}

// EncryptionScopeSource enumerates the values for encryption scope source.
type EncryptionScopeSource string

const (
	// EncryptionScopeSourceMicrosoftKeyVault ...
	EncryptionScopeSourceMicrosoftKeyVault EncryptionScopeSource = "Microsoft.KeyVault"
	// EncryptionScopeSourceMicrosoftStorage ...
	EncryptionScopeSourceMicrosoftStorage EncryptionScopeSource = "Microsoft.Storage"
)

// PossibleEncryptionScopeSourceValues returns an array of possible values for the EncryptionScopeSource const type.
func PossibleEncryptionScopeSourceValues() []EncryptionScopeSource {
	return []EncryptionScopeSource{EncryptionScopeSourceMicrosoftKeyVault, EncryptionScopeSourceMicrosoftStorage}
}

// EncryptionScopeState enumerates the values for encryption scope state.
type EncryptionScopeState string

const (
	// EncryptionScopeStateDisabled ...
	EncryptionScopeStateDisabled EncryptionScopeState = "Disabled"
	// EncryptionScopeStateEnabled ...
	EncryptionScopeStateEnabled EncryptionScopeState = "Enabled"
)

// PossibleEncryptionScopeStateValues returns an array of possible values for the EncryptionScopeState const type.
func PossibleEncryptionScopeStateValues() []EncryptionScopeState {
	return []EncryptionScopeState{EncryptionScopeStateDisabled, EncryptionScopeStateEnabled}
}

// ExtendedLocationTypes enumerates the values for extended location types.
type ExtendedLocationTypes string

const (
	// ExtendedLocationTypesEdgeZone ...
	ExtendedLocationTypesEdgeZone ExtendedLocationTypes = "EdgeZone"
)

// PossibleExtendedLocationTypesValues returns an array of possible values for the ExtendedLocationTypes const type.
func PossibleExtendedLocationTypesValues() []ExtendedLocationTypes {
	return []ExtendedLocationTypes{ExtendedLocationTypesEdgeZone}
}

// Format enumerates the values for format.
type Format string

const (
	// FormatCsv ...
	FormatCsv Format = "Csv"
	// FormatParquet ...
	FormatParquet Format = "Parquet"
)

// PossibleFormatValues returns an array of possible values for the Format const type.
func PossibleFormatValues() []Format {
	return []Format{FormatCsv, FormatParquet}
}

// GeoReplicationStatus enumerates the values for geo replication status.
type GeoReplicationStatus string

const (
	// GeoReplicationStatusBootstrap ...
	GeoReplicationStatusBootstrap GeoReplicationStatus = "Bootstrap"
	// GeoReplicationStatusLive ...
	GeoReplicationStatusLive GeoReplicationStatus = "Live"
	// GeoReplicationStatusUnavailable ...
	GeoReplicationStatusUnavailable GeoReplicationStatus = "Unavailable"
)

// PossibleGeoReplicationStatusValues returns an array of possible values for the GeoReplicationStatus const type.
func PossibleGeoReplicationStatusValues() []GeoReplicationStatus {
	return []GeoReplicationStatus{GeoReplicationStatusBootstrap, GeoReplicationStatusLive, GeoReplicationStatusUnavailable}
}

// HTTPProtocol enumerates the values for http protocol.
type HTTPProtocol string

const (
	// HTTPProtocolHTTPS ...
	HTTPProtocolHTTPS HTTPProtocol = "https"
	// HTTPProtocolHttpshttp ...
	HTTPProtocolHttpshttp HTTPProtocol = "https,http"
)

// PossibleHTTPProtocolValues returns an array of possible values for the HTTPProtocol const type.
func PossibleHTTPProtocolValues() []HTTPProtocol {
	return []HTTPProtocol{HTTPProtocolHTTPS, HTTPProtocolHttpshttp}
}

// IdentityType enumerates the values for identity type.
type IdentityType string

const (
	// IdentityTypeNone ...
	IdentityTypeNone IdentityType = "None"
	// IdentityTypeSystemAssigned ...
	IdentityTypeSystemAssigned IdentityType = "SystemAssigned"
	// IdentityTypeSystemAssignedUserAssigned ...
	IdentityTypeSystemAssignedUserAssigned IdentityType = "SystemAssigned,UserAssigned"
	// IdentityTypeUserAssigned ...
	IdentityTypeUserAssigned IdentityType = "UserAssigned"
)

// PossibleIdentityTypeValues returns an array of possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{IdentityTypeNone, IdentityTypeSystemAssigned, IdentityTypeSystemAssignedUserAssigned, IdentityTypeUserAssigned}
}

// ImmutabilityPolicyState enumerates the values for immutability policy state.
type ImmutabilityPolicyState string

const (
	// ImmutabilityPolicyStateLocked ...
	ImmutabilityPolicyStateLocked ImmutabilityPolicyState = "Locked"
	// ImmutabilityPolicyStateUnlocked ...
	ImmutabilityPolicyStateUnlocked ImmutabilityPolicyState = "Unlocked"
)

// PossibleImmutabilityPolicyStateValues returns an array of possible values for the ImmutabilityPolicyState const type.
func PossibleImmutabilityPolicyStateValues() []ImmutabilityPolicyState {
	return []ImmutabilityPolicyState{ImmutabilityPolicyStateLocked, ImmutabilityPolicyStateUnlocked}
}

// ImmutabilityPolicyUpdateType enumerates the values for immutability policy update type.
type ImmutabilityPolicyUpdateType string

const (
	// ImmutabilityPolicyUpdateTypeExtend ...
	ImmutabilityPolicyUpdateTypeExtend ImmutabilityPolicyUpdateType = "extend"
	// ImmutabilityPolicyUpdateTypeLock ...
	ImmutabilityPolicyUpdateTypeLock ImmutabilityPolicyUpdateType = "lock"
	// ImmutabilityPolicyUpdateTypePut ...
	ImmutabilityPolicyUpdateTypePut ImmutabilityPolicyUpdateType = "put"
)

// PossibleImmutabilityPolicyUpdateTypeValues returns an array of possible values for the ImmutabilityPolicyUpdateType const type.
func PossibleImmutabilityPolicyUpdateTypeValues() []ImmutabilityPolicyUpdateType {
	return []ImmutabilityPolicyUpdateType{ImmutabilityPolicyUpdateTypeExtend, ImmutabilityPolicyUpdateTypeLock, ImmutabilityPolicyUpdateTypePut}
}

// KeyPermission enumerates the values for key permission.
type KeyPermission string

const (
	// KeyPermissionFull ...
	KeyPermissionFull KeyPermission = "Full"
	// KeyPermissionRead ...
	KeyPermissionRead KeyPermission = "Read"
)

// PossibleKeyPermissionValues returns an array of possible values for the KeyPermission const type.
func PossibleKeyPermissionValues() []KeyPermission {
	return []KeyPermission{KeyPermissionFull, KeyPermissionRead}
}

// KeySource enumerates the values for key source.
type KeySource string

const (
	// KeySourceMicrosoftKeyvault ...
	KeySourceMicrosoftKeyvault KeySource = "Microsoft.Keyvault"
	// KeySourceMicrosoftStorage ...
	KeySourceMicrosoftStorage KeySource = "Microsoft.Storage"
)

// PossibleKeySourceValues returns an array of possible values for the KeySource const type.
func PossibleKeySourceValues() []KeySource {
	return []KeySource{KeySourceMicrosoftKeyvault, KeySourceMicrosoftStorage}
}

// KeyType enumerates the values for key type.
type KeyType string

const (
	// KeyTypeAccount ...
	KeyTypeAccount KeyType = "Account"
	// KeyTypeService ...
	KeyTypeService KeyType = "Service"
)

// PossibleKeyTypeValues returns an array of possible values for the KeyType const type.
func PossibleKeyTypeValues() []KeyType {
	return []KeyType{KeyTypeAccount, KeyTypeService}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindBlobStorage ...
	KindBlobStorage Kind = "BlobStorage"
	// KindBlockBlobStorage ...
	KindBlockBlobStorage Kind = "BlockBlobStorage"
	// KindFileStorage ...
	KindFileStorage Kind = "FileStorage"
	// KindStorage ...
	KindStorage Kind = "Storage"
	// KindStorageV2 ...
	KindStorageV2 Kind = "StorageV2"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindBlobStorage, KindBlockBlobStorage, KindFileStorage, KindStorage, KindStorageV2}
}

// LargeFileSharesState enumerates the values for large file shares state.
type LargeFileSharesState string

const (
	// LargeFileSharesStateDisabled ...
	LargeFileSharesStateDisabled LargeFileSharesState = "Disabled"
	// LargeFileSharesStateEnabled ...
	LargeFileSharesStateEnabled LargeFileSharesState = "Enabled"
)

// PossibleLargeFileSharesStateValues returns an array of possible values for the LargeFileSharesState const type.
func PossibleLargeFileSharesStateValues() []LargeFileSharesState {
	return []LargeFileSharesState{LargeFileSharesStateDisabled, LargeFileSharesStateEnabled}
}

// LeaseDuration enumerates the values for lease duration.
type LeaseDuration string

const (
	// LeaseDurationFixed ...
	LeaseDurationFixed LeaseDuration = "Fixed"
	// LeaseDurationInfinite ...
	LeaseDurationInfinite LeaseDuration = "Infinite"
)

// PossibleLeaseDurationValues returns an array of possible values for the LeaseDuration const type.
func PossibleLeaseDurationValues() []LeaseDuration {
	return []LeaseDuration{LeaseDurationFixed, LeaseDurationInfinite}
}

// LeaseShareAction enumerates the values for lease share action.
type LeaseShareAction string

const (
	// LeaseShareActionAcquire ...
	LeaseShareActionAcquire LeaseShareAction = "Acquire"
	// LeaseShareActionBreak ...
	LeaseShareActionBreak LeaseShareAction = "Break"
	// LeaseShareActionChange ...
	LeaseShareActionChange LeaseShareAction = "Change"
	// LeaseShareActionRelease ...
	LeaseShareActionRelease LeaseShareAction = "Release"
	// LeaseShareActionRenew ...
	LeaseShareActionRenew LeaseShareAction = "Renew"
)

// PossibleLeaseShareActionValues returns an array of possible values for the LeaseShareAction const type.
func PossibleLeaseShareActionValues() []LeaseShareAction {
	return []LeaseShareAction{LeaseShareActionAcquire, LeaseShareActionBreak, LeaseShareActionChange, LeaseShareActionRelease, LeaseShareActionRenew}
}

// LeaseState enumerates the values for lease state.
type LeaseState string

const (
	// LeaseStateAvailable ...
	LeaseStateAvailable LeaseState = "Available"
	// LeaseStateBreaking ...
	LeaseStateBreaking LeaseState = "Breaking"
	// LeaseStateBroken ...
	LeaseStateBroken LeaseState = "Broken"
	// LeaseStateExpired ...
	LeaseStateExpired LeaseState = "Expired"
	// LeaseStateLeased ...
	LeaseStateLeased LeaseState = "Leased"
)

// PossibleLeaseStateValues returns an array of possible values for the LeaseState const type.
func PossibleLeaseStateValues() []LeaseState {
	return []LeaseState{LeaseStateAvailable, LeaseStateBreaking, LeaseStateBroken, LeaseStateExpired, LeaseStateLeased}
}

// LeaseStatus enumerates the values for lease status.
type LeaseStatus string

const (
	// LeaseStatusLocked ...
	LeaseStatusLocked LeaseStatus = "Locked"
	// LeaseStatusUnlocked ...
	LeaseStatusUnlocked LeaseStatus = "Unlocked"
)

// PossibleLeaseStatusValues returns an array of possible values for the LeaseStatus const type.
func PossibleLeaseStatusValues() []LeaseStatus {
	return []LeaseStatus{LeaseStatusLocked, LeaseStatusUnlocked}
}

// ListContainersInclude enumerates the values for list containers include.
type ListContainersInclude string

const (
	// ListContainersIncludeDeleted ...
	ListContainersIncludeDeleted ListContainersInclude = "deleted"
)

// PossibleListContainersIncludeValues returns an array of possible values for the ListContainersInclude const type.
func PossibleListContainersIncludeValues() []ListContainersInclude {
	return []ListContainersInclude{ListContainersIncludeDeleted}
}

// ListKeyExpand enumerates the values for list key expand.
type ListKeyExpand string

const (
	// ListKeyExpandKerb ...
	ListKeyExpandKerb ListKeyExpand = "kerb"
)

// PossibleListKeyExpandValues returns an array of possible values for the ListKeyExpand const type.
func PossibleListKeyExpandValues() []ListKeyExpand {
	return []ListKeyExpand{ListKeyExpandKerb}
}

// MigrationState enumerates the values for migration state.
type MigrationState string

const (
	// MigrationStateCompleted ...
	MigrationStateCompleted MigrationState = "Completed"
	// MigrationStateInProgress ...
	MigrationStateInProgress MigrationState = "InProgress"
)

// PossibleMigrationStateValues returns an array of possible values for the MigrationState const type.
func PossibleMigrationStateValues() []MigrationState {
	return []MigrationState{MigrationStateCompleted, MigrationStateInProgress}
}

// MinimumTLSVersion enumerates the values for minimum tls version.
type MinimumTLSVersion string

const (
	// MinimumTLSVersionTLS10 ...
	MinimumTLSVersionTLS10 MinimumTLSVersion = "TLS1_0"
	// MinimumTLSVersionTLS11 ...
	MinimumTLSVersionTLS11 MinimumTLSVersion = "TLS1_1"
	// MinimumTLSVersionTLS12 ...
	MinimumTLSVersionTLS12 MinimumTLSVersion = "TLS1_2"
)

// PossibleMinimumTLSVersionValues returns an array of possible values for the MinimumTLSVersion const type.
func PossibleMinimumTLSVersionValues() []MinimumTLSVersion {
	return []MinimumTLSVersion{MinimumTLSVersionTLS10, MinimumTLSVersionTLS11, MinimumTLSVersionTLS12}
}

// Name enumerates the values for name.
type Name string

const (
	// NameAccessTimeTracking ...
	NameAccessTimeTracking Name = "AccessTimeTracking"
)

// PossibleNameValues returns an array of possible values for the Name const type.
func PossibleNameValues() []Name {
	return []Name{NameAccessTimeTracking}
}

// ObjectType enumerates the values for object type.
type ObjectType string

const (
	// ObjectTypeBlob ...
	ObjectTypeBlob ObjectType = "Blob"
	// ObjectTypeContainer ...
	ObjectTypeContainer ObjectType = "Container"
)

// PossibleObjectTypeValues returns an array of possible values for the ObjectType const type.
func PossibleObjectTypeValues() []ObjectType {
	return []ObjectType{ObjectTypeBlob, ObjectTypeContainer}
}

// Permissions enumerates the values for permissions.
type Permissions string

const (
	// PermissionsA ...
	PermissionsA Permissions = "a"
	// PermissionsC ...
	PermissionsC Permissions = "c"
	// PermissionsD ...
	PermissionsD Permissions = "d"
	// PermissionsL ...
	PermissionsL Permissions = "l"
	// PermissionsP ...
	PermissionsP Permissions = "p"
	// PermissionsR ...
	PermissionsR Permissions = "r"
	// PermissionsU ...
	PermissionsU Permissions = "u"
	// PermissionsW ...
	PermissionsW Permissions = "w"
)

// PossiblePermissionsValues returns an array of possible values for the Permissions const type.
func PossiblePermissionsValues() []Permissions {
	return []Permissions{PermissionsA, PermissionsC, PermissionsD, PermissionsL, PermissionsP, PermissionsR, PermissionsU, PermissionsW}
}

// PrivateEndpointConnectionProvisioningState enumerates the values for private endpoint connection
// provisioning state.
type PrivateEndpointConnectionProvisioningState string

const (
	// PrivateEndpointConnectionProvisioningStateCreating ...
	PrivateEndpointConnectionProvisioningStateCreating PrivateEndpointConnectionProvisioningState = "Creating"
	// PrivateEndpointConnectionProvisioningStateDeleting ...
	PrivateEndpointConnectionProvisioningStateDeleting PrivateEndpointConnectionProvisioningState = "Deleting"
	// PrivateEndpointConnectionProvisioningStateFailed ...
	PrivateEndpointConnectionProvisioningStateFailed PrivateEndpointConnectionProvisioningState = "Failed"
	// PrivateEndpointConnectionProvisioningStateSucceeded ...
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = "Succeeded"
)

// PossiblePrivateEndpointConnectionProvisioningStateValues returns an array of possible values for the PrivateEndpointConnectionProvisioningState const type.
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return []PrivateEndpointConnectionProvisioningState{PrivateEndpointConnectionProvisioningStateCreating, PrivateEndpointConnectionProvisioningStateDeleting, PrivateEndpointConnectionProvisioningStateFailed, PrivateEndpointConnectionProvisioningStateSucceeded}
}

// PrivateEndpointServiceConnectionStatus enumerates the values for private endpoint service connection status.
type PrivateEndpointServiceConnectionStatus string

const (
	// PrivateEndpointServiceConnectionStatusApproved ...
	PrivateEndpointServiceConnectionStatusApproved PrivateEndpointServiceConnectionStatus = "Approved"
	// PrivateEndpointServiceConnectionStatusPending ...
	PrivateEndpointServiceConnectionStatusPending PrivateEndpointServiceConnectionStatus = "Pending"
	// PrivateEndpointServiceConnectionStatusRejected ...
	PrivateEndpointServiceConnectionStatusRejected PrivateEndpointServiceConnectionStatus = "Rejected"
)

// PossiblePrivateEndpointServiceConnectionStatusValues returns an array of possible values for the PrivateEndpointServiceConnectionStatus const type.
func PossiblePrivateEndpointServiceConnectionStatusValues() []PrivateEndpointServiceConnectionStatus {
	return []PrivateEndpointServiceConnectionStatus{PrivateEndpointServiceConnectionStatusApproved, PrivateEndpointServiceConnectionStatusPending, PrivateEndpointServiceConnectionStatusRejected}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateResolvingDNS ...
	ProvisioningStateResolvingDNS ProvisioningState = "ResolvingDNS"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCreating, ProvisioningStateResolvingDNS, ProvisioningStateSucceeded}
}

// PublicAccess enumerates the values for public access.
type PublicAccess string

const (
	// PublicAccessBlob ...
	PublicAccessBlob PublicAccess = "Blob"
	// PublicAccessContainer ...
	PublicAccessContainer PublicAccess = "Container"
	// PublicAccessNone ...
	PublicAccessNone PublicAccess = "None"
)

// PossiblePublicAccessValues returns an array of possible values for the PublicAccess const type.
func PossiblePublicAccessValues() []PublicAccess {
	return []PublicAccess{PublicAccessBlob, PublicAccessContainer, PublicAccessNone}
}

// PublicNetworkAccess enumerates the values for public network access.
type PublicNetworkAccess string

const (
	// PublicNetworkAccessDisabled ...
	PublicNetworkAccessDisabled PublicNetworkAccess = "Disabled"
	// PublicNetworkAccessEnabled ...
	PublicNetworkAccessEnabled PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns an array of possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{PublicNetworkAccessDisabled, PublicNetworkAccessEnabled}
}

// Reason enumerates the values for reason.
type Reason string

const (
	// ReasonAccountNameInvalid ...
	ReasonAccountNameInvalid Reason = "AccountNameInvalid"
	// ReasonAlreadyExists ...
	ReasonAlreadyExists Reason = "AlreadyExists"
)

// PossibleReasonValues returns an array of possible values for the Reason const type.
func PossibleReasonValues() []Reason {
	return []Reason{ReasonAccountNameInvalid, ReasonAlreadyExists}
}

// ReasonCode enumerates the values for reason code.
type ReasonCode string

const (
	// ReasonCodeNotAvailableForSubscription ...
	ReasonCodeNotAvailableForSubscription ReasonCode = "NotAvailableForSubscription"
	// ReasonCodeQuotaID ...
	ReasonCodeQuotaID ReasonCode = "QuotaId"
)

// PossibleReasonCodeValues returns an array of possible values for the ReasonCode const type.
func PossibleReasonCodeValues() []ReasonCode {
	return []ReasonCode{ReasonCodeNotAvailableForSubscription, ReasonCodeQuotaID}
}

// RootSquashType enumerates the values for root squash type.
type RootSquashType string

const (
	// RootSquashTypeAllSquash ...
	RootSquashTypeAllSquash RootSquashType = "AllSquash"
	// RootSquashTypeNoRootSquash ...
	RootSquashTypeNoRootSquash RootSquashType = "NoRootSquash"
	// RootSquashTypeRootSquash ...
	RootSquashTypeRootSquash RootSquashType = "RootSquash"
)

// PossibleRootSquashTypeValues returns an array of possible values for the RootSquashType const type.
func PossibleRootSquashTypeValues() []RootSquashType {
	return []RootSquashType{RootSquashTypeAllSquash, RootSquashTypeNoRootSquash, RootSquashTypeRootSquash}
}

// RoutingChoice enumerates the values for routing choice.
type RoutingChoice string

const (
	// RoutingChoiceInternetRouting ...
	RoutingChoiceInternetRouting RoutingChoice = "InternetRouting"
	// RoutingChoiceMicrosoftRouting ...
	RoutingChoiceMicrosoftRouting RoutingChoice = "MicrosoftRouting"
)

// PossibleRoutingChoiceValues returns an array of possible values for the RoutingChoice const type.
func PossibleRoutingChoiceValues() []RoutingChoice {
	return []RoutingChoice{RoutingChoiceInternetRouting, RoutingChoiceMicrosoftRouting}
}

// Schedule enumerates the values for schedule.
type Schedule string

const (
	// ScheduleDaily ...
	ScheduleDaily Schedule = "Daily"
	// ScheduleWeekly ...
	ScheduleWeekly Schedule = "Weekly"
)

// PossibleScheduleValues returns an array of possible values for the Schedule const type.
func PossibleScheduleValues() []Schedule {
	return []Schedule{ScheduleDaily, ScheduleWeekly}
}

// Services enumerates the values for services.
type Services string

const (
	// ServicesB ...
	ServicesB Services = "b"
	// ServicesF ...
	ServicesF Services = "f"
	// ServicesQ ...
	ServicesQ Services = "q"
	// ServicesT ...
	ServicesT Services = "t"
)

// PossibleServicesValues returns an array of possible values for the Services const type.
func PossibleServicesValues() []Services {
	return []Services{ServicesB, ServicesF, ServicesQ, ServicesT}
}

// ShareAccessTier enumerates the values for share access tier.
type ShareAccessTier string

const (
	// ShareAccessTierCool ...
	ShareAccessTierCool ShareAccessTier = "Cool"
	// ShareAccessTierHot ...
	ShareAccessTierHot ShareAccessTier = "Hot"
	// ShareAccessTierPremium ...
	ShareAccessTierPremium ShareAccessTier = "Premium"
	// ShareAccessTierTransactionOptimized ...
	ShareAccessTierTransactionOptimized ShareAccessTier = "TransactionOptimized"
)

// PossibleShareAccessTierValues returns an array of possible values for the ShareAccessTier const type.
func PossibleShareAccessTierValues() []ShareAccessTier {
	return []ShareAccessTier{ShareAccessTierCool, ShareAccessTierHot, ShareAccessTierPremium, ShareAccessTierTransactionOptimized}
}

// SignedResource enumerates the values for signed resource.
type SignedResource string

const (
	// SignedResourceB ...
	SignedResourceB SignedResource = "b"
	// SignedResourceC ...
	SignedResourceC SignedResource = "c"
	// SignedResourceF ...
	SignedResourceF SignedResource = "f"
	// SignedResourceS ...
	SignedResourceS SignedResource = "s"
)

// PossibleSignedResourceValues returns an array of possible values for the SignedResource const type.
func PossibleSignedResourceValues() []SignedResource {
	return []SignedResource{SignedResourceB, SignedResourceC, SignedResourceF, SignedResourceS}
}

// SignedResourceTypes enumerates the values for signed resource types.
type SignedResourceTypes string

const (
	// SignedResourceTypesC ...
	SignedResourceTypesC SignedResourceTypes = "c"
	// SignedResourceTypesO ...
	SignedResourceTypesO SignedResourceTypes = "o"
	// SignedResourceTypesS ...
	SignedResourceTypesS SignedResourceTypes = "s"
)

// PossibleSignedResourceTypesValues returns an array of possible values for the SignedResourceTypes const type.
func PossibleSignedResourceTypesValues() []SignedResourceTypes {
	return []SignedResourceTypes{SignedResourceTypesC, SignedResourceTypesO, SignedResourceTypesS}
}

// SkuConversionStatus enumerates the values for sku conversion status.
type SkuConversionStatus string

const (
	// SkuConversionStatusFailed ...
	SkuConversionStatusFailed SkuConversionStatus = "Failed"
	// SkuConversionStatusInProgress ...
	SkuConversionStatusInProgress SkuConversionStatus = "InProgress"
	// SkuConversionStatusSucceeded ...
	SkuConversionStatusSucceeded SkuConversionStatus = "Succeeded"
)

// PossibleSkuConversionStatusValues returns an array of possible values for the SkuConversionStatus const type.
func PossibleSkuConversionStatusValues() []SkuConversionStatus {
	return []SkuConversionStatus{SkuConversionStatusFailed, SkuConversionStatusInProgress, SkuConversionStatusSucceeded}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// SkuNamePremiumLRS ...
	SkuNamePremiumLRS SkuName = "Premium_LRS"
	// SkuNamePremiumZRS ...
	SkuNamePremiumZRS SkuName = "Premium_ZRS"
	// SkuNameStandardGRS ...
	SkuNameStandardGRS SkuName = "Standard_GRS"
	// SkuNameStandardGZRS ...
	SkuNameStandardGZRS SkuName = "Standard_GZRS"
	// SkuNameStandardLRS ...
	SkuNameStandardLRS SkuName = "Standard_LRS"
	// SkuNameStandardRAGRS ...
	SkuNameStandardRAGRS SkuName = "Standard_RAGRS"
	// SkuNameStandardRAGZRS ...
	SkuNameStandardRAGZRS SkuName = "Standard_RAGZRS"
	// SkuNameStandardZRS ...
	SkuNameStandardZRS SkuName = "Standard_ZRS"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{SkuNamePremiumLRS, SkuNamePremiumZRS, SkuNameStandardGRS, SkuNameStandardGZRS, SkuNameStandardLRS, SkuNameStandardRAGRS, SkuNameStandardRAGZRS, SkuNameStandardZRS}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// SkuTierPremium ...
	SkuTierPremium SkuTier = "Premium"
	// SkuTierStandard ...
	SkuTierStandard SkuTier = "Standard"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{SkuTierPremium, SkuTierStandard}
}

// State enumerates the values for state.
type State string

const (
	// StateDeprovisioning ...
	StateDeprovisioning State = "Deprovisioning"
	// StateFailed ...
	StateFailed State = "Failed"
	// StateNetworkSourceDeleted ...
	StateNetworkSourceDeleted State = "NetworkSourceDeleted"
	// StateProvisioning ...
	StateProvisioning State = "Provisioning"
	// StateSucceeded ...
	StateSucceeded State = "Succeeded"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{StateDeprovisioning, StateFailed, StateNetworkSourceDeleted, StateProvisioning, StateSucceeded}
}

// UsageUnit enumerates the values for usage unit.
type UsageUnit string

const (
	// UsageUnitBytes ...
	UsageUnitBytes UsageUnit = "Bytes"
	// UsageUnitBytesPerSecond ...
	UsageUnitBytesPerSecond UsageUnit = "BytesPerSecond"
	// UsageUnitCount ...
	UsageUnitCount UsageUnit = "Count"
	// UsageUnitCountsPerSecond ...
	UsageUnitCountsPerSecond UsageUnit = "CountsPerSecond"
	// UsageUnitPercent ...
	UsageUnitPercent UsageUnit = "Percent"
	// UsageUnitSeconds ...
	UsageUnitSeconds UsageUnit = "Seconds"
)

// PossibleUsageUnitValues returns an array of possible values for the UsageUnit const type.
func PossibleUsageUnitValues() []UsageUnit {
	return []UsageUnit{UsageUnitBytes, UsageUnitBytesPerSecond, UsageUnitCount, UsageUnitCountsPerSecond, UsageUnitPercent, UsageUnitSeconds}
}
