# How to be a Programmer: Community Version
[//]: # (Version:1.1.0)
Robert L. Read with Community

Copyright 2002, 2003, 2016 Robert L. Read

Licensed under [Creative Commons Attribution-ShareAlike 4.0 International License](http://creativecommons.org/licenses/by-sa/4.0/).

[Available on gitbook to read online or download for offline reading (as PDF, ePub or Mobi)](https://www.gitbook.com/book/braydie/how-to-be-a-programmer/details)

[Available to buy as a hardcover book (cost covers production & shipping only)](http://www.blurb.com/b/6999069-how-to-be-a-programmer) - Edition 1, published 04/01/16

## Introduction
To be a good programmer is difficult and noble. The hardest part of making real a collective vision of a software project is dealing with one's coworkers and customers. Writing computer programs is important and takes great intelligence and skill. But it is really child's play compared to everything else that a good programmer must do to make a software system that succeeds for both the customer and myriad colleagues for whom he or she is partially responsible. In this essay I attempt to summarize as concisely as possible those things that I wish someone had explained to me when I was twenty-one.

This is very subjective and, therefore, this essay is doomed to be personal and somewhat opinionated. I confine myself to problems that a programmer is very likely to have to face in her work. Many of these problems and their solutions are so general to the human condition that I will probably seem preachy. I hope in spite of this that this essay will be useful.

Computer programming is taught in courses. The excellent books: The Pragmatic Programmer [Prag99], Code Complete [CodeC93], Rapid Development [RDev96], and Extreme Programming Explained [XP99] all teach computer programming and the larger issues of being a good programmer. The essays of Paul Graham [PGSite] and Eric Raymond [Hacker] should certainly be read before or along with this article. This essay differs from those excellent works by emphasizing social problems and comprehensively summarizing the entire set of necessary skills as I see them.

In this essay the term boss is used to refer to whomever gives you projects to do. I use the words business, company, and tribe, synonymously except that business connotes moneymaking, company connotes the modern workplace and tribe is generally the people you share loyalty with.

Welcome to the tribe.

## Contents

**Also available in [Chinese](zh/README.md) and [Japanese](jp/README.md)**

1. [Beginner](en/1-Beginner)
	- Personal Skills
		- [Learn to Debug](en/1-Beginner/Personal-Skills/01-Learn-To-Debug.md)
		- [How to Debug by Splitting the Problem Space](en/1-Beginner/Personal-Skills/02-How-to-Debug-by-Splitting-the-Problem-Space.md)
		- [How to Remove an Error](en/1-Beginner/Personal-Skills/03-How-to-Remove-an-Error.md)
		- [How to Debug Using a Log](en/1-Beginner/Personal-Skills/04-How-to-Debug-Using-a-Log.md)
		- [How to Understand Performance Problems](en/1-Beginner/Personal-Skills/05-How-to-Understand-Performance-Problems.md)
		- [How to Fix Performance Problems](en/1-Beginner/Personal-Skills/06-How-to-Fix-Performance-Problems.md)
		- [How to Optimize Loops](en/1-Beginner/Personal-Skills/07-How-to-Optimize-Loops.md)
		- [How to Deal with I/O Expense](en/1-Beginner/Personal-Skills/08-How-to-Deal-with-IO-Expense.md)
		- [How to Manage Memory](en/1-Beginner/Personal-Skills/09-How-to-Manage-Memory.md)
		- [How to Deal with Intermittent Bugs](en/1-Beginner/Personal-Skills/10-How-to-Deal-with-Intermittent-Bugs.md)
		- [How to Learn Design Skills](en/1-Beginner/Personal-Skills/11-How-to-Learn-Design-Skills.md)
		- [How to Conduct Experiments](en/1-Beginner/Personal-Skills/12-How-to-Conduct-Experiments.md)
	- Team Skills
		- [Why Estimation is Important](en/1-Beginner/Team-Skills/01-Why-Estimation-is-Important.md)
		- [How to Estimate Programming Time](en/1-Beginner/Team-Skills/02-How-to-Estimate-Programming-Time.md)
		- [How to Find Out Information](en/1-Beginner/Team-Skills/03-How-to-Find-Out-Information.md)
		- [How to Utilize People as Information Sources](en/1-Beginner/Team-Skills/04-How-to-Utilize-People-as-Information-Sources.md)
		- [How to Document Wisely](en/1-Beginner/Team-Skills/05-How-to-Document-Wisely.md)
		- [How to Work with Poor Code](en/1-Beginner/Team-Skills/06-How-to-Work-with-Poor-Code.md)
		- [How to Use Source Code Control](en/1-Beginner/Team-Skills/07-How-to-Use-Source-Code-Control.md)
		- [How to Unit Test](en/1-Beginner/Team-Skills/08-How-to-Unit-Test.md)
		- [Take Breaks when Stumped](en/1-Beginner/Team-Skills/09-Take-Breaks-when-Stumped.md)
		- [How to Recognize When to Go Home](en/1-Beginner/Team-Skills/10-How-to-Recognize-When-to-Go-Home.md)
		- [How to Deal with Difficult People](en/1-Beginner/Team-Skills/11-How-to-Deal-with-Difficult-People.md)
2. [Intermediate](en/2-Intermediate)
	- Personal Skills
		- [How to Stay Motivated](en/2-Intermediate/Personal-Skills/01-How-to-Stay-Motivated.md)
		- [How to be Widely Trusted](en/2-Intermediate/Personal-Skills/02-How-to-be-Widely-Trusted.md)
		- [How to Tradeoff Time vs. Space](en/2-Intermediate/Personal-Skills/03-How-to-Tradeoff-Time-vs-Space.md)
		- [How to Stress Test](en/2-Intermediate/Personal-Skills/04-How-to-Stress-Test.md)
		- [How to Balance Brevity and Abstraction](en/2-Intermediate/Personal-Skills/05-How-to-Balance-Brevity-and-Abstraction.md)
		- [How to Learn New Skills](en/2-Intermediate/Personal-Skills/06-How-to-Learn-New-Skills.md)
		- [Learn to Type](en/2-Intermediate/Personal-Skills/07-Learn-to-Type.md)
		- [How to Do Integration Testing](en/2-Intermediate/Personal-Skills/08-How-to-Do-Integration-Testing.md)
		- [Communication Languages](en/2-Intermediate/Personal-Skills/09-Communication-Languages.md)
		- [Heavy Tools](en/2-Intermediate/Personal-Skills/10-Heavy-Tools.md)
		- [How to analyze data](en/2-Intermediate/Personal-Skills/11-How-to-analyze-data.md)
	- Team Skills
		- [How to Manage Development Time](en/2-Intermediate/Team-Skills/01-How-to-Manage-Development-Time.md)
		- [How to Manage Third-Party Software Risks](en/2-Intermediate/Team-Skills/02-How-to-Manage-Third-Party-Software-Risks.md)
		- [How to Manage Consultants](en/2-Intermediate/Team-Skills/03-How-to-Manage-Consultants.md)
		- [How to Communicate the Right Amount](en/2-Intermediate/Team-Skills/04-How-to-Communicate-the-Right-Amount.md)
		- [How to Disagree Honestly and Get Away with It](en/2-Intermediate/Team-Skills/05-How-to-Disagree-Honestly-and-Get-Away-with-It.md)
	- Judgment
		- [How to Tradeoff Quality Against Development Time](en/2-Intermediate/Judgment/01-How-to-Tradeoff-Quality-Against-Development-Time.md)
		- [How to Manage Software System Dependence](en/2-Intermediate/Judgment/02-How-to-Manage-Software-System-Dependence.md)
		- [How to Decide if Software is Too Immature](en/2-Intermediate/Judgment/03-How-to-Decide-if-Software-is-Too-Immature.md)
		- [How to Make a Buy vs. Build Decision](en/2-Intermediate/Judgment/04-How-to-Make-a-Buy-vs-Build-Decision.md)
		- [How to Grow Professionally](en/2-Intermediate/Judgment/05-How-to-Grow-Professionally.md)
		- [How to Evaluate Interviewees](en/2-Intermediate/Judgment/06-How-to-Evaluate-Interviewees.md)
		- [How to Know When to Apply Fancy Computer Science](en/2-Intermediate/Judgment/07-How-to-Know-When-to-Apply-Fancy-Computer-Science.md)
		- [How to Talk to Non-Engineers](en/2-Intermediate/Judgment/08-How-to-Talk-to-Non-Engineers.md)
3. [Advanced](en/3-Advanced)
	- Technological Judgment
		- [How to Tell the Hard From the Impossible](en/3-Advanced/Technical-Judgment/01-How-to-Tell-the-Hard-From-the-Impossible.md)
		- [How to Utilize Embedded Languages](en/3-Advanced/Technical-Judgment/02-How-to-Utilize-Embedded-Languages.md)
		- [Choosing Languages](en/3-Advanced/Technical-Judgment/03-Choosing-Languages.md)
	- Compromising Wisely
		- [How to Fight Schedule Pressure](en/3-Advanced/Compromising-Wisely/01-How-to-Fight-Schedule-Pressure.md)
		- [How to Understand the User](en/3-Advanced/Compromising-Wisely/02-How-to-Understand-the-User.md)
		- [How to Get a Promotion](en/3-Advanced/Compromising-Wisely/03-How-to-Get-a-Promotion.md)
	- Serving Your Team
		- [How to Develop Talent](en/3-Advanced/Serving-Your-Team/01-How-to-Develop-Talent.md)
		- [How to Choose What to Work On](en/3-Advanced/Serving-Your-Team/02-How-to-Choose-What-to-Work-On.md)
		- [How to Get the Most From Your Team-mates](en/3-Advanced/Serving-Your-Team/03-How-to-Get-the-Most-From-Your-Teammates.md)
		- [How to Divide Problems Up](en/3-Advanced/Serving-Your-Team/04-How-to-Divide-Problems-Up.md)
		- [How to Handle Boring Tasks](en/3-Advanced/Serving-Your-Team/05-How-to-Handle-Boring-Tasks.md)
		- [How to Gather Support for a Project](en/3-Advanced/Serving-Your-Team/06-How-to-Gather-Support-for-a-Project.md)
		- [How to Grow a System](en/3-Advanced/Serving-Your-Team/07-How-to-Grow-a-System.md)
		- [How to Communicate Well](en/3-Advanced/Serving-Your-Team/08-How-to-Communicate-Well.md)
		- [How to Tell People Things They Don't Want to Hear](en/3-Advanced/Serving-Your-Team/09-How-to-Tell-People-Things-They-Dont-Want-to-Hear.md)
		- [How to Deal with Managerial Myths](en/3-Advanced/Serving-Your-Team/10-How-to-Deal-with-Managerial-Myths.md)
		- [How to Deal with Organizational Chaos](en/3-Advanced/Serving-Your-Team/11-How-to-Deal-with-Organizational-Chaos.md)
4. [Glossary](en/GLOSSARY.md)
5. [Appendix A - Bibliography/Websiteography](en/5-Bibliography.md)
6. [Appendix B - History (As of January 2016)](en/6-History.md)
6. [Appendix C - Contributions (As of January 2016)](en/7-Contributions.md)


<a rel="license" href="http://creativecommons.org/licenses/by-sa/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by-sa/4.0/88x31.png" /></a><br /><span xmlns:dct="http://purl.org/dc/terms/" href="http://purl.org/dc/dcmitype/Text" property="dct:title" rel="dct:type">How To Be A Programmer: Community Version</span> by <span xmlns:cc="http://creativecommons.org/ns#" property="cc:attributionName">Robert L. Read with Community</span> is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-sa/4.0/">Creative Commons Attribution-ShareAlike 4.0 International License</a>.
