/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// NetworkLoadBalancers struct for NetworkLoadBalancers
type NetworkLoadBalancers struct {
	Links *PaginationLinks `json:"_links,omitempty"`
	// URL to the object representation (absolute path).
	Href *string `json:"href,omitempty"`
	// The resource's unique identifier.
	Id *string `json:"id,omitempty"`
	// Array of items in the collection.
	Items *[]NetworkLoadBalancer `json:"items,omitempty"`
	// The limit (if specified in the request).
	Limit *float32 `json:"limit,omitempty"`
	// The offset (if specified in the request).
	Offset *float32 `json:"offset,omitempty"`
	// The type of object that has been created.
	Type *Type `json:"type,omitempty"`
}

// NewNetworkLoadBalancers instantiates a new NetworkLoadBalancers object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewNetworkLoadBalancers() *NetworkLoadBalancers {
	this := NetworkLoadBalancers{}

	return &this
}

// NewNetworkLoadBalancersWithDefaults instantiates a new NetworkLoadBalancers object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewNetworkLoadBalancersWithDefaults() *NetworkLoadBalancers {
	this := NetworkLoadBalancers{}
	return &this
}

// GetLinks returns the Links field value
// If the value is explicit nil, nil is returned
func (o *NetworkLoadBalancers) GetLinks() *PaginationLinks {
	if o == nil {
		return nil
	}

	return o.Links

}

// GetLinksOk returns a tuple with the Links field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancers) GetLinksOk() (*PaginationLinks, bool) {
	if o == nil {
		return nil, false
	}

	return o.Links, true
}

// SetLinks sets field value
func (o *NetworkLoadBalancers) SetLinks(v PaginationLinks) {

	o.Links = &v

}

// HasLinks returns a boolean if a field has been set.
func (o *NetworkLoadBalancers) HasLinks() bool {
	if o != nil && o.Links != nil {
		return true
	}

	return false
}

// GetHref returns the Href field value
// If the value is explicit nil, nil is returned
func (o *NetworkLoadBalancers) GetHref() *string {
	if o == nil {
		return nil
	}

	return o.Href

}

// GetHrefOk returns a tuple with the Href field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancers) GetHrefOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Href, true
}

// SetHref sets field value
func (o *NetworkLoadBalancers) SetHref(v string) {

	o.Href = &v

}

// HasHref returns a boolean if a field has been set.
func (o *NetworkLoadBalancers) HasHref() bool {
	if o != nil && o.Href != nil {
		return true
	}

	return false
}

// GetId returns the Id field value
// If the value is explicit nil, nil is returned
func (o *NetworkLoadBalancers) GetId() *string {
	if o == nil {
		return nil
	}

	return o.Id

}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancers) GetIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Id, true
}

// SetId sets field value
func (o *NetworkLoadBalancers) SetId(v string) {

	o.Id = &v

}

// HasId returns a boolean if a field has been set.
func (o *NetworkLoadBalancers) HasId() bool {
	if o != nil && o.Id != nil {
		return true
	}

	return false
}

// GetItems returns the Items field value
// If the value is explicit nil, nil is returned
func (o *NetworkLoadBalancers) GetItems() *[]NetworkLoadBalancer {
	if o == nil {
		return nil
	}

	return o.Items

}

// GetItemsOk returns a tuple with the Items field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancers) GetItemsOk() (*[]NetworkLoadBalancer, bool) {
	if o == nil {
		return nil, false
	}

	return o.Items, true
}

// SetItems sets field value
func (o *NetworkLoadBalancers) SetItems(v []NetworkLoadBalancer) {

	o.Items = &v

}

// HasItems returns a boolean if a field has been set.
func (o *NetworkLoadBalancers) HasItems() bool {
	if o != nil && o.Items != nil {
		return true
	}

	return false
}

// GetLimit returns the Limit field value
// If the value is explicit nil, nil is returned
func (o *NetworkLoadBalancers) GetLimit() *float32 {
	if o == nil {
		return nil
	}

	return o.Limit

}

// GetLimitOk returns a tuple with the Limit field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancers) GetLimitOk() (*float32, bool) {
	if o == nil {
		return nil, false
	}

	return o.Limit, true
}

// SetLimit sets field value
func (o *NetworkLoadBalancers) SetLimit(v float32) {

	o.Limit = &v

}

// HasLimit returns a boolean if a field has been set.
func (o *NetworkLoadBalancers) HasLimit() bool {
	if o != nil && o.Limit != nil {
		return true
	}

	return false
}

// GetOffset returns the Offset field value
// If the value is explicit nil, nil is returned
func (o *NetworkLoadBalancers) GetOffset() *float32 {
	if o == nil {
		return nil
	}

	return o.Offset

}

// GetOffsetOk returns a tuple with the Offset field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancers) GetOffsetOk() (*float32, bool) {
	if o == nil {
		return nil, false
	}

	return o.Offset, true
}

// SetOffset sets field value
func (o *NetworkLoadBalancers) SetOffset(v float32) {

	o.Offset = &v

}

// HasOffset returns a boolean if a field has been set.
func (o *NetworkLoadBalancers) HasOffset() bool {
	if o != nil && o.Offset != nil {
		return true
	}

	return false
}

// GetType returns the Type field value
// If the value is explicit nil, nil is returned
func (o *NetworkLoadBalancers) GetType() *Type {
	if o == nil {
		return nil
	}

	return o.Type

}

// GetTypeOk returns a tuple with the Type field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancers) GetTypeOk() (*Type, bool) {
	if o == nil {
		return nil, false
	}

	return o.Type, true
}

// SetType sets field value
func (o *NetworkLoadBalancers) SetType(v Type) {

	o.Type = &v

}

// HasType returns a boolean if a field has been set.
func (o *NetworkLoadBalancers) HasType() bool {
	if o != nil && o.Type != nil {
		return true
	}

	return false
}

func (o NetworkLoadBalancers) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Links != nil {
		toSerialize["_links"] = o.Links
	}

	if o.Href != nil {
		toSerialize["href"] = o.Href
	}

	if o.Id != nil {
		toSerialize["id"] = o.Id
	}

	if o.Items != nil {
		toSerialize["items"] = o.Items
	}

	if o.Limit != nil {
		toSerialize["limit"] = o.Limit
	}

	if o.Offset != nil {
		toSerialize["offset"] = o.Offset
	}

	if o.Type != nil {
		toSerialize["type"] = o.Type
	}

	return json.Marshal(toSerialize)
}

type NullableNetworkLoadBalancers struct {
	value *NetworkLoadBalancers
	isSet bool
}

func (v NullableNetworkLoadBalancers) Get() *NetworkLoadBalancers {
	return v.value
}

func (v *NullableNetworkLoadBalancers) Set(val *NetworkLoadBalancers) {
	v.value = val
	v.isSet = true
}

func (v NullableNetworkLoadBalancers) IsSet() bool {
	return v.isSet
}

func (v *NullableNetworkLoadBalancers) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableNetworkLoadBalancers(val *NetworkLoadBalancers) *NullableNetworkLoadBalancers {
	return &NullableNetworkLoadBalancers{value: val, isSet: true}
}

func (v NullableNetworkLoadBalancers) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableNetworkLoadBalancers) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
