// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/securitycenter/v1beta1/asset.proto

package securitycenter

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_struct "github.com/golang/protobuf/ptypes/struct"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Cloud Security Command Center's (Cloud SCC) representation of a Google Cloud
// Platform (GCP) resource.
//
// The Asset is a Cloud SCC resource that captures information about a single
// GCP resource. All modifications to an Asset are only within the context of
// Cloud SCC and don't affect the referenced GCP resource.
type Asset struct {
	// The relative resource name of this asset. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// Example:
	// "organizations/{organization_id}/assets/{asset_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Cloud SCC managed properties. These properties are managed by
	// Cloud SCC and cannot be modified by the user.
	SecurityCenterProperties *Asset_SecurityCenterProperties `protobuf:"bytes,2,opt,name=security_center_properties,json=securityCenterProperties,proto3" json:"security_center_properties,omitempty"`
	// Resource managed properties. These properties are managed and defined by
	// the GCP resource and cannot be modified by the user.
	ResourceProperties map[string]*_struct.Value `protobuf:"bytes,7,rep,name=resource_properties,json=resourceProperties,proto3" json:"resource_properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// User specified security marks. These marks are entirely managed by the user
	// and come from the SecurityMarks resource that belongs to the asset.
	SecurityMarks *SecurityMarks `protobuf:"bytes,8,opt,name=security_marks,json=securityMarks,proto3" json:"security_marks,omitempty"`
	// The time at which the asset was created in Cloud SCC.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time at which the asset was last updated, added, or deleted in Cloud
	// SCC.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Asset) Reset()         { *m = Asset{} }
func (m *Asset) String() string { return proto.CompactTextString(m) }
func (*Asset) ProtoMessage()    {}
func (*Asset) Descriptor() ([]byte, []int) {
	return fileDescriptor_51f3b31ca795196d, []int{0}
}

func (m *Asset) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Asset.Unmarshal(m, b)
}
func (m *Asset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Asset.Marshal(b, m, deterministic)
}
func (m *Asset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Asset.Merge(m, src)
}
func (m *Asset) XXX_Size() int {
	return xxx_messageInfo_Asset.Size(m)
}
func (m *Asset) XXX_DiscardUnknown() {
	xxx_messageInfo_Asset.DiscardUnknown(m)
}

var xxx_messageInfo_Asset proto.InternalMessageInfo

func (m *Asset) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Asset) GetSecurityCenterProperties() *Asset_SecurityCenterProperties {
	if m != nil {
		return m.SecurityCenterProperties
	}
	return nil
}

func (m *Asset) GetResourceProperties() map[string]*_struct.Value {
	if m != nil {
		return m.ResourceProperties
	}
	return nil
}

func (m *Asset) GetSecurityMarks() *SecurityMarks {
	if m != nil {
		return m.SecurityMarks
	}
	return nil
}

func (m *Asset) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Asset) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// Cloud SCC managed properties. These properties are managed by Cloud SCC and
// cannot be modified by the user.
type Asset_SecurityCenterProperties struct {
	// Immutable. The full resource name of the GCP resource this asset
	// represents. This field is immutable after create time. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The type of the GCP resource. Examples include: APPLICATION,
	// PROJECT, and ORGANIZATION. This is a case insensitive field defined by
	// Cloud SCC and/or the producer of the resource and is immutable
	// after create time.
	ResourceType string `protobuf:"bytes,2,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
	// The full resource name of the immediate parent of the resource. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	ResourceParent string `protobuf:"bytes,3,opt,name=resource_parent,json=resourceParent,proto3" json:"resource_parent,omitempty"`
	// The full resource name of the project the resource belongs to. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	ResourceProject string `protobuf:"bytes,4,opt,name=resource_project,json=resourceProject,proto3" json:"resource_project,omitempty"`
	// Owners of the Google Cloud resource.
	ResourceOwners       []string `protobuf:"bytes,5,rep,name=resource_owners,json=resourceOwners,proto3" json:"resource_owners,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Asset_SecurityCenterProperties) Reset()         { *m = Asset_SecurityCenterProperties{} }
func (m *Asset_SecurityCenterProperties) String() string { return proto.CompactTextString(m) }
func (*Asset_SecurityCenterProperties) ProtoMessage()    {}
func (*Asset_SecurityCenterProperties) Descriptor() ([]byte, []int) {
	return fileDescriptor_51f3b31ca795196d, []int{0, 0}
}

func (m *Asset_SecurityCenterProperties) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Asset_SecurityCenterProperties.Unmarshal(m, b)
}
func (m *Asset_SecurityCenterProperties) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Asset_SecurityCenterProperties.Marshal(b, m, deterministic)
}
func (m *Asset_SecurityCenterProperties) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Asset_SecurityCenterProperties.Merge(m, src)
}
func (m *Asset_SecurityCenterProperties) XXX_Size() int {
	return xxx_messageInfo_Asset_SecurityCenterProperties.Size(m)
}
func (m *Asset_SecurityCenterProperties) XXX_DiscardUnknown() {
	xxx_messageInfo_Asset_SecurityCenterProperties.DiscardUnknown(m)
}

var xxx_messageInfo_Asset_SecurityCenterProperties proto.InternalMessageInfo

func (m *Asset_SecurityCenterProperties) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *Asset_SecurityCenterProperties) GetResourceType() string {
	if m != nil {
		return m.ResourceType
	}
	return ""
}

func (m *Asset_SecurityCenterProperties) GetResourceParent() string {
	if m != nil {
		return m.ResourceParent
	}
	return ""
}

func (m *Asset_SecurityCenterProperties) GetResourceProject() string {
	if m != nil {
		return m.ResourceProject
	}
	return ""
}

func (m *Asset_SecurityCenterProperties) GetResourceOwners() []string {
	if m != nil {
		return m.ResourceOwners
	}
	return nil
}

func init() {
	proto.RegisterType((*Asset)(nil), "google.cloud.securitycenter.v1beta1.Asset")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "google.cloud.securitycenter.v1beta1.Asset.ResourcePropertiesEntry")
	proto.RegisterType((*Asset_SecurityCenterProperties)(nil), "google.cloud.securitycenter.v1beta1.Asset.SecurityCenterProperties")
}

func init() {
	proto.RegisterFile("google/cloud/securitycenter/v1beta1/asset.proto", fileDescriptor_51f3b31ca795196d)
}

var fileDescriptor_51f3b31ca795196d = []byte{
	// 514 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0x5d, 0x6f, 0xd3, 0x30,
	0x14, 0x55, 0x96, 0x75, 0x50, 0x97, 0x7d, 0xc8, 0x48, 0x10, 0x45, 0x48, 0x54, 0xec, 0x61, 0x45,
	0x42, 0x8e, 0x56, 0x5e, 0x26, 0xf6, 0xb4, 0x4e, 0x3c, 0x02, 0x23, 0x4c, 0x48, 0x20, 0xa1, 0xca,
	0x4d, 0xef, 0x42, 0x58, 0x62, 0x5b, 0xb6, 0x53, 0x94, 0x17, 0x24, 0x7e, 0x12, 0xff, 0x88, 0x27,
	0x7e, 0x07, 0xb2, 0xe3, 0xa4, 0x29, 0x55, 0xa1, 0xbc, 0xd9, 0xf7, 0x9e, 0x73, 0xee, 0xf5, 0x3d,
	0x57, 0x46, 0x51, 0xca, 0x79, 0x9a, 0x43, 0x94, 0xe4, 0xbc, 0x9c, 0x47, 0x0a, 0x92, 0x52, 0x66,
	0xba, 0x4a, 0x80, 0x69, 0x90, 0xd1, 0xe2, 0x74, 0x06, 0x9a, 0x9e, 0x46, 0x54, 0x29, 0xd0, 0x44,
	0x48, 0xae, 0x39, 0x3e, 0xae, 0x09, 0xc4, 0x12, 0xc8, 0x2a, 0x81, 0x38, 0x42, 0xf8, 0xd8, 0xa9,
	0x52, 0x91, 0x45, 0x37, 0x19, 0xe4, 0xf3, 0xe9, 0x0c, 0x3e, 0xd3, 0x45, 0xc6, 0x65, 0xad, 0x12,
	0x9e, 0x6d, 0x53, 0xb6, 0x09, 0x4f, 0x0b, 0x2a, 0x6f, 0x95, 0x63, 0x3e, 0x72, 0x4c, 0x7b, 0x9b,
	0x95, 0x37, 0x91, 0xd2, 0xb2, 0x4c, 0x5c, 0x77, 0x6d, 0xe1, 0x36, 0xab, 0xb3, 0x02, 0x94, 0xa6,
	0x85, 0xf8, 0x83, 0x6e, 0x3a, 0xa3, 0x8c, 0x71, 0x4d, 0x75, 0xc6, 0x99, 0x13, 0x7f, 0xf2, 0x63,
	0x0f, 0xf5, 0x2e, 0xcc, 0x63, 0x31, 0x46, 0xbb, 0x8c, 0x16, 0x10, 0x78, 0x43, 0x6f, 0xd4, 0x8f,
	0xed, 0x19, 0x7f, 0xf7, 0x50, 0xd8, 0xf6, 0x54, 0xf7, 0x3a, 0x15, 0x92, 0x0b, 0x90, 0x3a, 0x03,
	0x15, 0xec, 0x0c, 0xbd, 0xd1, 0x60, 0x7c, 0x49, 0xb6, 0x18, 0x10, 0xb1, 0x45, 0xc8, 0x3b, 0x97,
	0xbc, 0xb4, 0xc9, 0xab, 0x56, 0x2a, 0x0e, 0xd4, 0x86, 0x0c, 0x56, 0xe8, 0xbe, 0x04, 0xc5, 0x4b,
	0x99, 0x40, 0xb7, 0xf6, 0x9d, 0xa1, 0x3f, 0x1a, 0x8c, 0x27, 0xff, 0x51, 0x3b, 0x76, 0x2a, 0x4b,
	0xed, 0x97, 0x4c, 0xcb, 0x2a, 0xc6, 0x72, 0x2d, 0x81, 0x3f, 0xa0, 0x83, 0x55, 0x2f, 0x82, 0xbb,
	0xf6, 0xad, 0xe3, 0xad, 0xea, 0x35, 0xaf, 0x7c, 0x65, 0x98, 0xf1, 0xbe, 0xea, 0x5e, 0xf1, 0x39,
	0x1a, 0x24, 0x12, 0xa8, 0x86, 0xa9, 0x71, 0x2a, 0xe8, 0x5b, 0xdd, 0xb0, 0xd1, 0x6d, 0x6c, 0x24,
	0xd7, 0x8d, 0x8d, 0x31, 0xaa, 0xe1, 0x26, 0x60, 0xc8, 0xa5, 0x98, 0xb7, 0x64, 0xf4, 0x6f, 0x72,
	0x0d, 0x37, 0x81, 0xf0, 0x97, 0x87, 0x82, 0x4d, 0x06, 0xe0, 0x11, 0xda, 0x6f, 0xc7, 0xbc, 0xdc,
	0x83, 0x89, 0xff, 0xf3, 0xa2, 0x17, 0xdf, 0x6b, 0x32, 0xaf, 0xcd, 0x52, 0x1c, 0x77, 0x90, 0xba,
	0x12, 0x60, 0xd7, 0xa0, 0xbf, 0x04, 0x5d, 0x57, 0x02, 0xf0, 0x09, 0x3a, 0x5c, 0xba, 0x46, 0x25,
	0x30, 0x1d, 0xf8, 0x16, 0x76, 0xd0, 0x4e, 0xdb, 0x46, 0xf1, 0x53, 0x74, 0xd4, 0xb5, 0xf7, 0x0b,
	0x24, 0x3a, 0xd8, 0xb5, 0xc8, 0xc3, 0x8e, 0x2f, 0x26, 0xbc, 0xa2, 0xc9, 0xbf, 0x32, 0x90, 0x2a,
	0xe8, 0x0d, 0xfd, 0xae, 0xe6, 0x1b, 0x1b, 0x0d, 0x3f, 0xa1, 0x87, 0x1b, 0xcc, 0xc6, 0x47, 0xc8,
	0xbf, 0x85, 0xca, 0x2d, 0xb9, 0x39, 0xe2, 0x67, 0xa8, 0xb7, 0xa0, 0x79, 0x09, 0x6e, 0x9b, 0x1f,
	0xac, 0x0d, 0xf3, 0xbd, 0xc9, 0xc6, 0x35, 0xe8, 0xc5, 0xce, 0x99, 0x37, 0xf9, 0x86, 0x4e, 0x12,
	0x5e, 0x6c, 0xb3, 0x09, 0x57, 0xde, 0xc7, 0xb7, 0x0e, 0x96, 0xf2, 0x9c, 0xb2, 0x94, 0x70, 0x99,
	0x46, 0x29, 0x30, 0x2b, 0xee, 0x7e, 0x22, 0x2a, 0x32, 0xf5, 0xd7, 0x6f, 0xe1, 0x7c, 0x35, 0x3c,
	0xdb, 0xb3, 0xec, 0xe7, 0xbf, 0x03, 0x00, 0x00, 0xff, 0xff, 0xe7, 0x7e, 0xb0, 0x0b, 0xca, 0x04,
	0x00, 0x00,
}
