/*
Copyright (C) 2000-2005  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "stack.h"
extern int debug;
extern const char *nameparse, *namelib;
extern int currfunc;
extern int lastpass;
extern int autogc;
extern int warn;

#define STACKSZ (1024)
#define GNIL    (0)
#define GNOARG  (1)
static   inline int min(int x, int y) { return (x<=y)?x:y; }
static   inline int max(int x, int y) { return (x>=y)?x:y; }

typedef struct
{
  char *txt;
  long lineno;
} error_string;

typedef struct
{
  stack s;
  char *txt;
} comment;

typedef struct
{
  char *s;
  int c;
} strcom;
typedef enum {Fseq,
              Fmatrix,Frange,
              Fassign,
              Fmatcoeff,
              Fmatrixelts,Fmatrixlines,
              Fmat,Fvec,
              Flistarg,
              Frefarg,
              Fcall,

              Fconst,Fsmall,Fnoarg,
              Ftag,
              Fentry,Ffunction,Flambda,Fdeffunc,
              /*This node is generated by genblock, not by parser*/
              Fblock, Ffun
} Ffunc;
#define FneedENTRY (Fconst)
#define Flastfunc  (Ffun)

/*see parse.y for definition.
Fblock x: block number y:seq
*/
extern const char *Ffuncname[];


#include "type.h"
#include "optable.h"
typedef enum {Cuser,Cauto,Cglobal,Cconst,Carg,Ccompo,Cclosed,
              Cimmutable,Cdefmarker,Cundeclared,Cfunction} Vtype;
/*
  Cuser: Variable defined by user in the source
  Cauto: Variable get type of initialisation
  Cglobal: Global variable for this module.
  Cconst:  Variable affected exactly once in the code.
  Carg:   Variable is a function's parameter.
  Ccompo:  Variable components are updated.
  Cimmutable: Variable affected exactly once in the run.
  Cdefmarker: Variable initialised to the default marker.
  Cundeclared: Variable was not declared.
  Cfunction: Variable belong to function scope.
 */
typedef struct node_s
{
  Ffunc f;          /*node function*/
  int x;            /*node left child*/
  int y;            /*node right child*/
  int t;            /*node type*/
  int m;            /*node mode bitmask*/
  int lineno;       /*linenumber of corresponding code*/
  int comment;
} node;

/* Automatic variables GP names are <number1>.
 * Automatic variables C names are {p,l}<number2>
 * with number2<=number1 since we remove unused variables.
 */

#define varstr(y) (value[tree[(y).node].x].val.str)
#define vartype(x) (tree[(x).node].t)

typedef struct
{
  int flag;         /*context type, Vtype bitmask*/
  int key;          /*context hashkey*/
  const char *cvar; /*context var C name*/
  int node;
  int initval;      /*context initial value of var*/
  int val;          /*context value, if constant*/
} ctxvar;

enum AFenum {AFaccess,AFassign,AFassigncompo,AFassigncopy,AFrefarg, AFhide, AFclone};

typedef struct
{
  enum AFenum f;
  int idx;
} affnode;

enum GCenum {GCneeded, GCupto, GCglobal, GCreturn};
typedef struct
{
  ctxvar *c;       /*context stack*/
  stack s;
  int ret;         /*if not -1 , node number of var holding return
                     value*/
  affnode *var;    /*Data about variable*/
  stack v;
  int savb;
  int egc;         /*Extra var to be gerepiled*/
  long gc;         /*garbage collecting attribute, bitmask of GCenum*/
  int *gcvar;      /*List of var that need to be gerepiled*/
  stack g;
} context;

enum AAenum {AAtype,AActype,AAnoarg,AAsmall,AAstring,AAreftype,AAherevalue,AAlvalue,AAmulti,AAstdarg,AAoptsmall,AAopttype};

typedef struct
{
  enum AAenum t;
  int misc;
  int type;
  int mode;
  char *str;
} descargatom;

typedef struct
{
  int type;
  int init;
  int next;
} gpiterator;

typedef struct
{
  const char *cname;        /* C code */
  gpiterator iter;
  int type;                 /*return type*/
  int mode;                 /*return mode*/
  int nargs;                /*nb args*/
  descargatom *args;        /*type of args*/
} gpdescarg;

typedef struct
{
  int nb;          /*nb of description*/
  gpdescarg *a;    /*array of description*/
} gpdesc;

typedef struct
{
  int nb;          /*nb of wrappers*/
  int *w;         /*array of wrappers*/
} gpwrap;

typedef struct
{
  const char *cname;         /* C name */
  const char *code;          /* GP code */
  const char *origin;        /* library name of the symbol, NULL for gp/libpari*/
  int help;
} gpproto;

enum UFenum {UFclosure, UFstatic};
typedef struct
{
  enum UFenum flag;
  int pdefnode;
  int defnode;
  int bl;
  int sarg;
  int narg;
  int bctx;
  int wrapper;
  affnode *var;        /*Data about variable*/
  stack v;
  int savb;
  int *gcvar;      /*List of var that need to be gerepiled*/
  stack g;
} userfunc;

/*Positive enum are private to funcspec.c/patchfunc.h*/
enum {GPinstalled=-2,GPpari=-1,GPuser=0};
typedef int GPspec;

typedef struct
{
  const char *gpname;    /*name for GP*/
  int node;              /*Ffunction node*/
  GPspec spec;     /*Spec name for spec function*/
  gpproto proto;
  gpdesc *iter;    /*Iterator or NULL*/
  gpwrap *wrap;    /*Wrapper or NULL*/
  gpdesc *dsc;     /*Description or NULL*/
  userfunc *user;
} gpfunc;

#define functype(x) (tree[(x).node].t)
#define funcmode(x) (tree[(x).node].m)

int FC_badtype, FC_formatcode, FC_tovec, FC_tovecprec, FC_cast;
int FC_decl_base,FC_decl_ext;
int FC_gerepileupto, FC_gerepileall;
int FC_const_smallreal, FC_const_real, FC_const_expr;
int FC_proto_ret, FC_proto_code;
int FC_default_check, FC_default_marker;
int FC_copy, FC_avma, FC_low_stack_lim;
int FC_forprime_next, FC_forprime_init, FC_matrixrow;
int FC_proto_max_args;
int FC_call, FC_strtoclosure;

int Vgen;
int Gpari_sp, Gforprime, Gerror;

int max_args;

typedef enum {CSTsmall, CSTsmallreal, CSTint, CSTreal, CSTstr} CSTtype;

typedef struct
{
  CSTtype type;     /*type of data*/
  union value_u
  {
    long small;
    const char *str;
  } val;
} value_t;

typedef struct
{
  const char *name;
} Ctype_t;

typedef struct
{
  const char *name;
} GPtype_t;

typedef struct
{
  const char *name;
} Mmode_t;

typedef struct
{
  enum {Lbreak, Lnobrk, Liferr} type;
  int num;
  int go;
  int ne;
  int ie;
} Clabel_t;

node *tree;
value_t *value;
gpfunc *lfunc;
ctxvar *ctxstack;
affnode *affstack;
context *block;
comment *com;
error_string *errors;
Ctype_t *Ctype;
GPtype_t *GPtype;
Mmode_t *Mmode;
Clabel_t *label;

stack s_node,s_value,s_func,s_ctx,s_aff,s_bloc,s_comment,s_errors;
stack s_Ctype, s_GPtype, s_Mmode, s_label;

typedef enum { err_func=-1,err_parse=-2,err_desc=-3 } err_name;

char *xstrndup(const char *s, size_t n);

#ifdef __GNUC__
/*Avoid spurious warning*/
void die(int n, const char *format, ...) __attribute__ ((noreturn));
#else
void die(int n, const char *format, ...);
#endif
void warning(int n, const char *format, ...);

int listtostack(int n, Ffunc f, int *stack, int nbmax, const char *error,int nerr);
int listcalltostack(int n, int fnum, int *stack, int nbmax, const char *error,int nerr);
int listtostackparent(int n, Ffunc f, int *stack, int nbmax, const char *error,int nerr);
int genlistargs(int n,int *stack,int min,int max);
int genlistcats(int y,int *stack,int max);
void killlistarg(int n, int a);

int newcomment(void);
void pushcomment(int n, char x);
void gencomment(FILE *fout, int n, int flag);

typedef enum {PPend,PPstd,PPdefault,PPdefaultmulti,PPstar,PPauto} PPproto;

PPproto parseproto(char const **q, char *c);

int addcurrexpr(int n, int currexpr);
int newnode(Ffunc f, int x, int y);
int newnodecom(Ffunc f, int x, int y, int com);
int newsmall(int n);
int newrealnode(const char *s, int c);
int newintnode(const char *s, int c);
int newstringnode(const char *s, int c);
int newquotenode(const char *s, int c);
int newsmallrealvalue(long small);
int newentry(const char *s);
int newmember(const char *s);
int newleaf(int n);
int newopcall(OPerator s, int x, int y);
int newopcall3(OPerator s, int x, int y, int z);
int newtag(int x, const char *s, int c);
int newcoeff(int n, int x, int y);
int newlabel(int n);

const char *usercname(const char *s);

int is_const(int n, CSTtype t);

const char *entryname(int n);
int newuserfunc(const char *gpname);
int newblock(void);
int stacktoargs(int *stack, int nb);
int newseq(int x, int y);
int newdecl(int flag, int t, int initval, int *v);
int newcall(const char *s, int y);
int findfunction(const char *name);
int findfunction_len(const char *s, size_t n);
int findfuncdesc(const char *s);
int findfuncdescopt(const char *s);
int findfunctype(const char *s);
int findfunctypeopt(const char *s);
void genequal(int aff, const char *func, int *var, int *binf, int *t);
int addseqright(int seq, int n);
int addseqleft(int n, int seq);
int addlistleft(int n, int l);
int getfunc(const char *gpname);

const char *funcname(int f);
const char *GPname(int f);
void printnode(FILE *fout, int n);
void maketree(FILE *fout,int n);
int gentype(int n);
int genblockdeclaration(int args, int n, int flag, int type, int *seq);

void genheader(FILE *fout);
void gencode(FILE *fout, int n);
void genblock(int n, int p);
void gentopfunc(int n, int p, int fun, int pfun);
void gentoplevel(int n, int p);
int addinitfunc(int n);
void gendeblock(int n, int p, int ps, int *r, int *rs);
void moveblock(int n, int p, int ps, int *r, int *rs);
void pilelist(int n);
void pileclean(int n);
void varlist(int n);

void gensemicolon(FILE *fout,int x);
void genparens(FILE *fout, int x);
void genparensg(FILE *fout, int x);
void genendbrace(FILE * fout, int x);
void genbrace(FILE *fout, int x);
void genindent(FILE *fout);
void genindentline(FILE *fout, char *s);
void genindentseq(FILE *fout, int x);
void genpercent(FILE *fout, int n);

void gencast(FILE *fout, int n, int nt);
void gencastf(FILE *fout, int n, int nt, int f);

void gentypedec(FILE *fout, int t);
void genvarproto(FILE *fout, int n, int nerr);

void genentry(FILE *fout, int n);
void genentryfunc(FILE *fout, int n);
void genprotocode(FILE *fout,int nf);
void genprototype(FILE *fout,int nf, int kb);
void gendeffunc(FILE *fout, int n);
void gendefblock(FILE *fout, int n);

void genblockfuncspec(int n, int p, gpfunc *gp);
void genblockfunciter(int n, int p, gpfunc *gp);
int  gentypefuncspec(int n, gpfunc *gp);
void genentryspec(FILE *fout, int n, gpfunc *gp);
void gencodenoarg(FILE *fout, int t, int n);
void checkisvar(int aff, const char *func, int *var, int *t);

gpdescarg *descfindrulesdsc(int nb, int *arg, gpdesc *dsc);
gpdescarg *descfindrules(int nb, int *arg, gpfunc *gp);
gpdescarg *descfindrules1(int arg, int nf);
void gencodedesc(FILE *fout, int nb, int *arg, gpdescarg *rule, int nerr, int nf);
int genfuncbydesc(FILE *fout, int nb, int *arg, int nf, int nerr);
int genfuncbydesc1(FILE *fout, int arg, int nf, int nerr);
int genfuncbycode(FILE *fout, int nb, int *arg, int nf, int nerr);
int genfuncbycode1(FILE *fout, int arg, int nf, int nerr);
int genfunc(FILE *fout, int nb, int *arg, int nf, int nerr);
int genfunc1(FILE *fout, int arg, int nf, int nerr);

enum {MAT_range,MAT_std,MAT_line,MAT_column,VEC_std};
int matindex_type(long n);

int detag(int n);
int getlvalue(int n);
int getlvaluerr(int n);
int getvar(int n);
int getvarerr(int n);
int getvarbyname(const char *s);
ctxvar *getvarinblock(int n, context *fc);
int fillvar(int n, int flag, int t, int initval);
int pushvar(int n, int ctype, int t, int initval);
void pushctx(context *fc);
void restorectx(int c);
void copyctx(int n, context *fc);
int newctx(int flag);
int newaff(enum AFenum, int idx);
void copyaff(int sava, int savc, context *fc);

int isfunc(int n, const char *s);
int isasmall(const char *s, long *res);
int newctype(const char *s);
int strtoctype(const char *s);
int newtype(const char *s);
int strtotype(const char *s);
int strtotype_len(const char *s, size_t n);
int newmode(const char *s);
int strtomode(char *s);
int geninsertvar(int seq, int ret);
int geninsertvarop(int seq, int ret, OPerator op);
int newgetg(int v, int l, const char *t);
void makeblock(int bl, int n, int aseq, int ret, int savx);
void makeblocks(int bl1, int bl2, int n, int bseq, int aseq, int ret, int savx);
void makeblocks3(int bl1, int bl2, int bl3, int n, int bseq, int aseq, int ret, int sav0, int savx);
int gengerepilelist(context *fc,int **gc);
void gengerepileend(int bl);
