/*
 * support.h
 * This file is part of gtk-nodoka-engine
 *
 * Copyright (C) 2007, 2008 - Martin Sourada, Daniel Geiger
 *
 * gtk-nodoka-engine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gtk-nodoka-engine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gtk-nodoka-engine; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */ 

#ifndef SUPPORT_H
#define SUPPORT_H

#include <gtk/gtk.h>
#include <math.h>
#include <string.h>

#include "nodoka_types.h"

/* GTK 2.2 compatibility */
#ifndef GTK_IS_COMBO_BOX_ENTRY
#define GTK_IS_COMBO_BOX_ENTRY(x) 0
#endif
#ifndef GTK_IS_COMBO_BOX
#define GTK_IS_COMBO_BOX(x) 0
#endif

#define RADIO_SIZE 13
#define CHECK_SIZE 13

#define NDK_IS_ETREE(object) ((object) && ndk_object_is_a ((GObject*)(object), "ETree"))
#define NDK_IS_ETABLE(object) ((object) && ndk_object_is_a ((GObject*)(object), "ETable"))


G_GNUC_INTERNAL GtkTextDirection nodoka_get_direction (GtkWidget * widget);

G_GNUC_INTERNAL gboolean nodoka_sanitize_size (GdkWindow * window, gint * width,
											   gint * height);

G_GNUC_INTERNAL GtkWidget *nodoka_special_get_ancestor (GtkWidget * widget,
														GType widget_type);

G_GNUC_INTERNAL void nodoka_shade (const NodokaRGB * a, NodokaRGB * b, float k);

G_GNUC_INTERNAL GtkWidget *nodoka_get_parent_window (GtkWidget * widget);

G_GNUC_INTERNAL GdkColor *nodoka_get_parent_bgcolor (GtkWidget * widget);

G_GNUC_INTERNAL gboolean ndk_is_combo_box (GtkWidget * widget);

G_GNUC_INTERNAL GtkWidget *ndk_find_combo_box_widget (GtkWidget * widget);

G_GNUC_INTERNAL void nodoka_gdk_color_to_rgb (GdkColor * c, double *r,
											  double *g, double *b);

G_GNUC_INTERNAL void nodoka_gtk_treeview_get_header_index (GtkTreeView * tv,
														   GtkWidget * header,
														   gint * column_index,
														   gint * columns,
														   gboolean *
														   resizable);

G_GNUC_INTERNAL void nodoka_gtk_clist_get_header_index (GtkCList * clist,
														GtkWidget * button,
														gint * column_index,
														gint * columns);

G_GNUC_INTERNAL void nodoka_get_parent_bg (const GtkWidget * widget,
										   NodokaRGB * color);

G_GNUC_INTERNAL void nodoka_option_menu_get_props (GtkWidget * widget,
												   GtkRequisition *
												   indicator_size,
												   GtkBorder *
												   indicator_spacing);

G_GNUC_INTERNAL NodokaStepper nodoka_scrollbar_get_stepper (GtkWidget * widget,
															GdkRectangle *
															stepper);

G_GNUC_INTERNAL NodokaStepper nodoka_scrollbar_visible_steppers (GtkWidget *
																 widget);

G_GNUC_INTERNAL NodokaJunction nodoka_scrollbar_get_junction (GtkWidget *
															  widget);

G_GNUC_INTERNAL gboolean ndk_is_panel_widget (GtkWidget * widget);

G_GNUC_INTERNAL gboolean ndk_object_is_a (const GObject * object, const gchar * type_name);


#endif /* SUPPORT_H */
