// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKDATABOXMM_GRID_H
#define _GTKDATABOXMM_GRID_H

#include <gtkdataboxmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (c) 2012  iCub Facility, Istituto Italiano di Tecnologia
 *   @author Daniele E. Domenichelli <daniele.domenichelli@iit.it>
 *
 * This file is part of gtkdataboxmm.
 *
 * gtkdataboxmm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2.1 of the License,
 * or (at your option) any later version.
 *
 * gtkdataboxmm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <gtkdataboxmm/graph.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkDataboxGrid GtkDataboxGrid;
typedef struct _GtkDataboxGridClass GtkDataboxGridClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace GDatabox
{ class Grid_Class; } // namespace GDatabox
namespace Gdk { class Color; }

namespace GDatabox
{


class Grid : public Graph
{
    
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Grid CppObjectType;
  typedef Grid_Class CppClassType;
  typedef GtkDataboxGrid BaseObjectType;
  typedef GtkDataboxGridClass BaseClassType;

private:  friend class Grid_Class;
  static CppClassType grid_class_;

private:
  // noncopyable
  Grid(const Grid&);
  Grid& operator=(const Grid&);

protected:
  explicit Grid(const Glib::ConstructParams& construct_params);
  explicit Grid(GtkDataboxGrid* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Grid();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkDataboxGrid*       gobj()       { return reinterpret_cast<GtkDataboxGrid*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkDataboxGrid* gobj() const { return reinterpret_cast<GtkDataboxGrid*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkDataboxGrid* gobj_copy();

private:


protected:
    Grid(int hlines, int vlines, const Gdk::Color &color, unsigned int size = 1);
    Grid(int hlines, int vlines, float *hline_vals, float *vline_vals, const Gdk::Color &color, unsigned int size = 1);
    

public:
    static Glib::RefPtr<Grid> create(int hlines, int vlines, const Gdk::Color &color, unsigned int size = 1);
    static Glib::RefPtr<Grid> create(int hlines, int vlines, float *hline_vals, float *vline_vals, const Gdk::Color &color, unsigned int size = 1);

    
  /** Sets the number of horizontal lines in the @a grid.
   * @param hlines Number of vertical lines in the grid.
   */
  void set_hlines(int hlines);
    
  /** Gets the number of horizontal lines in the @a grid.
   * @return Number of horizontal lines in the @a grid.
   */
  int get_hlines() const;

    
  /** Sets the number of vertical lines in the @a grid.
   * @param vlines Number of vertical lines in the grid.
   */
  void set_vlines(int hlines);
    
  /** Gets the number of vertical lines in the @a grid.
   * @return Number of vertical lines in the @a grid.
   */
  int get_vlines() const;

    #ifdef GLIBMM_PROPERTIES_ENABLED
/** Number of vertical lines.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< int > property_grid_vlines() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Number of vertical lines.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_grid_vlines() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

    #ifdef GLIBMM_PROPERTIES_ENABLED
/** Number of horizontal lines.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< int > property_grid_hlines() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Number of horizontal lines.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_grid_hlines() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace GDatabox


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates GDatabox::Grid
   */
  Glib::RefPtr<GDatabox::Grid> wrap(GtkDataboxGrid* object, bool take_copy = false);
}


#endif /* _GTKDATABOXMM_GRID_H */

