/***************************************************************************
 *   Copyright (C) 2003-2007 by Spiros Georgaras <sng@hellug.gr>           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qstring.h>
#include <kmessagebox.h>
#include <KConfigGroup>
#include "iconload.h"

//================================
iconload::iconload(){
	items=0;
	pix=0;
}
//================================
iconload::~iconload(){
	delete[] pix;
}
//================================
int iconload::loadIcon(QStringList picNames,int id){
// qWarning("iconload::loadIcon -->");
QString pic,name;
KStandardDirs kdir;
if (id>items-1) if(resize(id+1)==-1) return -1;
// for ( QStringList::Iterator it = picNames.begin(); it != picNames.end(); ++it ) {
// 		name=*it;
for(int i=0;i<picNames.size();i++){
		name=picNames.at(i);
//  		qWarning("name = %s",picNames.value(i).toLocal8Bit().constData());
		if(theme.isEmpty()) readThemeName();
//   		qWarning("  theme = %s",theme.toLocal8Bit().constData());
//  		pic=kdir.locateLocal("icon",theme+"/"+name);
// 		qWarning("  pic = %s",pic.toLocal8Bit().constData());
		pix[id]=QPixmap(pic);
		if(pix[id].isNull()){
//  			qWarning("  pic is null!! (1)");
//  			qWarning("  trying new theme");
 			pic=kdir.locate("icon",theme+"/"+name);
//   			qWarning("  pic = %s",pic.toLocal8Bit().constData());
			pix[id]=QPixmap(pic);
		}else return 1;
		
// 		if(pix[id].isNull()){
//  			qWarning("  pic is null!!");
//  			qWarning("  trying hicolor theme");
//  			pic=kdir.locateLocal("icon","hicolor/"+name);
//   			qWarning("  pic = %s",pic.toLocal8Bit().constData());
// 			pix[id]=QPixmap(pic);
// 		}else return 1;
// 		if(pix[id].isNull()){
//  			qWarning("  pic is null!! (2)");
//  			qWarning("  trying hicolor theme");
//  			pic=kdir.locate("icon","hicolor/"+name);
//   			qWarning("  pic = %s",pic.toLocal8Bit().constData());
// 			pix[id]=QPixmap(pic);
// 		}else return 1;
		
// // // }
// // // for(int i=0;i<picNames.size();i++){
		if(pix[id].isNull()){
// 			qWarning("  pic is null!!");
// 			qWarning("  trying data");
// 			KStandardDirs a; old impl
// 			pic=a.findResource("data",name); old impl
			pic=kdir.findResource("data",name);
// 			qWarning("  pic = %s",pic.toLocal8Bit().constData());
			pix[id]=QPixmap(pic);
			if(pix[id].isNull()){
// 				qWarning("  pic is still empty...");
// 				qWarning("  trying system search");
// 				QStringList folderList=a.findDirs("icon", ""); old impl
				QStringList folderList=kdir.findDirs("icon", "");
				for ( QStringList::Iterator it = folderList.begin(); it != folderList.end() ; ++it ) {
								QString folder=*it;
					readFolder(folder,name,id);
					if(!pix[id].isNull()) break;//return 1;
				}
			}else return 1;
		}else return 1;
}
if(pix[id].isNull()){
// 	qWarning("returning -1 for name = %s ",name.toLocal8Bit().constData());
	return -1;
}
// qWarning("returning 1");
return 1;
}
//================================
void iconload::readFolder(QString folder, QString name, int id){
	QDir d;
	d.cd(folder);
	d.setFilter( QDir::Dirs | QDir::NoSymLinks );
	d.setSorting( QDir::Name );
//	d.setNameFilter("*"); old impl
	d.setNameFilters(QStringList("*"));
// 	const QFileInfoList *list = d.entryInfoList(); old impl
	const QFileInfoList list = d.entryInfoList();
	QFileInfo fi;
	
	for (int i = 0; i < list.size(); ++i) {
		fi=list.at(i);
		if(fi.fileName()!="." && fi.fileName()!=".."){
			QString file=folder; file.append(fi.fileName());
			file.append("/"); file.append(name);
			//qWarning("  file = %s",file.toLocal8Bit().constData());
			QFile iconFile(file);
			if(iconFile.exists()){
				pix[id]=QPixmap(file);
				return;
			}
		}
	}
	
//	QFileInfoListIterator it( *list );
// 	QFileInfo *fi;
// 	while ( (fi = it.current()) != 0 ) {
// 		if(fi->fileName()!="." && fi->fileName()!=".."){
// 			QString file=folder; file.append(fi->fileName());
// 			file.append("/"); file.append(name);
// 			//qWarning("  file = %s",file.toLocal8Bit().constData());
// 			QFile iconFile(file);
// 			if(iconFile.exists()){
// 				pix[id]=QPixmap(file);
// 				return;
// 			}
// 		}
// 		++it;
// 	}
}
//================================
QPixmap iconload::Icon(int index){
	return pix[index];
}
//================================
//	Returns -1 if memory alocation failed
//================================
int iconload::resize(int newItemNum){
	QPixmap* p;
	p=new QPixmap[newItemNum+1];
	if(p==NULL) return -1;
	for(int i=0;i<items;i++) p[i]=pix[i];
	delete [] pix;
	pix=p;
	items=newItemNum+1;
	return items;
}
//================================
QString iconload::defIconTheme(){
	if(theme.isEmpty()) readThemeName();
	return theme;
}
//================================
void iconload::readThemeName(){
	KConfig config("kdeglobals");
// 	config.setGroup("Icons"); old impl
	KConfigGroup group=config.group("Icons");
	theme=group.readEntry("Theme","");
}
