<?hh
// generated by idl-to-hni.php

/* Sends an ALLO command to the remote FTP server to allocate space for a file
 * to be uploaded.  Many FTP servers do not support this command. These
 * servers may return a failure code (FALSE) indicating the command is not
 * supported or a success code (TRUE) to indicate that pre-allocation is not
 * necessary and the client should continue as though the operation were
 * successful. Because of this, it may be best to reserve this function for
 * servers which explicitly require preallocation.
 */
<<__Native("ZendCompat")>>
function ftp_alloc(mixed $ftp_stream,
                   mixed $filesize,
                   mixed &$result): mixed;

/* Changes to the parent directory.
 */
<<__Native("ZendCompat")>>
function ftp_cdup(mixed $ftp_stream): mixed;

/* Changes the current directory to the specified one.
 */
<<__Native("ZendCompat")>>
function ftp_chdir(mixed $ftp_stream,
                   mixed $directory): mixed;

/* Sets the permissions on the specified remote file to mode.
 */
<<__Native("ZendCompat")>>
function ftp_chmod(mixed $ftp_stream,
                   mixed $mode,
                   mixed $filename): mixed;

/* ftp_close() closes the given link identifier and releases the resource.
 * After calling this function, you can no longer use the FTP connection and
 * must create a new one with ftp_connect().
 */
<<__Native("ZendCompat")>>
function ftp_close(mixed $ftp_stream): mixed;

/* ftp_connect() opens an FTP connection to the specified host.
 */
<<__Native("ZendCompat")>>
function ftp_connect(mixed $host,
                     mixed $port,
                     mixed $timeout): mixed;

/* ftp_delete() deletes the file specified by path from the FTP server.
 */
<<__Native("ZendCompat")>>
function ftp_delete(mixed $ftp_stream,
                    mixed $path): mixed;

/* Sends a SITE EXEC command request to the FTP server.
 */
<<__Native("ZendCompat")>>
function ftp_exec(mixed $ftp_stream,
                  mixed $command): mixed;

/* ftp_fget() retrieves remote_file from the FTP server, and writes it to the
 * given file pointer.
 */
<<__Native("ZendCompat")>>
function ftp_fget(mixed $ftp_stream,
                  mixed $handle,
                  mixed $remote_file,
                  mixed $mode,
                  mixed $resumepos): mixed;

/* ftp_fput() uploads the data from a file pointer to a remote file on the FTP
 * server.
 */
<<__Native("ZendCompat")>>
function ftp_fput(mixed $ftp_stream,
                  mixed $remote_file,
                  mixed $handle,
                  mixed $mode,
                  mixed $startpos): mixed;

/* This function returns the value for the requested option from the specified
 * FTP connection.
 */
<<__Native("ZendCompat")>>
function ftp_get_option(mixed $ftp_stream,
                        mixed $option): mixed;

/* ftp_get() retrieves a remote file from the FTP server, and saves it into a
 * local file.
 */
<<__Native("ZendCompat")>>
function ftp_get(mixed $ftp_stream,
                 mixed $local_file,
                 mixed $remote_file,
                 mixed $mode,
                 mixed $resumepos): mixed;

/* Logs in to the given FTP stream.
 */
<<__Native("ZendCompat")>>
function ftp_login(mixed $ftp_stream,
                   mixed $username,
                   mixed $password): mixed;

/* ftp_mdtm() gets the last modified time for a remote file.  Not all servers
 * support this feature!  ftp_mdtm() does not work with directories.
 */
<<__Native("ZendCompat")>>
function ftp_mdtm(mixed $ftp_stream,
                  mixed $remote_file): mixed;

/* Creates the specified directory on the FTP server.
 */
<<__Native("ZendCompat")>>
function ftp_mkdir(mixed $ftp_stream,
                   mixed $directory): mixed;

/* Continues retrieving/sending a file non-blocking.
 */
<<__Native("ZendCompat")>>
function ftp_nb_continue(mixed $ftp_stream): mixed;

/* ftp_nb_fget() retrieves a remote file from the FTP server.  The difference
 * between this function and ftp_fget() is that this function retrieves the
 * file asynchronously, so your program can perform other operations while the
 * file is being downloaded.
 */
<<__Native("ZendCompat")>>
function ftp_nb_fget(mixed $ftp_stream,
                     mixed $handle,
                     mixed $remote_file,
                     mixed $mode,
                     mixed $resumepos): mixed;

/* ftp_nb_fput() uploads the data from a file pointer to a remote file on the
 * FTP server.  The difference between this function and the ftp_fput() is
 * that this function uploads the file asynchronously, so your program can
 * perform other operations while the file is being uploaded.
 */
<<__Native("ZendCompat")>>
function ftp_nb_fput(mixed $ftp_stream,
                     mixed $remote_file,
                     mixed $handle,
                     mixed $mode,
                     mixed $startpos): mixed;

/* ftp_nb_get() retrieves a remote file from the FTP server, and saves it into
 * a local file.  The difference between this function and ftp_get() is that
 * this function retrieves the file asynchronously, so your program can
 * perform other operations while the file is being downloaded.
 */
<<__Native("ZendCompat")>>
function ftp_nb_get(mixed $ftp_stream,
                    mixed $local_file,
                    mixed $remote_file,
                    mixed $mode,
                    mixed $resumepos): mixed;

/* ftp_nb_put() stores a local file on the FTP server.  The difference between
 * this function and the ftp_put() is that this function uploads the file
 * asynchronously, so your program can perform other operations while the file
 * is being uploaded.
 */
<<__Native("ZendCompat")>>
function ftp_nb_put(mixed $ftp_stream,
                    mixed $remote_file,
                    mixed $local_file,
                    mixed $mode,
                    mixed $startpos): mixed;

<<__Native("ZendCompat")>>
function ftp_nlist(mixed $ftp_stream,
                   mixed $directory): mixed;

/* ftp_pasv() turns on or off passive mode. In passive mode, data connections
 * are initiated by the client, rather than by the server. It may be needed if
 * the client is behind firewall.  Please note that ftp_pasv() can only be
 * called after a successfull login or otherwise it will fail.
 */
<<__Native("ZendCompat")>>
function ftp_pasv(mixed $ftp_stream,
                  mixed $pasv): mixed;

/* ftp_put() stores a local file on the FTP server.
 */
<<__Native("ZendCompat")>>
function ftp_put(mixed $ftp_stream,
                 mixed $remote_file,
                 mixed $local_file,
                 mixed $mode,
                 mixed $startpos): mixed;

<<__Native("ZendCompat")>>
function ftp_pwd(mixed $ftp_stream): mixed;

<<__Native("ZendCompat")>>
function ftp_quit(): mixed;

/* Sends an arbitrary command to the FTP server.
 */
<<__Native("ZendCompat")>>
function ftp_raw(mixed $ftp_stream,
                 mixed $command): mixed;

/* ftp_rawlist() executes the FTP LIST command, and returns the result as an
 * array.
 */
<<__Native("ZendCompat")>>
function ftp_rawlist(mixed $ftp_stream,
                     mixed $directory,
                     mixed $recursive): mixed;

/* ftp_rename() renames a file or a directory on the FTP server.
 */
<<__Native("ZendCompat")>>
function ftp_rename(mixed $ftp_stream,
                    mixed $oldname,
                    mixed $newname): mixed;

/* Removes the specified directory on the FTP server.
 */
<<__Native("ZendCompat")>>
function ftp_rmdir(mixed $ftp_stream,
                   mixed $directory): mixed;

/* This function controls various runtime options for the specified FTP
 * stream.
 */
<<__Native("ZendCompat")>>
function ftp_set_option(mixed $ftp_stream,
                        mixed $option,
                        mixed $value): mixed;

/* ftp_site() sends the given SITE command to the FTP server.  SITE commands
 * are not standardized, and vary from server to server. They are useful for
 * handling such things as file permissions and group membership.
 */
<<__Native("ZendCompat")>>
function ftp_site(mixed $ftp_stream,
                  mixed $command): mixed;

/* ftp_size() returns the size of the given file in bytes.  Not all servers
 * support this feature.
 */
<<__Native("ZendCompat")>>
function ftp_size(mixed $ftp_stream,
                  mixed $remote_file): mixed;

/* ftp_ssl_connect() opens an explicit SSL-FTP connection to the specified
 * host. Why this function may not exist  ftp_ssl_connect() is only available
 * if both the ftp module and the OpenSSL support is built statically into
 * php, this means that on Windows this function will be undefined in the
 * official PHP builds. To make this function available on Windows you must
 * compile your own PHP binaries.  ftp_ssl_connect() is not intended for use
 * with sFTP. To use sFTP with PHP, please see ssh2_sftp().
 */
<<__Native("ZendCompat")>>
function ftp_ssl_connect(mixed $host,
                         mixed $port,
                         mixed $timeout): mixed;

/* Returns the system type identifier of the remote FTP server.
 */
<<__Native("ZendCompat")>>
function ftp_systype(mixed $ftp_stream): mixed;
