/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  A base class for all DataSubjects for Field types.
//
#ifndef IFIELDDATASUBJECT_H
#define IFIELDDATASUBJECT_H


#include "idatasubject.h"


class iFieldFileLoader;


class iFieldDataSubject : public iDataSubject
{

	friend class iFieldFileLoader;

public:

	vtkTypeMacro(iFieldDataSubject,iDataSubject);
	static const iObjectType& Type();
	virtual const iObjectType& GetObjectType() const;

protected:

	iFieldDataSubject(iFieldFileLoader *fl, const iString &name);

	virtual void DataSubjectPackStateBody(iString &s) const;
	virtual void DataSubjectUnPackStateBody(const iString &s);

	virtual void FieldDataSubjectPackStateBody(iString &) const {}
	virtual void FieldDataSubjectUnPackStateBody(const iString &){}

private:

	iFieldFileLoader *mFieldLoader;
};


//
//  Useful macros to declare all members that have to be overwritten in children
//
#define IFIELDDATASUBJECT_DECLARE_INHERITED_MEMBERS \
	IDATASUBJECT_DECLARE_INHERITED_MEMBERS

#define IFIELDDATASUBJECT_DECLARE_INHERITED_KEYS \
	IDATASUBJECT_DECLARE_INHERITED_KEYS

#define IFIELDDATASUBJECT_DEFINE_TYPE(_object_,_id_,_fname_,_sname_,_rank_,_keywords_,_environment_) \
	IDATASUBJECT_DEFINE_TYPE(_object_,_id_,_fname_,_sname_,_rank_,_keywords_,_environment_)

#define IFIELDDATASUBJECT_DEFINE_INHERITED_KEYS(_type_) \
	IDATASUBJECT_DEFINE_INHERITED_KEYS(_type_)

#define IFIELDDATASUBJECT_DECLARE_CLASS(_prefix_,_name_) \
class _prefix_##_name_##DataSubject : public iFieldDataSubject \
{ \
public: \
	vtkTypeMacro(_prefix_##_name_##DataSubject,iFieldDataSubject); \
	_prefix_##_name_##DataSubject(iFieldFileLoader *fl); \
	IFIELDDATASUBJECT_DECLARE_INHERITED_KEYS; \
	IFIELDDATASUBJECT_DECLARE_INHERITED_MEMBERS; \
}

#define IFIELDDATASUBJECT_DEFINE_CLASS(_prefix_,_name_,_fname_,_sname_,_rank_,_keywords_,_environment_) \
IFIELDDATASUBJECT_DEFINE_TYPE(_prefix_##_name_##DataSubject,_prefix_##Extension::SubjectId(),_fname_,_sname_,_rank_,_keywords_,_environment_); \
IFIELDDATASUBJECT_DEFINE_INHERITED_KEYS(_prefix_##_name_##DataSubject); \
_prefix_##_name_##DataSubject::_prefix_##_name_##DataSubject(iFieldFileLoader *fl) : iFieldDataSubject(fl,_prefix_##_name_##DataSubject::Type().FullName()){}

#endif

