/*
 * RTPDestPanel.java
 *
 * Created on June 14, 2007, 10:24 AM
 */

package net.sf.fmj.ui.wizards;

import java.util.*;

/**
 *
 * @author Ken Larson
 */
public class RTPDestPanel extends javax.swing.JPanel
{
    private List<javax.swing.JLabel> trackNames = new ArrayList<javax.swing.JLabel>();

    private List<javax.swing.JTextField> textSessionAddresses = new ArrayList<javax.swing.JTextField>();

    private List<javax.swing.JTextField> textPorts = new ArrayList<javax.swing.JTextField>();
    private List<javax.swing.JComboBox> comboTTLs = new ArrayList<javax.swing.JComboBox>();
    private List<Integer> trackNumbers = new ArrayList<Integer>();
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel labelMessage;
    private javax.swing.JLabel labelPort;

    private javax.swing.JLabel labelSessionAddress;

    private javax.swing.JLabel labelTTL;

    private javax.swing.JLabel labelTrack;

    // End of variables declaration//GEN-END:variables

    /** Creates new form RTPDestPanel */
    public RTPDestPanel()
    {
        initComponents();
    }

    public void addTrack(int trackNum, boolean audio)
    {
        java.awt.GridBagConstraints gridBagConstraints;

        javax.swing.JLabel trackName = new javax.swing.JLabel();
        javax.swing.JTextField textSessionAddress = new javax.swing.JTextField();
        javax.swing.JTextField textPort = new javax.swing.JTextField();
        javax.swing.JComboBox comboTTL = new javax.swing.JComboBox();

        trackName.setText((audio ? "Audio " : "Video ") + trackNum);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(trackName, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(textSessionAddress, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(textPort, gridBagConstraints);

        comboTTL.setModel(new javax.swing.DefaultComboBoxModel(new String[] {
                "1", "2", "3", "4", "8", "16", "32", "64", "128", "255" }));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(comboTTL, gridBagConstraints);

        trackNames.add(trackName);
        textSessionAddresses.add(textSessionAddress);
        textPorts.add(textPort);
        comboTTLs.add(comboTTL);
        trackNumbers.add(new Integer(trackNum));

    }

    public javax.swing.JComboBox getComboTTL(int index)
    {
        for (int i = 0; i < trackNumbers.size(); ++i)
        {
            Integer trackNum = trackNumbers.get(i);
            if (trackNum.intValue() == index)
            {
                return comboTTLs.get(i);
            }
        }
        throw new IllegalArgumentException();
    }

    public javax.swing.JLabel getLabelPort()
    {
        return labelPort;
    }

    public javax.swing.JLabel getLabelSessionAddress()
    {
        return labelSessionAddress;
    }

    public javax.swing.JLabel getLabelTTL()
    {
        return labelTTL;
    }

    public javax.swing.JTextField getTextPort(int index)
    {
        for (int i = 0; i < trackNumbers.size(); ++i)
        {
            Integer trackNum = trackNumbers.get(i);
            if (trackNum.intValue() == index)
            {
                return textPorts.get(i);
            }
        }
        throw new IllegalArgumentException();
    }

    public javax.swing.JTextField getTextSessionAddress(int index)
    {
        for (int i = 0; i < trackNumbers.size(); ++i)
        {
            Integer trackNum = trackNumbers.get(i);
            if (trackNum.intValue() == index)
            {
                return textSessionAddresses.get(i);
            }
        }
        throw new IllegalArgumentException();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed"
    // desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents()
    {
        java.awt.GridBagConstraints gridBagConstraints;

        labelMessage = new javax.swing.JLabel();
        labelTrack = new javax.swing.JLabel();
        labelSessionAddress = new javax.swing.JLabel();
        labelPort = new javax.swing.JLabel();
        labelTTL = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        labelMessage
                .setText("Enter the session address and port number for each track:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(labelMessage, gridBagConstraints);

        labelTrack.setText("Track:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(labelTrack, gridBagConstraints);

        labelSessionAddress.setText("Session address:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(labelSessionAddress, gridBagConstraints);

        labelPort.setText("Port:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(labelPort, gridBagConstraints);

        labelTTL.setText("TTL:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(labelTTL, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

}
