//---------------------------------------------------------------------------
//
// "" for ʳβʳβ
// 
//
//      Programed by NAKAUE.T (Meister)
//
//  2001.04.21  Phase 0.50a1   Υ饹
//  2001.05.03  Phase 0.50a4  饤󥹥ץ
//  2001.05.26  Phase 5.1     󥿡ץ꥿ѥ鲽
//                            API
//  2001.06.17  Phase 6.0     ʣȥؤƱɲäΥХ
//  2002.03.10  Phase 7.9.0   񥢥󥿡ե
//  2002.05.09  Phase 8.0.0   ֵ̾ǽComposite PatternʬΥ
//                            KIS++ؤС
//
//---------------------------------------------------------------------------
#ifndef KAWARI_DICT_H
#define KAWARI_DICT_H
//---------------------------------------------------------------------------
#include "config.h"
//---------------------------------------------------------------------------
#include <string>
#include <vector>
#include <map>
#include <set>
using namespace std;
//---------------------------------------------------------------------------
#include "libkawari/kawari_ns.h"
#include "libkawari/kawari_code.h"
#include "libkawari/wordcollection.h"
//---------------------------------------------------------------------------
// 
class TNS_KawariDictionary: public TGarbageCollector {
private:
	// ִ̾ط

	// Х̾
	TNameSpace *GlobalNameSpace;

	// ƥ
	class TContext : public TNameSpace {
	public:
		// 򻲾ȥå
		std::vector<std::string> history;
		// 롼פҿ
		unsigned int loopcount;

		TContext(TGarbageCollector *col): TNameSpace(col), loopcount(0) {}
		virtual ~TContext() {}
	};

	// NameSpace
	TNameSpace *SearchNameSpace(const string &entry) {
		if (IsLocalEntry(entry)) return GetCurrentContext();
		else return GlobalNameSpace;
	}


	// ñط

	// ٤Ƥñݻ
	TWordPointerCollection<TKVMCode_base,TKVMCode_baseP_Less> WordCollection;

	// ñ
	set<TWordID> Garbage;

	// PVWݻ
	set<TWordID> PVWSet;


	// ƥȴط

	// ƥȥå
	std::vector<TContext *> ContextStack;

	// ߤΥƥȤ
	// ̵NULL֤
	TContext *GetCurrentContext(void) const;

	// 륨ȥ̾Ƚ
	bool IsLocalEntry(const std::string &entry_name) const;


	// 
	class TKawariLogger &logger;
public:
	TNS_KawariDictionary (TKawariLogger &lgr) : logger(lgr) {
		GlobalNameSpace = new TNameSpace(this);
		GlobalNameSpace->Reserve(2000);
		WordCollection.Reserve(10000);
	}
	virtual ~TNS_KawariDictionary (){
		delete GlobalNameSpace;
		GlobalNameSpace = NULL;
	}

	// ϰϳΥǥå
	static const unsigned int NPos;		// UINT_MAX


	// API

	// ñ
	//  : ñθĿ (줿ñϿʤ)
	unsigned int WordCollectionSize(void) const;

	// ͭȥ
	//  : ȥθĿ
	unsigned int Size(void) const;

	// ꤵ줿ȥñ
	//  : ñθĿ
//	unsigned int EntrySize(TEntryID entry) const;


	// ȥϢAPI

	// ȥ
	//  : ȥ
	TEntry GetEntry(const string &entry);

	// ȥ
	// ˥ȥ꤬¸ߤϡID֤
	//  : ȥID
	TEntry CreateEntry(const string& entry);

	// ȥID
	//  : ȥθĿ
	unsigned int FindAllEntry(vector<TEntry> &entrycol) const;

	// ꤵ줿ȥƤ˴ޤޤñ
	// 貾ñ${ȥ̾}פΤŸƺƵŪ󤹤
	//  : ñθĿ
	unsigned int GetWordCollection(TEntry entry,set<TWordID> &wordcol);


	// ñϢAPI

	// ñ
	// ñ줬¸ߤϡID֤
	// աñIDñǤä硢delete
	//  : ñID
	TWordID CreateWord(TKVMCode_base* word);

	// ñID
	//  : 1ꥸ󡢸Ĥʤ0֤
	TWordID GetWordID(TKVMCode_base* word) const;

	// IDñѴ
	//  : ֥ɥĥ꡼
	TKVMCode_base *GetWordFromID(TWordID id) const;

	// ñ˺ޡդ
	void MarkWordForGC(TWordID id);


	// ƥȴϢAPI

	// ߤΥƥȤ򻲾ȥåΥݥ󥿤
	unsigned int LinkFrame(void);

	// ߤΥƥȤ򻲾ȥåΥݥ󥿤
	void UnlinkFrame(unsigned int pos);

	// 롼פ
	void StartLoop(void);

	// 롼פФ
	void EndLoop(void);

	// ߤΥ롼׳ؤ
	unsigned int CurrentLoop(void);

	// ƥȤåpush
	void CreateContext(void);

	// ƥȤpop
	// 줬ǸΥƥȤǤ硢٥å쥯
	void DeleteContext(void);

	// ƥȥåθߤο
	unsigned int GetContextStackDepth(void);

	// 򻲾ȥåִʸpush롣
	void PushToHistory (const string &str);

	// 򻲾
	string GetHistory (int index);

	// ֤
	TKawariLogger &GetLogger(void) {
		return logger;
	}

};
//--------------------------------------------------------------------------
// 륨ȥ̾Ƚ
inline bool TNS_KawariDictionary::IsLocalEntry(const std::string &entry_name) const{
	return (entry_name.size()&&(entry_name[0]=='@'));
}
//---------------------------------------------------------------------------
// ȥID
inline TEntry TNS_KawariDictionary::GetEntry(const string& entry)
{
	TNameSpace *ns=SearchNameSpace(entry);
	return (ns) ? ns->Get(entry):TEntry(GlobalNameSpace, 0);
}
//---------------------------------------------------------------------------
// ñ
inline unsigned int TNS_KawariDictionary::WordCollectionSize(void) const
{
	return(WordCollection.Size());
}
//---------------------------------------------------------------------------
// ͭȥ
inline unsigned int TNS_KawariDictionary::Size(void) const
{
	return(GlobalNameSpace->Size());
}
//---------------------------------------------------------------------------
// ñID
inline TWordID TNS_KawariDictionary::GetWordID(TKVMCode_base* word) const
{
	return(WordCollection.Find(word));
}
//---------------------------------------------------------------------------
// IDñѴ
//  : ֥ɥĥ꡼
inline TKVMCode_base *TNS_KawariDictionary::GetWordFromID(TWordID id) const
{
	TKVMCode_base *const*word=WordCollection.Find(id);
	return(word?(*word):NULL);
}
//---------------------------------------------------------------------------
// ñ˺ޡդ
inline void TNS_KawariDictionary::MarkWordForGC(TWordID id)
{
	Garbage.insert(id);
}
//---------------------------------------------------------------------------
// ȥ̾
//  : ȥθĿ
inline unsigned int TNS_KawariDictionary::FindAllEntry(vector<TEntry> &entrycol) const
{
	return GlobalNameSpace->FindAllEntry(entrycol);
}
//--------------------------------------------------------------------------
// ߤΥƥȤ
inline TNS_KawariDictionary::TContext *TNS_KawariDictionary::GetCurrentContext(void) const{
	if (ContextStack.size())
		return ContextStack.back();
	else
		return NULL;
}
//--------------------------------------------------------------------------
// ƥȥåθߤο
inline unsigned int TNS_KawariDictionary::GetContextStackDepth(void){
	return ContextStack.size();
}
//--------------------------------------------------------------------------
// 롼פ
inline void TNS_KawariDictionary::StartLoop(void){
	TContext *ctx=GetCurrentContext();
	if (!ctx) return;
	ctx->loopcount++;
}
//--------------------------------------------------------------------------
// 롼פФ
inline void TNS_KawariDictionary::EndLoop(void){
	TContext *ctx=GetCurrentContext();
	if (!ctx) return;
	if (ctx->loopcount) ctx->loopcount--;
}
//--------------------------------------------------------------------------
// ߤΥ롼׳ؤ
inline unsigned int TNS_KawariDictionary::CurrentLoop(void){
	TContext *ctx=GetCurrentContext();
	if (!ctx) return 0;
	return ctx->loopcount;
}
//--------------------------------------------------------------------------
#endif
