/***************************************************************************
 *   Copyright (C) 2007-2012 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KGmailNotifier.                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#include "atomparser.h"

// ------------------------------------------------------------------------------------------------------------------- //
//    Construction & Destruction                                                                                       //
// ------------------------------------------------------------------------------------------------------------------- //

AtomParser::AtomParser()
{
    m_xmlReader = new QXmlSimpleReader;
    m_contentHandler = new AtomContentHandler;
    m_xmlReader->setContentHandler(m_contentHandler);
}

// ------------------------------------------------------------------------------------------------------------------- //

AtomParser::~AtomParser()
{
    if (m_xmlReader)
        delete m_xmlReader;

    if (m_contentHandler)
        delete m_contentHandler;
}


// ------------------------------------------------------------------------------------------------------------------- //
//    Public methods                                                                                                   //
// ------------------------------------------------------------------------------------------------------------------- //

bool AtomParser::parseFile(const QString &atomFile)
{
    if (!QFile::exists(atomFile))
        return false;

    QFile file(atomFile);

    QXmlInputSource source(&file);

    m_xmlReader->parse(source);

    return true;
}

// ------------------------------------------------------------------------------------------------------------------- //

unsigned int AtomParser::messageCount() const
{
    return m_contentHandler->messageCount();
}

// ------------------------------------------------------------------------------------------------------------------- //

const QString& AtomParser::lastSender() const
{
    return m_contentHandler->lastSender();
}

// ------------------------------------------------------------------------------------------------------------------- //

const QString& AtomParser::lastSubject() const
{
    return m_contentHandler->lastSubject();
}

// ------------------------------------------------------------------------------------------------------------------- //
