/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.resolve.constraintSystem;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/constraintSystem")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class ConstraintSystemTestGenerated extends AbstractConstraintSystemTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInConstraintSystem() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
    }

    @TestMetadata("compiler/testData/constraintSystem/checkStatus")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CheckStatus extends AbstractConstraintSystemTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInCheckStatus() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/checkStatus"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
        }

        @TestMetadata("conflictingConstraints.constraints")
        public void testConflictingConstraints() throws Exception {
            runTest("compiler/testData/constraintSystem/checkStatus/conflictingConstraints.constraints");
        }

        @TestMetadata("successful.constraints")
        public void testSuccessful() throws Exception {
            runTest("compiler/testData/constraintSystem/checkStatus/successful.constraints");
        }

        @TestMetadata("typeConstructorMismatch.constraints")
        public void testTypeConstructorMismatch() throws Exception {
            runTest("compiler/testData/constraintSystem/checkStatus/typeConstructorMismatch.constraints");
        }

        @TestMetadata("unknownParameters.constraints")
        public void testUnknownParameters() throws Exception {
            runTest("compiler/testData/constraintSystem/checkStatus/unknownParameters.constraints");
        }
    }

    @TestMetadata("compiler/testData/constraintSystem/computeValues")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ComputeValues extends AbstractConstraintSystemTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInComputeValues() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/computeValues"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
        }

        @TestMetadata("contradiction.constraints")
        public void testContradiction() throws Exception {
            runTest("compiler/testData/constraintSystem/computeValues/contradiction.constraints");
        }

        @TestMetadata("subTypeOfUpperBounds.constraints")
        public void testSubTypeOfUpperBounds() throws Exception {
            runTest("compiler/testData/constraintSystem/computeValues/subTypeOfUpperBounds.constraints");
        }

        @TestMetadata("superTypeOfLowerBounds1.constraints")
        public void testSuperTypeOfLowerBounds1() throws Exception {
            runTest("compiler/testData/constraintSystem/computeValues/superTypeOfLowerBounds1.constraints");
        }

        @TestMetadata("superTypeOfLowerBounds2.constraints")
        public void testSuperTypeOfLowerBounds2() throws Exception {
            runTest("compiler/testData/constraintSystem/computeValues/superTypeOfLowerBounds2.constraints");
        }
    }

    @TestMetadata("compiler/testData/constraintSystem/integerValueTypes")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IntegerValueTypes extends AbstractConstraintSystemTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInIntegerValueTypes() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/integerValueTypes"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
        }

        @TestMetadata("byteOverflow.constraints")
        public void testByteOverflow() throws Exception {
            runTest("compiler/testData/constraintSystem/integerValueTypes/byteOverflow.constraints");
        }

        @TestMetadata("defaultLong.constraints")
        public void testDefaultLong() throws Exception {
            runTest("compiler/testData/constraintSystem/integerValueTypes/defaultLong.constraints");
        }

        @TestMetadata("numberAndAny.constraints")
        public void testNumberAndAny() throws Exception {
            runTest("compiler/testData/constraintSystem/integerValueTypes/numberAndAny.constraints");
        }

        @TestMetadata("numberAndString.constraints")
        public void testNumberAndString() throws Exception {
            runTest("compiler/testData/constraintSystem/integerValueTypes/numberAndString.constraints");
        }

        @TestMetadata("severalNumbers.constraints")
        public void testSeveralNumbers() throws Exception {
            runTest("compiler/testData/constraintSystem/integerValueTypes/severalNumbers.constraints");
        }

        @TestMetadata("simpleByte.constraints")
        public void testSimpleByte() throws Exception {
            runTest("compiler/testData/constraintSystem/integerValueTypes/simpleByte.constraints");
        }

        @TestMetadata("simpleInt.constraints")
        public void testSimpleInt() throws Exception {
            runTest("compiler/testData/constraintSystem/integerValueTypes/simpleInt.constraints");
        }

        @TestMetadata("simpleShort.constraints")
        public void testSimpleShort() throws Exception {
            runTest("compiler/testData/constraintSystem/integerValueTypes/simpleShort.constraints");
        }
    }

    @TestMetadata("compiler/testData/constraintSystem/severalVariables")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SeveralVariables extends AbstractConstraintSystemTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSeveralVariables() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
        }

        @TestMetadata("simpleDependency.constraints")
        public void testSimpleDependency() throws Exception {
            runTest("compiler/testData/constraintSystem/severalVariables/simpleDependency.constraints");
        }

        @TestMetadata("simpleEquality.constraints")
        public void testSimpleEquality() throws Exception {
            runTest("compiler/testData/constraintSystem/severalVariables/simpleEquality.constraints");
        }

        @TestMetadata("simpleEquality1.constraints")
        public void testSimpleEquality1() throws Exception {
            runTest("compiler/testData/constraintSystem/severalVariables/simpleEquality1.constraints");
        }

        @TestMetadata("simpleReversedDependency.constraints")
        public void testSimpleReversedDependency() throws Exception {
            runTest("compiler/testData/constraintSystem/severalVariables/simpleReversedDependency.constraints");
        }

        @TestMetadata("simpleSubtype.constraints")
        public void testSimpleSubtype() throws Exception {
            runTest("compiler/testData/constraintSystem/severalVariables/simpleSubtype.constraints");
        }

        @TestMetadata("simpleSubtype1.constraints")
        public void testSimpleSubtype1() throws Exception {
            runTest("compiler/testData/constraintSystem/severalVariables/simpleSubtype1.constraints");
        }

        @TestMetadata("compiler/testData/constraintSystem/severalVariables/direct")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Direct extends AbstractConstraintSystemTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDirect() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/direct"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/testData/constraintSystem/severalVariables/direct/contravariant")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Contravariant extends AbstractConstraintSystemTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInContravariant() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/direct/contravariant"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
                }

                @TestMetadata("varEqDepEq.constraints")
                public void testVarEqDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/contravariant/varEqDepEq.constraints");
                }

                @TestMetadata("varEqDepSub.constraints")
                public void testVarEqDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/contravariant/varEqDepSub.constraints");
                }

                @TestMetadata("varEqDepSuper.constraints")
                public void testVarEqDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/contravariant/varEqDepSuper.constraints");
                }

                @TestMetadata("varSubDepEq.constraints")
                public void testVarSubDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/contravariant/varSubDepEq.constraints");
                }

                @TestMetadata("varSubDepSub.constraints")
                public void testVarSubDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/contravariant/varSubDepSub.constraints");
                }

                @TestMetadata("varSubDepSuper.constraints")
                public void testVarSubDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/contravariant/varSubDepSuper.constraints");
                }

                @TestMetadata("varSuperDepEq.constraints")
                public void testVarSuperDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/contravariant/varSuperDepEq.constraints");
                }

                @TestMetadata("varSuperDepSub.constraints")
                public void testVarSuperDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/contravariant/varSuperDepSub.constraints");
                }

                @TestMetadata("varSuperDepSuper.constraints")
                public void testVarSuperDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/contravariant/varSuperDepSuper.constraints");
                }
            }

            @TestMetadata("compiler/testData/constraintSystem/severalVariables/direct/covariant")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Covariant extends AbstractConstraintSystemTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInCovariant() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/direct/covariant"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
                }

                @TestMetadata("varEqDepEq.constraints")
                public void testVarEqDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/covariant/varEqDepEq.constraints");
                }

                @TestMetadata("varEqDepSub.constraints")
                public void testVarEqDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/covariant/varEqDepSub.constraints");
                }

                @TestMetadata("varEqDepSuper.constraints")
                public void testVarEqDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/covariant/varEqDepSuper.constraints");
                }

                @TestMetadata("varSubDepEq.constraints")
                public void testVarSubDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/covariant/varSubDepEq.constraints");
                }

                @TestMetadata("varSubDepSub.constraints")
                public void testVarSubDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/covariant/varSubDepSub.constraints");
                }

                @TestMetadata("varSubDepSuper.constraints")
                public void testVarSubDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/covariant/varSubDepSuper.constraints");
                }

                @TestMetadata("varSuperDepEq.constraints")
                public void testVarSuperDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/covariant/varSuperDepEq.constraints");
                }

                @TestMetadata("varSuperDepSub.constraints")
                public void testVarSuperDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/covariant/varSuperDepSub.constraints");
                }

                @TestMetadata("varSuperDepSuper.constraints")
                public void testVarSuperDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/covariant/varSuperDepSuper.constraints");
                }
            }

            @TestMetadata("compiler/testData/constraintSystem/severalVariables/direct/invariant")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Invariant extends AbstractConstraintSystemTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInvariant() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/direct/invariant"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
                }

                @TestMetadata("varEqDepEq.constraints")
                public void testVarEqDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/invariant/varEqDepEq.constraints");
                }

                @TestMetadata("varEqDepSub.constraints")
                public void testVarEqDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/invariant/varEqDepSub.constraints");
                }

                @TestMetadata("varEqDepSuper.constraints")
                public void testVarEqDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/invariant/varEqDepSuper.constraints");
                }

                @TestMetadata("varSubDepEq.constraints")
                public void testVarSubDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/invariant/varSubDepEq.constraints");
                }

                @TestMetadata("varSubDepSub.constraints")
                public void testVarSubDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/invariant/varSubDepSub.constraints");
                }

                @TestMetadata("varSubDepSuper.constraints")
                public void testVarSubDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/invariant/varSubDepSuper.constraints");
                }

                @TestMetadata("varSuperDepEq.constraints")
                public void testVarSuperDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/invariant/varSuperDepEq.constraints");
                }

                @TestMetadata("varSuperDepSub.constraints")
                public void testVarSuperDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/invariant/varSuperDepSub.constraints");
                }

                @TestMetadata("varSuperDepSuper.constraints")
                public void testVarSuperDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/direct/invariant/varSuperDepSuper.constraints");
                }
            }
        }

        @TestMetadata("compiler/testData/constraintSystem/severalVariables/interdependency")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Interdependency extends AbstractConstraintSystemTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInInterdependency() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/interdependency"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
            }

            @TestMetadata("interdependency1.constraints")
            public void testInterdependency1() throws Exception {
                runTest("compiler/testData/constraintSystem/severalVariables/interdependency/interdependency1.constraints");
            }

            @TestMetadata("interdependency2.constraints")
            public void testInterdependency2() throws Exception {
                runTest("compiler/testData/constraintSystem/severalVariables/interdependency/interdependency2.constraints");
            }

            @TestMetadata("interdependency3.constraints")
            public void testInterdependency3() throws Exception {
                runTest("compiler/testData/constraintSystem/severalVariables/interdependency/interdependency3.constraints");
            }
        }

        @TestMetadata("compiler/testData/constraintSystem/severalVariables/nullable")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Nullable extends AbstractConstraintSystemTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInNullable() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/nullable"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/testData/constraintSystem/severalVariables/nullable/contravariant")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Contravariant extends AbstractConstraintSystemTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInContravariant() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/nullable/contravariant"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
                }

                @TestMetadata("varEqDepEq.constraints")
                public void testVarEqDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/contravariant/varEqDepEq.constraints");
                }

                @TestMetadata("varEqDepSub.constraints")
                public void testVarEqDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/contravariant/varEqDepSub.constraints");
                }

                @TestMetadata("varEqDepSuper.constraints")
                public void testVarEqDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/contravariant/varEqDepSuper.constraints");
                }

                @TestMetadata("varSubDepEq.constraints")
                public void testVarSubDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/contravariant/varSubDepEq.constraints");
                }

                @TestMetadata("varSubDepSub.constraints")
                public void testVarSubDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/contravariant/varSubDepSub.constraints");
                }

                @TestMetadata("varSubDepSuper.constraints")
                public void testVarSubDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/contravariant/varSubDepSuper.constraints");
                }

                @TestMetadata("varSuperDepEq.constraints")
                public void testVarSuperDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/contravariant/varSuperDepEq.constraints");
                }

                @TestMetadata("varSuperDepSub.constraints")
                public void testVarSuperDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/contravariant/varSuperDepSub.constraints");
                }

                @TestMetadata("varSuperDepSuper.constraints")
                public void testVarSuperDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/contravariant/varSuperDepSuper.constraints");
                }
            }

            @TestMetadata("compiler/testData/constraintSystem/severalVariables/nullable/covariant")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Covariant extends AbstractConstraintSystemTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInCovariant() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/nullable/covariant"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
                }

                @TestMetadata("varEqDepEq.constraints")
                public void testVarEqDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/covariant/varEqDepEq.constraints");
                }

                @TestMetadata("varEqDepSub.constraints")
                public void testVarEqDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/covariant/varEqDepSub.constraints");
                }

                @TestMetadata("varEqDepSuper.constraints")
                public void testVarEqDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/covariant/varEqDepSuper.constraints");
                }

                @TestMetadata("varSubDepEq.constraints")
                public void testVarSubDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/covariant/varSubDepEq.constraints");
                }

                @TestMetadata("varSubDepSub.constraints")
                public void testVarSubDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/covariant/varSubDepSub.constraints");
                }

                @TestMetadata("varSubDepSuper.constraints")
                public void testVarSubDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/covariant/varSubDepSuper.constraints");
                }

                @TestMetadata("varSuperDepEq.constraints")
                public void testVarSuperDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/covariant/varSuperDepEq.constraints");
                }

                @TestMetadata("varSuperDepSub.constraints")
                public void testVarSuperDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/covariant/varSuperDepSub.constraints");
                }

                @TestMetadata("varSuperDepSuper.constraints")
                public void testVarSuperDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/covariant/varSuperDepSuper.constraints");
                }
            }

            @TestMetadata("compiler/testData/constraintSystem/severalVariables/nullable/invariant")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Invariant extends AbstractConstraintSystemTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInvariant() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/nullable/invariant"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
                }

                @TestMetadata("varEqDepEq.constraints")
                public void testVarEqDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/invariant/varEqDepEq.constraints");
                }

                @TestMetadata("varEqDepSub.constraints")
                public void testVarEqDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/invariant/varEqDepSub.constraints");
                }

                @TestMetadata("varEqDepSuper.constraints")
                public void testVarEqDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/invariant/varEqDepSuper.constraints");
                }

                @TestMetadata("varSubDepEq.constraints")
                public void testVarSubDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/invariant/varSubDepEq.constraints");
                }

                @TestMetadata("varSubDepSub.constraints")
                public void testVarSubDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/invariant/varSubDepSub.constraints");
                }

                @TestMetadata("varSubDepSuper.constraints")
                public void testVarSubDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/invariant/varSubDepSuper.constraints");
                }

                @TestMetadata("varSuperDepEq.constraints")
                public void testVarSuperDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/invariant/varSuperDepEq.constraints");
                }

                @TestMetadata("varSuperDepSub.constraints")
                public void testVarSuperDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/invariant/varSuperDepSub.constraints");
                }

                @TestMetadata("varSuperDepSuper.constraints")
                public void testVarSuperDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/nullable/invariant/varSuperDepSuper.constraints");
                }
            }
        }

        @TestMetadata("compiler/testData/constraintSystem/severalVariables/other")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Other extends AbstractConstraintSystemTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInOther() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/other"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
            }

            @TestMetadata("constraintForNullables.constraints")
            public void testConstraintForNullables() throws Exception {
                runTest("compiler/testData/constraintSystem/severalVariables/other/constraintForNullables.constraints");
            }

            @TestMetadata("nestedConsumer.constraints")
            public void testNestedConsumer() throws Exception {
                runTest("compiler/testData/constraintSystem/severalVariables/other/nestedConsumer.constraints");
            }

            @TestMetadata("nestedConsumer1.constraints")
            public void testNestedConsumer1() throws Exception {
                runTest("compiler/testData/constraintSystem/severalVariables/other/nestedConsumer1.constraints");
            }

            @TestMetadata("nestedInvConsumer.constraints")
            public void testNestedInvConsumer() throws Exception {
                runTest("compiler/testData/constraintSystem/severalVariables/other/nestedInvConsumer.constraints");
            }

            @TestMetadata("nestedInvProducer.constraints")
            public void testNestedInvProducer() throws Exception {
                runTest("compiler/testData/constraintSystem/severalVariables/other/nestedInvProducer.constraints");
            }

            @TestMetadata("nestedProducer.constraints")
            public void testNestedProducer() throws Exception {
                runTest("compiler/testData/constraintSystem/severalVariables/other/nestedProducer.constraints");
            }

            @TestMetadata("nestedProducerAndConsumer.constraints")
            public void testNestedProducerAndConsumer() throws Exception {
                runTest("compiler/testData/constraintSystem/severalVariables/other/nestedProducerAndConsumer.constraints");
            }

            @TestMetadata("severalOccurrences.constraints")
            public void testSeveralOccurrences() throws Exception {
                runTest("compiler/testData/constraintSystem/severalVariables/other/severalOccurrences.constraints");
            }

            @TestMetadata("simpleFun.constraints")
            public void testSimpleFun() throws Exception {
                runTest("compiler/testData/constraintSystem/severalVariables/other/simpleFun.constraints");
            }

            @TestMetadata("simpleThreeVars.constraints")
            public void testSimpleThreeVars() throws Exception {
                runTest("compiler/testData/constraintSystem/severalVariables/other/simpleThreeVars.constraints");
            }

            @TestMetadata("simpleThreeVarsNoIncorporation.constraints")
            public void testSimpleThreeVarsNoIncorporation() throws Exception {
                runTest("compiler/testData/constraintSystem/severalVariables/other/simpleThreeVarsNoIncorporation.constraints");
            }

            @TestMetadata("simpleThreeVarsNoIncorporationFixed.constraints")
            public void testSimpleThreeVarsNoIncorporationFixed() throws Exception {
                runTest("compiler/testData/constraintSystem/severalVariables/other/simpleThreeVarsNoIncorporationFixed.constraints");
            }
        }

        @TestMetadata("compiler/testData/constraintSystem/severalVariables/recursive")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Recursive extends AbstractConstraintSystemTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInRecursive() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/recursive"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
            }

            @TestMetadata("implicitlyRecursive.constraints")
            public void testImplicitlyRecursive() throws Exception {
                runTest("compiler/testData/constraintSystem/severalVariables/recursive/implicitlyRecursive.constraints");
            }

            @TestMetadata("kt8879.constraints")
            public void testKt8879() throws Exception {
                runTest("compiler/testData/constraintSystem/severalVariables/recursive/kt8879.constraints");
            }

            @TestMetadata("mutuallyRecursive.constraints")
            public void testMutuallyRecursive() throws Exception {
                runTest("compiler/testData/constraintSystem/severalVariables/recursive/mutuallyRecursive.constraints");
            }

            @TestMetadata("simpleRecursive.constraints")
            public void testSimpleRecursive() throws Exception {
                runTest("compiler/testData/constraintSystem/severalVariables/recursive/simpleRecursive.constraints");
            }
        }

        @TestMetadata("compiler/testData/constraintSystem/severalVariables/reversed")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Reversed extends AbstractConstraintSystemTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInReversed() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/reversed"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/testData/constraintSystem/severalVariables/reversed/contravariant")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Contravariant extends AbstractConstraintSystemTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInContravariant() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/reversed/contravariant"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
                }

                @TestMetadata("varEqDepEq.constraints")
                public void testVarEqDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/contravariant/varEqDepEq.constraints");
                }

                @TestMetadata("varEqDepSub.constraints")
                public void testVarEqDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/contravariant/varEqDepSub.constraints");
                }

                @TestMetadata("varEqDepSuper.constraints")
                public void testVarEqDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/contravariant/varEqDepSuper.constraints");
                }

                @TestMetadata("varSubDepEq.constraints")
                public void testVarSubDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/contravariant/varSubDepEq.constraints");
                }

                @TestMetadata("varSubDepSub.constraints")
                public void testVarSubDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/contravariant/varSubDepSub.constraints");
                }

                @TestMetadata("varSubDepSuper.constraints")
                public void testVarSubDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/contravariant/varSubDepSuper.constraints");
                }

                @TestMetadata("varSuperDepEq.constraints")
                public void testVarSuperDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/contravariant/varSuperDepEq.constraints");
                }

                @TestMetadata("varSuperDepSub.constraints")
                public void testVarSuperDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/contravariant/varSuperDepSub.constraints");
                }

                @TestMetadata("varSuperDepSuper.constraints")
                public void testVarSuperDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/contravariant/varSuperDepSuper.constraints");
                }
            }

            @TestMetadata("compiler/testData/constraintSystem/severalVariables/reversed/covariant")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Covariant extends AbstractConstraintSystemTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInCovariant() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/reversed/covariant"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
                }

                @TestMetadata("varEqDepEq.constraints")
                public void testVarEqDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/covariant/varEqDepEq.constraints");
                }

                @TestMetadata("varEqDepSub.constraints")
                public void testVarEqDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/covariant/varEqDepSub.constraints");
                }

                @TestMetadata("varEqDepSuper.constraints")
                public void testVarEqDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/covariant/varEqDepSuper.constraints");
                }

                @TestMetadata("varSubDepEq.constraints")
                public void testVarSubDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/covariant/varSubDepEq.constraints");
                }

                @TestMetadata("varSubDepSub.constraints")
                public void testVarSubDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/covariant/varSubDepSub.constraints");
                }

                @TestMetadata("varSubDepSuper.constraints")
                public void testVarSubDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/covariant/varSubDepSuper.constraints");
                }

                @TestMetadata("varSuperDepEq.constraints")
                public void testVarSuperDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/covariant/varSuperDepEq.constraints");
                }

                @TestMetadata("varSuperDepSub.constraints")
                public void testVarSuperDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/covariant/varSuperDepSub.constraints");
                }

                @TestMetadata("varSuperDepSuper.constraints")
                public void testVarSuperDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/covariant/varSuperDepSuper.constraints");
                }
            }

            @TestMetadata("compiler/testData/constraintSystem/severalVariables/reversed/invariant")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Invariant extends AbstractConstraintSystemTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInvariant() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/reversed/invariant"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
                }

                @TestMetadata("varEqDepEq.constraints")
                public void testVarEqDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/invariant/varEqDepEq.constraints");
                }

                @TestMetadata("varEqDepSub.constraints")
                public void testVarEqDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/invariant/varEqDepSub.constraints");
                }

                @TestMetadata("varEqDepSuper.constraints")
                public void testVarEqDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/invariant/varEqDepSuper.constraints");
                }

                @TestMetadata("varSubDepEq.constraints")
                public void testVarSubDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/invariant/varSubDepEq.constraints");
                }

                @TestMetadata("varSubDepSub.constraints")
                public void testVarSubDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/invariant/varSubDepSub.constraints");
                }

                @TestMetadata("varSubDepSuper.constraints")
                public void testVarSubDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/invariant/varSubDepSuper.constraints");
                }

                @TestMetadata("varSuperDepEq.constraints")
                public void testVarSuperDepEq() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/invariant/varSuperDepEq.constraints");
                }

                @TestMetadata("varSuperDepSub.constraints")
                public void testVarSuperDepSub() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/invariant/varSuperDepSub.constraints");
                }

                @TestMetadata("varSuperDepSuper.constraints")
                public void testVarSuperDepSuper() throws Exception {
                    runTest("compiler/testData/constraintSystem/severalVariables/reversed/invariant/varSuperDepSuper.constraints");
                }
            }
        }
    }

    @TestMetadata("compiler/testData/constraintSystem/variance")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Variance extends AbstractConstraintSystemTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInVariance() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/variance"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
        }

        @TestMetadata("consumer.constraints")
        public void testConsumer() throws Exception {
            runTest("compiler/testData/constraintSystem/variance/consumer.constraints");
        }

        @TestMetadata("invariant.constraints")
        public void testInvariant() throws Exception {
            runTest("compiler/testData/constraintSystem/variance/invariant.constraints");
        }

        @TestMetadata("producer.constraints")
        public void testProducer() throws Exception {
            runTest("compiler/testData/constraintSystem/variance/producer.constraints");
        }
    }
}
