package junit.test.svg;

import latexDraw.parsers.svg.MalformedSVGDocument;
import latexDraw.parsers.svg.SVGAttributes;
import latexDraw.parsers.svg.SVGElements;
import latexDraw.parsers.svg.SVGLength;
import latexDraw.parsers.svg.elements.SVGEllipseElement;
import latexDraw.parsers.svg.parsers.UnitProcessor;

import org.junit.Test;

/** 
 * This class contains tests for the SVGEllipseElement class.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 10/12/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
@SuppressWarnings("nls")
public class TestSVGEllipseElement extends AbstractTestSVGElement
{
	@Test
	public void testContructor()
	{
		try
		{ 
			new SVGEllipseElement(null, null);
			fail();
		}
		catch(Exception e){/**/}
		
		try
		{ 
			new SVGEllipseElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}

		try
		{ 
			node.setAttribute(SVGAttributes.SVG_RX, "dsd");
			node.setAttribute(SVGAttributes.SVG_RY, "dsd");
			new SVGEllipseElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{ 
			node.setAttribute(SVGAttributes.SVG_RX, "1");
			new SVGEllipseElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{ 
			node.setAttribute(SVGAttributes.SVG_RX, "-1");
			node.setAttribute(SVGAttributes.SVG_RY, "10");
			new SVGEllipseElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{ 
			node.setAttribute(SVGAttributes.SVG_RX, "10");
			node.setAttribute(SVGAttributes.SVG_RY, "-1");
			new SVGEllipseElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{
			node.setAttribute(SVGAttributes.SVG_RX, "10");
			node.setAttribute(SVGAttributes.SVG_RY, "20");
			new SVGEllipseElement(node, null);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testGetCy()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_RX, "10");
			node.setAttribute(SVGAttributes.SVG_RY, "20");
			SVGEllipseElement e = new SVGEllipseElement(node, null);
			assertEquals(e.getCy(), 0.);
			
			node.setAttribute(SVGAttributes.SVG_CY, "40");
			e = new SVGEllipseElement(node, null);
			assertEquals(e.getCy(), 40.);
			
			node.setAttribute(SVGAttributes.SVG_CY, "40px");
			e = new SVGEllipseElement(node, null);
			assertEquals(e.getCy(), 40.);
			
			node.setAttribute(SVGAttributes.SVG_CY, "40 cm");
			e = new SVGEllipseElement(node, null);
			assertEquals(e.getCy(), UnitProcessor.toUserUnit(40, SVGLength.LengthType.CM));
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testGetCx()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_RX, "10");
			node.setAttribute(SVGAttributes.SVG_RY, "20");
			SVGEllipseElement e = new SVGEllipseElement(node, null);
			assertEquals(e.getCx(), 0.);
			
			node.setAttribute(SVGAttributes.SVG_CX, "30");
			e = new SVGEllipseElement(node, null);
			assertEquals(e.getCx(), 30.);
			
			node.setAttribute(SVGAttributes.SVG_CX, "40px");
			e = new SVGEllipseElement(node, null);
			assertEquals(e.getCx(), 40.);
			
			node.setAttribute(SVGAttributes.SVG_CX, "40 cm");
			e = new SVGEllipseElement(node, null);
			assertEquals(e.getCx(), UnitProcessor.toUserUnit(40, SVGLength.LengthType.CM));
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testEnableRendering()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_RX, "0");
			node.setAttribute(SVGAttributes.SVG_RY, "0");
			SVGEllipseElement e = new SVGEllipseElement(node, null);
			assertFalse(e.enableRendering());
			
			node.setAttribute(SVGAttributes.SVG_RX, "10");
			node.setAttribute(SVGAttributes.SVG_RY, "0");
			e = new SVGEllipseElement(node, null);
			assertFalse(e.enableRendering());
			
			node.setAttribute(SVGAttributes.SVG_RX, "0");
			node.setAttribute(SVGAttributes.SVG_RY, "10");
			e = new SVGEllipseElement(node, null);
			assertFalse(e.enableRendering());
			
			node.setAttribute(SVGAttributes.SVG_RX, "10");
			node.setAttribute(SVGAttributes.SVG_RY, "10");
			e = new SVGEllipseElement(node, null);
			assertTrue(e.enableRendering());
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testGetRy()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_RX, "10");
			node.setAttribute(SVGAttributes.SVG_RY, "20");
			SVGEllipseElement e = new SVGEllipseElement(node, null);
			assertEquals(e.getRy(), 20.);
			node.setAttribute(SVGAttributes.SVG_RY, "20 pt");
			e = new SVGEllipseElement(node, null);
			assertEquals(e.getRy(), UnitProcessor.toUserUnit(20, SVGLength.LengthType.PT));
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Test
	public void testGetRx()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_RX, "10");
			node.setAttribute(SVGAttributes.SVG_RY, "20");
			SVGEllipseElement e = new SVGEllipseElement(node, null);
			assertEquals(e.getRx(), 10.);
			node.setAttribute(SVGAttributes.SVG_RX, "10mm");
			e = new SVGEllipseElement(node, null);
			assertEquals(e.getRx(), UnitProcessor.toUserUnit(10, SVGLength.LengthType.MM));
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Override
	public String getNameNode()
	{
		return SVGElements.SVG_ELLIPSE;
	}
}
