<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/

# Include the default value
global $CONFIG_DEFAULT;
global $CONFIG;

include_once("config-default.php");

	function getInput($name,$type) {
		global $CONFIG;
		global $CONFIG_DEFAULT;

		if (isset($_POST[$name])) {
			$value = $_POST[$name];
		}
		elseif (isset($CONFIG[$name])) {
			$value = $CONFIG[$name];
		}
		else {
			$value=$CONFIG_DEFAULT[$name];
		}
		if($_POST['modify'] || $_POST['save']){
			return "<input type=\"".$type."\" name=\"".$name."\" value=\"".$value."\" size=\"50\">";
		}else{
			if($type == "PASSWORD")
				return "<strong>**********</strong>";
			else
				return "<strong>".$value."</strong>";
		}

	}
	function getPrinter($name,$type,$value) {
		if($_POST['modify']|| $_POST['save']){
			return "<input type=\"".$type."\" name=\"".$name."\" value=\"".$value."\" size=\"50\">";
		}else{
			return "<strong>".$value."</strong>";
		}

	}

	function getLangageName( $langage_file ){
		include $langage_file;
		return $lang_name;
	}


?>
<form name="setup" method="POST" action="<?php
	if ($param = getGETParam()) $param = '?'.$param;
	print $_SERVER['PHP_SELF'].$param; ?>">

	<?php
		// Buttons on the top of the page were added for an easier use of this module
		if($_POST['modify'] || $_POST['save']){
	?>
			<p>
				<input type="submit" name="save" value="<?= getMessage('save') ?>">
				<input type="submit" name="exit" value="<?= getMessage('exit') ?>">
			</p>
	<?php
		}else{
			echo "<p>";
				echo "<input type='submit' name='modify' value='".getMessage('modify')."'>";
				if($CONFIG['first_setup_lock']!="TRUE"){
					echo "<input type='submit' name='lock_setup' value='".getMessage('lock_setup')."'>";
				}
			echo "</p>";
		}
	?>

	<h2><?= getMessage('cfg_lang_section') ?></h2>

	<p>
	<?php
		echo getMessage('cfg_language')."<br>";
		if($_POST['modify'] || $_POST['save']){
			echo "<select  name='lang' id='lang'>";
			$full_dir = scandir( "./util" );
			foreach( $full_dir as $file ){
				if( ereg( "(^text-)..(\.php$)","$file" ) ){
					$langage = substr( $file, 5, 2 );
					echo "<option value='".$langage."'";
					if( $CONFIG['lang'] == $langage )
						echo "selected";
					echo ">".getLangageName( $file )."</option>";
				}
			}
			echo "</select>";
		}else{
			echo getInput('lang', 'TEXT');
		}
	?>
	</p>

	<p>
	<?= getMessage('cfg_charset') ?><br>
	<?= getInput('charset','TEXT') ?>
	</p>
	</p>
		<h2><?= getMessage('cfg_configurator_security_section') ?></h2>
	<p>
				
	<p>
	<?= getMessage('use_https') ?><br>
	<?php
	if($_POST['modify'] || $_POST['save']){
	?>
	<select  name="use_https" id="use_https">
		<option value="true" <?php if($CONFIG['use_https']== "true")print("selected=selected");?>><?=getMessage('cfg_val_true')?></option>
  		<option value="false" <?php if($CONFIG['use_https']== "false")print("selected=selected");?>><?=getMessage('cfg_val_false')?></option>
	</select>
	<?php
	}else{
		if($CONFIG['use_https']== "true"){?>
		  <strong><?=getMessage('cfg_val_true')?></strong>
		<?php }else{ ?>
		<strong><?=getMessage('cfg_val_false')?></strong>
		<?php }
	?>

	<?php
	}
	?>
	</p>


	<h2><?= getMessage('cfg_terminal_security_section') ?></h2>
	<p>
	<?= getMessage('cfg_terminal_auth') ?><br>
	<?php
	if($_POST['modify'] || $_POST['save']){
	?>
	<select  name="terminal_auth" id="terminal_auth">
		<option value="true" <?php if($CONFIG['terminal_auth']== "true")print("selected=selected");?>><?=getMessage('cfg_val_true')?></option>
  		<option value="false" <?php if($CONFIG['terminal_auth']== "false")print("selected=selected");?>><?=getMessage('cfg_val_false')?></option>
	</select>
	<?php
	}else{
		?>
		<?= getInput('terminal_auth','TEXT') ?>
	<?php
	}
	?>
	</p>
	<p>
	<?= getMessage('cfg_terminal_password') ?><br>
	<?= getInput('terminal_password','TEXT') ?>
	</p>
	<h2>
	<?= getMessage('cfg_db_section') ?></h2>
	<p>
	<?= getMessage('cfg_db_server') ?><br>
	<?= getInput('db_server','TEXT') ?>
	</p>
	<p>
	<?= getMessage('cfg_db_user') ?><br>
	<?= getInput('db_user','TEXT') ?>
	</p>
	<p>
	<?= getMessage('cfg_db_password') ?><br>
	<?= getInput('db_password','PASSWORD') ?>
	</p>
	<p>
	<?= getMessage('cfg_db_name') ?><br>
	<?= getInput('db_name','TEXT') ?>
	</p>
	<p>
	<?= getMessage('cfg_db_type') ?><br>
	<?= getInput('db_type','TEXT') ?>
	</p>
	<h2><?= getMessage('cfg_auth_section') ?></h2>
	<p>
	<?= getMessage('cfg_auth_name') ?><br>

	<?php
	if($_POST['modify'] || $_POST['save']){
	?>
	<select  name="auth_name" id="auth_name">
		<option value="EmptyAuth" <?php if($CONFIG['auth_name']== "EmptyAuth")print("selected=selected");?>>htaccess</option>
  		<option value="LDAPAuth" <?php if($CONFIG['auth_name']== "LDAPAuth")print("selected=selected");?>>ldap</option>
	</select>
	<?php
	}else{
	?>
	<?= getInput('auth_name','TEXT') ?>
	<?php
	}
	?>
	</p>
	<?php if($CONFIG['auth_name']== "LDAPAuth" || $_POST['auth_name']== "LDAPAuth"){?>
	<h3><?= getMessage('cfg_ldap_section') ?></h3>

	<p>
	<?= getMessage('cfg_ldap_host') ?><br>
	<?= getInput('ldap_host','TEXT') ?>
	</p>
	<p>
	<?= getMessage('cfg_ldap_basedn') ?><br>
	<?= getInput('ldap_basedn','TEXT') ?>
	</p>
	<p>
	<?= getMessage('cfg_ldap_object_class') ?><br>
	<?= getInput('ldap_object_class','TEXT') ?>
	</p>
	<p>
	<?= getMessage('cfg_ldap_group_object_class') ?><br>
	<?= getInput('ldap_group_object_class','TEXT') ?>
	</p>
	<p>
	<?= getMessage('cfg_ldap_group') ?><br>
	<?= getInput('ldap_group','TEXT') ?>
	</p>
	<p>
	<?= getMessage('cfg_ldap_binddn') ?><br>
	<?= getInput('ldap_binddn','TEXT') ?>
	</p>
	<p><?= getMessage('cfg_ldap_bindpw') ?><br>
	<?= getInput('ldap_bindpw','PASSWORD') ?>
	</p>
	<p>
	<?= getMessage('cfg_ldap_uidAttribute') ?><br>
	<?= getInput('ldap_uidAttribute','TEXT') ?>
	</p>
	<p><?= getMessage('cfg_ldap_version') ?><br>
	<?= getInput('ldap_version','TEXT') ?>
	</p>
	<?php if(!$_POST['modify'] && !$_POST['save']){?>
	<h3><?= getMessage('test_ldap') ?></h3>
	<table><tr>
		<td>
			<?= getMessage('ask_uid') ?>&nbsp;
			<input type="text" name="login" value="<?=$_POST['login']?>" size=\"30\" />
		</td>
		<td>
			<?= getMessage('ask_password') ?>
			<input type="password" name="password" size=\"30\" />
		</td>
		<td>
			<input type="submit" name="test" value="<?= getMessage('test') ?>" />
		</td>
	</tr></table>
	<?php } ?>
	<h3><?= getMessage('ldap_group_role') ?></h3>
	<?php
	//edit group->role
	if($_POST['modify'] || $_POST['save']){
		$countGroup = 0;
		foreach ($GROUP_ROLE as $group=>$role) {
			$countGroup++;?>
			<input name="group_ldap<?=$countGroup?>" type="text" id="group_ldap<?=$countGroup?>" value="<?=$group?>" />
			<select name="role_group_ldap<?=$countGroup?>" id="role_group_ldap<?=$countGroup?>">
		<?php
			foreach ($ROLE as $roleName=>$value) {?>
				<option value="<?=$roleName?>" <?php if($roleName ==$role )print("selected=\"selected\""); ?>><?=$roleName?></option>
		<?php } ?>
			</select></br>
	<?php }
	  	  $countGroup++;?>
	  	  <input name="group_ldap<?=$countGroup?>" type="text" id="group_ldap<?=$countGroup?>" value="" />
    	  <select name="role_group_ldap<?=$countGroup?>" id="role_group_ldap<?=$countGroup?>">
		<?php
			foreach ($ROLE as $roleName=>$value) {?>
				<option value="<?=$roleName?>"><?=$roleName?></option>
		<?php } ?>
			</select></br>
	<?php
	}else{
		foreach ($GROUP_ROLE as $group=>$role) {?>
			<strong><?=$group?></strong>
		<?php
			foreach ($ROLE as $roleName=>$value) {
				if($roleName ==$role){
		?>
					=><?=$roleName?><br />
		<?php
					break;
				}
			}
		 }
	}
}
?>
	<h2><?= getMessage('cfg_loadbalancer_section') ?></h2>

	<p>
	<?= getMessage('cfg_loadbalancer') ?><br>
	<?= getInput('loadbalancer','TEXT') ?>
	</p>

	<h2><?= getMessage('printer_server_section') ?></h2>
	<?php
	if(!empty($CONFIG['printer_servers']) || $_POST['modify'] || $_POST['save']){
		if(!$_POST['modify']&& !$_POST['save']){
			foreach($CONFIG['printer_servers'] as $printerServer){
	?>
				<?=getPrinter('printer_servers'.$count,'TEXT',$printerServer)?><br/>
	<?php	}
		}else{
			$count = 1;
			if(is_array($CONFIG['printer_servers'])){
				foreach($CONFIG['printer_servers'] as $printerServer){
					?>
					<?=getPrinter('printer_servers'.$count++,'TEXT',$printerServer)?><br/>
				<?php
				}
			}
				?>
				<?=getPrinter('printer_servers'.$count++,'TEXT',"")?><br/>
	<?php
		}
	?>
	<?php
	}else{
	?>NONE
	<?php
	}
	?>
	<?php
	if(($_POST['modify'] || $_POST['save'])){
	?>

  <input type="hidden" name="first_setup_lock" value="FALSE"/>


	<?php
	}
	?>
	<?php
	if($_POST['modify'] || $_POST['save']){
	?>
	<p><input type="submit" name="save" value="<?= getMessage('save') ?>">
	<input type="submit" name="exit" value="<?= getMessage('exit') ?>">
	</p>
	<?php
	}else{
	?>
	<p><input type="submit" name="modify" value="<?= getMessage('modify') ?>"/>
	<?php
		if($CONFIG['first_setup_lock']!="TRUE"){
	?>
	   <input type="submit" name="lock_setup" value="<?= getMessage('lock_setup') ?>"/>
	</p>
	<?php
		}
	}
	?>
</form>
