#!/usr/bin/python

import string
import sys
import os
from statlib import stats

f_name = sys.argv[1]

f = open(f_name,"r")
lines = f.readlines()[2:]
f.close()

f = open(f_name + ".parsed","w")

metrics = ["bi","bo","sum"]
stats_data = ["mean","stdev"]

data = {}
for metric in metrics:
    data[metric] = {}
    data[metric]["samples"] = []
    for stat in stats_data:
        data[metric][stat] = 0
print data
for i,line in enumerate(lines):
    s = string.split(line)
    bi = int(s[8])
    bo = int(s[9])
    sum = bi + bo
    f.write("%s %s %s %s\n" % (i,s[8],s[9],sum))
    data["bi"]["samples"].append(int(bi))
    data["bo"]["samples"].append(int(bo))
    data["sum"]["samples"].append(sum)
f.close()
print data

for metric in metrics:
    data[metric]["mean"] = stats.mean(data[metric]["samples"])
    data[metric]["stdev"] = stats.stdev(data[metric]["samples"])


f = open(f_name + ".stats","w")
for metric in metrics:
    f.write("%s %s %s\n" % (metric, data[metric]["mean"],data[metric]["stdev"]))
    
f.close()
