------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                    A U N I T . T I M E _ M E A S U R E                   --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                                                                          --
--                    Copyright (C) 2006-2019, AdaCore                      --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.                                     --
--                                                                          --
-- As a special exception under Section 7 of GPL version 3, you are granted --
-- additional permissions described in the GCC Runtime Library Exception,   --
-- version 3.1, as published by the Free Software Foundation.               --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
-- GNAT is maintained by AdaCore (http://www.adacore.com)                   --
--                                                                          --
------------------------------------------------------------------------------

--  Dummy package when Ada.Calendar is not supported
with AUnit.IO;

package AUnit.Time_Measure is

   type Time is null record;

   type AUnit_Duration is private;

   Null_Time : Time;

   procedure Start_Measure (T : in out Time);
   --  Start a new measure

   procedure Stop_Measure (T : in out Time);
   --  Stop the measure

   function Get_Measure (T : Time) return AUnit_Duration;
   --  Get the measure

   generic
   procedure Gen_Put_Measure (File    : AUnit.IO.File_Type;
                              Measure : AUnit_Duration);
   --  Put the image of the measure

   generic
   procedure Gen_Put_Measure_In_Seconds (File    : AUnit.IO.File_Type;
                                         Measure : AUnit_Duration);
   --  Unlike Gen_Put_Measure, puts the measure in seconds only, also puts
   --  9 digits after decimal point.

private

   type AUnit_Duration is new Integer;

end AUnit.Time_Measure;
