/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.util.StringTokenizer;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.dns.DomainProtocolException;
import org.apache.harmony.jndi.provider.dns.ProviderConstants;

public class ProviderMgr {
    static final int LOG_NONE = 0;
    static final int LOG_ERROR = 1;
    static final int LOG_WARNING = 2;
    static final int LOG_DEBUG = 3;
    static final boolean CHECK_NAMES = false;

    public static int writeName(String name, byte[] buffer, int startIdx) throws DomainProtocolException {
        int idx = startIdx;
        if (name != null) {
            if (buffer == null) {
                throw new NullPointerException(Messages.getString("jndi.32"));
            }
            if (startIdx > buffer.length || startIdx < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            StringTokenizer st = new StringTokenizer(name, ".");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token == null || token.length() == 0) break;
                byte[] tokenBytes = token.getBytes();
                int tokenBytesLen = tokenBytes.length;
                if (tokenBytesLen > 63) {
                    throw new DomainProtocolException(Messages.getString("jndi.64", token));
                }
                if (idx + tokenBytesLen + 1 > buffer.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                buffer[idx++] = (byte)tokenBytesLen;
                int i = 0;
                while (i < tokenBytesLen) {
                    buffer[idx++] = tokenBytes[i];
                    ++i;
                }
                if (idx - startIdx + 1 <= 255) continue;
                throw new DomainProtocolException(Messages.getString("jndi.5A", 255, name));
            }
            buffer[idx++] = 0;
        }
        return idx;
    }

    public static int parseName(byte[] mesBytes, int startIdx, StringBuffer result) throws DomainProtocolException {
        int n;
        int idx = startIdx;
        boolean firstTime = true;
        if (mesBytes == null) {
            throw new NullPointerException(Messages.getString("jndi.5B"));
        }
        if (result == null) {
            throw new NullPointerException(Messages.getString("jndi.5C"));
        }
        while ((n = ProviderMgr.parse8Int(mesBytes, idx++)) != 0) {
            if ((n & 0xC0) == 192) {
                int namePtr = ProviderMgr.parse16Int(mesBytes, --idx) & 0x3FFF;
                idx += 2;
                if (!firstTime) {
                    result.append('.');
                }
                ProviderMgr.parseName(mesBytes, namePtr, result);
                break;
            }
            if (n > 63) {
                throw new DomainProtocolException(Messages.getString("jndi.59"));
            }
            if (idx + n > mesBytes.length) {
                throw new DomainProtocolException(Messages.getString("jndi.5D"));
            }
            if (firstTime) {
                firstTime = false;
            } else {
                result.append('.');
            }
            result.append(new String(mesBytes, idx, n));
            idx += n;
        }
        return idx;
    }

    public static int getMatchingCount(String name1, String name2) {
        int k = 0;
        if (name1 == null || name2 == null) {
            return 0;
        }
        StringTokenizer st1 = new StringTokenizer(name1, ".");
        StringTokenizer st2 = new StringTokenizer(name2, ".");
        while (st1.hasMoreTokens() && st2.hasMoreTokens()) {
            if (!st1.nextToken().equalsIgnoreCase(st2.nextToken())) break;
            ++k;
        }
        return k;
    }

    public static String getParentName(String name) {
        if (name == null) {
            return null;
        }
        if (name.trim().equals(".") || name.trim().length() == 0) {
            return ".";
        }
        int n = name.indexOf(46);
        if (n != -1 && name.length() > n + 1) {
            return name.substring(n + 1, name.length());
        }
        return ".";
    }

    public static int write16Int(int value, byte[] buffer, int startIdx) {
        int idx = startIdx;
        buffer[idx++] = (byte)((value & 0xFF00) >> 8);
        buffer[idx++] = (byte)(value & 0xFF);
        return idx;
    }

    public static int write32Int(long value, byte[] buffer, int startIdx) {
        int idx = startIdx;
        buffer[idx++] = (byte)((value & 0xFF000000L) >> 24);
        buffer[idx++] = (byte)((value & 0xFF0000L) >> 16);
        buffer[idx++] = (byte)((value & 0xFF00L) >> 8);
        buffer[idx++] = (byte)(value & 0xFFL);
        return idx;
    }

    public static int parse8Int(byte[] buffer, int idx) {
        return buffer[idx] & 0xFF;
    }

    public static int parse16Int(byte[] buffer, int idx) {
        int a = (buffer[idx] & 0xFF) << 8;
        int b = buffer[idx + 1] & 0xFF;
        return a | b;
    }

    public static long parse32Int(byte[] buffer, int idx) {
        long a = ((long)buffer[idx] & 0xFFL) << 24;
        long b = ((long)buffer[idx + 1] & 0xFFL) << 16;
        long c = ((long)buffer[idx + 2] & 0xFFL) << 8;
        long d = (long)buffer[idx + 3] & 0xFFL;
        return a | b | c | d;
    }

    public static int writeCharString(String value, byte[] buffer, int startIdx) throws DomainProtocolException {
        int idx = startIdx;
        if (value == null || buffer == null) {
            throw new NullPointerException(Messages.getString("jndi.5E"));
        }
        if (value.length() > 255) {
            throw new DomainProtocolException(Messages.getString("jndi.5F"));
        }
        byte[] bytes = value.getBytes();
        buffer[idx++] = (byte)bytes.length;
        byte[] byArray = bytes;
        int n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            byte element = byArray[n];
            buffer[idx++] = element;
            ++n;
        }
        return idx;
    }

    public static int parseCharString(byte[] mesBytes, int startIdx, StringBuffer result) {
        if (mesBytes == null || result == null) {
            throw new NullPointerException(Messages.getString("jndi.60"));
        }
        byte len = mesBytes[startIdx];
        result.append(new String(mesBytes, startIdx + 1, (int)len));
        return startIdx + 1 + len;
    }

    public static int setBit(int value, int mask, boolean bit) {
        value = bit ? (value |= mask) : (value &= ~mask);
        return value;
    }

    public static boolean checkBit(int value, int mask) {
        return (value & mask) != 0;
    }

    public static boolean namesAreEqual(String name1, String name2) {
        if (!name1.endsWith(".")) {
            name1 = String.valueOf(name1) + ".";
        }
        if (!name2.endsWith(".")) {
            name2 = String.valueOf(name2) + ".";
        }
        return name1.equalsIgnoreCase(name2);
    }

    public static String normalizeName(String zone) {
        if (zone == null) {
            return zone;
        }
        return zone.endsWith(".") ? zone.toLowerCase() : String.valueOf(zone.toLowerCase()) + ".";
    }

    public static String getIpStr(byte[] ip) {
        StringBuffer sb = new StringBuffer();
        if (ip == null || ip.length < 4) {
            throw new IllegalArgumentException(Messages.getString("jndi.61"));
        }
        int i = 0;
        while (i < 4) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append("" + (ip[i] & 0xFF));
            ++i;
        }
        return sb.toString();
    }

    public static byte[] parseIpStr(String ipStr) {
        byte[] b = new byte[4];
        String errMsg1 = Messages.getString("jndi.62");
        if (ipStr != null) {
            int k = 0;
            StringTokenizer st = new StringTokenizer(ipStr, ".");
            while (st.hasMoreTokens()) {
                int n;
                String token = st.nextToken();
                try {
                    n = Integer.parseInt(token);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(errMsg1);
                }
                b[k++] = (byte)n;
            }
            if (k != 4) {
                throw new IllegalArgumentException(errMsg1);
            }
        } else {
            throw new NullPointerException(Messages.getString("jndi.63"));
        }
        return b;
    }

    public static int getRecordClassNumber(String str) {
        int i = 0;
        while (i < ProviderConstants.rrClassNames.length) {
            if (ProviderConstants.rrClassNames[i] != null && str.equalsIgnoreCase(ProviderConstants.rrClassNames[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getRecordTypeNumber(String str) {
        int i = 0;
        while (i < ProviderConstants.rrTypeNames.length) {
            if (ProviderConstants.rrTypeNames[i] != null && str.equalsIgnoreCase(ProviderConstants.rrTypeNames[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

