package org.apache.commons.openpgp;

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * Bouncy Castle implementation of the OpenPGP signer.
 *
 * @author <a href="mailto:brett@apache.org">Brett Porter</a>
 */
public class BouncyCastleOpenPgpSigner
    implements OpenPgpSigner
{
    private static final int BUFFER_SIZE = 1024;

    public void sign( InputStream data, OutputStream signedOutput, String keyId, KeyRing keyRing, boolean asciiArmor )
        throws OpenPgpException
    {
        // TODO
    }

    public void detachedSign( InputStream data, OutputStream signature, String keyId, KeyRing keyRing,
                              boolean asciiArmor )
        throws OpenPgpException, IOException
    {
        OpenPgpStreamingSigner updater =
            new BouncyCastleOpenPgpStreamingSigner( signature, keyId, keyRing, asciiArmor );

        byte[] buf = new byte[BUFFER_SIZE];

        int len;
        do
        {
            len = data.read( buf );
            if ( len > 0 )
            {
                updater.update( buf, 0, len );
            }
        }
        while ( len >= 0 );

        updater.finish();
    }
}
