/*
 * @(#)IChannelLogRecordUTestI.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.sourceforge.groboutils.codecoverage.v2;

import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import net.sourceforge.groboutils.junit.v1.iftc.ImplFactory;
import net.sourceforge.groboutils.junit.v1.iftc.InterfaceTestCase;
import net.sourceforge.groboutils.junit.v1.iftc.InterfaceTestSuite;


/**
 * Tests the IChannelLogRecord interface.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:27 $
 * @since     December 28, 2002
 */
public class IChannelLogRecordUTestI extends InterfaceTestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = IChannelLogRecordUTestI.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public IChannelLogRecordUTestI( String name, ImplFactory f )
    {
        super( name, IChannelLogRecord.class, f );
    }

    
    public IChannelLogRecord createIChannelLogRecord()
    {
        return (IChannelLogRecord)createImplObject();
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testGetClassSignature1()
    {
        IChannelLogRecord clr = createIChannelLogRecord();
        String s = clr.getClassSignature();
        assertNotNull(
            "Null class signature.",
            s );
        assertTrue(
            "Empty class signature.",
            s.length() > 0 );
    }
    
    
    public void testGetMethodIndex1()
    {
        IChannelLogRecord clr = createIChannelLogRecord();
        short s = clr.getMethodIndex();
        assertTrue(
            "Method index is invalid.",
            s >= 0 );
    }
    
    
    public void testGetMarkIndex1()
    {
        IChannelLogRecord clr = createIChannelLogRecord();
        short s = clr.getMarkIndex();
        
        // nothing really to assert with this.
    }
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static InterfaceTestSuite suite()
    {
        InterfaceTestSuite suite = new InterfaceTestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

