/*
 * @(#)ModifiedInstructionListUTest.java
 *
 * Copyright (C) 2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.compiler;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import net.sourceforge.groboutils.codecoverage.v2.BCELCreatorUtil;

import org.apache.bcel.generic.InstructionList;


/**
 * Tests the ModifiedInstructionList class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:28 $
 * @since     January 13, 2003
 */
public class ModifiedInstructionListUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = ModifiedInstructionListUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public ModifiedInstructionListUTest( String name )
    {
        super( name );
    }


    //-------------------------------------------------------------------------
    // Tests
    
    public void testConstructor1()
    {
        try
        {
            new ModifiedInstructionList( (short)0, 0, 0, null, null );
            fail( "Did not throw IllegalArgumentException." );
        }
        catch (IllegalArgumentException e)
        {
            // test exception
        }
    }
    
    
    public void testConstructor2()
    {
        new ModifiedInstructionList( (short)0, 0,
            0, createInstructionList(), createModifiedTargeters() );
    }
    
    
    public void testClose1()
    {
        ModifiedInstructionList mil = new ModifiedInstructionList(
            (short)0, 0, 0, createInstructionList(),
            createModifiedTargeters() );
        mil.close();
    }
    
    
    public void testClose2()
    {
        ModifiedInstructionList mil = new ModifiedInstructionList(
            (short)0, 0, 0, createInstructionList(),
            createModifiedTargeters() );
        mil.close();
        try
        {
            mil.close();
            fail( "Did not throw IllegalStateException." );
        }
        catch (IllegalStateException e)
        {
            // test exception
        }
    }
    
    
    public void testClose3()
    {
        ModifiedInstructionList mil = new ModifiedInstructionList(
            (short)0, 0, 0, createInstructionList(),
            createModifiedTargeters() );
        mil.close();
        try
        {
            mil.getInstructionAt(0);
            fail( "Did not throw IllegalStateException." );
        }
        catch (IllegalStateException e)
        {
            // test exception
        }
    }
    
    
    public void testClose4()
    {
        ModifiedInstructionList mil = new ModifiedInstructionList(
            (short)0, 0, 0, createInstructionList(),
            createModifiedTargeters() );
        mil.close();
        try
        {
            mil.getInstructionCount();
            fail( "Did not throw IllegalStateException." );
        }
        catch (IllegalStateException e)
        {
            // test exception
        }
    }
    
    
    public void testClose5()
    {
        ModifiedInstructionList mil = new ModifiedInstructionList(
            (short)0, 0, 0, createInstructionList(),
            createModifiedTargeters() );
        mil.close();
        try
        {
            mil.updateInstructionList();
            fail( "Did not throw IllegalStateException." );
        }
        catch (IllegalStateException e)
        {
            // test exception
        }
    }
    
    
    public void testUpdateInstructionList1()
    {
        ModifiedInstructionList mil = new ModifiedInstructionList(
            (short)0, 0, 0, createInstructionList(),
            createModifiedTargeters() );
        int origCount = mil.getInstructionCount();
        mil.updateInstructionList();
        assertEquals( "Changed instruction count!", origCount,
            mil.getInstructionCount() );
        mil.updateInstructionList();
        assertEquals( "Changed instruction count!", origCount,
            mil.getInstructionCount() );
        mil.updateInstructionList();
        assertEquals( "Changed instruction count!", origCount,
            mil.getInstructionCount() );
    }
    
    
    public void testUpdateInstructionList2()
    {
        ModifiedInstructionList mil = new ModifiedInstructionList(
            (short)0, 0, 0, createInstructionList(),
            createModifiedTargeters() );
        int origCount = mil.getInstructionCount();
        mil.getInstructionAt( origCount - 1 ).
            addMark( (short)1, Short.MAX_VALUE );
        mil.updateInstructionList();
        mil.getInstructionAt( origCount - 1 ).
            addMark( (short)1, Short.MAX_VALUE );
        mil.updateInstructionList();
        int count = mil.getInstructionCount();
        mil.updateInstructionList();
        assertEquals( "Changed instruction count!", count,
            mil.getInstructionCount() );
    }
    
    
    public void testGetInstructionAt1()
    {
        // requirement: we need to be able to put a mark at the end of the
        // list.
        ModifiedInstructionList mil = new ModifiedInstructionList(
            (short)0, 0, 0, new InstructionList(),
            createModifiedTargeters() );
        MarkedInstruction mi = mil.getInstructionAt( 0 );
        assertNotNull(
            "Returned null end instruction.",
            mi );
        assertTrue(
            "End instruction is not the NullInstruction.",
            mi.getInstruction() instanceof NullInstruction );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    protected InstructionList createInstructionList()
    {
        InstructionList il = BCELCreatorUtil.createInstructionList();
        BCELCreatorUtil.addInstructionHandle( il );
        return il;
    }
    
    
    protected ModifiedTargeters createModifiedTargeters()
    {
        org.apache.bcel.classfile.JavaClass jc = null;
        try
        {
            jc = BCELCreatorUtil.createJavaClass( THIS_CLASS );
        }
        catch (java.io.IOException ex)
        {
            ex.printStackTrace();
            fail( ex.getMessage() );
        }
        return new ModifiedTargeters(
            BCELCreatorUtil.createMethodGen( jc, 0 ) );
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

