/*
 *  @(#)MockAutoDoc.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.autodoc.v1;

import org.apache.log4j.Logger;

import junit.framework.Assert;

import net.sourceforge.groboutils.autodoc.v1.spi.*;


/**
 * Entry class for loading the AutoDoc pieces for a particular class.  As
 * this class is always instantiated, it does not need an interface. This
 * acts as a central factory for generating all the AutoDoc instances.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:15 $
 * @since      March 23, 2002
 */
public class MockAutoDoc extends AutoDoc
{
    private static final Logger LOG = Logger.getLogger( MockAutoDoc.class );
    
    private AutoDocFactory factory;
    private int getFactoryCallCount = 0;
    
    public MockAutoDoc( Class c, AutoDocFactory f )
    {
        super( c );
        mockSetupFactory( f );
    }
    
    
    /**
     * Returns the factory this implementation knows.
     */
    protected AutoDocFactory getFactory()
    {
        ++this.getFactoryCallCount;
        return this.factory;
    }
    
    
    /**
     * 
     */
    public void mockSetupFactory( AutoDocFactory f )
    {
        this.factory = f;
    }
    
    
    /**
     * 
     */
    public int mockGetFactoryCallCount()
    {
        return this.getFactoryCallCount;
    }
    
    
    /**
     * 
     */
    public void mockVerify()
    {
        Assert.assertEquals(
            "Did not match the expected getFactory() call count.",
            1,
            mockGetFactoryCallCount() );
    }
}

