/*
 *  @(#)AsmblTransition.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.mbtf.v1.assembler;


import net.sourceforge.groboutils.mbtf.v1.IState;
import net.sourceforge.groboutils.mbtf.v1.ITransition;
import net.sourceforge.groboutils.mbtf.v1.IValidate;
import net.sourceforge.groboutils.mbtf.v1.IAction;

import net.sourceforge.groboutils.mbtf.v1.engine.TransitionImpl;

import java.util.Vector;


/**
 * 
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:25 $
 * @since      June 12, 2002
 */
public class AsmblTransition
{
    private String name;
    private Vector validates = new Vector();
    private IAction action;
    private String nextState;
    
    private TransitionImpl iTrans;
    
    
    /**
     * 
     */
    public AsmblTransition()
    {
        // do nothing
    }
    
    
    public void setName( String name )
    {
        if (name == null)
        {
            throw new IllegalArgumentException("no null args");
        }
        
        // invalidates our transition
        resetTransition( true );
        
        this.name = name;
    }
    
    
    public String getName()
    {
        return this.name;
    }
    
    
    public void setNextStateName( String name )
    {
        if (name == null)
        {
            throw new IllegalArgumentException("no null args");
        }
        
        // invalidates our transition, and its state (if any)
        resetTransition( false );
        
        this.nextState = name;
    }
    
    
    public String getNextStateName()
    {
        return this.nextState;
    }
    
    
    public void addValidate( IValidate v )
    {
        if (v != null)
        {
            // invalidates our transition
            resetTransition( true );

            this.validates.addElement( v );
        }
    }
    
    
    public void setAction( IAction a )
    {
        if (a == null)
        {
            throw new IllegalArgumentException("no null args");
        }
        
        // invalidates our transition
        resetTransition( true );
        
        this.action = a;
    }
    
    
    public IValidate[] getValidates()
    {
        IValidate v[] = new IValidate[ this.validates.size() ];
        this.validates.copyInto( v );
        return v;
    }
    
    
    public IAction getAction()
    {
        return this.action;
    }
    
    
    public ITransition getTransition()
    {
        if (this.iTrans == null)
        {
            this.iTrans = new TransitionImpl( getName(), null, getAction(),
                getValidates() );
        }
        return this.iTrans;
    }
    
    
    public void setDestinationState( IState state )
    {
        // ensure the transition is created...
        getTransition();
        
        // make sure the state is correct
        if (state == null)
        {
            throw new IllegalArgumentException("no null args");
        }
        if (!state.getName().equals( getNextStateName() ))
        {
            throw new IllegalArgumentException("Invalid state name");
        }
        
        // only set the destination if we can.
        if (!this.iTrans.isDestinationStateSet())
        {
            this.iTrans.setDestinationState( state );
        }
    }
    
    
    protected void resetTransition( boolean saveState )
    {
        if (saveState && this.iTrans != null &&
            this.iTrans.isDestinationStateSet())
        {
            throw new IllegalStateException("Cannot reset transition");
        }
        else
        {
            this.iTrans = null;
        }
    }
}

