/* ----- core/wforcesntrup1277, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_wforcesntrup1277_checksums[] = {
  "85ee647fbe8423f5655b8b98cd0258f8aac032a58e7ba63881c6476ac31574c9",
  "21ca0241b12b7bbd8478b9026d8b2b71e1e18b1d4d247103555f3bdab7958397",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_wforcesntrup1277_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_wforcesntrup1277_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_wforcesntrup1277_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_wforcesntrup1277_CONSTBYTES

static void *storage_core_wforcesntrup1277_h;
static unsigned char *test_core_wforcesntrup1277_h;
static void *storage_core_wforcesntrup1277_n;
static unsigned char *test_core_wforcesntrup1277_n;
static void *storage_core_wforcesntrup1277_k;
static unsigned char *test_core_wforcesntrup1277_k;
static void *storage_core_wforcesntrup1277_c;
static unsigned char *test_core_wforcesntrup1277_c;
static void *storage_core_wforcesntrup1277_h2;
static unsigned char *test_core_wforcesntrup1277_h2;
static void *storage_core_wforcesntrup1277_n2;
static unsigned char *test_core_wforcesntrup1277_n2;
static void *storage_core_wforcesntrup1277_k2;
static unsigned char *test_core_wforcesntrup1277_k2;
static void *storage_core_wforcesntrup1277_c2;
static unsigned char *test_core_wforcesntrup1277_c2;

#define precomputed_core_wforcesntrup1277_NUM 9

static const unsigned char precomputed_core_wforcesntrup1277_h[precomputed_core_wforcesntrup1277_NUM][crypto_core_OUTPUTBYTES] = {
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {255,1,1,0,0,255,0,255,1,1,0,0,0,255,0,0,0,0,255,0,1,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,255,255,0,0,255,1,0,1,1,255,0,255,0,0,0,0,1,0,1,0,1,1,255,255,1,0,0,0,0,0,0,0,1,0,1,0,1,0,255,0,0,0,0,0,1,255,0,0,0,0,0,1,1,0,255,0,255,0,0,0,0,255,0,0,255,255,0,0,1,0,0,0,0,255,255,0,0,0,0,0,0,1,0,0,0,0,0,1,1,1,0,0,0,0,1,0,1,1,0,1,0,0,255,0,255,0,0,0,0,1,0,255,0,1,0,0,0,0,0,0,255,0,0,0,1,0,0,255,0,0,0,255,255,0,0,0,0,1,0,0,255,1,0,0,0,255,0,255,0,0,0,1,0,1,0,0,0,0,1,0,255,255,0,255,1,0,0,0,0,0,0,0,1,0,0,255,1,255,0,0,255,0,0,0,1,1,255,0,0,1,0,0,0,255,255,0,0,255,0,0,1,255,0,1,0,1,255,0,0,0,0,255,0,0,1,0,0,0,0,0,1,0,0,0,255,0,255,0,0,255,255,0,255,255,1,1,1,1,0,255,0,0,0,255,255,0,0,0,1,0,255,0,255,0,0,0,255,0,0,0,0,0,255,255,1,1,1,0,255,0,1,0,0,0,0,255,0,0,255,0,0,1,1,255,255,0,0,0,0,255,0,255,255,0,255,0,0,255,255,0,255,255,1,1,255,1,0,1,0,255,255,0,0,0,1,255,0,1,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,255,255,0,0,1,255,255,0,1,1,1,0,0,1,1,0,1,255,0,0,1,0,0,255,0,0,255,0,1,0,255,1,0,0,255,1,0,0,0,1,0,0,0,1,0,255,0,0,0,0,0,255,1,0,0,0,1,1,0,0,0,0,0,0,1,0,0,255,1,0,0,0,255,255,255,255,1,0,0,0,255,0,1,255,255,1,0,0,0,1,0,1,0,0,0,0,255,0,1,0,0,255,1,0,0,0,255,1,0,0,0,0,0,0,0,255,0,0,0,0,0,1,0,255,0,0,0,0,0,0,1,0,255,0,1,255,0,0,0,255,255,0,255,255,0,0,1,0,0,0,0,1,1,1,255,0,0,0,1,1,0,0,0,255,0,255,0,0,255,0,0,0,255,1,255,0,1,1,0,0,0,0,1,1,0,255,0,0,0,1,0,0,255,1,0,0,0,1,1,1,0,1,0,0,255,0,1,0,0,0,0,1,0,255,1,0,1,0,255,0,0,1,255,0,0,0,255,0,255,0,255,255,0,255,255,0,0,1,0,0,255,1,1,0,0,255,0,0,255,1,0,0,1,255,0,0,0,0,0,0,1,0,0,1,0,255,0,0,255,1,0,0,255,255,1,0,255,1,255,0,255,0,0,0,255,255,255,0,1,0,255,1,0,0,0,0,1,0,0,0,0,1,0,0,255,1,255,255,0,0,0,255,1,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,255,1,255,0,0,255,0,255,1,0,255,1,0,0,0,255,0,1,0,0,255,0,1,0,0,255,0,0,0,0,1,255,1,255,0,0,0,1,1,0,0,0,255,255,255,255,0,0,255,0,0,0,255,1,0,0,1,255,0,0,1,255,0,0,0,0,255,0,255,0,1,1,0,1,0,1,0,0,1,1,0,1,0,0,0,1,0,0,255,0,1,255,1,0,255,0,1,1,1,0,0,0,0,0,0,0,0,0,0,255,1,0,0,0,0,0,1,255,0,0,1,0,0,255,0,0,1,0,0,0,0,255,255,0,255,0,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,255,0,0,0,0,255,255,1,0,1,1,0,0,255,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,1,1,0,0,0,0,255,255,0,0,0,1,1,0,1,0,0,255,0,0,255,1,255,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,255,255,0,0,1,0,0,0,255,0,0,255,255,1,0,0,255,255,255,0,0,0,0,1,0,0,255,255,0,0,0,0,0,255,1,0,0,255,1,255,0,1,0,0,1,0,0,0,0,0,0,0,0,255,0,0,0,0,1,0,0,0,1,0,0,0,0,255,255,0,0,0,0,255,0,255,255,0,0,0,255,0,0,0,1,1,0,0,0,1,1,0,0,0,1,0,255,0,0,0,0,255,0,0,255,0,0,0,255,0,255,0,0,0,0,0,0,0,0,0,0,1,255,0,0,0,255,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0,255,0,0,0,0,0,0,0,0,1,1,1,255,1,0,1,0,0,0,0,0,255,255,0,1,0,1,1,255,1,255,0,0,0,255,0,1,1,0,0,0,1,0,1,0,0,0,1,0,0,0,0,255,1,255,0,0,255,1,0,0,0,0,0,0,0,0,255,255,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,255,255,1,1,0,0,1,1,0,0,0,255,0,0,1,0,0,1,1,255,0,0,0,1,0,0,0,1,0,0,255,0,0,0,1,1,1,0,255,1,0,0,0,0,0,0,0,0,255,0,0,255,1,1,0,0,0,0,0,255,0,255,0,255,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,255,1,255,0,0,255,0,0,255,0,1,0,1,0,0,1,0,255,0,0,255,0,1,255,0,0,0,255,0,1,255,1,1,0,1},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
} ;

static const unsigned char precomputed_core_wforcesntrup1277_n[precomputed_core_wforcesntrup1277_NUM][crypto_core_INPUTBYTES] = {
  {197,86,12,15,172,69,252,171,135,171,8,242,35,136,23,238,254,14,34,42,142,130,170,204,128,22,178,116,26,214,3,216,166,160,252,238,85,255,92,91,43,9,172,174,107,206,30,122,41,202,10,234,162,197,102,60,54,161,168,234,232,61,224,209,156,156,142,186,146,36,85,11,200,197,142,227,243,19,40,44,34,227,78,118,2,170,160,120,34,233,24,26,43,36,248,60,112,196,213,206,154,104,255,38,199,21,128,171,219,20,25,249,115,20,200,123,102,191,69,100,26,132,217,73,189,25,116,254,56,235,188,101,6,28,137,215,58,172,6,242,80,116,125,225,87,18,71,18,0,108,5,209,114,93,233,92,62,212,187,207,93,24,127,228,44,252,173,173,220,143,244,174,126,157,211,234,178,253,247,176,40,30,156,174,197,229,133,38,65,23,154,74,134,7,14,165,27,148,208,71,140,199,73,63,158,93,40,130,188,82,174,119,200,226,46,237,20,87,68,88,83,19,73,33,55,208,207,166,69,177,26,223,93,79,205,68,151,149,150,90,196,180,137,67,96,6,132,101,209,255,187,209,151,44,227,175,61,224,238,57,35,247,231,201,133,146,140,94,103,205,114,236,238,252,49,117,254,192,83,89,215,81,4,45,53,148,63,231,104,77,70,221,4,241,192,93,153,20,168,249,92,180,31,196,62,67,86,115,147,21,119,193,248,58,209,71,127,94,33,251,70,66,198,2,129,188,69,33,138,242,121,19,159,91,34,62,190,233,216,170,248,110,56,11,72,165,95,15,59,231,24,32,0,160,38,166,112,164,59,173,109,43,7,77,64,2,171,205,72,142,185,195,135,56,83,238,77,17,25,115,148,221,157,147,143,57,75,245,214,140,127,113,65,73,95,50,22,101,24,151,38,159,16,84,236,143,147,71,12,247,15,116,205,71,36,195,80,204,228,163,110,187,28,33,147,97,253,185,45,197,113,212,97,91,4,8,152,150,242,97,150,82,76,27,216,216,195,85,43,224,62,63,195,249,8,234,23,224,216,144,127,217,225,101,218,26,249,224,231,47,97,112,88,25,229,16,56,81,111,87,222,141,131,165,109,143,137,98,159,50,101,102,41,68,57,86,180,191,117,167,41,223,104,228,138,150,192,85,34,161,41,173,50,34,159,5,255,197,238,181,202,191,242,170,174,80,164,97,159,100,30,67,73,25,50,254,61,65,132,255,16,241,171,243,89,49,127,196,178,189,188,191,41,219,86,66,187,126,86,3,104,77,116,139,215,83,211,100,198,51,253,26,213,19,232,147,66,32,49,63,215,218,203,132,131,176,84,215,110,123,2,102,75,96,71,226,86,152,160,30,194,203,131,164,104,192,223,48,228,55,148,127,76,12,195,1,12,109,179,184,105,39,63,201,114,232,119,110,217,220,165,131,182,207,254,94,115,205,224,144,199,196,178,185,238,161,14,208,14,118,113,72,125,87,74,76,44,124,141,174,186,193,253,0,207,161,32,99,151,21,130,11,88,159,252,182,61,66,12,105,131,131,45,196,150,46,187,172,23,193,81,165,119,59,32,82,192,51,147,19,50,24,38,75,190,153,89,90,246,96,188,95,237,109,43,255,248,153,150,152,222,212,103,228,18,193,225,124,10,160,120,192,109,63,90,110,125,169,238,172,193,144,179,110,127,254,223,243,123,36,202,114,6,193,16,174,176,11,84,249,185,76,109,18,118,6,121,125,118,36,124,69,159,133,120,86,135,233,233,217,160,170,86,213,65,70,22,16,214,9,101,30,155,96,40,35,223,172,45,7,34,159,38,172,238,53,173,84,211,134,30,3,5,103,44,101,196,113,245,28,205,242,189,187,114,45,21,142,203,155,105,232,177,175,115,200,159,76,185,120,146,27,156,170,219,207,122,190,31,21,161,199,35,201,149,145,7,252,151,46,50,123,145,219,248,64,107,170,215,110,44,144,254,147,142,49,78,102,81,136,237,187,158,10,33,37,219,162,15,12,80,87,169,237,175,51,248,17,236,121,224,167,224,93,127,230,208,93,239,200,37,231,140,210,29,173,225,174,15,63,85,221,156,177,111,195,201,234,9,1,22,42,128,100,5,96,240,71,90,30,127,230,200,12,234,0,131,32,198,28,124,119,231,114,123,222,132,157,226,110,108,160,116,6,120,239,107,120,195,66,76,173,172,231,169,133,81,220,173,58,41,116,223,141,28,223,252,167,250,221,251,113,145,7,189,54,32,17,61,159,164,71,147,111,185,168,28,159,136,21,186,197,132,63,194,137,134,5,52,244,136,147,17,148,225,120,186,222,103,183,235,124,219,72,93,184,249,14,38,0,31,99,89,101,32,203,121,49,227,42,71,214,144,138,207,45,33,22,43,100,107,182,107,2,67,72,205,30,26,75,177,195,155,106,124,123,149,169,95,191,169,58,36,202,241,250,124,205,198,47,93,244,48,72,170,2,80,15,88,36,177,124,145,173,150,26,105,84,126,129,16,73,210,179,18,216,78,45,238,55,134,8,167,246,20,57,200,231,135,128,145,58,149,176,81,51,143,52,68,62,47,138,46,57,255,1,59,128,10,43,130,123,209,114,192,96,59,251,86,133,178,89,66,249,28,250,247,237,33,77,16,31,55,189,76,191,226,209,230,162,2,1,65,200,28,173,84,174,239,208,248,219,235,13,129,19,104,203,37,240,6,251,233,53,194,114,60,69,111,14,47,119,147,31,249,250,149,184,99,53,242,227,18,138,4,160,232,9,123,119,167,192,206,78,124,169,211,141,150,59,111,234,213,103,189,151,244,232,31,88,201,3,16,117,203,94,73,64,44,140,14,217,61,79,122,68,37,0,61,97,52,129,28,32,64,6,7},
  {126,72,138,164,211,92,2,142,175,73,112,55,46,76,230,144,85,210,239,100,102,185,132,86,245,56,203,22,197,245,73,1,225,184,129,197,66,162,221,26,228,140,51,235,34,56,70,54,132,162,184,17,245,111,42,243,70,72,191,92,3,171,105,226,121,249,25,247,69,248,216,176,250,67,8,124,21,105,224,207,174,4,75,33,175,133,4,38,107,169,126,140,167,10,224,184,144,192,114,249,187,53,150,197,128,102,56,16,56,28,32,145,93,179,238,150,110,8,114,182,151,130,128,63,26,29,32,253,141,205,167,116,162,109,103,220,162,34,64,192,151,139,105,237,70,141,56,83,45,76,95,189,110,163,202,125,152,243,111,85,5,44,109,254,136,56,186,99,40,189,245,255,109,109,20,87,125,210,109,119,137,165,249,85,127,0,128,230,13,220,231,134,192,89,10,50,172,242,225,163,85,166,206,4,253,133,116,223,193,82,106,187,96,138,213,14,23,234,98,232,240,126,161,126,108,41,103,17,133,0,65,76,123,1,97,252,8,165,0,203,156,153,254,131,135,89,19,27,17,78,242,73,242,179,56,224,172,95,87,122,131,204,204,218,23,157,126,165,221,150,21,255,99,136,106,248,2,231,73,76,135,112,69,4,18,65,183,50,77,242,15,215,89,187,5,55,246,234,18,133,127,122,177,92,18,133,80,10,207,16,160,42,51,164,20,5,68,88,25,69,56,149,199,35,146,30,134,96,87,66,36,149,142,8,41,62,1,116,74,122,48,133,184,44,179,48,130,166,98,61,163,79,37,107,62,50,157,12,104,246,151,194,155,22,2,141,70,106,52,113,131,109,82,123,107,189,204,24,136,209,17,172,248,122,105,68,185,94,49,134,226,71,194,230,64,115,51,107,232,57,57,143,20,192,199,42,148,238,41,1,48,140,232,44,251,145,122,31,120,205,126,49,96,160,199,119,154,28,117,2,159,238,204,253,0,186,191,71,10,99,197,41,46,251,168,25,169,11,242,14,47,194,134,87,5,232,68,142,15,36,53,184,113,38,163,165,42,142,222,39,243,182,75,40,65,26,137,235,138,223,74,171,142,168,220,14,64,153,26,91,200,48,116,20,151,180,112,54,184,110,164,136,131,66,18,195,177,44,164,129,218,207,26,1,177,130,113,22,67,130,142,227,195,204,17,37,253,126,181,165,188,98,179,189,46,244,157,16,80,135,83,65,138,105,137,53,186,143,39,63,8,212,123,161,79,12,152,82,196,170,33,252,171,175,8,139,251,21,209,56,169,157,194,200,125,210,202,160,79,168,18,98,229,188,185,171,254,104,195,195,83,154,199,135,28,247,29,111,162,152,193,182,177,19,20,26,130,181,167,75,122,8,185,74,44,10,55,232,81,243,68,239,80,3,177,97,16,138,64,235,168,11,92,163,56,124,196,240,36,25,74,83,198,47,41,42,216,177,19,236,34,134,161,48,142,56,46,252,206,10,173,229,229,240,21,233,212,80,203,215,103,176,186,18,41,169,17,144,152,187,145,191,243,158,41,77,10,138,77,166,195,90,236,254,39,104,87,168,209,141,89,167,138,171,207,214,176,30,138,3,210,43,90,157,234,39,181,59,201,147,35,190,207,25,15,50,181,242,119,217,131,211,183,107,100,168,88,250,33,37,34,41,245,167,16,135,239,234,68,21,196,1,189,107,133,227,235,39,15,164,201,159,18,246,180,206,25,71,219,125,40,107,94,147,91,225,49,218,195,106,98,116,28,161,12,42,138,212,234,167,218,99,140,195,105,118,218,45,50,151,247,194,81,188,74,48,169,112,70,227,55,0,60,72,19,156,197,226,249,189,93,237,17,226,187,50,45,239,80,238,230,226,62,42,226,232,2,173,106,114,117,39,144,9,96,219,105,28,218,132,207,30,53,250,192,71,252,59,40,135,107,109,252,223,74,99,224,207,214,145,198,159,220,97,241,166,105,255,135,15,249,119,132,172,79,103,19,134,23,119,78,204,29,80,164,152,160,69,131,29,215,69,89,47,7,151,196,160,80,22,151,106,253,221,214,8,173,186,233,161,68,63,116,6,19,159,145,136,60,40,232,117,134,15,45,86,234,155,199,6,168,57,251,135,28,143,79,67,239,105,45,223,176,105,138,41,50,41,18,197,110,174,17,228,76,94,105,0,205,215,26,244,147,180,181,94,158,245,148,179,136,207,30,171,84,74,1,239,244,248,142,146,111,91,62,30,162,23,34,197,229,166,255,216,9,83,43,66,88,94,165,120,52,200,147,25,195,101,242,39,22,172,123,51,212,245,180,163,169,19,85,169,142,118,81,243,178,17,59,112,48,93,185,71,95,156,64,99,87,224,9,80,0,62,183,245,227,210,91,1,159,155,251,161,224,75,242,3,2,249,81,14,102,210,109,38,201,214,154,1,188,221,128,61,236,145,142,132,40,3,211,215,82,72,175,69,244,200,217,98,16,7,176,148,128,189,253,38,223,147,190,35,60,255,119,205,208,159,60,95,43,223,224,28,184,23,198,87,90,181,17,119,191,126,193,251,8,98,165,82,29,181,111,141,75,43,203,190,100,161,14,17,231,10,89,239,111,159,250,216,120,235,11,140,120,9,102,83,206,68,64,85,64,73,24,33,217,228,35,84,5,132,97,15,46,9,88,217,123,174,218,183,25,16,151,101,171,148,72,250,168,227,69,28,202,206,160,3,166,9,148,211,65,204,98,208,148,122,244,186,110,252,137,46,125,143,96,230,72,16,97,48,52,249,70,78,244,220,148,17,98,173,204,151,134,39,109,179,0,13,87,145,47,75,150,110,91,94,74,162,82,8,31,135,100,132,30,135,242,116,178,237,214,66,86,155,192},
  {20,112,56,128,135,81,173,192,116,122,133,193,16,193,69,46,196,148,46,169,222,164,114,0,204,104,161,192,152,80,85,78,216,73,75,189,152,223,9,106,157,171,57,207,116,60,175,240,212,233,113,13,22,84,142,11,198,120,83,179,149,50,59,144,14,110,106,3,26,49,250,225,195,227,156,97,237,152,10,81,138,185,114,128,162,40,101,91,9,185,83,118,68,159,169,156,82,208,151,215,222,146,234,169,250,233,125,36,44,73,71,187,20,52,202,82,160,174,96,9,19,166,19,126,186,135,179,121,222,122,73,131,180,50,193,49,195,229,191,8,206,121,219,174,44,221,1,46,64,93,118,187,82,50,171,115,42,95,82,92,7,54,174,228,245,244,192,160,65,51,163,212,23,235,39,4,94,42,172,152,205,49,143,74,10,32,20,5,86,112,70,254,19,139,193,157,235,93,208,39,31,105,196,139,120,176,187,100,38,4,64,241,255,61,70,245,178,16,128,129,90,26,82,3,153,233,53,26,37,52,201,29,201,73,42,217,168,230,130,95,56,69,41,254,247,215,176,29,48,220,83,135,160,39,227,191,181,123,68,77,47,234,239,79,253,231,202,222,65,8,81,87,200,167,123,228,129,63,31,234,224,205,64,235,139,71,224,240,71,119,115,36,202,4,1,177,25,168,43,9,243,44,58,253,246,211,183,197,54,251,74,234,0,13,129,130,243,23,231,13,112,134,216,116,105,4,148,36,187,222,193,95,91,159,26,35,137,2,1,98,84,206,9,68,138,215,52,37,225,211,11,116,154,237,155,172,82,192,47,254,114,23,151,27,216,133,104,117,80,136,231,5,123,156,21,78,98,107,17,180,21,206,29,147,8,207,187,196,167,208,204,115,144,72,102,246,135,227,242,42,52,191,13,216,233,55,120,20,124,185,64,219,6,231,94,248,110,177,17,177,125,230,85,180,37,105,208,151,32,185,147,83,212,64,70,67,197,148,233,70,204,54,133,148,158,149,237,70,157,215,173,178,239,123,14,106,241,166,230,197,89,168,86,210,208,41,127,206,157,33,151,235,28,220,235,56,242,106,207,8,237,248,252,35,136,38,151,64,180,218,148,85,137,139,30,166,114,211,43,130,171,136,14,153,140,214,192,186,155,99,177,64,228,255,116,184,150,6,87,241,89,206,235,174,28,212,110,226,26,137,78,232,77,230,182,173,191,107,104,100,197,7,9,250,227,237,160,206,230,184,11,78,165,156,246,136,47,177,14,139,220,184,222,242,118,38,95,42,145,97,197,165,214,230,245,183,88,61,215,164,140,1,236,132,163,102,18,69,100,144,143,127,83,253,170,38,69,98,210,107,124,254,101,134,10,172,141,252,232,174,11,148,121,177,105,201,230,50,165,20,204,89,223,139,171,81,128,132,109,35,217,232,232,61,213,127,224,184,184,155,158,181,16,156,192,83,194,250,61,8,235,100,145,218,72,99,24,154,42,100,26,175,148,95,51,113,138,21,44,154,89,107,227,246,88,169,240,81,237,163,232,17,22,247,67,131,25,192,128,168,30,56,92,69,31,236,22,148,81,83,158,33,156,36,84,89,56,153,30,86,46,58,134,31,114,49,103,55,155,89,210,53,93,35,38,33,99,253,45,4,83,191,152,165,90,224,213,63,131,176,24,224,195,96,243,122,143,127,116,107,34,54,88,33,32,248,17,77,53,217,170,118,28,186,115,83,211,252,148,82,39,143,76,145,175,214,238,117,114,89,198,102,129,148,161,209,68,137,160,171,249,71,30,87,200,0,220,154,73,131,221,60,128,254,196,29,202,107,213,141,59,56,207,199,113,37,39,144,66,254,69,5,221,240,185,216,138,67,130,153,228,66,193,137,40,1,39,207,177,52,234,80,229,12,126,226,82,151,143,222,159,122,77,177,170,83,215,248,20,63,205,83,181,85,198,218,59,209,93,21,11,93,56,227,155,47,54,230,212,166,107,211,122,86,141,153,241,175,144,227,36,227,79,104,214,101,211,216,14,133,143,122,136,228,40,171,17,117,182,178,48,190,137,136,230,120,117,123,44,230,200,192,51,11,231,18,236,248,181,185,214,220,199,127,192,7,17,210,99,236,37,169,68,104,114,232,245,113,180,81,117,241,232,6,215,64,119,19,201,75,167,101,202,244,140,196,210,153,187,13,238,194,137,156,208,6,211,196,54,239,233,227,5,102,24,76,91,95,137,149,252,72,10,141,116,173,69,2,134,0,28,224,186,1,163,162,111,10,88,194,222,130,4,175,62,136,100,56,111,243,212,47,146,31,174,235,8,60,254,58,232,158,172,240,65,230,139,13,152,19,248,69,91,172,10,217,28,52,196,87,12,252,163,146,251,83,138,77,238,102,48,85,77,76,70,126,142,164,76,244,107,43,76,230,220,122,85,25,49,189,186,164,141,18,64,129,156,10,26,205,224,85,107,74,84,91,239,106,44,232,216,106,122,158,204,61,197,38,209,33,78,24,131,62,168,24,232,158,168,7,159,45,207,7,201,227,76,136,3,78,191,155,94,211,2,5,85,170,107,246,183,114,188,67,2,9,26,198,174,212,117,208,159,99,167,51,21,52,80,212,43,113,80,42,117,225,98,105,212,129,169,77,249,166,74,115,169,188,245,234,248,99,250,206,188,29,127,95,117,221,232,77,43,113,221,240,183,115,92,99,119,91,183,114,234,104,96,104,239,96,150,150,135,198,157,69,254,129,203,80,247,23,90,145,239,107,116,204,19,253,252,30,204,123,33,40,21,3,123,233,237,247,30,203,23,248,206,198,105,53,14,82,139,34,17,221,141,39,43,5,234,108,214,234,45,62,137,221,240,11,221,244,158,49,157,153,101},
  {166,83,103,184,222,216,187,183,12,53,21,28,113,111,28,239,181,126,35,51,245,171,218,254,95,221,164,152,35,212,28,178,179,191,1,6,193,224,105,121,140,140,129,32,194,67,189,49,132,96,5,4,116,121,19,201,76,121,201,46,105,223,243,251,196,129,227,43,11,110,153,166,89,200,242,1,60,205,28,23,184,3,83,246,246,147,147,96,11,11,28,13,13,98,56,199,235,89,55,197,135,204,137,250,254,220,98,98,228,127,246,174,161,29,185,18,154,179,178,233,95,48,59,5,252,33,33,117,238,82,97,196,139,52,174,16,109,243,109,208,105,221,227,216,127,188,179,144,33,188,242,6,249,139,7,112,43,32,113,194,187,172,51,45,44,144,215,223,76,132,244,70,203,24,244,133,178,174,191,146,230,249,123,216,234,233,185,163,89,53,219,74,247,196,33,27,224,149,37,50,5,1,186,240,187,123,83,255,33,228,25,120,225,11,86,12,233,134,204,9,38,127,104,204,120,68,18,120,78,21,39,175,82,77,24,237,17,58,137,118,87,187,253,139,33,55,240,188,59,187,57,255,167,127,226,82,225,33,111,191,21,61,17,26,52,189,69,220,215,148,62,251,104,84,12,176,131,119,107,191,226,225,147,164,246,189,244,164,246,206,84,44,112,118,220,223,20,48,121,3,159,124,37,180,235,60,60,19,47,5,254,156,152,105,136,50,105,21,120,54,96,56,75,79,213,79,53,155,170,143,32,180,100,4,252,151,241,149,107,126,180,205,68,9,208,235,113,16,175,7,121,128,215,141,180,1,126,152,230,138,129,7,113,58,48,125,56,136,201,202,106,32,224,148,26,156,214,93,69,85,186,217,115,4,244,112,160,152,77,202,211,45,63,93,87,213,167,237,252,17,101,255,99,173,191,145,5,131,43,53,86,159,203,59,196,82,172,219,86,147,39,31,92,11,80,32,243,39,6,206,180,232,93,243,238,114,56,9,16,18,224,99,139,240,114,83,36,130,72,50,155,139,46,28,223,13,240,5,216,139,83,177,103,133,110,23,251,169,188,43,92,68,39,25,20,15,120,136,188,230,25,47,187,128,54,32,232,8,124,151,248,125,221,168,118,221,193,174,25,170,134,131,111,56,198,237,47,5,81,186,237,219,21,135,168,236,73,4,30,118,110,118,187,31,173,68,171,107,117,129,119,202,206,210,8,115,244,71,222,115,234,249,90,137,161,166,98,240,199,119,250,12,30,55,130,140,243,248,169,200,175,227,248,220,1,88,204,141,94,182,126,89,233,32,205,64,232,87,155,197,189,36,42,69,36,36,102,128,208,106,167,92,153,168,210,57,85,64,152,215,164,117,14,44,162,241,246,227,180,40,24,117,219,183,86,93,67,60,245,177,254,42,198,39,180,78,36,148,233,16,150,229,159,99,18,163,121,109,226,108,69,164,178,6,55,2,36,8,23,19,244,127,30,156,120,187,96,101,71,179,119,244,245,194,253,193,65,119,80,131,222,54,144,255,193,171,17,9,245,155,79,86,58,165,125,135,2,166,141,115,11,66,207,175,151,251,226,124,73,118,165,216,147,64,70,131,206,170,74,245,232,104,105,154,4,251,68,174,185,126,139,46,32,222,30,239,107,8,12,188,31,116,53,203,237,64,244,56,217,123,100,137,85,139,96,86,51,121,234,89,175,77,63,247,6,51,143,237,65,151,181,228,81,5,208,244,150,252,5,169,210,231,111,150,206,167,183,193,108,109,193,209,46,159,217,221,154,44,214,133,86,220,249,254,60,45,66,64,130,36,111,75,11,244,7,31,94,144,244,152,168,185,110,102,68,74,37,111,242,172,92,115,211,237,153,79,229,52,177,186,164,137,143,140,20,106,145,161,191,174,217,124,103,166,59,65,72,232,80,42,229,44,35,73,128,197,84,168,22,142,215,252,245,124,114,244,95,172,179,147,87,36,176,35,254,178,174,94,43,224,59,179,11,203,160,30,38,39,58,131,47,146,49,42,250,112,149,191,110,243,245,66,246,122,89,103,126,191,185,50,135,119,55,83,164,28,181,151,198,131,41,51,168,191,98,154,179,154,217,123,222,146,237,230,85,156,193,212,16,163,178,146,189,67,17,193,226,124,115,194,211,4,255,156,164,182,185,109,131,111,37,27,9,145,222,222,243,163,94,180,206,87,246,184,144,196,82,192,45,129,71,103,233,105,43,60,80,122,173,182,20,234,240,193,197,8,202,189,172,234,119,141,84,115,205,42,194,35,117,250,211,179,248,152,163,112,215,212,243,59,82,112,41,7,95,149,40,202,169,84,124,186,72,10,242,108,170,116,18,31,158,50,241,239,103,43,16,35,172,61,120,233,119,155,98,37,29,23,55,17,191,144,198,225,164,144,69,121,138,142,6,124,46,140,153,90,182,237,11,38,186,20,55,108,72,122,61,163,236,144,138,24,171,121,26,177,185,56,142,245,112,234,171,156,203,48,241,188,98,148,3,235,57,240,209,182,82,136,247,36,198,169,226,27,14,83,142,14,12,124,16,164,119,105,163,160,100,227,179,188,215,56,239,134,229,45,131,42,38,96,78,130,248,71,77,213,203,0,117,4,199,71,141,126,221,165,161,3,206,7,17,131,165,80,31,51,208,210,166,244,182,30,217,108,55,117,61,247,178,220,12,118,127,73,42,52,136,160,213,139,39,24,15,192,38,63,234,118,28,207,116,119,79,94,133,24,203,223,146,169,29,241,50,98,254,152,173,113,69,143,101,27,60,6,121,191,155,149,145,38,230,207,59,58,67,111,217,135,67,181,3,148,120,31,131,83,200,242,128,79,25,187,124,33,181,144,47,36,198,198,126,25,45,33,212,168,244},
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255},
  {1,1,0,1,0,0,0,0,0,1,1,1,0,0,0,1,0,255,0,1,255,0,0,0,255,1,1,1,255,255,0,0,0,1,255,0,0,0,0,1,0,1,0,0,0,0,255,0,255,0,255,0,1,0,0,0,0,0,0,0,255,1,0,0,1,1,0,1,1,1,1,0,0,0,255,255,0,255,255,1,0,0,1,255,0,0,0,1,1,0,255,1,1,1,0,1,1,1,0,1,0,0,1,255,0,0,0,0,0,255,255,0,1,255,0,1,255,0,0,255,0,0,0,255,0,1,0,0,0,0,0,0,0,0,255,1,255,255,0,0,255,0,0,1,0,1,0,0,255,0,0,0,255,1,0,1,255,0,0,0,0,0,0,1,0,255,0,1,0,0,0,255,0,255,0,0,255,0,255,0,0,0,1,0,0,0,1,255,0,0,0,1,1,0,1,0,1,0,0,255,0,0,1,255,1,0,0,0,0,255,1,255,0,0,0,0,0,0,255,1,0,1,0,0,255,1,255,255,0,0,1,0,1,0,255,0,0,255,0,1,255,0,0,0,0,0,0,0,0,0,1,0,1,0,255,0,0,1,0,0,1,1,0,0,0,1,255,1,0,1,0,1,0,0,0,0,0,0,0,1,255,0,0,1,255,0,255,1,0,255,255,0,0,255,1,0,0,1,255,0,255,0,255,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,255,0,0,0,0,0,0,1,0,0,0,0,255,0,255,255,1,0,0,0,1,0,0,1,0,0,0,0,255,0,1,0,0,0,0,0,0,1,0,0,0,255,0,255,1,255,0,255,1,0,0,255,0,0,0,0,1,0,0,255,0,0,0,0,255,0,1,0,255,1,0,1,0,0,1,0,0,0,255,0,0,0,255,0,255,0,0,0,0,0,0,1,0,255,255,0,0,1,0,255,0,255,255,0,1,1,0,0,0,0,0,1,1,0,0,1,0,0,0,0,1,0,1,0,0,1,0,0,255,0,0,1,0,0,0,0,0,0,1,1,255,0,1,255,0,255,1,0,255,0,0,0,0,0,0,0,1,0,0,0,1,0,0,255,0,0,0,255,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,1,0,0,0,1,0,255,0,0,0,0,255,0,1,255,0,255,1,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,0,0,0,0,0,0,1,255,0,1,255,1,0,0,0,0,0,0,255,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,255,255,1,0,0,0,0,255,0,0,0,1,0,0,0,0,0,0,0,0,255,255,0,0,1,255,0,0,0,0,255,1,0,255,0,255,0,255,255,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,255,0,0,1,0,255,0,255,0,1,255,255,0,1,0,0,255,0,0,1,0,1,0,0,255,0,0,1,1,0,0,1,255,0,0,0,1,0,255,0,0,0,255,1,1,0,255,0,1,0,0,255,0,1,0,1,255,1,0,0,0,0,0,1,0,0,0,1,0,255,0,0,0,255,1,0,1,1,0,0,255,0,0,0,255,1,0,255,1,0,255,0,255,0,1,0,255,0,0,255,0,255,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,0,0,255,0,255,1,0,1,1,1,255,0,0,0,1,0,0,255,0,0,0,0,1,0,0,255,0,0,0,0,0,255,1,0,0,0,1,0,0,0,255,255,1,0,1,0,0,1,255,255,0,0,0,0,0,0,0,1,0,0,255,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,255,0,255,255,0,0,0,0,255,0,1,0,255,0,1,1,0,0,0,0,0,0,0,255,1,0,0,255,0,0,1,0,255,255,1,1,255,1,0,0,0,0,0,255,255,0,0,0,1,1,1,0,1,0,1,255,255,0,0,1,0,1,0,0,1,1,0,255,1,255,0,0,1,1,0,0,0,0,255,0,1,255,0,0,0,0,1,0,0,255,0,0,0,0,0,0,0,1,0,0,0,0,0,255,0,0,0,0,0,255,255,0,0,255,255,1,1,0,0,1,255,1,0,0,0,1,0,255,0,0,1,255,0,1,0,1,0,1,0,0,1,0,255,255,1,0,1,0,0,0,0,0,255,1,0,255,0,255,1,255,0,1,1,0,0,0,255,0,0,0,255,1,0,255,0,255,0,0,0,0,1,0,1,255,255,255,255,0,1,255,1,1,255,0,0,0,255,1,0,1,1,0,255,255,0,0,0,1,0,0,0,0,255,0,1,255,0,255,255,0,1,255,255,0,0,0,255,0,255,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,0,0,0,0,0,0,255,0,255,1,1,0,0,1,0,0,0,0,255,255,0,0,1,1,0,1,0,0,1,0,1,0,0,0,0,0,1,255,255,1,255,0,0,0,255,1,1,0,0,0,255,0,0,255,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,1,0,255,255,0,1,0,0,0,0,0,1,0,0,255,0,1,0,1,1,1,0,0,0,1,255,0,1,255,255,0,0,0,0,0,0,0,0,0,0,0,0,255,1,0,255,255,0,1,255,0,0,0,255,0,1,1,0,0,1,0,0,0,0,1,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,255,0,255,0,0,0,0,0,0,255,1,255,0,255,0,0,1,255,0,0,0,0,0,0,0,1,0,1,1,255,0,1,0,0,0,255,0,255},
  {255,1,1,0,0,255,0,255,1,1,0,0,0,255,0,0,0,0,255,0,1,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,255,255,0,0,255,1,0,1,1,255,0,255,0,0,0,0,1,0,1,0,1,1,255,255,1,0,0,0,0,0,0,0,1,0,1,0,1,0,255,0,0,0,0,0,1,255,0,0,0,0,0,1,1,0,255,0,255,0,0,0,0,255,0,0,255,255,0,0,1,0,0,0,0,255,255,0,0,0,0,0,0,1,0,0,0,0,0,1,1,1,0,0,0,0,1,0,1,1,0,1,0,0,255,0,255,0,0,0,0,1,0,255,0,1,0,0,0,0,0,0,255,0,0,0,1,0,0,255,0,0,0,255,255,0,0,0,0,1,0,0,255,1,0,0,0,255,0,255,0,0,0,1,0,1,0,0,0,0,1,0,255,255,0,255,1,0,0,0,0,0,0,0,1,0,0,255,1,255,0,0,255,0,0,0,1,1,255,0,0,1,0,0,0,255,255,0,0,255,0,0,1,255,0,1,0,1,255,0,0,0,0,255,0,0,1,0,0,0,0,0,1,0,0,0,255,0,255,0,0,255,255,0,255,255,1,1,1,1,0,255,0,0,0,255,255,0,0,0,1,0,255,0,255,0,0,0,255,0,0,0,0,0,255,255,1,1,1,0,255,0,1,0,0,0,0,255,0,0,255,0,0,1,1,255,255,0,0,0,0,255,0,255,255,0,255,0,0,255,255,0,255,255,1,1,255,1,0,1,0,255,255,0,0,0,1,255,0,1,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,255,255,0,0,1,255,255,0,1,1,1,0,0,1,1,0,1,255,0,0,1,0,0,255,0,0,255,0,1,0,255,1,0,0,255,1,0,0,0,1,0,0,0,1,0,255,0,0,0,0,0,255,1,0,0,0,1,1,0,0,0,0,0,0,1,0,0,255,1,0,0,0,255,255,255,255,1,0,0,0,255,0,1,255,255,1,0,0,0,1,0,1,0,0,0,0,255,0,1,0,0,255,1,0,0,0,255,1,0,0,0,0,0,0,0,255,0,0,0,0,0,1,0,255,0,0,0,0,0,0,1,0,255,0,1,255,0,0,0,255,255,0,255,255,0,0,1,0,0,0,0,1,1,1,255,0,0,0,1,1,0,0,0,255,0,255,0,0,255,0,0,0,255,1,255,0,1,1,0,0,0,0,1,1,0,255,0,0,0,1,0,0,255,1,0,0,0,1,1,1,0,1,0,0,255,0,1,0,0,0,0,1,0,255,1,0,1,0,255,0,0,1,255,0,0,0,255,0,255,0,255,255,0,255,255,0,0,1,0,0,255,1,1,0,0,255,0,0,255,1,0,0,1,255,0,0,0,0,0,0,1,0,0,1,0,255,0,0,255,1,0,0,255,255,1,0,255,1,255,0,255,0,0,0,255,255,255,0,1,0,255,1,0,0,0,0,1,0,0,0,0,1,0,0,255,1,255,255,0,0,0,255,1,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,255,1,255,0,0,255,0,255,1,0,255,1,0,0,0,255,0,1,0,0,255,0,1,0,0,255,0,0,0,0,1,255,1,255,0,0,0,1,1,0,0,0,255,255,255,255,0,0,255,0,0,0,255,1,0,0,1,255,0,0,1,255,0,0,0,0,255,0,255,0,1,1,0,1,0,1,0,0,1,1,0,1,0,0,0,1,0,0,255,0,1,255,1,0,255,0,1,1,1,0,0,0,0,0,0,0,0,0,0,255,1,0,0,0,0,0,1,255,0,0,1,0,0,255,0,0,1,0,0,0,0,255,255,0,255,0,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,255,0,0,0,0,255,255,1,0,1,1,0,0,255,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,1,1,0,0,0,0,255,255,0,0,0,1,1,0,1,0,0,255,0,0,255,1,255,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,255,255,0,0,1,0,0,0,255,0,0,255,255,1,0,0,255,255,255,0,0,0,0,1,0,0,255,255,0,0,0,0,0,255,1,0,0,255,1,255,0,1,0,0,1,0,0,0,0,0,0,0,0,255,0,0,0,0,1,0,0,0,1,0,0,0,0,255,255,0,0,0,0,255,0,255,255,0,0,0,255,0,0,0,1,1,0,0,0,1,1,0,0,0,1,0,255,0,0,0,0,255,0,0,255,0,0,0,255,0,255,0,0,0,0,0,0,0,0,0,0,1,255,0,0,0,255,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0,255,0,0,0,0,0,0,0,0,1,1,1,255,1,0,1,0,0,0,0,0,255,255,0,1,0,1,1,255,1,255,0,0,0,255,0,1,1,0,0,0,1,0,1,0,0,0,1,0,0,0,0,255,1,255,0,0,255,1,0,0,0,0,0,0,0,0,255,255,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,255,255,1,1,0,0,1,1,0,0,0,255,0,0,1,0,0,1,1,255,0,0,0,1,0,0,0,1,0,0,255,0,0,0,1,1,1,0,255,1,0,0,0,0,0,0,0,0,255,0,0,255,1,1,0,0,0,0,0,255,0,255,0,255,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,255,1,255,0,0,255,0,0,255,0,1,0,1,0,0,1,0,255,0,0,255,0,1,255,0,0,0,255,0,1,255,1,1,0,1},
  {1,1,0,0,0,1,255,0,0,1,1,255,0,1,1,0,0,0,1,0,0,0,255,1,0,0,0,0,1,0,255,1,255,0,255,255,1,0,0,1,0,1,0,0,0,0,0,255,0,0,0,0,0,0,255,0,255,0,255,255,0,1,0,1,0,0,255,1,1,0,1,255,0,1,255,255,0,1,255,1,0,0,0,0,0,0,0,1,0,0,0,0,255,0,0,0,1,0,255,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,1,0,1,0,0,255,0,0,0,255,0,255,255,1,1,0,255,0,0,255,1,1,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,1,0,1,255,0,1,0,255,0,0,0,255,1,0,0,0,1,0,0,0,255,0,255,255,255,0,0,0,0,1,255,1,255,1,0,0,0,0,1,0,255,255,0,0,0,1,0,0,255,1,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,255,0,0,1,0,1,0,0,0,0,1,0,255,0,0,0,0,0,0,0,255,0,0,0,255,0,255,1,255,1,255,1,1,0,0,255,0,0,0,0,0,1,0,0,0,1,0,255,0,0,0,1,255,1,1,0,0,0,0,1,0,0,0,255,0,0,1,0,255,0,0,255,0,255,0,0,0,1,0,0,0,0,1,0,1,1,0,255,1,1,0,1,0,0,0,0,0,1,0,0,255,255,0,0,0,255,0,1,1,1,0,1,0,0,255,0,0,255,1,0,0,1,255,255,0,1,255,1,255,255,1,255,0,0,255,0,0,0,1,1,1,0,255,255,1,0,0,0,0,255,255,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,255,0,255,255,0,0,0,1,255,0,255,0,1,0,0,0,0,0,0,0,0,1,1,255,255,255,255,0,0,0,0,1,0,255,0,0,0,1,0,0,0,1,0,1,1,0,1,0,255,1,0,0,1,1,1,0,0,0,0,0,255,0,0,0,0,255,0,1,255,255,0,0,1,1,0,1,0,1,1,0,255,0,0,1,1,0,0,0,0,0,1,0,0,0,0,1,1,0,255,255,255,255,0,0,0,0,0,1,255,1,0,0,0,255,0,1,0,0,0,1,255,0,255,0,255,0,1,1,0,255,0,1,0,0,255,0,0,0,0,255,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,255,0,0,1,255,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,255,0,0,0,0,0,1,0,0,0,0,0,255,0,0,255,0,1,0,255,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,255,1,1,1,255,1,0,0,1,0,0,1,1,0,1,255,0,255,0,1,255,0,0,0,255,255,255,1,255,0,255,255,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,0,0,0,255,0,0,0,255,255,0,0,1,0,0,0,0,1,0,0,0,0,1,0,1,0,0,255,1,0,1,0,1,0,0,0,0,0,0,0,0,255,0,255,0,0,0,0,0,0,0,0,255,255,0,255,255,0,0,255,255,0,0,255,255,0,0,255,255,1,255,0,0,255,0,0,255,0,0,1,0,0,0,0,0,0,0,0,1,0,255,0,0,0,0,0,0,0,255,255,0,0,0,1,1,0,1,0,255,0,1,0,1,0,0,255,255,0,0,1,0,0,0,0,255,0,0,255,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,255,0,255,0,1,0,1,1,0,0,1,255,1,0,0,0,0,0,0,0,0,0,0,0,0,0,255,0,1,1,255,0,255,0,255,255,0,0,0,0,1,255,1,255,255,255,0,0,1,1,0,0,0,255,0,255,0,0,0,0,0,255,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,255,0,255,255,0,255,1,0,1,0,0,255,0,0,0,0,0,0,0,255,0,0,0,1,1,0,0,0,0,0,0,0,255,0,0,255,0,0,0,0,0,0,0,255,255,0,255,1,0,1,1,255,0,1,0,0,255,0,1,0,0,1,1,0,0,0,1,0,255,255,1,0,0,255,0,0,0,255,1,0,255,255,255,0,255,0,255,0,255,0,0,0,0,0,0,0,0,0,255,0,0,0,255,0,255,0,255,0,255,0,255,255,255,1,0,0,1,255,1,0,0,0,0,255,0,0,0,255,255,255,0,255,1,1,1,0,0,0,1,1,0,255,0,1,1,255,0,0,255,1,0,0,0,0,0,255,1,255,0,255,0,255,0,0,0,0,0,0,0,0,255,0,255,0,255,1,255,0,255,0,255,0,0,1,0,0,0,255,0,255,0,0,0,0,0,0,0,255,1,1,1,1,0,255,1,255,255,1,0,0,255,0,0,0,0,0,1,0,255,1,0,1,0,1,1,1,1,0,1,1,1,0,255,0,255,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,255,0,0,255,0,0,1,0,0,255,0,0,1,0,1,0,0,255,1,255,0,255,255,255,0,255,0,1,1,0,0,255,0,0,0,0,0,1,255,1,1,1,0,0,1,0,1,255,0,0,0,0,255,255,0,1,255,0,1,1,1,0,255,0,1,0,1,1,1,255,255,0,0,1,1,0,0,0,1,0,1,0,255,0,255,0},
} ;

static const unsigned char precomputed_core_wforcesntrup1277_k[precomputed_core_wforcesntrup1277_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
  {},
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_wforcesntrup1277_c[precomputed_core_wforcesntrup1277_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
  {},
  {},
  {},
  {},
  {},
} ;

static void test_core_wforcesntrup1277_impl(long long impl)
{
  unsigned char *h = test_core_wforcesntrup1277_h;
  unsigned char *n = test_core_wforcesntrup1277_n;
  unsigned char *k = test_core_wforcesntrup1277_k;
  unsigned char *c = test_core_wforcesntrup1277_c;
  unsigned char *h2 = test_core_wforcesntrup1277_h2;
  unsigned char *n2 = test_core_wforcesntrup1277_n2;
  unsigned char *k2 = test_core_wforcesntrup1277_k2;
  unsigned char *c2 = test_core_wforcesntrup1277_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_wforcesntrup1277_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_wforcesntrup1277(impl);
    printf("core_wforcesntrup1277 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_wforcesntrup1277_implementation(impl),ntruprime_dispatch_core_wforcesntrup1277_compiler(impl));
  } else {
    crypto_core = ntruprime_core_wforcesntrup1277;
    printf("core_wforcesntrup1277 selected implementation %s compiler %s\n",ntruprime_core_wforcesntrup1277_implementation(),ntruprime_core_wforcesntrup1277_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(n2,n2,k,c);
      public(n2,hlen);
      public(k,klen);
      public(c,clen);
      if (memcmp(n2,h,hlen) != 0) fail("failure: crypto_core does not handle n=h overlap\n");
      memcpy(n2,n,nlen);
      secret(n,nlen);
      secret(k2,klen);
      secret(c,clen);
      crypto_core(k2,n,k2,c);
      public(k2,hlen);
      public(n,nlen);
      public(c,clen);
      if (memcmp(k2,h,hlen) != 0) fail("failure: crypto_core does not handle k=h overlap\n");
      memcpy(k2,k,klen);
      secret(n,nlen);
      secret(k,klen);
      secret(c2,clen);
      crypto_core(c2,n,k,c2);
      public(c2,hlen);
      public(n,nlen);
      public(k,klen);
      if (memcmp(c2,h,hlen) != 0) fail("failure: crypto_core does not handle c=h overlap\n");
      memcpy(c2,c,clen);
    }
    {
      long long weight,i,direction;
      for (weight = 0;weight <= nlen;++weight) {
        for (direction = 0;direction < 2;++direction) {
          output_prepare(h2,h,hlen);
          input_prepare(n2,n,nlen);
          input_prepare(k2,k,klen);
          input_prepare(c2,c,clen);
          for (i = 0;i < nlen;++i) {
            n[i] &= ~1;
            if (direction) {
              if (nlen-1-i < weight) n[i] += 1;
            } else {
              if (i < weight) n[i] += 1;
            }
            n2[i] = n[i];
          }
          crypto_core(h,n,k,c);
          checksum(h,hlen);
          output_compare(h2,h,hlen,"crypto_core");
          input_compare(n2,n,nlen,"crypto_core");
          input_compare(k2,k,klen,"crypto_core");
          input_compare(c2,c,clen,"crypto_core");
          double_canary(h2,h,hlen);
          double_canary(n2,n,nlen);
          double_canary(k2,k,klen);
          double_canary(c2,c,clen);
          crypto_core(h2,n2,k2,c2);
          if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic");
        }
      }
    }
    checksum_expected(core_wforcesntrup1277_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_wforcesntrup1277_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_wforcesntrup1277_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_wforcesntrup1277_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_wforcesntrup1277_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_wforcesntrup1277_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_wforcesntrup1277_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_wforcesntrup1277_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_wforcesntrup1277_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_wforcesntrup1277_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_wforcesntrup1277(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"wforcesntrup1277")) return;
  storage_core_wforcesntrup1277_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_wforcesntrup1277_h = aligned(storage_core_wforcesntrup1277_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_wforcesntrup1277_n = callocplus(crypto_core_INPUTBYTES);
  test_core_wforcesntrup1277_n = aligned(storage_core_wforcesntrup1277_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_wforcesntrup1277_k = callocplus(crypto_core_KEYBYTES);
  test_core_wforcesntrup1277_k = aligned(storage_core_wforcesntrup1277_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_wforcesntrup1277_c = callocplus(crypto_core_CONSTBYTES);
  test_core_wforcesntrup1277_c = aligned(storage_core_wforcesntrup1277_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_wforcesntrup1277_h2 = callocplus(maxalloc);
  test_core_wforcesntrup1277_h2 = aligned(storage_core_wforcesntrup1277_h2,crypto_core_OUTPUTBYTES);
  storage_core_wforcesntrup1277_n2 = callocplus(maxalloc);
  test_core_wforcesntrup1277_n2 = aligned(storage_core_wforcesntrup1277_n2,crypto_core_INPUTBYTES);
  storage_core_wforcesntrup1277_k2 = callocplus(maxalloc);
  test_core_wforcesntrup1277_k2 = aligned(storage_core_wforcesntrup1277_k2,crypto_core_KEYBYTES);
  storage_core_wforcesntrup1277_c2 = callocplus(maxalloc);
  test_core_wforcesntrup1277_c2 = aligned(storage_core_wforcesntrup1277_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_wforcesntrup1277 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_wforcesntrup1277();++impl)
      forked(test_core_wforcesntrup1277_impl,impl);
    ++test_core_wforcesntrup1277_h;
    ++test_core_wforcesntrup1277_n;
    ++test_core_wforcesntrup1277_k;
    ++test_core_wforcesntrup1277_c;
    ++test_core_wforcesntrup1277_h2;
    ++test_core_wforcesntrup1277_n2;
    ++test_core_wforcesntrup1277_k2;
    ++test_core_wforcesntrup1277_c2;
  }
  free(storage_core_wforcesntrup1277_c2);
  free(storage_core_wforcesntrup1277_k2);
  free(storage_core_wforcesntrup1277_n2);
  free(storage_core_wforcesntrup1277_h2);
  free(storage_core_wforcesntrup1277_c);
  free(storage_core_wforcesntrup1277_k);
  free(storage_core_wforcesntrup1277_n);
  free(storage_core_wforcesntrup1277_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

