//------------------------------------------------------------------------------
// <auto-generated />
//
// This file was automatically generated by SWIG (http://www.swig.org).
// Version 3.0.12
//
// Do not make changes to this file unless you know what you are doing--modify
// the SWIG interface file instead.
//------------------------------------------------------------------------------

namespace libsbml {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html A MIRIAM-compliant date representation.
 *
 * @htmlinclude not-sbml-warning.html
 *
 * A Date object stores a reasonably complete representation of date and
 * time.  Its purpose is to serve as a way to store dates to be read and
 * written in the <a target='_blank'
 * href='http://www.w3.org/TR/NOTE-datetime'>W3C date format</a> used in
 * RDF Dublin Core annotations within SBML.  The W3C date format is a
 * restricted form of <a target='_blank'
 * href='http://en.wikipedia.org/wiki/ISO_8601'>ISO 8601</a>, the
 * international standard for the representation of dates and times.  A
 * time and date value in this W3C format takes the form
 * YYYY-MM-DDThh:mm:ssXHH:ZZ (e.g., <code>1997-07-16T19:20:30+01:00</code>)
 * where XHH:ZZ is the time zone offset.  The libSBML Date object contains
 * the following fields to represent these values:
 * 
 * @li @em year: a long integer representing the year.  This should be a
 * four-digit number such as @c 2011.
 * 
 * @li @em month: a long integer representing the month, with a range of
 * values of 1&ndash;12.  The value @c 1 represents January, and so on.
 *
 * @li @em day: a long integer representing the day of the month, with a
 * range of values of 1&ndash;31.
 * 
 * @li @em hour: a long integer representing the hour on a 24-hour clock,
 * with a range of values of 0&ndash;23.
 * 
 * @li @em minute: a long integer representing the minute, with a range
 * of 0&ndash;59.
 * 
 * @li @em second: a long integer representing the second, with a range
 * of 0&ndash;59.
 * 
 * @li @em sign: a long integer representing the sign of the offset (@c 0
 * signifying @c + and @c 1 signifying @c -).  See the paragraph below for
 * further explanations.
 * 
 * @li @em hours @em offset: a long integer representing the time zone's hour
 * offset from GMT, with a range of 0&ndash;12.
 * 
 * @li @em minute @em offset: a long integer representing the time zone's
 * minute offset from GMT, with a range of 0&ndash;59.
 *
 * To illustrate the time zone offset, a value of <code>-05:00</code> would
 * correspond to USA Eastern Standard Time.  In the Date object, this would
 * require a value of @c 1 for the sign field, @c 5 for the hour offset and
 * @c 0 for the minutes offset.
 *
 * In the restricted RDF annotations used in SBML, described in
 * Section&nbsp;6 of the SBML Level&nbsp;2 and Level&nbsp;3 specification
 * documents, date/time stamps can be used to indicate the time of
 * creation and modification of a model.  The following SBML model fragment
 * illustrates this:
@verbatim
<model metaid='_180340' id='GMO' name='Goldbeter1991_MinMitOscil'>
    <annotation>
        <rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'
                 xmlns:dc='http://purl.org/dc/elements/1.1/'
                 xmlns:dcterms='http://purl.org/dc/terms/'
                 xmlns:vCard='http://www.w3.org/2001/vcard-rdf/3.0#' >
            <rdf:Description rdf:about='#_180340'>
                <dc:creator>
                    <rdf:Bag>
                        <rdf:li rdf:parseType='Resource'>
                            <vCard:N rdf:parseType='Resource'>
                                <vCard:Family>Shapiro</vCard:Family>
                                <vCard:Given>Bruce</vCard:Given>
                            </vCard:N>
                            <vCard:EMAIL>bshapiro@jpl.nasa.gov</vCard:EMAIL>
                            <vCard:ORG rdf:parseType='Resource'>
                                <vCard:Orgname>NASA Jet Propulsion Laboratory</vCard:Orgname>
                            </vCard:ORG>
                        </rdf:li>
                    </rdf:Bag>
                </dc:creator>
                <dcterms:created rdf:parseType='Resource'>
                    <dcterms:W3CDTF>2005-02-06T23:39:40+00:00</dcterms:W3CDTF>
                </dcterms:created>
                <dcterms:modified rdf:parseType='Resource'>
                    <dcterms:W3CDTF>2005-09-13T13:24:56+00:00</dcterms:W3CDTF>
                </dcterms:modified>
            </rdf:Description>
        </rdf:RDF>
    </annotation>
</model>
@endverbatim
 */

public class Date : global::System.IDisposable {
	private HandleRef swigCPtr;
	protected bool swigCMemOwn;
	
	internal Date(IntPtr cPtr, bool cMemoryOwn)
	{
		swigCMemOwn = cMemoryOwn;
		swigCPtr    = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(Date obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (Date obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~Date() {
    Dispose();
  }

  public virtual void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != global::System.IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_Date(swigCPtr);
        }
        swigCPtr = new global::System.Runtime.InteropServices.HandleRef(null, global::System.IntPtr.Zero);
      }
      global::System.GC.SuppressFinalize(this);
    }
  }

  public static bool operator==(Date lhs, Date rhs)
  {
    if((Object)lhs == (Object)rhs)
    {
      return true;
    }

    if( ((Object)lhs == null) || ((Object)rhs == null) )
    {
      return false;
    }

    return (getCPtr(lhs).Handle.ToString() == getCPtr(rhs).Handle.ToString());
  }

  public static bool operator!=(Date lhs, Date rhs)
  {
    return !(lhs == rhs);
  }

  public override bool Equals(Object sb)
  {
    if ( ! (sb is Date) )
    {
      return false;
    }

    return this == (Date)sb;
  }

  public override int GetHashCode()
  {
    return swigCPtr.Handle.ToInt32();
  }

  
/**
   * Creates a time and date representation for use in model annotations
   * and elsewhere.
   *
   * The following is the complete set of possible arguments to this
   * constructor, with default values as indicated:
   *
   * @param year a long integereger representing the year.  This should be
   * a four-digit number such as @c 2011.  (Default value used if this
   * argument is not given: @c 2000.)
   * 
   * @param month a long integereger representing the month, with a range
   * of values of 1&ndash;12.  The value @c 1 represents January, and so
   * on.  (Default value used if this argument is not given: @c 1.)
   *
   * @param day a long integereger representing the day of the month, with
   * a range of values of 1&ndash;31.  (Default value used if this argument
   * is not given: @c 1.)
   * 
   * @param hour a long integereger representing the hour on a 24-hour
   * clock, with a range of values of 0&ndash;23.  (Default value used if
   * this argument is not given: @c 0.)
   * 
   * @param minute a long integereger representing the minute, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param second a long integereger representing the second, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param sign a long integereger representing the sign of the offset
   * (@c 0 signifying @c + and @c 1 signifying @c -).  See the paragraph
   * below for further explanations.  (Default value used if this argument
   * is not given: @c 0.)
   * 
   * @param hoursOffset a long integereger representing the time zone's
   * hour offset from GMT.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param minutesOffset a long integereger representing the time zone's
   * minute offset from GMT.  (Default value used if this argument is not
   * given: @c 0.)
   *
   * To illustrate the time zone offset, a value of <code>-05:00</code>
   * would correspond to USA Eastern Standard Time.  In the Date object,
   * this would require a value of @c 1 for the sign field, @c 5 for the
   * hour offset and @c 0 for the minutes offset.
   * 
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 Date(long year, long month, long day, long hour, long minute, long second, long sign, long hoursOffset, long minutesOffset) : this(libsbmlPINVOKE.new_Date__SWIG_0(year, month, day, hour, minute, second, sign, hoursOffset, minutesOffset), true) {
  }

  
/**
   * Creates a time and date representation for use in model annotations
   * and elsewhere.
   *
   * The following is the complete set of possible arguments to this
   * constructor, with default values as indicated:
   *
   * @param year a long integereger representing the year.  This should be
   * a four-digit number such as @c 2011.  (Default value used if this
   * argument is not given: @c 2000.)
   * 
   * @param month a long integereger representing the month, with a range
   * of values of 1&ndash;12.  The value @c 1 represents January, and so
   * on.  (Default value used if this argument is not given: @c 1.)
   *
   * @param day a long integereger representing the day of the month, with
   * a range of values of 1&ndash;31.  (Default value used if this argument
   * is not given: @c 1.)
   * 
   * @param hour a long integereger representing the hour on a 24-hour
   * clock, with a range of values of 0&ndash;23.  (Default value used if
   * this argument is not given: @c 0.)
   * 
   * @param minute a long integereger representing the minute, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param second a long integereger representing the second, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param sign a long integereger representing the sign of the offset
   * (@c 0 signifying @c + and @c 1 signifying @c -).  See the paragraph
   * below for further explanations.  (Default value used if this argument
   * is not given: @c 0.)
   * 
   * @param hoursOffset a long integereger representing the time zone's
   * hour offset from GMT.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param minutesOffset a long integereger representing the time zone's
   * minute offset from GMT.  (Default value used if this argument is not
   * given: @c 0.)
   *
   * To illustrate the time zone offset, a value of <code>-05:00</code>
   * would correspond to USA Eastern Standard Time.  In the Date object,
   * this would require a value of @c 1 for the sign field, @c 5 for the
   * hour offset and @c 0 for the minutes offset.
   * 
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 Date(long year, long month, long day, long hour, long minute, long second, long sign, long hoursOffset) : this(libsbmlPINVOKE.new_Date__SWIG_1(year, month, day, hour, minute, second, sign, hoursOffset), true) {
  }

  
/**
   * Creates a time and date representation for use in model annotations
   * and elsewhere.
   *
   * The following is the complete set of possible arguments to this
   * constructor, with default values as indicated:
   *
   * @param year a long integereger representing the year.  This should be
   * a four-digit number such as @c 2011.  (Default value used if this
   * argument is not given: @c 2000.)
   * 
   * @param month a long integereger representing the month, with a range
   * of values of 1&ndash;12.  The value @c 1 represents January, and so
   * on.  (Default value used if this argument is not given: @c 1.)
   *
   * @param day a long integereger representing the day of the month, with
   * a range of values of 1&ndash;31.  (Default value used if this argument
   * is not given: @c 1.)
   * 
   * @param hour a long integereger representing the hour on a 24-hour
   * clock, with a range of values of 0&ndash;23.  (Default value used if
   * this argument is not given: @c 0.)
   * 
   * @param minute a long integereger representing the minute, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param second a long integereger representing the second, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param sign a long integereger representing the sign of the offset
   * (@c 0 signifying @c + and @c 1 signifying @c -).  See the paragraph
   * below for further explanations.  (Default value used if this argument
   * is not given: @c 0.)
   * 
   * @param hoursOffset a long integereger representing the time zone's
   * hour offset from GMT.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param minutesOffset a long integereger representing the time zone's
   * minute offset from GMT.  (Default value used if this argument is not
   * given: @c 0.)
   *
   * To illustrate the time zone offset, a value of <code>-05:00</code>
   * would correspond to USA Eastern Standard Time.  In the Date object,
   * this would require a value of @c 1 for the sign field, @c 5 for the
   * hour offset and @c 0 for the minutes offset.
   * 
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 Date(long year, long month, long day, long hour, long minute, long second, long sign) : this(libsbmlPINVOKE.new_Date__SWIG_2(year, month, day, hour, minute, second, sign), true) {
  }

  
/**
   * Creates a time and date representation for use in model annotations
   * and elsewhere.
   *
   * The following is the complete set of possible arguments to this
   * constructor, with default values as indicated:
   *
   * @param year a long integereger representing the year.  This should be
   * a four-digit number such as @c 2011.  (Default value used if this
   * argument is not given: @c 2000.)
   * 
   * @param month a long integereger representing the month, with a range
   * of values of 1&ndash;12.  The value @c 1 represents January, and so
   * on.  (Default value used if this argument is not given: @c 1.)
   *
   * @param day a long integereger representing the day of the month, with
   * a range of values of 1&ndash;31.  (Default value used if this argument
   * is not given: @c 1.)
   * 
   * @param hour a long integereger representing the hour on a 24-hour
   * clock, with a range of values of 0&ndash;23.  (Default value used if
   * this argument is not given: @c 0.)
   * 
   * @param minute a long integereger representing the minute, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param second a long integereger representing the second, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param sign a long integereger representing the sign of the offset
   * (@c 0 signifying @c + and @c 1 signifying @c -).  See the paragraph
   * below for further explanations.  (Default value used if this argument
   * is not given: @c 0.)
   * 
   * @param hoursOffset a long integereger representing the time zone's
   * hour offset from GMT.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param minutesOffset a long integereger representing the time zone's
   * minute offset from GMT.  (Default value used if this argument is not
   * given: @c 0.)
   *
   * To illustrate the time zone offset, a value of <code>-05:00</code>
   * would correspond to USA Eastern Standard Time.  In the Date object,
   * this would require a value of @c 1 for the sign field, @c 5 for the
   * hour offset and @c 0 for the minutes offset.
   * 
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 Date(long year, long month, long day, long hour, long minute, long second) : this(libsbmlPINVOKE.new_Date__SWIG_3(year, month, day, hour, minute, second), true) {
  }

  
/**
   * Creates a time and date representation for use in model annotations
   * and elsewhere.
   *
   * The following is the complete set of possible arguments to this
   * constructor, with default values as indicated:
   *
   * @param year a long integereger representing the year.  This should be
   * a four-digit number such as @c 2011.  (Default value used if this
   * argument is not given: @c 2000.)
   * 
   * @param month a long integereger representing the month, with a range
   * of values of 1&ndash;12.  The value @c 1 represents January, and so
   * on.  (Default value used if this argument is not given: @c 1.)
   *
   * @param day a long integereger representing the day of the month, with
   * a range of values of 1&ndash;31.  (Default value used if this argument
   * is not given: @c 1.)
   * 
   * @param hour a long integereger representing the hour on a 24-hour
   * clock, with a range of values of 0&ndash;23.  (Default value used if
   * this argument is not given: @c 0.)
   * 
   * @param minute a long integereger representing the minute, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param second a long integereger representing the second, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param sign a long integereger representing the sign of the offset
   * (@c 0 signifying @c + and @c 1 signifying @c -).  See the paragraph
   * below for further explanations.  (Default value used if this argument
   * is not given: @c 0.)
   * 
   * @param hoursOffset a long integereger representing the time zone's
   * hour offset from GMT.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param minutesOffset a long integereger representing the time zone's
   * minute offset from GMT.  (Default value used if this argument is not
   * given: @c 0.)
   *
   * To illustrate the time zone offset, a value of <code>-05:00</code>
   * would correspond to USA Eastern Standard Time.  In the Date object,
   * this would require a value of @c 1 for the sign field, @c 5 for the
   * hour offset and @c 0 for the minutes offset.
   * 
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 Date(long year, long month, long day, long hour, long minute) : this(libsbmlPINVOKE.new_Date__SWIG_4(year, month, day, hour, minute), true) {
  }

  
/**
   * Creates a time and date representation for use in model annotations
   * and elsewhere.
   *
   * The following is the complete set of possible arguments to this
   * constructor, with default values as indicated:
   *
   * @param year a long integereger representing the year.  This should be
   * a four-digit number such as @c 2011.  (Default value used if this
   * argument is not given: @c 2000.)
   * 
   * @param month a long integereger representing the month, with a range
   * of values of 1&ndash;12.  The value @c 1 represents January, and so
   * on.  (Default value used if this argument is not given: @c 1.)
   *
   * @param day a long integereger representing the day of the month, with
   * a range of values of 1&ndash;31.  (Default value used if this argument
   * is not given: @c 1.)
   * 
   * @param hour a long integereger representing the hour on a 24-hour
   * clock, with a range of values of 0&ndash;23.  (Default value used if
   * this argument is not given: @c 0.)
   * 
   * @param minute a long integereger representing the minute, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param second a long integereger representing the second, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param sign a long integereger representing the sign of the offset
   * (@c 0 signifying @c + and @c 1 signifying @c -).  See the paragraph
   * below for further explanations.  (Default value used if this argument
   * is not given: @c 0.)
   * 
   * @param hoursOffset a long integereger representing the time zone's
   * hour offset from GMT.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param minutesOffset a long integereger representing the time zone's
   * minute offset from GMT.  (Default value used if this argument is not
   * given: @c 0.)
   *
   * To illustrate the time zone offset, a value of <code>-05:00</code>
   * would correspond to USA Eastern Standard Time.  In the Date object,
   * this would require a value of @c 1 for the sign field, @c 5 for the
   * hour offset and @c 0 for the minutes offset.
   * 
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 Date(long year, long month, long day, long hour) : this(libsbmlPINVOKE.new_Date__SWIG_5(year, month, day, hour), true) {
  }

  
/**
   * Creates a time and date representation for use in model annotations
   * and elsewhere.
   *
   * The following is the complete set of possible arguments to this
   * constructor, with default values as indicated:
   *
   * @param year a long integereger representing the year.  This should be
   * a four-digit number such as @c 2011.  (Default value used if this
   * argument is not given: @c 2000.)
   * 
   * @param month a long integereger representing the month, with a range
   * of values of 1&ndash;12.  The value @c 1 represents January, and so
   * on.  (Default value used if this argument is not given: @c 1.)
   *
   * @param day a long integereger representing the day of the month, with
   * a range of values of 1&ndash;31.  (Default value used if this argument
   * is not given: @c 1.)
   * 
   * @param hour a long integereger representing the hour on a 24-hour
   * clock, with a range of values of 0&ndash;23.  (Default value used if
   * this argument is not given: @c 0.)
   * 
   * @param minute a long integereger representing the minute, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param second a long integereger representing the second, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param sign a long integereger representing the sign of the offset
   * (@c 0 signifying @c + and @c 1 signifying @c -).  See the paragraph
   * below for further explanations.  (Default value used if this argument
   * is not given: @c 0.)
   * 
   * @param hoursOffset a long integereger representing the time zone's
   * hour offset from GMT.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param minutesOffset a long integereger representing the time zone's
   * minute offset from GMT.  (Default value used if this argument is not
   * given: @c 0.)
   *
   * To illustrate the time zone offset, a value of <code>-05:00</code>
   * would correspond to USA Eastern Standard Time.  In the Date object,
   * this would require a value of @c 1 for the sign field, @c 5 for the
   * hour offset and @c 0 for the minutes offset.
   * 
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 Date(long year, long month, long day) : this(libsbmlPINVOKE.new_Date__SWIG_6(year, month, day), true) {
  }

  
/**
   * Creates a time and date representation for use in model annotations
   * and elsewhere.
   *
   * The following is the complete set of possible arguments to this
   * constructor, with default values as indicated:
   *
   * @param year a long integereger representing the year.  This should be
   * a four-digit number such as @c 2011.  (Default value used if this
   * argument is not given: @c 2000.)
   * 
   * @param month a long integereger representing the month, with a range
   * of values of 1&ndash;12.  The value @c 1 represents January, and so
   * on.  (Default value used if this argument is not given: @c 1.)
   *
   * @param day a long integereger representing the day of the month, with
   * a range of values of 1&ndash;31.  (Default value used if this argument
   * is not given: @c 1.)
   * 
   * @param hour a long integereger representing the hour on a 24-hour
   * clock, with a range of values of 0&ndash;23.  (Default value used if
   * this argument is not given: @c 0.)
   * 
   * @param minute a long integereger representing the minute, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param second a long integereger representing the second, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param sign a long integereger representing the sign of the offset
   * (@c 0 signifying @c + and @c 1 signifying @c -).  See the paragraph
   * below for further explanations.  (Default value used if this argument
   * is not given: @c 0.)
   * 
   * @param hoursOffset a long integereger representing the time zone's
   * hour offset from GMT.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param minutesOffset a long integereger representing the time zone's
   * minute offset from GMT.  (Default value used if this argument is not
   * given: @c 0.)
   *
   * To illustrate the time zone offset, a value of <code>-05:00</code>
   * would correspond to USA Eastern Standard Time.  In the Date object,
   * this would require a value of @c 1 for the sign field, @c 5 for the
   * hour offset and @c 0 for the minutes offset.
   * 
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 Date(long year, long month) : this(libsbmlPINVOKE.new_Date__SWIG_7(year, month), true) {
  }

  
/**
   * Creates a time and date representation for use in model annotations
   * and elsewhere.
   *
   * The following is the complete set of possible arguments to this
   * constructor, with default values as indicated:
   *
   * @param year a long integereger representing the year.  This should be
   * a four-digit number such as @c 2011.  (Default value used if this
   * argument is not given: @c 2000.)
   * 
   * @param month a long integereger representing the month, with a range
   * of values of 1&ndash;12.  The value @c 1 represents January, and so
   * on.  (Default value used if this argument is not given: @c 1.)
   *
   * @param day a long integereger representing the day of the month, with
   * a range of values of 1&ndash;31.  (Default value used if this argument
   * is not given: @c 1.)
   * 
   * @param hour a long integereger representing the hour on a 24-hour
   * clock, with a range of values of 0&ndash;23.  (Default value used if
   * this argument is not given: @c 0.)
   * 
   * @param minute a long integereger representing the minute, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param second a long integereger representing the second, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param sign a long integereger representing the sign of the offset
   * (@c 0 signifying @c + and @c 1 signifying @c -).  See the paragraph
   * below for further explanations.  (Default value used if this argument
   * is not given: @c 0.)
   * 
   * @param hoursOffset a long integereger representing the time zone's
   * hour offset from GMT.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param minutesOffset a long integereger representing the time zone's
   * minute offset from GMT.  (Default value used if this argument is not
   * given: @c 0.)
   *
   * To illustrate the time zone offset, a value of <code>-05:00</code>
   * would correspond to USA Eastern Standard Time.  In the Date object,
   * this would require a value of @c 1 for the sign field, @c 5 for the
   * hour offset and @c 0 for the minutes offset.
   * 
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 Date(long year) : this(libsbmlPINVOKE.new_Date__SWIG_8(year), true) {
  }

  
/**
   * Creates a time and date representation for use in model annotations
   * and elsewhere.
   *
   * The following is the complete set of possible arguments to this
   * constructor, with default values as indicated:
   *
   * @param year a long integereger representing the year.  This should be
   * a four-digit number such as @c 2011.  (Default value used if this
   * argument is not given: @c 2000.)
   * 
   * @param month a long integereger representing the month, with a range
   * of values of 1&ndash;12.  The value @c 1 represents January, and so
   * on.  (Default value used if this argument is not given: @c 1.)
   *
   * @param day a long integereger representing the day of the month, with
   * a range of values of 1&ndash;31.  (Default value used if this argument
   * is not given: @c 1.)
   * 
   * @param hour a long integereger representing the hour on a 24-hour
   * clock, with a range of values of 0&ndash;23.  (Default value used if
   * this argument is not given: @c 0.)
   * 
   * @param minute a long integereger representing the minute, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param second a long integereger representing the second, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param sign a long integereger representing the sign of the offset
   * (@c 0 signifying @c + and @c 1 signifying @c -).  See the paragraph
   * below for further explanations.  (Default value used if this argument
   * is not given: @c 0.)
   * 
   * @param hoursOffset a long integereger representing the time zone's
   * hour offset from GMT.  (Default value used if this argument is not
   * given: @c 0.)
   * 
   * @param minutesOffset a long integereger representing the time zone's
   * minute offset from GMT.  (Default value used if this argument is not
   * given: @c 0.)
   *
   * To illustrate the time zone offset, a value of <code>-05:00</code>
   * would correspond to USA Eastern Standard Time.  In the Date object,
   * this would require a value of @c 1 for the sign field, @c 5 for the
   * hour offset and @c 0 for the minutes offset.
   * 
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 Date() : this(libsbmlPINVOKE.new_Date__SWIG_9(), true) {
  }

  
/**
   * Creates a Date object from a string expressing a date and time value.
   *
   * This constructor expects its argument to be in the <a target='_blank'
   * href='http://www.w3.org/TR/NOTE-datetime'>W3C date format with time
   * zone offset</a>, used in RDF Dublin Core annotations within SBML.
   * 
   *
 * 
 * The date format expresses a date and time value as a string of the form
 * YYYY-MM-DDThh:mm:ssXHH:ZZ, where
 * 
 * @li @em YYYY is a four-digit integer representing the year.  This
 * should be a four-digit number such as @c 2011.
 * 
 * @li @em MM is a two-digit integer representing the month, with a range
 * of values of 01&ndash;12.  The value @c 1 represents January, and so
 * on.
 *
 * @li @em DD is a two-digit integer representing the day of the month,
 * with a range of values of 01&ndash;31.
 * 
 * @li @em T is the literal character @c T.
 * 
 * @li @em hh is a two-digit integer representing the hour on a 24-hour
 * clock, with a range of values of 00&ndash;23.
 * 
 * @li @em mm is a two-digit integer representing the minute, with a
 * range of 00&ndash;59.
 * 
 * @li @em ss is a two-digit integer representing the second, with a
 * range of 0&ndash;59.
 * 
 * @li @em X is the the sign of the time zone offset, either @c + or
 * <code>-</code>.
 *
 * @li @em HH is a two-digit integer representing the hour of the time
 * zone offset, with a range of 00&ndash;23.
 *
 * @li @em ZZ is a two-digit integer representing the minutes of the time
 * zone offset, with a range of 00&ndash;59.
 *
 * In the string format above, it is important not to forget the literal
 * character @c T in the string.  Here is an example date/time string:
 * <code>1997-07-16T19:20:30+01:00</code>, which would represent July 16,
 * 1997, at 19:20:30 in Central European Time (which is UTC +1:00). 
   *
   * If this constructor is given a @c null argument or a string of length
   * zero, it constructs a Date object with the value of January 1, 2000,
   * at time 00:00 UTC.  Otherwise, the argument @em must be in the
   * complete format described above, or unpredictable results will happen.
   *
   * @param date a string representing the date.
   */ public
 Date(string date) : this(libsbmlPINVOKE.new_Date__SWIG_10(date), true) {
  }

  
/**
   * Copy constructor; creates a copy of this Date.
   *
   * @param orig the object to copy.
   */ public
 Date(Date orig) : this(libsbmlPINVOKE.new_Date__SWIG_11(Date.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates and returns a deep copy of this Date object.
   *
   * @return the (deep) copy of this Date object.
   */ public
 Date clone() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Date_clone(swigCPtr);
    Date ret = (cPtr == global::System.IntPtr.Zero) ? null : new Date(cPtr, true);
    return ret;
  }

  
/**
   * Returns the year from this Date.
   *
   * @return the year from this Date.
   */ public
 long getYear() { return (long)libsbmlPINVOKE.Date_getYear(swigCPtr); }

  
/**
   * Returns the month from this Date.
   *
   * @return the month from this Date.
   */ public
 long getMonth() { return (long)libsbmlPINVOKE.Date_getMonth(swigCPtr); }

  
/**
   * Returns the day from this Date.
   *
   * @return the day from this Date.
   */ public
 long getDay() { return (long)libsbmlPINVOKE.Date_getDay(swigCPtr); }

  
/**
   * Returns the hour from this Date.
   *
   * @return the hour from this Date.
   */ public
 long getHour() { return (long)libsbmlPINVOKE.Date_getHour(swigCPtr); }

  
/**
   * Returns the minute from this Date.
   *
   * @return the minute from this Date.
   */ public
 long getMinute() { return (long)libsbmlPINVOKE.Date_getMinute(swigCPtr); }

  
/**
   * Returns the seconds from this Date.
   *
   * @return the seconds from this Date.
   */ public
 long getSecond() { return (long)libsbmlPINVOKE.Date_getSecond(swigCPtr); }

  
/**
   * Returns the sign of the time zone offset from this Date.
   *
   * @return the sign of the offset from this Date.
   */ public
 long getSignOffset() { return (long)libsbmlPINVOKE.Date_getSignOffset(swigCPtr); }

  
/**
   * Returns the hours of the time zone offset from this Date.
   *
   * @return the hours of the offset from this Date.
   */ public
 long getHoursOffset() { return (long)libsbmlPINVOKE.Date_getHoursOffset(swigCPtr); }

  
/**
   * Returns the minutes of the time zone offset from this Date.
   *
   * @return the minutes of the offset from this Date.
   */ public
 long getMinutesOffset() { return (long)libsbmlPINVOKE.Date_getMinutesOffset(swigCPtr); }

  
/**
   * Returns the current Date value in text-string form.
   *
   * The string returned will be in the <a target='_blank'
   * href='http://www.w3.org/TR/NOTE-datetime'>W3C date format with time
   * zone offset</a>, used in RDF Dublin Core annotations within SBML.
   *
   *
 * 
 * The date format expresses a date and time value as a string of the form
 * YYYY-MM-DDThh:mm:ssXHH:ZZ, where
 * 
 * @li @em YYYY is a four-digit integer representing the year.  This
 * should be a four-digit number such as @c 2011.
 * 
 * @li @em MM is a two-digit integer representing the month, with a range
 * of values of 01&ndash;12.  The value @c 1 represents January, and so
 * on.
 *
 * @li @em DD is a two-digit integer representing the day of the month,
 * with a range of values of 01&ndash;31.
 * 
 * @li @em T is the literal character @c T.
 * 
 * @li @em hh is a two-digit integer representing the hour on a 24-hour
 * clock, with a range of values of 00&ndash;23.
 * 
 * @li @em mm is a two-digit integer representing the minute, with a
 * range of 00&ndash;59.
 * 
 * @li @em ss is a two-digit integer representing the second, with a
 * range of 0&ndash;59.
 * 
 * @li @em X is the the sign of the time zone offset, either @c + or
 * <code>-</code>.
 *
 * @li @em HH is a two-digit integer representing the hour of the time
 * zone offset, with a range of 00&ndash;23.
 *
 * @li @em ZZ is a two-digit integer representing the minutes of the time
 * zone offset, with a range of 00&ndash;59.
 *
 * In the string format above, it is important not to forget the literal
 * character @c T in the string.  Here is an example date/time string:
 * <code>1997-07-16T19:20:30+01:00</code>, which would represent July 16,
 * 1997, at 19:20:30 in Central European Time (which is UTC +1:00). 
   *
   * @return the date as a string.
   */ public
 string getDateAsString() {
    string ret = libsbmlPINVOKE.Date_getDateAsString(swigCPtr);
    return ret;
  }

  
/**
   * Sets the value of the year of this Date object.
   *
   * The value given as argument must be between 1000 and 9999 inclusive.
   * (In the millennium during which this libSBML documentation is being
   * written, a typical value is @c 2011, but we hope that SBML will
   * continue to be used for a long time.)
   *  
   * @param year a long integer representing the year.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   */ public
 int setYear(long year) {
    int ret = libsbmlPINVOKE.Date_setYear(swigCPtr, year);
    return ret;
  }

  
/**
   * Sets the value of the month of this Date object.
   *
   * @param month a long integer representing the month; it must be in the
   * range 1&ndash;12 or an error will be signaled.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   */ public
 int setMonth(long month) {
    int ret = libsbmlPINVOKE.Date_setMonth(swigCPtr, month);
    return ret;
  }

  
/**
   * Sets the value of the day of this Date object.
   *  
   * @param day a long integer representing the day; it must be in the
   * range 0&ndash;31 or an error will be signaled.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   */ public
 int setDay(long day) {
    int ret = libsbmlPINVOKE.Date_setDay(swigCPtr, day);
    return ret;
  }

  
/**
   * Sets the value of the hour of this Date object.
   *  
   * @param hour a long integer representing the hour to set; it must be
   * in the range 0&ndash;23 or an error will be signaled.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   */ public
 int setHour(long hour) {
    int ret = libsbmlPINVOKE.Date_setHour(swigCPtr, hour);
    return ret;
  }

  
/**
   * Sets the value of the minute of this Date object.
   *  
   * @param minute a long integer representing the minute to set; it must
   * be in the range 0&ndash;59 or an error will be signaled.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   */ public
 int setMinute(long minute) {
    int ret = libsbmlPINVOKE.Date_setMinute(swigCPtr, minute);
    return ret;
  }

  
/**
   * Sets the value of the second of the Date object.
   *  
   * @param second a long integer representing the seconds; it must
   * be in the range 0&ndash;59 or an error will be signaled.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   */ public
 int setSecond(long second) {
    int ret = libsbmlPINVOKE.Date_setSecond(swigCPtr, second);
    return ret;
  }

  
/**
   * Sets the value of the sign of the time zone offset of this Date object.
   *
   * The only permissible values are @c 0 and @c 1.
   *  
   * @param sign a long integer representing the sign of the offset, with
   * @c 0 signifying @c + and @c 1 signifying @c -.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   */ public
 int setSignOffset(long sign) {
    int ret = libsbmlPINVOKE.Date_setSignOffset(swigCPtr, sign);
    return ret;
  }

  
/**
   * Sets the value of this Date object's time zone hour offset.
   *  
   * @param hoursOffset a long integer representing the hours of the
   * offset; it must be in the range 0&ndash;12 or an error will be
   * signaled.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   */ public
 int setHoursOffset(long hoursOffset) {
    int ret = libsbmlPINVOKE.Date_setHoursOffset(swigCPtr, hoursOffset);
    return ret;
  }

  
/**
   * Sets the value of this Date object's time zone minutes offset.
   *  
   * @param minutesOffset a long integer representing the minutes of the
   * offset; it must be in the range 0&ndash;59 or an error will be
   * signaled.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   */ public
 int setMinutesOffset(long minutesOffset) {
    int ret = libsbmlPINVOKE.Date_setMinutesOffset(swigCPtr, minutesOffset);
    return ret;
  }

  
/**
   * Sets the value of this Date object using a date and time value
   * expressed as a text string.
   * 
   * This method expects its argument to be in the <a target='_blank'
   * href='http://www.w3.org/TR/NOTE-datetime'>W3C date format with time
   * zone offset</a>, used in RDF Dublin Core annotations within SBML.
   *
   *
 * 
 * The date format expresses a date and time value as a string of the form
 * YYYY-MM-DDThh:mm:ssXHH:ZZ, where
 * 
 * @li @em YYYY is a four-digit integer representing the year.  This
 * should be a four-digit number such as @c 2011.
 * 
 * @li @em MM is a two-digit integer representing the month, with a range
 * of values of 01&ndash;12.  The value @c 1 represents January, and so
 * on.
 *
 * @li @em DD is a two-digit integer representing the day of the month,
 * with a range of values of 01&ndash;31.
 * 
 * @li @em T is the literal character @c T.
 * 
 * @li @em hh is a two-digit integer representing the hour on a 24-hour
 * clock, with a range of values of 00&ndash;23.
 * 
 * @li @em mm is a two-digit integer representing the minute, with a
 * range of 00&ndash;59.
 * 
 * @li @em ss is a two-digit integer representing the second, with a
 * range of 0&ndash;59.
 * 
 * @li @em X is the the sign of the time zone offset, either @c + or
 * <code>-</code>.
 *
 * @li @em HH is a two-digit integer representing the hour of the time
 * zone offset, with a range of 00&ndash;23.
 *
 * @li @em ZZ is a two-digit integer representing the minutes of the time
 * zone offset, with a range of 00&ndash;59.
 *
 * In the string format above, it is important not to forget the literal
 * character @c T in the string.  Here is an example date/time string:
 * <code>1997-07-16T19:20:30+01:00</code>, which would represent July 16,
 * 1997, at 19:20:30 in Central European Time (which is UTC +1:00). 
   *
   * If this method is given a @c null argument or a string of length zero,
   * it constructs a Date object with the value of January 1, 2000, at time
   * 00:00 UTC.  Otherwise, the argument @em must be in the complete format
   * described above, or unpredictable results will happen.
   *
   * @param date a string representing the date.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   */ public
 int setDateAsString(string date) {
    int ret = libsbmlPINVOKE.Date_setDateAsString(swigCPtr, date);
    return ret;
  }

  
/**
   * Returns @c true or @c false depending on whether this date object represents
   * a valid date and time value.
   *
   * This method verifies that the date/time value stored in this object is
   * well-formed and represents plausible values.  A time and date value in
   * the W3C format takes the form YYYY-MM-DDThh:mm:ssXHH:ZZ (e.g.,
   * <code>1997-07-16T19:20:30+01:00</code>) where XHH:ZZ is the time zone
   * offset.  This method checks such things as whether the value of the
   * month number is less than or equal to 12, whether the value of the
   * minutes number is less than or equal to 59, whether a time zone offset
   * is set, etc.
   *
   * @return @c true if the date is valid, @c false otherwise.
   */ public
 bool representsValidDate() {
    bool ret = libsbmlPINVOKE.Date_representsValidDate(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool hasBeenModified() {
    bool ret = libsbmlPINVOKE.Date_hasBeenModified(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 void resetModifiedFlags() {
    libsbmlPINVOKE.Date_resetModifiedFlags(swigCPtr);
  }

}

}
