[comment {-*- tcl -*- doctools}]
[vset FORMATNAME jpeg]
[vset FORMATFULLNAME {Joint Picture Expert Group format}]

[include format-header.inc]

[include format-package.inc]

This handler provides new additional configuration options. See
section [sectref {JPEG OPTIONS}] for more detailed explanations.


[include format-middle.inc]

In addition the value for the option is treated as list and may
contain any of the special options listed in section

[sectref {JPEG OPTIONS}].

[list_end]



[section {JPEG OPTIONS}]
The handler provides the following options:

[list_begin definitions]

[def [option -fast]]

This option is for reading from JPEG data. If specified, it activates a
processing mode which is fast, but also provides only low-quality
information.


[def [option -grayscale]]

This option can be used for both reading and writing of JPEG
data. Usage of this option forces incoming images to grayscale, and
written images will be monochrome.


[def "[option -quality] [arg n]"]

This option is for writing JPEG data. It specifies the compression
level as a quality percentage. The higher the quality, the less the
compression. The nominal range for [arg n] is

[const 0]...[const 100]. Useful values are in the range
[const 5]...[const 95]. The default value is [const 75].


[def "[option -smooth] [arg n]"]

This option is for writing JPEG data. When used the writer will smooth
the image before performing the compression. Values in the

[const 10]...[const 30] are usually enough. The default is [const 0],
i.e no smoothing.


[def [option -optimize]]

This option is for writing JPEG data. If specified, it causes the writer to
optimize the Huffman table used to encode the JPEG coefficients.


[def [option -progressive]]

This option is for writing JPEG data. If specified, it causes the creation of
a [term progressive] JPEG file.


[include format-footer.inc]
