#ifndef __OPERATORS_H
#define __OPERATORS_H
/*-------------------------------------------------------------------------
 * Copyright (c) 2000 Kenneth W. Sodemann (stufflehead@bigfoot.com)
 *-------------------------------------------------------------------------
 * operators
 *
 * Synopsis:
 *    The operators defined in MathWars
 *
 * $Id: operators.h,v 1.1 2000/10/15 15:36:46 stuffle Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to 
 * Free Software Foundation, Inc. 
 * 59 Temple Place, Suite 330 
 * Boston, MA  02111-1307  USA
 *
 *-------------------------------------------------------------------------
 */
/*! \file operators.h
 
  \brief
  Define the binary operators that MathWar understands

  MathWar works with binary operators, such as addition and multiplication.
  The operators that MathWars understands are defined here.

  \author Kenneth W. Sodemann <stufflehead@bigfoot.com>
  $Revision: 1.1 $
  $Date: 2000/10/15 15:36:46 $
*/

/*! \enum operator_type
 * The mathematical operators that are defined for MathWars.  Due to the
 * way MathWars works, any operators defined here must be binary operators
 * (IOW, they must work on two (and only two) numbers at a time).
 */
/*! \var SUBTRACTION
 * The operation of subtraction.
 */
/*! \var ADDITION
 * The operation of addition.
 */
/*! \var MULTIPLICATION
 * The operation of multiplication.
 */
typedef enum
{
   SUBTRACTION = 1,
   ADDITION,
   MULTIPLICATION
} operator_type;


/*! \fn gint operator_result (gint x1, gint x2, operator_type oper)
 
  \brief Determine what the result of the operation should be

  \param x1
  Operand number one

  \param x2
  Operand number two

  \param oper
  The operation to be performed

  \return
  The result of x1 oper x2
*/
gint operator_result (gint x1, gint x2, operator_type oper);


/*! \fn gchar operator_symbol (operator_type oper)
 
  \brief Return the symbol associated with the operator

  \param oper
  The operator for which to return the symbol

  \return
  The symbol associated with the operator.
*/
gchar operator_symbol (operator_type oper);

#endif
