# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class PassArrays(DataObjectAlgorithm):
    r"""
    PassArrays - Passes a subset of arrays to the output
    
    Superclass: DataObjectAlgorithm
    
    This filter preserves all the topology of the input, but only a
    subset of arrays are passed to the output. Add an array to be passed
    to the output data object with add_array(). If remove_arrays is on, the
    specified arrays will be the ones that are removed instead of the
    ones that are kept.
    
    Arrays with special attributes (scalars, pedigree ids, etc.) will
    retain those attributes in the output.
    
    By default, only those field types with at least one array specified
    through add_array will be processed. If instead use_field_types is
    turned on, you explicitly set which field types to process with
    add_field_type.
    
    By default, ghost arrays will be passed unless remove_arrays is
    selected and those arrays are specifically chosen to be removed.
    
    Example 1:
    
    passArray->add_array(vtkdata_object::POINT, "velocity"); 
    
    The output will have only that one array "velocity" in the point
    data, but cell and field data will be untouched.
    
    Example 2:
    
    passArray->add_array(vtkdata_object::POINT, "velocity");
    passArray->use_field_types_on();
    passArray->add_field_type(vtkdata_object::POINT);
    passArray->add_field_type(vtkdata_object::CELL); 
    
    The point data would still contain the single array, but the cell
    data would be cleared since you did not specify any arrays to pass.
    Field data would still be untouched.
    
    @section Note
    
    PassArrays has been replaced by `vtkpass_selected_arrays`. It is
    recommended that newer code uses `vtkpass_selected_arrays` instead of
    this filter. `vtkpass_selected_arrays` uses `vtkdata_array_selection` to
    select arrays and hence provides a more typical API. `vtkpass_arrays`
    may be deprecated in future releases.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPassArrays, obj, update, **traits)
    
    remove_arrays = tvtk_base.false_bool_trait(desc=\
        r"""
        Instead of passing only the specified arrays, remove the
        specified arrays and keep all other arrays. Default is off.
        """
    )

    def _remove_arrays_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRemoveArrays,
                        self.remove_arrays_)

    use_field_types = tvtk_base.false_bool_trait(desc=\
        r"""
        Process only those field types explicitly specified with
        add_field_type. Otherwise, processes field types associated with at
        least one specified array. Default is off.
        """
    )

    def _use_field_types_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseFieldTypes,
                        self.use_field_types_)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def add_array(self, *args):
        """
        add_array(self, fieldType:int, name:str) -> None
        C++: virtual void add_array(int fieldType, const char *name)
        Adds an array to pass through. fieldType where the array that
        should be passed (point data, cell data, etc.). It should be one
        of the constants defined in the DataObject::AttributeTypes
        enumeration.
        """
        ret = self._wrap_call(self._vtk_obj.AddArray, *args)
        return ret

    def add_cell_data_array(self, *args):
        """
        add_cell_data_array(self, name:str) -> None
        C++: virtual void add_cell_data_array(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.AddCellDataArray, *args)
        return ret

    def add_field_data_array(self, *args):
        """
        add_field_data_array(self, name:str) -> None
        C++: virtual void add_field_data_array(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.AddFieldDataArray, *args)
        return ret

    def add_field_type(self, *args):
        """
        add_field_type(self, fieldType:int) -> None
        C++: virtual void add_field_type(int fieldType)
        Add a field type to process. fieldType where the array that
        should be passed (point data, cell data, etc.). It should be one
        of the constants defined in the DataObject::AttributeTypes
        enumeration. NOTE: These are only used if use_field_type is turned
        on.
        """
        ret = self._wrap_call(self._vtk_obj.AddFieldType, *args)
        return ret

    def add_point_data_array(self, *args):
        """
        add_point_data_array(self, name:str) -> None
        C++: virtual void add_point_data_array(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.AddPointDataArray, *args)
        return ret

    def clear_arrays(self):
        """
        clear_arrays(self) -> None
        C++: virtual void clear_arrays()
        Clear all arrays to pass through.
        """
        ret = self._vtk_obj.ClearArrays()
        return ret
        

    def clear_cell_data_arrays(self):
        """
        clear_cell_data_arrays(self) -> None
        C++: virtual void clear_cell_data_arrays()"""
        ret = self._vtk_obj.ClearCellDataArrays()
        return ret
        

    def clear_field_data_arrays(self):
        """
        clear_field_data_arrays(self) -> None
        C++: virtual void clear_field_data_arrays()"""
        ret = self._vtk_obj.ClearFieldDataArrays()
        return ret
        

    def clear_field_types(self):
        """
        clear_field_types(self) -> None
        C++: virtual void clear_field_types()
        Clear all field types to process.
        """
        ret = self._vtk_obj.ClearFieldTypes()
        return ret
        

    def clear_point_data_arrays(self):
        """
        clear_point_data_arrays(self) -> None
        C++: virtual void clear_point_data_arrays()"""
        ret = self._vtk_obj.ClearPointDataArrays()
        return ret
        

    def remove_array(self, *args):
        """
        remove_array(self, fieldType:int, name:str) -> None
        C++: virtual void remove_array(int fieldType, const char *name)"""
        ret = self._wrap_call(self._vtk_obj.RemoveArray, *args)
        return ret

    def remove_cell_data_array(self, *args):
        """
        remove_cell_data_array(self, name:str) -> None
        C++: virtual void remove_cell_data_array(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.RemoveCellDataArray, *args)
        return ret

    def remove_field_data_array(self, *args):
        """
        remove_field_data_array(self, name:str) -> None
        C++: virtual void remove_field_data_array(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.RemoveFieldDataArray, *args)
        return ret

    def remove_point_data_array(self, *args):
        """
        remove_point_data_array(self, name:str) -> None
        C++: virtual void remove_point_data_array(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.RemovePointDataArray, *args)
        return ret

    _updateable_traits_ = \
    (('remove_arrays', 'GetRemoveArrays'), ('use_field_types',
    'GetUseFieldTypes'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'remove_arrays', 'use_field_types',
    'object_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PassArrays, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PassArrays properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['remove_arrays', 'use_field_types'], [], ['object_name']),
            title='Edit PassArrays properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PassArrays properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

