// Copyright (c) 2011, Jens Peter Secher <jpsecher@gmail.com>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

/// Interface for something that holds a log and a verbosity level.

interface ILog
{
	/// Put something in the log (which is usually a file).
	function log( line : String ) : Void;

	/// Put something on the error channel (which is usually stderr).
	function error( line : String ) : Void;

	/// The info channel (which is usually stdout) is guarded by the verbosity.
	/// Increasing verbosity is supposed to give more info.
	var verbosity (default,null) : Int;
	function info( level : Int, line : String ) : Void;
	function infos( level : Int, lines : Iterable<String> ) : Void;
}
