![logo by max.icons](https://github.com/ultrabug/mkdocs-static-i18n/blob/main/docs/assets/logo_by_maxicons.png)

# MkDocs static i18n plugin

![mkdocs-static-i18n pypi version](https://img.shields.io/pypi/v/mkdocs-static-i18n.svg)

*The MkDocs plugin that helps you support multiple language versions of your site / documentation.*

*Like what you :eyes:? Using this plugin? Give it a :star:!*

The `mkdocs-static-i18n` plugin allows you to support multiple languages of your documentation by adding static translation files to your existing documentation pages.

Multi language support is just **one `.<language>.md` file away**!

Even better, `mkdocs-static-i18n` also allows you to build and serve localized versions of any file extension to display localized images, medias and assets.

Localized images/medias/assets are just **one `.<language>.<extension>` file away**!

Don't like file suffixes? You're more into a folder based structure? We got you covered as well!

## Documentation

Check out the [plugins' documentation here](https://ultrabug.github.io/mkdocs-static-i18n/).

TL;DR? There's a [quick start guide](https://ultrabug.github.io/mkdocs-static-i18n/getting-started/quick-start/) for you!

## Upgrading from 0.x versions

:warning: Version 1.0.0 brings **breaking changes** to the configuration format of the plugin. Check out the [upgrade to v1.0.0 guide](https://ultrabug.github.io/mkdocs-static-i18n/setup/upgrading-to-1/) to ease updating your `mkdocs.yml` file!

## See it in action

This plugin is proudly bringing localized content of [hundreds of projects](https://github.com/ultrabug/mkdocs-static-i18n/network/dependents) to their users.

Check it out live:

- [On this repository documentation](https://ultrabug.github.io/mkdocs-static-i18n/)
- [On my own website: ultrabug.fr](https://ultrabug.fr)

But also in our hall of fame:

- [AWS Copilot CLI](https://aws.github.io/copilot-cli/)
- [OWASP Top 10](https://github.com/OWASP/Top10)
- [Spaceship Prompt](https://spaceship-prompt.sh/)
- [FederatedAI FATE](https://fate.readthedocs.io/en/latest/)
- [Privacy Guides Org](https://www.privacyguides.org/en/)
- [Computer Science Self Learning Wiki](https://csdiy.wiki/)

## Contributions welcome

Feel free to ask questions, enhancements and to contribute to this project!

## Development

The project is managed with `hatch`. [Install `hatch`](https://hatch.pypa.io/1.9/install/#gui-installer) first.

Run the tests:

```
hatch run test:test
hatch run style:check
```

Serve the documentation:

```
hatch run doc:serve
```

## Credits

- Logo by [max.icons](https://www.flaticon.com/authors/maxicons)
