# MoarVM Release Guide

## Versions

MoarVM currently has a monthly release cycle, with releases made in time for
the month's NQP and Rakudo release. Version numbers are simply YYYY.MM. For
example, the January 2014 release is 2014.01. If any bugfix releases need to
be made, they should be numbered as 2041.01.1, 2041.01.2, etc.

## Making a release

1. Make sure that you are on the MoarVM commit you want to make a release
   from, and that your status is clean.

2. Ensure that NQP and Rakudo will build and that `make test` in each is
   clean. Also run `make spectest` in Rakudo; discuss any failures you see
   with the Rakudo developers.

3. If possible, run NQP and Rakudo `make test` and Rakudo `make spectest` when
   `#define MVM_DEBUG_NFG 1` and `#define MVM_DEBUG_NFG_STRICT 1` in src/strings/ops.h
   after recompiling to make sure there have been no normalization bugs
   introduced.

4. Update docs/ChangeLog with any significant changes since the previous release.

5. Update the VERSION file with the release name.

6. Run `make release VERSION=2017.10`, substituting the correct version name.

7. Take the MoarVM-2017.10.tar.gz file generated by step 6, copy it to a separate directory,
   extract it, and then in that directory do:

        perl Configure.pl --prefix=install
        make install
        install/bin/moar --version

8. Provided step 5 and 6 work, you have a release! You need to setup git to be
   able to sign your commits. The -a option adds a tag while the -s makes sure
   the tag is signed. Even if your commits are signed by default, you will need
   the -s option as well.

        git tag -as 2017.10

9. Run git verify-tag 2017.10 to make sure the signature is valid and the tag
   was actually signed.

10. Upload it by committing the tar file
   to https://github.com/MoarVM/moarvm.org/ in the releases directory.

11. Make sure you have the Text::Markdown Perl 5 module and run:

        ./tools/moarvm.org_releases.pl > ../moarvm.org/releases.html

   It should output to STDERR all the versions it found in ChangeLog make sure
   the most recent release appears first and all releases going back to 2014.01
   appear.

12. Manually edit moarvm.org/index.html to have the DL link and mention the most
    recent release.
    Changes need to be made on lines:
  - 36: Large text
  - 38: Description text
  - 41: Download link

13. Optionally, update the ports/macports/Portfile to reflect this latest
   version, and open a ticket at https://trac.macports.org/newticket to get
   the macport updated. (For now, just make Coke do it.)

13. Do something fun to celebrate. Like watching nyan cat, or having a beer. Or
   why not both?
