/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.cnd.discovery.wizard.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.discovery.wizard.api.FileConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.api.FolderConfiguration;

/**
 *
 * @author Alexander Simon
 */
public class FolderConfigurationImpl extends NodeConfigurationImpl implements FolderConfiguration {
    private final String path;
    private final Map<String, FolderConfigurationImpl> folders = new HashMap<>();
    private final List<FileConfigurationImpl> files = new ArrayList<>();

    public FolderConfigurationImpl(String path) {
        this.path = path;
    }

    public FolderConfigurationImpl cut(){
        if (folders.size() == 1 && files.isEmpty()){
            return folders.values().iterator().next();
        }
        return null;
    }
    
    @Override
    public List<FolderConfiguration> getFolders() {
        return new ArrayList<FolderConfiguration>(folders.values());
    }

    public void addChild(FolderConfigurationImpl subfolder) {
        folders.put(subfolder.getFolderName(),subfolder);
    }

    public FolderConfigurationImpl getChild(String name) {
        return folders.get(name);
    }

    @Override
    public List<FileConfiguration> getFiles() {
        return new ArrayList<FileConfiguration>(files);
    }

    public void addFile(FileConfigurationImpl file) {
        files.add(file);
    }

    @Override
    public String getFolderPath() {
        return path;
    }

    @Override
    public String getFolderName() {
        int i = path.lastIndexOf("/"); // NOI18N
        if(i>=0){
            return path.substring(i+1);
        }
        return path;
    }
}
