/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2015 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2015 Sun Microsystems, Inc.
 */
package org.netbeans.modules.dlight.sendto.conifg.ui;

import org.netbeans.modules.dlight.sendto.api.OutputMode;
import org.netbeans.modules.dlight.sendto.output.OutputPatternsEditSupport;
import javax.swing.JPanel;

/**
 *
 * @author akrasny
 */
public class OutputConfigurationPanel extends JPanel {

    private OutputMode mode = OutputMode.OUTPUT_WINDOW;

    /**
     * Creates new form OutputConfigurationPanel
     */
    public OutputConfigurationPanel() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        cbInTerminal = new javax.swing.JCheckBox();
        btnModifyParsers = new javax.swing.JButton();

        setLayout(new java.awt.BorderLayout());

        org.openide.awt.Mnemonics.setLocalizedText(cbInTerminal, org.openide.util.NbBundle.getMessage(OutputConfigurationPanel.class, "OutputConfigurationPanel.cbInTerminal.text")); // NOI18N
        cbInTerminal.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cbInTerminalActionPerformed(evt);
            }
        });
        add(cbInTerminal, java.awt.BorderLayout.LINE_START);

        btnModifyParsers.setForeground(new java.awt.Color(0, 48, 255));
        org.openide.awt.Mnemonics.setLocalizedText(btnModifyParsers, org.openide.util.NbBundle.getMessage(OutputConfigurationPanel.class, "OutputConfigurationPanel.btnModifyParsers.text")); // NOI18N
        btnModifyParsers.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        btnModifyParsers.setBorderPainted(false);
        btnModifyParsers.setContentAreaFilled(false);
        btnModifyParsers.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        btnModifyParsers.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnModifyParsersActionPerformed(evt);
            }
        });
        add(btnModifyParsers, java.awt.BorderLayout.LINE_END);
    }// </editor-fold>//GEN-END:initComponents

    private void cbInTerminalActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cbInTerminalActionPerformed
        OutputMode newMode = cbInTerminal.isSelected()
                ? OutputMode.INTERNAL_TERMINAL
                : OutputMode.OUTPUT_WINDOW;
        setOutputMode(newMode);
    }//GEN-LAST:event_cbInTerminalActionPerformed

    private void btnModifyParsersActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnModifyParsersActionPerformed
        OutputPatternsEditSupport.openEditor();
    }//GEN-LAST:event_btnModifyParsersActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnModifyParsers;
    private javax.swing.JCheckBox cbInTerminal;
    // End of variables declaration//GEN-END:variables

    public OutputMode getOutputMode() {
        return mode;
    }

    public void setOutputMode(OutputMode newMode) {
        mode = newMode;
        cbInTerminal.setSelected(newMode == OutputMode.INTERNAL_TERMINAL);
        btnModifyParsers.setEnabled(newMode == OutputMode.OUTPUT_WINDOW);
    }
}
